# -*- coding: utf-8 -*-

from deprecation import deprecated
from square.api_helper import APIHelper
from square.http.api_response import ApiResponse
from square.api.base_api import BaseApi
from square.http.auth.o_auth_2 import OAuth2


class V1ItemsApi(BaseApi):

    """A Controller to access Endpoints in the square API."""

    def __init__(self, config, call_back=None):
        super(V1ItemsApi, self).__init__(config, call_back)

    @deprecated()
    def list_categories(self,
                        location_id):
        """Does a GET request to /v1/{location_id}/categories.

        Lists all the item categories for a given location.

        Args:
            location_id (string): The ID of the location to list categories
                for.

        Returns:
            list of V1Category: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/categories'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def create_category(self,
                        location_id,
                        body):
        """Does a POST request to /v1/{location_id}/categories.

        Creates an item category.

        Args:
            location_id (string): The ID of the location to create an item
                for.
            body (V1Category): An object containing the fields to POST for the
                request.  See the corresponding object definition for field
                details.

        Returns:
            V1Category: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/categories'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def delete_category(self,
                        location_id,
                        category_id):
        """Does a DELETE request to /v1/{location_id}/categories/{category_id}.

        Deletes an existing item category.
        __DeleteCategory__ returns nothing on success but Connect SDKs
        map the empty response to an empty `V1DeleteCategoryRequest` object
        as documented below.

        Args:
            location_id (string): The ID of the item's associated location.
            category_id (string): The ID of the category to delete.

        Returns:
            V1Category: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/categories/{category_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'category_id': category_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def update_category(self,
                        location_id,
                        category_id,
                        body):
        """Does a PUT request to /v1/{location_id}/categories/{category_id}.

        Modifies the details of an existing item category.

        Args:
            location_id (string): The ID of the category's associated
                location.
            category_id (string): The ID of the category to edit.
            body (V1Category): An object containing the fields to POST for the
                request.  See the corresponding object definition for field
                details.

        Returns:
            V1Category: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/categories/{category_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'category_id': category_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def list_discounts(self,
                       location_id):
        """Does a GET request to /v1/{location_id}/discounts.

        Lists all the discounts for a given location.

        Args:
            location_id (string): The ID of the location to list categories
                for.

        Returns:
            list of V1Discount: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/discounts'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def create_discount(self,
                        location_id,
                        body):
        """Does a POST request to /v1/{location_id}/discounts.

        Creates a discount.

        Args:
            location_id (string): The ID of the location to create an item
                for.
            body (V1Discount): An object containing the fields to POST for the
                request.  See the corresponding object definition for field
                details.

        Returns:
            V1Discount: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/discounts'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def delete_discount(self,
                        location_id,
                        discount_id):
        """Does a DELETE request to /v1/{location_id}/discounts/{discount_id}.

        Deletes an existing discount.
        __DeleteDiscount__ returns nothing on success but Connect SDKs
        map the empty response to an empty `V1DeleteDiscountRequest` object
        as documented below.

        Args:
            location_id (string): The ID of the item's associated location.
            discount_id (string): The ID of the discount to delete.

        Returns:
            V1Discount: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/discounts/{discount_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'discount_id': discount_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def update_discount(self,
                        location_id,
                        discount_id,
                        body):
        """Does a PUT request to /v1/{location_id}/discounts/{discount_id}.

        Modifies the details of an existing discount.

        Args:
            location_id (string): The ID of the category's associated
                location.
            discount_id (string): The ID of the discount to edit.
            body (V1Discount): An object containing the fields to POST for the
                request.  See the corresponding object definition for field
                details.

        Returns:
            V1Discount: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/discounts/{discount_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'discount_id': discount_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def list_fees(self,
                  location_id):
        """Does a GET request to /v1/{location_id}/fees.

        Lists all the fees (taxes) for a given location.

        Args:
            location_id (string): The ID of the location to list fees for.

        Returns:
            list of V1Fee: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/fees'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def create_fee(self,
                   location_id,
                   body):
        """Does a POST request to /v1/{location_id}/fees.

        Creates a fee (tax).

        Args:
            location_id (string): The ID of the location to create a fee for.
            body (V1Fee): An object containing the fields to POST for the
                request.  See the corresponding object definition for field
                details.

        Returns:
            V1Fee: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/fees'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def delete_fee(self,
                   location_id,
                   fee_id):
        """Does a DELETE request to /v1/{location_id}/fees/{fee_id}.

        Deletes an existing fee (tax).
        __DeleteFee__ returns nothing on success but Connect SDKs
        map the empty response to an empty `V1DeleteFeeRequest` object
        as documented below.

        Args:
            location_id (string): The ID of the fee's associated location.
            fee_id (string): The ID of the fee to delete.

        Returns:
            V1Fee: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/fees/{fee_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'fee_id': fee_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def update_fee(self,
                   location_id,
                   fee_id,
                   body):
        """Does a PUT request to /v1/{location_id}/fees/{fee_id}.

        Modifies the details of an existing fee (tax).

        Args:
            location_id (string): The ID of the fee's associated location.
            fee_id (string): The ID of the fee to edit.
            body (V1Fee): An object containing the fields to POST for the
                request.  See the corresponding object definition for field
                details.

        Returns:
            V1Fee: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/fees/{fee_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'fee_id': fee_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def list_inventory(self,
                       location_id,
                       limit=None,
                       batch_token=None):
        """Does a GET request to /v1/{location_id}/inventory.

        Provides inventory information for all inventory-enabled item
        variations.

        Args:
            location_id (string): The ID of the item's associated location.
            limit (int, optional): The maximum number of inventory entries to
                return in a single response. This value cannot exceed 1000.
            batch_token (string, optional): A pagination cursor to retrieve
                the next set of results for your original query to the
                endpoint.

        Returns:
            list of V1InventoryEntry: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/inventory'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'limit': limit,
            'batch_token': batch_token
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def adjust_inventory(self,
                         location_id,
                         variation_id,
                         body):
        """Does a POST request to /v1/{location_id}/inventory/{variation_id}.

        Adjusts the current available inventory of an item variation.

        Args:
            location_id (string): The ID of the item's associated location.
            variation_id (string): The ID of the variation to adjust inventory
                information for.
            body (V1AdjustInventoryRequest): An object containing the fields
                to POST for the request.  See the corresponding object
                definition for field details.

        Returns:
            V1InventoryEntry: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/inventory/{variation_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'variation_id': variation_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def list_items(self,
                   location_id,
                   batch_token=None):
        """Does a GET request to /v1/{location_id}/items.

        Provides summary information of all items for a given location.

        Args:
            location_id (string): The ID of the location to list items for.
            batch_token (string, optional): A pagination cursor to retrieve
                the next set of results for your original query to the
                endpoint.

        Returns:
            list of V1Item: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/items'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'batch_token': batch_token
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def create_item(self,
                    location_id,
                    body):
        """Does a POST request to /v1/{location_id}/items.

        Creates an item and at least one variation for it.
        Item-related entities include fields you can use to associate them
        with
        entities in a non-Square system.
        When you create an item-related entity, you can optionally specify
        `id`.
        This value must be unique among all IDs ever specified for the
        account,
        including those specified by other applications. You can never reuse
        an
        entity ID. If you do not specify an ID, Square generates one for the
        entity.
        Item variations have a `user_data` string that lets you associate
        arbitrary
        metadata with the variation. The string cannot exceed 255 characters.

        Args:
            location_id (string): The ID of the location to create an item
                for.
            body (V1Item): An object containing the fields to POST for the
                request.  See the corresponding object definition for field
                details.

        Returns:
            V1Item: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/items'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def delete_item(self,
                    location_id,
                    item_id):
        """Does a DELETE request to /v1/{location_id}/items/{item_id}.

        Deletes an existing item and all item variations associated with it.
        __DeleteItem__ returns nothing on success but Connect SDKs
        map the empty response to an empty `V1DeleteItemRequest` object
        as documented below.

        Args:
            location_id (string): The ID of the item's associated location.
            item_id (string): The ID of the item to modify.

        Returns:
            V1Item: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/items/{item_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'item_id': item_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def retrieve_item(self,
                      location_id,
                      item_id):
        """Does a GET request to /v1/{location_id}/items/{item_id}.

        Provides the details for a single item, including associated modifier
        lists and fees.

        Args:
            location_id (string): The ID of the item's associated location.
            item_id (string): The item's ID.

        Returns:
            V1Item: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/items/{item_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'item_id': item_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def update_item(self,
                    location_id,
                    item_id,
                    body):
        """Does a PUT request to /v1/{location_id}/items/{item_id}.

        Modifies the core details of an existing item.

        Args:
            location_id (string): The ID of the item's associated location.
            item_id (string): The ID of the item to modify.
            body (V1Item): An object containing the fields to POST for the
                request.  See the corresponding object definition for field
                details.

        Returns:
            V1Item: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/items/{item_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'item_id': item_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def remove_fee(self,
                   location_id,
                   item_id,
                   fee_id):
        """Does a DELETE request to /v1/{location_id}/items/{item_id}/fees/{fee_id}.

        Removes a fee assocation from an item so the fee is no longer
        automatically applied to the item in Square Point of Sale.

        Args:
            location_id (string): The ID of the fee's associated location.
            item_id (string): The ID of the item to add the fee to.
            fee_id (string): The ID of the fee to apply.

        Returns:
            V1Item: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/items/{item_id}/fees/{fee_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'item_id': item_id,
            'fee_id': fee_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def apply_fee(self,
                  location_id,
                  item_id,
                  fee_id):
        """Does a PUT request to /v1/{location_id}/items/{item_id}/fees/{fee_id}.

        Associates a fee with an item so the fee is automatically applied to
        the item in Square Point of Sale.

        Args:
            location_id (string): The ID of the fee's associated location.
            item_id (string): The ID of the item to add the fee to.
            fee_id (string): The ID of the fee to apply.

        Returns:
            V1Item: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/items/{item_id}/fees/{fee_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'item_id': item_id,
            'fee_id': fee_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def remove_modifier_list(self,
                             location_id,
                             modifier_list_id,
                             item_id):
        """Does a DELETE request to /v1/{location_id}/items/{item_id}/modifier-lists/{modifier_list_id}.

        Removes a modifier list association from an item so the modifier
        options from the list can no longer be applied to the item.

        Args:
            location_id (string): The ID of the item's associated location.
            modifier_list_id (string): The ID of the modifier list to remove.
            item_id (string): The ID of the item to remove the modifier list
                from.

        Returns:
            V1Item: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/items/{item_id}/modifier-lists/{modifier_list_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'modifier_list_id': modifier_list_id,
            'item_id': item_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def apply_modifier_list(self,
                            location_id,
                            modifier_list_id,
                            item_id):
        """Does a PUT request to /v1/{location_id}/items/{item_id}/modifier-lists/{modifier_list_id}.

        Associates a modifier list with an item so the associated modifier
        options can be applied to the item.

        Args:
            location_id (string): The ID of the item's associated location.
            modifier_list_id (string): The ID of the modifier list to apply.
            item_id (string): The ID of the item to add the modifier list to.

        Returns:
            V1Item: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/items/{item_id}/modifier-lists/{modifier_list_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'modifier_list_id': modifier_list_id,
            'item_id': item_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def create_variation(self,
                         location_id,
                         item_id,
                         body):
        """Does a POST request to /v1/{location_id}/items/{item_id}/variations.

        Creates an item variation for an existing item.

        Args:
            location_id (string): The ID of the item's associated location.
            item_id (string): The item's ID.
            body (V1Variation): An object containing the fields to POST for
                the request.  See the corresponding object definition for
                field details.

        Returns:
            V1Variation: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/items/{item_id}/variations'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'item_id': item_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def delete_variation(self,
                         location_id,
                         item_id,
                         variation_id):
        """Does a DELETE request to /v1/{location_id}/items/{item_id}/variations/{variation_id}.

        Deletes an existing item variation from an item.
        __DeleteVariation__ returns nothing on success but Connect SDKs
        map the empty response to an empty `V1DeleteVariationRequest` object
        as documented below.

        Args:
            location_id (string): The ID of the item's associated location.
            item_id (string): The ID of the item to delete.
            variation_id (string): The ID of the variation to delete.

        Returns:
            V1Variation: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/items/{item_id}/variations/{variation_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'item_id': item_id,
            'variation_id': variation_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def update_variation(self,
                         location_id,
                         item_id,
                         variation_id,
                         body):
        """Does a PUT request to /v1/{location_id}/items/{item_id}/variations/{variation_id}.

        Modifies the details of an existing item variation.

        Args:
            location_id (string): The ID of the item's associated location.
            item_id (string): The ID of the item to modify.
            variation_id (string): The ID of the variation to modify.
            body (V1Variation): An object containing the fields to POST for
                the request.  See the corresponding object definition for
                field details.

        Returns:
            V1Variation: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/items/{item_id}/variations/{variation_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'item_id': item_id,
            'variation_id': variation_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def list_modifier_lists(self,
                            location_id):
        """Does a GET request to /v1/{location_id}/modifier-lists.

        Lists all the modifier lists for a given location.

        Args:
            location_id (string): The ID of the location to list modifier
                lists for.

        Returns:
            list of V1ModifierList: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/modifier-lists'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def create_modifier_list(self,
                             location_id,
                             body):
        """Does a POST request to /v1/{location_id}/modifier-lists.

        Creates an item modifier list and at least 1 modifier option for it.

        Args:
            location_id (string): The ID of the location to create a modifier
                list for.
            body (V1ModifierList): An object containing the fields to POST for
                the request.  See the corresponding object definition for
                field details.

        Returns:
            V1ModifierList: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/modifier-lists'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def delete_modifier_list(self,
                             location_id,
                             modifier_list_id):
        """Does a DELETE request to /v1/{location_id}/modifier-lists/{modifier_list_id}.

        Deletes an existing item modifier list and all modifier options
        associated with it.
        __DeleteModifierList__ returns nothing on success but Connect SDKs
        map the empty response to an empty `V1DeleteModifierListRequest`
        object
        as documented below.

        Args:
            location_id (string): The ID of the item's associated location.
            modifier_list_id (string): The ID of the modifier list to delete.

        Returns:
            V1ModifierList: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/modifier-lists/{modifier_list_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'modifier_list_id': modifier_list_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def retrieve_modifier_list(self,
                               location_id,
                               modifier_list_id):
        """Does a GET request to /v1/{location_id}/modifier-lists/{modifier_list_id}.

        Provides the details for a single modifier list.

        Args:
            location_id (string): The ID of the item's associated location.
            modifier_list_id (string): The modifier list's ID.

        Returns:
            V1ModifierList: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/modifier-lists/{modifier_list_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'modifier_list_id': modifier_list_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def update_modifier_list(self,
                             location_id,
                             modifier_list_id,
                             body):
        """Does a PUT request to /v1/{location_id}/modifier-lists/{modifier_list_id}.

        Modifies the details of an existing item modifier list.

        Args:
            location_id (string): The ID of the item's associated location.
            modifier_list_id (string): The ID of the modifier list to edit.
            body (V1UpdateModifierListRequest): An object containing the
                fields to POST for the request.  See the corresponding object
                definition for field details.

        Returns:
            V1ModifierList: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/modifier-lists/{modifier_list_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'modifier_list_id': modifier_list_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def create_modifier_option(self,
                               location_id,
                               modifier_list_id,
                               body):
        """Does a POST request to /v1/{location_id}/modifier-lists/{modifier_list_id}/modifier-options.

        Creates an item modifier option and adds it to a modifier list.

        Args:
            location_id (string): The ID of the item's associated location.
            modifier_list_id (string): The ID of the modifier list to edit.
            body (V1ModifierOption): An object containing the fields to POST
                for the request.  See the corresponding object definition for
                field details.

        Returns:
            V1ModifierOption: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/modifier-lists/{modifier_list_id}/modifier-options'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'modifier_list_id': modifier_list_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def delete_modifier_option(self,
                               location_id,
                               modifier_list_id,
                               modifier_option_id):
        """Does a DELETE request to /v1/{location_id}/modifier-lists/{modifier_list_id}/modifier-options/{modifier_option_id}.

        Deletes an existing item modifier option from a modifier list.
        __DeleteModifierOption__ returns nothing on success but Connect
        SDKs map the empty response to an empty
        `V1DeleteModifierOptionRequest`
        object.

        Args:
            location_id (string): The ID of the item's associated location.
            modifier_list_id (string): The ID of the modifier list to delete.
            modifier_option_id (string): The ID of the modifier list to edit.

        Returns:
            V1ModifierOption: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/modifier-lists/{modifier_list_id}/modifier-options/{modifier_option_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'modifier_list_id': modifier_list_id,
            'modifier_option_id': modifier_option_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def update_modifier_option(self,
                               location_id,
                               modifier_list_id,
                               modifier_option_id,
                               body):
        """Does a PUT request to /v1/{location_id}/modifier-lists/{modifier_list_id}/modifier-options/{modifier_option_id}.

        Modifies the details of an existing item modifier option.

        Args:
            location_id (string): The ID of the item's associated location.
            modifier_list_id (string): The ID of the modifier list to edit.
            modifier_option_id (string): The ID of the modifier list to edit.
            body (V1ModifierOption): An object containing the fields to POST
                for the request.  See the corresponding object definition for
                field details.

        Returns:
            V1ModifierOption: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/modifier-lists/{modifier_list_id}/modifier-options/{modifier_option_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'modifier_list_id': modifier_list_id,
            'modifier_option_id': modifier_option_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def list_pages(self,
                   location_id):
        """Does a GET request to /v1/{location_id}/pages.

        Lists all Favorites pages (in Square Point of Sale) for a given
        location.

        Args:
            location_id (string): The ID of the location to list Favorites
                pages for.

        Returns:
            list of V1Page: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/pages'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def create_page(self,
                    location_id,
                    body):
        """Does a POST request to /v1/{location_id}/pages.

        Creates a Favorites page in Square Point of Sale.

        Args:
            location_id (string): The ID of the location to create an item
                for.
            body (V1Page): An object containing the fields to POST for the
                request.  See the corresponding object definition for field
                details.

        Returns:
            V1Page: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/pages'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def delete_page(self,
                    location_id,
                    page_id):
        """Does a DELETE request to /v1/{location_id}/pages/{page_id}.

        Deletes an existing Favorites page and all of its cells.
        __DeletePage__ returns nothing on success but Connect SDKs
        map the empty response to an empty `V1DeletePageRequest` object.

        Args:
            location_id (string): The ID of the Favorites page's associated
                location.
            page_id (string): The ID of the page to delete.

        Returns:
            V1Page: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/pages/{page_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'page_id': page_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def update_page(self,
                    location_id,
                    page_id,
                    body):
        """Does a PUT request to /v1/{location_id}/pages/{page_id}.

        Modifies the details of a Favorites page in Square Point of Sale.

        Args:
            location_id (string): The ID of the Favorites page's associated
                location
            page_id (string): The ID of the page to modify.
            body (V1Page): An object containing the fields to POST for the
                request.  See the corresponding object definition for field
                details.

        Returns:
            V1Page: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/pages/{page_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'page_id': page_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def delete_page_cell(self,
                         location_id,
                         page_id,
                         row=None,
                         column=None):
        """Does a DELETE request to /v1/{location_id}/pages/{page_id}/cells.

        Deletes a cell from a Favorites page in Square Point of Sale.
        __DeletePageCell__ returns nothing on success but Connect SDKs
        map the empty response to an empty `V1DeletePageCellRequest` object
        as documented below.

        Args:
            location_id (string): The ID of the Favorites page's associated
                location.
            page_id (string): The ID of the page to delete.
            row (string, optional): The row of the cell to clear. Always an
                integer between 0 and 4, inclusive. Row 0 is the top row.
            column (string, optional): The column of the cell to clear. Always
                an integer between 0 and 4, inclusive. Column 0 is the
                leftmost column.

        Returns:
            V1Page: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/pages/{page_id}/cells'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'page_id': page_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'row': row,
            'column': column
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url, headers=_headers)
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result

    @deprecated()
    def update_page_cell(self,
                         location_id,
                         page_id,
                         body):
        """Does a PUT request to /v1/{location_id}/pages/{page_id}/cells.

        Modifies a cell of a Favorites page in Square Point of Sale.

        Args:
            location_id (string): The ID of the Favorites page's associated
                location.
            page_id (string): The ID of the page the cell belongs to.
            body (V1PageCell): An object containing the fields to POST for the
                request.  See the corresponding object definition for field
                details.

        Returns:
            V1Page: Response from the API. Success

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/v1/{location_id}/pages/{page_id}/cells'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'location_id': location_id,
            'page_id': page_id
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        OAuth2.apply(self.config, _request)
        _response = self.execute_request(_request)

        decoded = APIHelper.json_deserialize(_response.text)
        if type(decoded) is dict:
            _errors = decoded.get('errors')
        else:
            _errors = None
        _result = ApiResponse(_response, body=decoded, errors=_errors)
        return _result
