/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AllergyintoleranceClinical {
    ACTIVE,
    INACTIVE,
    RESOLVED,
    NULL;


    public static AllergyintoleranceClinical fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("inactive".equals(codeString)) {
            return INACTIVE;
        }
        if ("resolved".equals(codeString)) {
            return RESOLVED;
        }
        throw new FHIRException("Unknown AllergyintoleranceClinical code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case INACTIVE: {
                return "inactive";
            }
            case RESOLVED: {
                return "resolved";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "The subject is currently experiencing, or is at risk of, a reaction to the identified substance.";
            }
            case INACTIVE: {
                return "The subject is no longer at risk of a reaction to the identified substance.";
            }
            case RESOLVED: {
                return "A reaction to the identified substance has been clinically reassessed by testing or re-exposure and is considered no longer to be present. Re-exposure could be accidental, unplanned, or outside of any clinical setting.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case INACTIVE: {
                return "Inactive";
            }
            case RESOLVED: {
                return "Resolved";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

