/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.gclient;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.ICriterionInternal;
import ca.uhn.fhir.rest.gclient.IParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.ParameterUtil;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

class StringCriterion<A extends IParam>
implements ICriterion<A>,
ICriterionInternal {
    private String myValue;
    private String myName;
    private ParamPrefixEnum myPrefix;

    public StringCriterion(String theName, String theValue) {
        this.myName = theName;
        this.myValue = ParameterUtil.escapeWithDefault(theValue);
    }

    public StringCriterion(String theName, ParamPrefixEnum thePrefix, String theValue) {
        this.myName = theName;
        this.myPrefix = thePrefix;
        this.myValue = ParameterUtil.escapeWithDefault(theValue);
    }

    public StringCriterion(String theName, Collection<String> theValue) {
        this.myName = theName;
        StringBuilder b = new StringBuilder();
        for (String next : theValue) {
            if (StringUtils.isBlank(next)) continue;
            if (b.length() > 0) {
                b.append(',');
            }
            b.append(ParameterUtil.escape(next));
        }
        this.myValue = b.toString();
    }

    @Override
    public String getParameterName() {
        return this.myName;
    }

    @Override
    public String getParameterValue(FhirContext theContext) {
        if (StringUtils.isBlank(this.myValue)) {
            return "";
        }
        if (this.myPrefix != null) {
            return this.myPrefix.getValue() + this.myValue;
        }
        return this.myValue;
    }
}

