/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;

public abstract class BaseQueryParameter
implements IParameter {
    public abstract List<QualifiedParamList> encode(FhirContext var1, Object var2) throws InternalErrorException;

    public abstract String getName();

    public abstract RestSearchParameterTypeEnum getParamType();

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
    }

    public abstract boolean isRequired();

    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
        if (theSourceClientArgument == null) {
            if (this.isRequired()) {
                throw new NullPointerException(Msg.code(1451) + "SearchParameter '" + this.getName() + "' is required and may not be null");
            }
        } else {
            List<QualifiedParamList> value = this.encode(theContext, theSourceClientArgument);
            for (QualifiedParamList nextParamEntry : value) {
                StringBuilder b = new StringBuilder();
                for (String str : nextParamEntry) {
                    if (b.length() > 0) {
                        b.append(",");
                    }
                    b.append(str);
                }
                String qualifier = nextParamEntry.getQualifier();
                String paramName = StringUtils.isNotBlank(qualifier) ? this.getName() + qualifier : this.getName();
                List paramValues = theTargetQueryArguments.computeIfAbsent(paramName, k -> new ArrayList(value.size()));
                paramValues.add(b.toString());
            }
        }
    }
}

