/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology;

import au.csiro.pathling.fhirpath.encoding.SimpleCoding;
import au.csiro.pathling.terminology.BaseMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.ValueSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValueSetMapping
extends BaseMapping {
    private static final Logger log = LoggerFactory.getLogger(ValueSetMapping.class);

    private ValueSetMapping() {
    }

    @Nonnull
    public static ValueSet toIntersection(@Nonnull String valueSetUri, @Nonnull Collection<SimpleCoding> codings) {
        Set validCodeSystems = codings.stream().filter(SimpleCoding::isDefined).map(coding -> new CodeSystemReference(Optional.ofNullable(coding.getSystem()), Optional.ofNullable(coding.getVersion()))).collect(Collectors.toUnmodifiableSet());
        ValueSet intersection = new ValueSet();
        ValueSet.ValueSetComposeComponent compose = new ValueSet.ValueSetComposeComponent();
        ArrayList<ValueSet.ConceptSetComponent> includes = new ArrayList<ValueSet.ConceptSetComponent>();
        for (CodeSystemReference codeSystem : validCodeSystems) {
            ValueSet.ConceptSetComponent include = new ValueSet.ConceptSetComponent();
            include.setValueSet(Collections.singletonList(new CanonicalType(valueSetUri)));
            include.setSystem(codeSystem.getSystem().get());
            codeSystem.getVersion().ifPresent(include::setVersion);
            List<ValueSet.ConceptReferenceComponent> concepts = codings.stream().filter(x$0 -> codeSystem.matchesCoding((SimpleCoding)x$0)).map(SimpleCoding::getCode).filter(Objects::nonNull).distinct().map(code -> {
                ValueSet.ConceptReferenceComponent concept = new ValueSet.ConceptReferenceComponent();
                concept.setCode((String)code);
                return concept;
            }).collect(Collectors.toList());
            if (concepts.isEmpty()) continue;
            include.setConcept(concepts);
            includes.add(include);
        }
        compose.setInclude(includes);
        intersection.setCompose(compose);
        return intersection;
    }

    @Nonnull
    public static Set<SimpleCoding> codingSetFromExpansion(@Nullable ValueSet valueSet) {
        if (valueSet == null) {
            return Collections.emptySet();
        }
        return valueSet.getExpansion().getContains().stream().map(contains -> new SimpleCoding(contains.getSystem(), contains.getCode(), contains.getVersion())).collect(Collectors.toSet());
    }

    private static final class CodeSystemReference {
        @Nonnull
        private final Optional<String> system;
        @Nonnull
        private final Optional<String> version;

        private boolean matchesCoding(@Nonnull SimpleCoding coding) {
            if (this.system.isEmpty() || coding.getSystem() == null) {
                return false;
            }
            boolean eitherSideIsMissingVersion = this.version.isEmpty() || coding.getVersion() == null;
            boolean versionAgnosticTest = this.system.get().equals(coding.getSystem());
            if (eitherSideIsMissingVersion) {
                return versionAgnosticTest;
            }
            return versionAgnosticTest && this.version.get().equals(coding.getVersion());
        }

        public CodeSystemReference(@Nonnull Optional<String> system, @Nonnull Optional<String> version) {
            if (system == null) {
                throw new NullPointerException("system is marked non-null but is null");
            }
            if (version == null) {
                throw new NullPointerException("version is marked non-null but is null");
            }
            this.system = system;
            this.version = version;
        }

        @Nonnull
        public Optional<String> getSystem() {
            return this.system;
        }

        @Nonnull
        public Optional<String> getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CodeSystemReference)) {
                return false;
            }
            CodeSystemReference other = (CodeSystemReference)o;
            Optional<String> this$system = this.getSystem();
            Optional<String> other$system = other.getSystem();
            if (this$system == null ? other$system != null : !((Object)this$system).equals(other$system)) {
                return false;
            }
            Optional<String> this$version = this.getVersion();
            Optional<String> other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $system = this.getSystem();
            result = result * 59 + ($system == null ? 43 : ((Object)$system).hashCode());
            Optional<String> $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            return result;
        }

        public String toString() {
            return "ValueSetMapping.CodeSystemReference(system=" + this.getSystem() + ", version=" + this.getVersion() + ")";
        }
    }
}

