/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology;

import au.csiro.pathling.fhirpath.encoding.SimpleCoding;
import au.csiro.pathling.terminology.BaseMapping;
import au.csiro.pathling.terminology.Relation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Enumerations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClosureMapping
extends BaseMapping {
    private static final Logger log = LoggerFactory.getLogger(ClosureMapping.class);

    private ClosureMapping() {
    }

    private static void appendSubsumesMapping(@Nonnull Collection<Relation.Entry> entries, @Nonnull SimpleCoding source2, @Nonnull SimpleCoding target, @Nonnull Enumerations.ConceptMapEquivalence equivalence) {
        switch (equivalence) {
            case SUBSUMES: {
                entries.add(Relation.Entry.of(target, source2));
                break;
            }
            case SPECIALIZES: {
                entries.add(Relation.Entry.of(source2, target));
                break;
            }
            case EQUAL: {
                entries.add(Relation.Entry.of(source2, target));
                entries.add(Relation.Entry.of(target, source2));
                break;
            }
            case UNMATCHED: {
                break;
            }
            default: {
                log.warn("Ignoring unexpected equivalence: " + equivalence + " source: " + source2 + " target: " + target);
            }
        }
    }

    @Nonnull
    private static List<Relation.Entry> conceptMapToMappings(@Nonnull ConceptMap conceptMap) {
        ArrayList<Relation.Entry> entries = new ArrayList<Relation.Entry>();
        if (conceptMap.hasGroup()) {
            List<ConceptMap.ConceptMapGroupComponent> groups2 = conceptMap.getGroup();
            for (ConceptMap.ConceptMapGroupComponent group : groups2) {
                List<ConceptMap.SourceElementComponent> elements = group.getElement();
                for (ConceptMap.SourceElementComponent source2 : elements) {
                    for (ConceptMap.TargetElementComponent target : source2.getTarget()) {
                        ClosureMapping.appendSubsumesMapping(entries, new SimpleCoding(group.getSource(), source2.getCode(), group.getSourceVersion()), new SimpleCoding(group.getTarget(), target.getCode(), group.getTargetVersion()), target.getEquivalence());
                    }
                }
            }
        }
        return entries;
    }

    @Nonnull
    public static Relation relationFromConceptMap(@Nonnull ConceptMap conceptMap) {
        return Relation.fromMappings(ClosureMapping.conceptMapToMappings(conceptMap));
    }
}

