/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.fhirpath.function.translate;

import au.csiro.pathling.fhir.TerminologyServiceFactory;
import au.csiro.pathling.fhirpath.encoding.CodingEncoding;
import au.csiro.pathling.fhirpath.encoding.SimpleCoding;
import au.csiro.pathling.sql.MapperWithPreview;
import au.csiro.pathling.terminology.ConceptTranslator;
import au.csiro.pathling.terminology.TerminologyService;
import au.csiro.pathling.utilities.Streams;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.spark.sql.Row;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Enumerations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TranslateMapper
implements MapperWithPreview<List<SimpleCoding>, Row[], ConceptTranslator> {
    private static final Logger log = LoggerFactory.getLogger(TranslateMapper.class);
    private static final long serialVersionUID = 2879761794073649202L;
    @Nonnull
    private final String requestId;
    @Nonnull
    private final TerminologyServiceFactory terminologyServiceFactory;
    @Nonnull
    private final String conceptMapUrl;
    private final boolean reverse;
    @Nonnull
    private final List<Enumerations.ConceptMapEquivalence> equivalences;

    public TranslateMapper(@Nonnull String requestId, @Nonnull TerminologyServiceFactory terminologyServiceFactory, @Nonnull String conceptMapUrl, boolean reverse, @Nonnull List<Enumerations.ConceptMapEquivalence> equivalences) {
        this.requestId = requestId;
        this.terminologyServiceFactory = terminologyServiceFactory;
        this.conceptMapUrl = conceptMapUrl;
        this.reverse = reverse;
        this.equivalences = equivalences;
    }

    @Override
    @Nonnull
    public ConceptTranslator preview(@Nonnull Iterator<List<SimpleCoding>> input) {
        if (!input.hasNext() || this.equivalences.isEmpty()) {
            return new ConceptTranslator();
        }
        MDC.put("requestId", this.requestId);
        Set<SimpleCoding> uniqueCodings = Streams.streamOf(input).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        TerminologyService terminologyService = this.terminologyServiceFactory.buildService(log);
        return terminologyService.translate(uniqueCodings, this.conceptMapUrl, this.reverse, this.equivalences);
    }

    @Override
    @Nullable
    public Row[] call(@Nullable List<SimpleCoding> input, @Nonnull ConceptTranslator state) {
        List<Coding> outputCodings = state.translate(input);
        return outputCodings.isEmpty() ? null : CodingEncoding.encodeList(outputCodings);
    }
}

