/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.fhirpath.function.subsumes;

import au.csiro.pathling.fhir.TerminologyServiceFactory;
import au.csiro.pathling.fhirpath.encoding.SimpleCoding;
import au.csiro.pathling.sql.MapperWithPreview;
import au.csiro.pathling.terminology.Relation;
import au.csiro.pathling.terminology.TerminologyService;
import au.csiro.pathling.utilities.Streams;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SubsumesMapper
implements MapperWithPreview<ImmutablePair<List<SimpleCoding>, List<SimpleCoding>>, Boolean, Relation> {
    private static final Logger log = LoggerFactory.getLogger(SubsumesMapper.class);
    private static final long serialVersionUID = 2879761794073649202L;
    @Nonnull
    private final String requestId;
    @Nonnull
    private final TerminologyServiceFactory terminologyServiceFactory;
    private final boolean inverted;

    public SubsumesMapper(@Nonnull String requestId, @Nonnull TerminologyServiceFactory terminologyServiceFactory, boolean inverted) {
        this.requestId = requestId;
        this.terminologyServiceFactory = terminologyServiceFactory;
        this.inverted = inverted;
    }

    @Override
    @Nonnull
    public Relation preview(@Nonnull Iterator<ImmutablePair<List<SimpleCoding>, List<SimpleCoding>>> input) {
        MDC.put("requestId", this.requestId);
        Set<SimpleCoding> codings = Streams.streamOf(input).filter(r -> r.getLeft() != null && r.getRight() != null).flatMap(r -> Stream.concat(((List)r.getLeft()).stream(), ((List)r.getRight()).stream())).filter(Objects::nonNull).collect(Collectors.toSet());
        TerminologyService terminologyService = this.terminologyServiceFactory.buildService(log);
        return terminologyService.getSubsumesRelation(codings);
    }

    @Nonnull
    private static <T> List<T> safeGetList(@Nullable List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    @Override
    @Nullable
    public Boolean call(@Nullable ImmutablePair<List<SimpleCoding>, List<SimpleCoding>> input, @Nonnull Relation subsumeRelation) {
        if (Objects.isNull(input) || Objects.isNull(input.getLeft())) {
            return null;
        }
        List<SimpleCoding> inputCodings = SubsumesMapper.safeGetList(input.getLeft());
        List<SimpleCoding> argCodings = SubsumesMapper.safeGetList(input.getRight());
        return !this.inverted ? subsumeRelation.anyRelates(inputCodings, argCodings) : subsumeRelation.anyRelates(argCodings, inputCodings);
    }
}

