/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.fhirpath.encoding;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Coding;

public class ImmutableCoding
implements Serializable {
    private static final long serialVersionUID = -2461921559175440312L;
    @Nullable
    private final String system;
    @Nullable
    private final String version;
    @Nullable
    private final String code;
    @Nullable
    private final String display;
    @Nullable
    protected final Boolean userSelected;

    @Nonnull
    public Coding toCoding() {
        return new Coding(this.system, this.code, this.display).setVersion(this.version).setUserSelectedElement(this.userSelected != null ? new BooleanType(this.userSelected) : null);
    }

    @Nonnull
    public static ImmutableCoding of(@Nonnull Coding coding) {
        return ImmutableCoding.of(coding.getSystem(), coding.getVersion(), coding.getCode(), coding.getDisplay(), coding.hasUserSelected() ? Boolean.valueOf(coding.getUserSelected()) : null);
    }

    @Nonnull
    public static ImmutableCoding of(@Nonnull String system, @Nonnull String code, @Nonnull String display) {
        return ImmutableCoding.of(system, null, code, display, null);
    }

    @Nonnull
    public static ImmutableCoding empty() {
        return ImmutableCoding.of(null, null, null, null, null);
    }

    private ImmutableCoding(@Nullable String system, @Nullable String version, @Nullable String code, @Nullable String display, @Nullable Boolean userSelected) {
        this.system = system;
        this.version = version;
        this.code = code;
        this.display = display;
        this.userSelected = userSelected;
    }

    public static ImmutableCoding of(@Nullable String system, @Nullable String version, @Nullable String code, @Nullable String display, @Nullable Boolean userSelected) {
        return new ImmutableCoding(system, version, code, display, userSelected);
    }

    public String toString() {
        return "ImmutableCoding(system=" + this.getSystem() + ", version=" + this.getVersion() + ", code=" + this.getCode() + ", display=" + this.getDisplay() + ", userSelected=" + this.getUserSelected() + ")";
    }

    @Nullable
    public String getSystem() {
        return this.system;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getCode() {
        return this.code;
    }

    @Nullable
    public String getDisplay() {
        return this.display;
    }

    @Nullable
    public Boolean getUserSelected() {
        return this.userSelected;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImmutableCoding)) {
            return false;
        }
        ImmutableCoding other = (ImmutableCoding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$userSelected = this.getUserSelected();
        Boolean other$userSelected = other.getUserSelected();
        if (this$userSelected == null ? other$userSelected != null : !((Object)this$userSelected).equals(other$userSelected)) {
            return false;
        }
        String this$system = this.getSystem();
        String other$system = other.getSystem();
        if (this$system == null ? other$system != null : !this$system.equals(other$system)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$display = this.getDisplay();
        String other$display = other.getDisplay();
        return !(this$display == null ? other$display != null : !this$display.equals(other$display));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImmutableCoding;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $userSelected = this.getUserSelected();
        result = result * 59 + ($userSelected == null ? 43 : ((Object)$userSelected).hashCode());
        String $system = this.getSystem();
        result = result * 59 + ($system == null ? 43 : $system.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $display = this.getDisplay();
        result = result * 59 + ($display == null ? 43 : $display.hashCode());
        return result;
    }
}

