/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.fhirpath.encoding;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.hl7.fhir.r4.model.Coding;

public interface CodingEncoding {
    public static final StructType DATA_TYPE = CodingEncoding.codingStructType();
    public static final int SYSTEM_INDEX = DATA_TYPE.fieldIndex("system");
    public static final int VERSION_INDEX = DATA_TYPE.fieldIndex("version");
    public static final int CODE_INDEX = DATA_TYPE.fieldIndex("code");
    public static final int DISPLAY_INDEX = DATA_TYPE.fieldIndex("display");
    public static final int USER_SELECTED_INDEX = DATA_TYPE.fieldIndex("userSelected");

    @Nonnull
    public static StructType codingStructType() {
        Metadata metadata = new MetadataBuilder().build();
        StructField id = new StructField("id", DataTypes.StringType, true, metadata);
        StructField system = new StructField("system", DataTypes.StringType, true, metadata);
        StructField version = new StructField("version", DataTypes.StringType, true, metadata);
        StructField code = new StructField("code", DataTypes.StringType, true, metadata);
        StructField display = new StructField("display", DataTypes.StringType, true, metadata);
        StructField userSelected = new StructField("userSelected", DataTypes.BooleanType, true, metadata);
        StructField fid = new StructField("_fid", DataTypes.IntegerType, true, metadata);
        return new StructType(new StructField[]{id, system, version, code, display, userSelected, fid});
    }

    @Nullable
    public static Row encode(@Nullable Coding coding) {
        if (coding == null) {
            return null;
        }
        Boolean userSelected = coding.hasUserSelected() ? Boolean.valueOf(coding.getUserSelected()) : null;
        return RowFactory.create((Object[])new Object[]{coding.getId(), coding.getSystem(), coding.getVersion(), coding.getCode(), coding.getDisplay(), userSelected, null});
    }

    public static Coding decode(@Nonnull Row row) {
        Coding coding = new Coding();
        coding.setSystem(row.getString(SYSTEM_INDEX));
        coding.setVersion(row.getString(VERSION_INDEX));
        coding.setCode(row.getString(CODE_INDEX));
        coding.setDisplay(row.getString(DISPLAY_INDEX));
        if (!row.isNullAt(USER_SELECTED_INDEX)) {
            coding.setUserSelected(row.getBoolean(USER_SELECTED_INDEX));
        }
        return coding;
    }

    @Nullable
    public static Row[] encodeList(@Nullable List<Coding> codings) {
        return codings == null ? null : (Row[])codings.stream().map(CodingEncoding::encode).toArray(Row[]::new);
    }
}

