/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.fhir;

import au.csiro.pathling.fhir.AccessContext;
import au.csiro.pathling.fhir.AccessScope;
import au.csiro.pathling.fhir.ClientCredentialsResponse;
import au.csiro.pathling.utilities.Preconditions;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
public class ClientAuthInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ClientAuthInterceptor.class);
    public static final int AUTH_CONNECT_TIMEOUT = 5000;
    public static final int AUTH_CONNECTION_REQUEST_TIMEOUT = 5000;
    public static final int AUTH_SOCKET_TIMEOUT = 5000;
    public static final int AUTH_RETRY_COUNT = 3;
    @Nonnull
    private final String tokenEndpoint;
    @Nonnull
    private final String clientId;
    @Nonnull
    private final String clientSecret;
    @Nullable
    private final String scope;
    private final long tokenExpiryTolerance;
    @Nonnull
    private static final Map<AccessScope, AccessContext> accessContexts = new HashMap<AccessScope, AccessContext>();

    public ClientAuthInterceptor(@Nonnull String tokenEndpoint, @Nonnull String clientId, @Nonnull String clientSecret, @Nullable String scope, long tokenExpiryTolerance) {
        this.tokenEndpoint = tokenEndpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scope = scope;
        this.tokenExpiryTolerance = tokenExpiryTolerance;
    }

    @Hook(value=Pointcut.CLIENT_REQUEST)
    public void handleClientRequest(@Nullable IHttpRequest httpRequest) throws IOException {
        if (httpRequest != null) {
            AccessContext accessContext = ClientAuthInterceptor.ensureAccessContext(this.clientId, this.clientSecret, this.tokenEndpoint, this.scope, this.tokenExpiryTolerance);
            String accessToken = accessContext.getClientCredentialsResponse().getAccessToken();
            Preconditions.checkNotNull(accessToken);
            httpRequest.addHeader("Authorization", "Bearer " + accessToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static AccessContext ensureAccessContext(@Nonnull String clientId, @Nonnull String clientSecret, @Nonnull String tokenEndpoint, @Nonnull String scope, long tokenExpiryTolerance) throws IOException {
        Map<AccessScope, AccessContext> map = accessContexts;
        synchronized (map) {
            AccessScope accessScope = new AccessScope(tokenEndpoint, clientId, scope);
            AccessContext accessContext = accessContexts.get(accessScope);
            if (accessContext == null || accessContext.getExpiryTime().isBefore(Instant.now().plusSeconds(tokenExpiryTolerance))) {
                log.debug("Getting new token");
                accessContext = ClientAuthInterceptor.getNewAccessContext(clientId, clientSecret, tokenEndpoint, scope, tokenExpiryTolerance);
                accessContexts.put(accessScope, accessContext);
            }
            return accessContext;
        }
    }

    @Nonnull
    private static AccessContext getNewAccessContext(@Nonnull String clientId, @Nonnull String clientSecret, @Nonnull String tokenEndpoint, @Nullable String scope, long tokenExpiryTolerance) throws IOException {
        ArrayList<NameValuePair> authParams = new ArrayList<NameValuePair>();
        authParams.add(new BasicNameValuePair("client_id", clientId));
        authParams.add(new BasicNameValuePair("client_secret", clientSecret));
        return ClientAuthInterceptor.getAccessContext(authParams, tokenEndpoint, scope, tokenExpiryTolerance);
    }

    @Nonnull
    private static AccessContext getAccessContext(@Nonnull List<NameValuePair> authParams, @Nonnull String tokenEndpoint, @Nullable String scope, long tokenExpiryTolerance) throws IOException {
        ClientCredentialsResponse response = ClientAuthInterceptor.clientCredentialsGrant(authParams, tokenEndpoint, scope, tokenExpiryTolerance);
        Instant expires = ClientAuthInterceptor.getExpiryTime(response);
        log.debug("New token will expire at {}", (Object)expires);
        return new AccessContext(response, expires);
    }

    @Nonnull
    private static ClientCredentialsResponse clientCredentialsGrant(@Nonnull List<NameValuePair> authParams, @Nonnull String tokenEndpoint, @Nullable String scope, long tokenExpiryTolerance) throws IOException {
        log.debug("Performing client credentials grant using token endpoint: {}", (Object)tokenEndpoint);
        try (CloseableHttpClient httpClient = ClientAuthInterceptor.getHttpClient();){
            String responseString;
            HttpPost request = new HttpPost(tokenEndpoint);
            request.addHeader("Content-Type", "application/x-www-form-urlencoded");
            request.addHeader("Accept", "application/json");
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add(new BasicNameValuePair("grant_type", "client_credentials"));
            if (scope != null) {
                authParams.add(new BasicNameValuePair("scope", scope));
            }
            params.addAll(authParams);
            request.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)params));
            CloseableHttpResponse response = httpClient.execute(request);
            Header contentTypeHeader = response.getFirstHeader("Content-Type");
            if (contentTypeHeader == null) {
                throw new ClientProtocolException("Client credentials response contains no Content-Type header");
            }
            boolean responseIsJson = contentTypeHeader.getValue().startsWith("application/json");
            if (!responseIsJson) {
                throw new ClientProtocolException("Invalid response from token endpoint: content type is not application/json");
            }
            Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
            ClientCredentialsResponse grant = (ClientCredentialsResponse)gson.fromJson(responseString = EntityUtils.toString(response.getEntity()), ClientCredentialsResponse.class);
            if (grant.getAccessToken() == null) {
                throw new ClientProtocolException("Client credentials grant does not contain access token");
            }
            if ((long)grant.getExpiresIn() < tokenExpiryTolerance) {
                throw new ClientProtocolException("Client credentials grant expiry is less than the tolerance: " + grant.getExpiresIn());
            }
            ClientCredentialsResponse clientCredentialsResponse = grant;
            return clientCredentialsResponse;
        }
    }

    private static CloseableHttpClient getHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        return HttpClients.custom().setRetryHandler(new DefaultHttpRequestRetryHandler(3, true)).setDefaultRequestConfig(requestConfig).build();
    }

    private static Instant getExpiryTime(@Nonnull ClientCredentialsResponse response) {
        return Instant.now().plusSeconds(response.getExpiresIn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAccessContexts() {
        Map<AccessScope, AccessContext> map = accessContexts;
        synchronized (map) {
            accessContexts.clear();
        }
    }
}

