<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>${unit.fullname}</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="./assets/purecss/pure-min.css">
<link rel="stylesheet" href="./assets/purecss/grids-responsive-min.css">
<link rel="stylesheet" href="./assets/style.css">
<link rel="stylesheet" href="./assets/pygments/default.css">
<link rel="stylesheet" href="./assets/jquery/jquery-ui.min.css">
<script src="./assets/jquery/jquery-3.0.0.min.js"></script>
<script src="./assets/jquery/jquery-ui.min.js"></script>
<script src="nedoc.js"></script>
  <% prev = 0; t = tree(gctx, unit, public=True) %>
</head>
<body>
<div id="layout" class="pure-g">
<div class="sidebar pure-u-1 pure-u-md-1-4">
        <div class="header">
            <h1 class="brand-title">${gctx.config.project_name}</h1>
            ${gctx.config.project_version}
        </div>

<div id="sbox">
<input id="search" style="color: black;" placeholder="search ..."/>
</div>

        <div class="tree">
<ul>
% for (i, (level, uc)) in enumerate(t):
<%
if uc.imported:
    continue
child = uc.unit
if child.role == "module":
    if (i + 1 < len(t) and t[i + 1][0] > level) or child == unit:
        marker = "&#9662;"
    else:
        marker = "&#9656;"
else:
    marker = ""
%>
    % if prev < level:
    <li><ul>
    %endif
    % if prev > level:
    </ul></li>
    %endif
    <%
       # Disable now since it makes the tree confusing
       #if uc.imported:
       #    imp = "<span class='import'>[imported]</span> "
       #else:
       #    imp = ""
       if child == unit:
           cls = "selectimp" if uc.imported else "select"
       else:
           cls = ""
    %>
    <li>
    % if cls:
    <div class="${cls}">
    % endif
    <%
       if child.keyword:
          keyword = "<i>{}</i> ".format(child.keyword)
       else:
          keyword = ""
    %>
    <a href=${ctx.link_to(child)}>${marker | n} ${keyword | n}${child.name}</a>\
    % if cls:
    </div>
    %endif
    </li>
    <% prev = level %>\
% endfor
% for _ in range(level):
    </ul>
% endfor
    </ul>
    </div>
    </div>

    <div class="content pure-u-1 pure-u-md-3-4">
        ${self.body()}
        <p class="footer">
            Generated by <a href="https://github.com/spirali/nedoc">nedoc</a> v${gctx.nedoc_version} at ${ctx.now.strftime("%Y-%m-%d %H:%M")}
        </p>
    </div>
</div>
</body>
</html>
