/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import uk.ac.cam.ch.wwmm.opsin.AmbiguityChecker;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Attribute;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.GroupingEl;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.StereoAnalyser;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;
import uk.ac.cam.ch.wwmm.opsin.WordRule;

class WordRulesOmittedSpaceCorrector {
    private static final Pattern matchAteOrIteEnding = Pattern.compile("[ai]t[e]?[\\])}]*$", 2);
    private final BuildState state;
    private final Element parse;

    WordRulesOmittedSpaceCorrector(BuildState state, Element parse) {
        this.state = state;
        this.parse = parse;
    }

    void correctOmittedSpaces() throws StructureBuildingException {
        List<Element> wordRules = OpsinTools.getDescendantElementsWithTagName(this.parse, "wordRule");
        for (Element wordRule : wordRules) {
            WordRule wordRuleVal = WordRule.valueOf(wordRule.getAttributeValue("wordRule"));
            if (wordRuleVal == WordRule.divalentFunctionalGroup) {
                this.checkAndCorrectOmittedSpacesInDivalentFunctionalGroupRule(wordRule);
                continue;
            }
            if (wordRuleVal != WordRule.simple) continue;
            this.checkAndCorrectOmittedSpaceEster(wordRule);
        }
    }

    private void checkAndCorrectOmittedSpacesInDivalentFunctionalGroupRule(Element divalentFunctionalGroupWordRule) {
        Element firstGroup;
        Fragment firstFrag;
        Element firstSubOrbracket;
        List<Element> children;
        List<Element> substituentWords = OpsinTools.getChildElementsWithTagNameAndAttribute(divalentFunctionalGroupWordRule, "word", "type", "substituent");
        if (substituentWords.size() == 1 && (children = OpsinTools.getChildElementsWithTagNames(substituentWords.get(0), new String[]{"substituent", "bracket"})).size() == 2 && (firstSubOrbracket = children.get(0)).getAttribute("locant") == null && firstSubOrbracket.getAttribute("multiplier") == null && this.hasSingleMonoValentCarbonOrSiliconRadical(firstFrag = (firstGroup = StructureBuildingMethods.findRightMostGroupInSubBracketOrRoot(firstSubOrbracket)).getFrag())) {
            Element subToMove = children.get(1);
            subToMove.detach();
            GroupingEl newWord = new GroupingEl("word");
            newWord.addAttribute(new Attribute("type", "substituent"));
            ((Element)newWord).addChild(subToMove);
            OpsinTools.insertAfter(substituentWords.get(0), newWord);
        }
    }

    private void checkAndCorrectOmittedSpaceEster(Element wordRule) throws StructureBuildingException {
        List<Element> children;
        List<Element> words = wordRule.getChildElements("word");
        if (words.size() != 1) {
            return;
        }
        Element word = words.get(0);
        String wordRuleContents = wordRule.getAttributeValue("value");
        if (matchAteOrIteEnding.matcher(wordRuleContents).find() && (children = OpsinTools.getChildElementsWithTagNames(word, new String[]{"substituent", "bracket", "root"})).size() >= 2) {
            Element rootEl = children.get(children.size() - 1);
            Element rootGroup = StructureBuildingMethods.findRightMostGroupInSubBracketOrRoot(rootEl);
            Fragment rootFrag = rootGroup.getFrag();
            int functionalAtomsCount = rootFrag.getFunctionalAtomCount();
            int rootMultiplier = 1;
            String rootElMultiplierAtrVal = rootEl.getAttributeValue("multiplier");
            if (rootElMultiplierAtrVal != null) {
                rootMultiplier = Integer.parseInt(rootElMultiplierAtrVal);
                functionalAtomsCount *= rootMultiplier;
            }
            if (functionalAtomsCount > 0) {
                List<Element> substituents = children.subList(0, children.size() - 1);
                int substituentCount = substituents.size();
                if (substituentCount == 1 && rootMultiplier > 1) {
                    return;
                }
                Element firstChild = substituents.get(0);
                if (!this.checkSuitabilityOfSubstituentForEsterFormation(firstChild, functionalAtomsCount)) {
                    if (firstChild.getAttribute("locant") != null) {
                        Integer lastSubOrBracketWithoutLocantIdx = null;
                        for (int i = 1; i < substituents.size(); ++i) {
                            Element subOrBracket = substituents.get(i);
                            if (subOrBracket.getAttribute("locant") != null) continue;
                            if (!this.checkSuitabilityOfSubstituentForEsterFormation(subOrBracket, 1)) {
                                return;
                            }
                            lastSubOrBracketWithoutLocantIdx = i;
                            break;
                        }
                        if (lastSubOrBracketWithoutLocantIdx != null && this.substitutionWouldBeAmbiguous(rootFrag, null)) {
                            ArrayList<Element> elsToFormEsterSub = new ArrayList<Element>();
                            for (int i = 0; i <= lastSubOrBracketWithoutLocantIdx; ++i) {
                                elsToFormEsterSub.add(substituents.get(i));
                            }
                            this.transformToEster(wordRule, elsToFormEsterSub);
                        }
                    }
                    return;
                }
                String multiplierValue = firstChild.getAttributeValue("multiplier");
                if (this.specialCaseWhereEsterPreferred(StructureBuildingMethods.findRightMostGroupInSubBracketOrRoot(firstChild), multiplierValue, rootGroup, substituentCount)) {
                    this.transformToEster(wordRule, firstChild);
                } else if (substituentCount > 1 && (this.allBarFirstSubstituentHaveLocants(substituents) || this.insufficientSubstitutableHydrogenForSubstitution(substituents, rootFrag, rootMultiplier))) {
                    this.transformToEster(wordRule, firstChild);
                } else if ((substituentCount == 1 || rootMultiplier > 1) && this.substitutionWouldBeAmbiguous(rootFrag, multiplierValue)) {
                    this.transformToEster(wordRule, firstChild);
                }
            }
        }
    }

    private boolean allBarFirstSubstituentHaveLocants(List<Element> substituentsAndBrackets) {
        if (substituentsAndBrackets.size() <= 1) {
            return false;
        }
        for (int i = 1; i < substituentsAndBrackets.size(); ++i) {
            if (substituentsAndBrackets.get(i).getAttribute("locant") != null) continue;
            return false;
        }
        return true;
    }

    private boolean insufficientSubstitutableHydrogenForSubstitution(List<Element> substituentsAndBrackets, Fragment frag, int rootMultiplier) {
        int substitutableHydrogens = this.getAtomForEachSubstitutableHydrogen(frag).size() * rootMultiplier;
        for (int i = 1; i < substituentsAndBrackets.size(); ++i) {
            Element subOrBracket = substituentsAndBrackets.get(i);
            Fragment f = StructureBuildingMethods.findRightMostGroupInSubBracketOrRoot(subOrBracket).getFrag();
            String multiplierValue = subOrBracket.getAttributeValue("multiplier");
            int multiplier = 1;
            if (multiplierValue != null) {
                multiplier = Integer.parseInt(multiplierValue);
            }
            substitutableHydrogens -= this.getTotalOutAtomValency(f) * multiplier;
        }
        Element potentialEsterSub = substituentsAndBrackets.get(0);
        int firstFragSubstitutableHydrogenRequired = this.getTotalOutAtomValency(StructureBuildingMethods.findRightMostGroupInSubBracketOrRoot(potentialEsterSub).getFrag());
        String multiplierValue = potentialEsterSub.getAttributeValue("multiplier");
        int multiplier = 1;
        if (multiplierValue != null) {
            multiplier = Integer.parseInt(multiplierValue);
        }
        return substitutableHydrogens >= 0 && substitutableHydrogens - firstFragSubstitutableHydrogenRequired * multiplier < 0;
    }

    private int getTotalOutAtomValency(Fragment f) {
        int outAtomValency = 0;
        int l = f.getOutAtomCount();
        for (int i = 0; i < l; ++i) {
            outAtomValency += f.getOutAtom(i).getValency();
        }
        return outAtomValency;
    }

    private boolean specialCaseWhereEsterPreferred(Element substituentGroupEl, String multiplierValue, Element rootGroup, int numOfSubstituents) {
        if (multiplierValue != null && Integer.parseInt(multiplierValue) == 1) {
            return true;
        }
        String rootGroupName = rootGroup.getParent().getValue();
        if (substituentGroupEl.getAttributeValue("type").equals("chain") && "alkaneStem".equals(substituentGroupEl.getAttributeValue("subType")) && substituentGroupEl.getParent().getValue().matches(substituentGroupEl.getValue() + "yl-?") && rootGroupName.matches(".*(form|methan|acet|ethan)[o]?ate?")) {
            return true;
        }
        if ((rootGroupName.endsWith("carbamate") || rootGroupName.endsWith("carbamat")) && numOfSubstituents >= 2) {
            Element temp = substituentGroupEl.getParent();
            while (temp.getParent() != null) {
                temp = temp.getParent();
            }
            if (temp.getChildElements("wordRule").size() == 1) {
                return true;
            }
        }
        return false;
    }

    private boolean substitutionWouldBeAmbiguous(Fragment frag, String multiplierValue) {
        int multiplier = 1;
        if (multiplierValue != null) {
            multiplier = Integer.parseInt(multiplierValue);
        }
        if (multiplier == 1 && frag.getDefaultInAtom() != null) {
            return false;
        }
        List<Atom> atomForEachSubstitutableHydrogen = this.getAtomForEachSubstitutableHydrogen(frag);
        if (atomForEachSubstitutableHydrogen.size() == multiplier) {
            return false;
        }
        StereoAnalyser analyser = new StereoAnalyser(frag);
        HashSet<String> uniqueEnvironments = new HashSet<String>();
        for (Atom a : atomForEachSubstitutableHydrogen) {
            uniqueEnvironments.add(AmbiguityChecker.getAtomEnviron(analyser, a));
        }
        return uniqueEnvironments.size() != 1 || multiplier != 1 && multiplier != atomForEachSubstitutableHydrogen.size() - 1;
    }

    private boolean checkSuitabilityOfSubstituentForEsterFormation(Element subOrBracket, int rootFunctionalAtomsCount) {
        int multiplier;
        if (subOrBracket.getAttribute("locant") != null) {
            return false;
        }
        Fragment rightMostGroup = StructureBuildingMethods.findRightMostGroupInSubBracketOrRoot(subOrBracket).getFrag();
        if (!this.hasSingleMonoValentCarbonOrSiliconRadical(rightMostGroup)) {
            return false;
        }
        String multiplierStr = subOrBracket.getAttributeValue("multiplier");
        return multiplierStr == null || (multiplier = Integer.parseInt(multiplierStr)) <= rootFunctionalAtomsCount;
    }

    private boolean hasSingleMonoValentCarbonOrSiliconRadical(Fragment frag) {
        OutAtom outAtom;
        return frag.getOutAtomCount() == 1 && (outAtom = frag.getOutAtom(0)).getValency() == 1 && (outAtom.getAtom().getElement() == ChemEl.C || outAtom.getAtom().getElement() == ChemEl.Si);
    }

    private List<Atom> getAtomForEachSubstitutableHydrogen(Fragment frag) {
        ArrayList<Atom> substitutableAtoms = new ArrayList<Atom>();
        List<Atom> atomList = frag.getAtomList();
        for (Atom atom : atomList) {
            int currentValency;
            if (FragmentTools.isCharacteristicAtom(atom)) continue;
            int currentExpectedValency = atom.determineValency(true);
            for (int i = currentValency = atom.getIncomingValency() + (atom.hasSpareValency() ? 1 : 0) + atom.getOutValency(); i < currentExpectedValency; ++i) {
                substitutableAtoms.add(atom);
            }
        }
        return substitutableAtoms;
    }

    private void transformToEster(Element parentSimpleWordRule, Element substituentOrBracket) throws StructureBuildingException {
        parentSimpleWordRule.getAttribute("wordRule").setValue(WordRule.ester.toString());
        List<Element> childElsOfSub = substituentOrBracket.getChildElements();
        Element lastChildElOfSub = childElsOfSub.get(childElsOfSub.size() - 1);
        if (lastChildElOfSub.getName().equals("hyphen")) {
            lastChildElOfSub.detach();
        }
        substituentOrBracket.detach();
        GroupingEl newSubstituentWord = new GroupingEl("word");
        newSubstituentWord.addAttribute(new Attribute("type", "substituent"));
        ((Element)newSubstituentWord).addChild(substituentOrBracket);
        parentSimpleWordRule.insertChild(newSubstituentWord, 0);
        String multiplierStr = substituentOrBracket.getAttributeValue("multiplier");
        if (multiplierStr != null) {
            substituentOrBracket.removeAttribute(substituentOrBracket.getAttribute("multiplier"));
            int multiplier = Integer.parseInt(multiplierStr);
            for (int i = 1; i < multiplier; ++i) {
                Element clone = this.state.fragManager.cloneElement(this.state, newSubstituentWord);
                OpsinTools.insertAfter(newSubstituentWord, clone);
            }
        }
    }

    private void transformToEster(Element parentSimpleWordRule, List<Element> elsToFormEsterSub) throws StructureBuildingException {
        parentSimpleWordRule.getAttribute("wordRule").setValue(WordRule.ester.toString());
        List<Element> childElsOfSub = elsToFormEsterSub.get(elsToFormEsterSub.size() - 1).getChildElements();
        Element lastChildElOfSub = childElsOfSub.get(childElsOfSub.size() - 1);
        if (lastChildElOfSub.getName().equals("hyphen")) {
            lastChildElOfSub.detach();
        }
        GroupingEl newSubstituentWord = new GroupingEl("word");
        newSubstituentWord.addAttribute(new Attribute("type", "substituent"));
        for (Element elToFormEsterSub : elsToFormEsterSub) {
            elToFormEsterSub.detach();
            ((Element)newSubstituentWord).addChild(elToFormEsterSub);
        }
        parentSimpleWordRule.insertChild(newSubstituentWord, 0);
    }
}

