/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.Parse;
import uk.ac.cam.ch.wwmm.opsin.ParseRules;
import uk.ac.cam.ch.wwmm.opsin.ParseRulesResults;
import uk.ac.cam.ch.wwmm.opsin.ParseTokens;
import uk.ac.cam.ch.wwmm.opsin.ParseWord;
import uk.ac.cam.ch.wwmm.opsin.ParsingException;
import uk.ac.cam.ch.wwmm.opsin.ReverseParseRules;
import uk.ac.cam.ch.wwmm.opsin.TokenizationResult;
import uk.ac.cam.ch.wwmm.opsin.WordTools;
import uk.ac.cam.ch.wwmm.opsin.WordType;

class Tokeniser {
    private final ParseRules parseRules;
    private final Pattern matchCasCollectiveIndex = Pattern.compile("([\\[\\(\\{]([1-9][0-9]?[cC][iI][, ]?)+[\\]\\)\\}])+|[1-9][0-9]?[cC][iI]", 2);
    private final Pattern matchCompoundWithPhrase = Pattern.compile("(compd\\. with|compound with|and) ", 2);

    Tokeniser(ParseRules parseRules) {
        this.parseRules = parseRules;
    }

    ParseRules getParseRules() {
        return this.parseRules;
    }

    TokenizationResult tokenize(String name, boolean allowRemovalOfWhiteSpace) throws ParsingException {
        TokenizationResult result = allowRemovalOfWhiteSpace ? new TokenizationResult(WordTools.removeWhiteSpaceIfBracketsAreUnbalanced(name)) : new TokenizationResult(name);
        TokenizationResult resultFromBeforeWhitespaceRemoval = null;
        while (!result.isSuccessfullyTokenized()) {
            ParseRulesResults results = this.parseRules.getParses(result.getUnparsedName());
            List<ParseTokens> parseTokens = results.getParseTokensList();
            result.setWorkingName(results.getUninterpretableName());
            String parsedName = result.getUnparsedName().substring(0, result.getUnparsedName().length() - result.getWorkingName().length());
            if (this.isWordParsable(parseTokens, result)) {
                this.parseWord(result, parseTokens, parsedName, false);
                resultFromBeforeWhitespaceRemoval = null;
                continue;
            }
            if (resultFromBeforeWhitespaceRemoval == null) {
                resultFromBeforeWhitespaceRemoval = new TokenizationResult(name);
                resultFromBeforeWhitespaceRemoval.setErrorFields(result.getUnparsedName(), result.getWorkingName(), results.getUnparseableName());
            }
            if (this.fixWord(result, parsedName, allowRemovalOfWhiteSpace)) continue;
            result.setErrorFields(resultFromBeforeWhitespaceRemoval.getUnparsedName(), resultFromBeforeWhitespaceRemoval.getUninterpretableName(), resultFromBeforeWhitespaceRemoval.getUnparsableName());
            break;
        }
        return result;
    }

    TokenizationResult tokenizeRightToLeft(ReverseParseRules reverseParseRules, String name, boolean allowRemovalOfWhiteSpace) throws ParsingException {
        TokenizationResult result = new TokenizationResult(name);
        TokenizationResult resultFromBeforeWhitespaceRemoval = null;
        while (!result.isSuccessfullyTokenized()) {
            ParseRulesResults results = reverseParseRules.getParses(result.getUnparsedName());
            List<ParseTokens> parseTokens = results.getParseTokensList();
            result.setWorkingName(results.getUninterpretableName());
            String parsedName = result.getUnparsedName().substring(result.getWorkingName().length());
            if (this.isWordParsableInReverse(parseTokens, result)) {
                this.parseWord(result, parseTokens, parsedName, true);
                resultFromBeforeWhitespaceRemoval = null;
                continue;
            }
            if (resultFromBeforeWhitespaceRemoval == null) {
                resultFromBeforeWhitespaceRemoval = new TokenizationResult(name);
                resultFromBeforeWhitespaceRemoval.setErrorFields(result.getUnparsedName(), result.getWorkingName(), results.getUnparseableName());
            }
            if (this.fixWordInReverse(result, parsedName, allowRemovalOfWhiteSpace)) continue;
            result.setErrorFields(resultFromBeforeWhitespaceRemoval.getUnparsedName(), resultFromBeforeWhitespaceRemoval.getUninterpretableName(), resultFromBeforeWhitespaceRemoval.getUnparsableName());
            break;
        }
        Collections.reverse(result.getParse().getWords());
        return result;
    }

    private boolean isWordParsableInReverse(List<ParseTokens> parseTokens, TokenizationResult result) {
        return parseTokens.size() > 0 && (result.isFullyInterpretable() || result.getWorkingName().charAt(result.getWorkingName().length() - 1) == ' ' || result.getWorkingName().charAt(result.getWorkingName().length() - 1) == '-');
    }

    private boolean isWordParsable(List<ParseTokens> parseTokens, TokenizationResult result) {
        return parseTokens.size() > 0 && (result.isFullyInterpretable() || result.getWorkingName().charAt(0) == ' ' || result.getWorkingName().charAt(0) == '-');
    }

    private void parseWord(TokenizationResult result, List<ParseTokens> parseTokens, String parsedName, boolean reverse) {
        this.addParseWords(parseTokens, parsedName, result.getParse(), reverse);
        if (result.isFullyInterpretable()) {
            result.setUnparsedName(result.getWorkingName());
        } else {
            String remainingName = result.getWorkingName();
            remainingName = reverse ? (remainingName.length() > 3 && remainingName.endsWith(" - ") ? remainingName.substring(0, remainingName.length() - 3) : remainingName.substring(0, remainingName.length() - 1)) : (remainingName.length() > 3 && remainingName.startsWith(" - ") ? remainingName.substring(3) : remainingName.substring(1));
            result.setUnparsedName(remainingName);
        }
    }

    private void addParseWords(List<ParseTokens> parseTokens, String parsedName, Parse parse, boolean reverse) {
        List<ParseWord> parseWords = WordTools.splitIntoParseWords(parseTokens, parsedName);
        if (reverse) {
            Collections.reverse(parseWords);
        }
        for (ParseWord parseWord : parseWords) {
            parse.addWord(parseWord);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean fixWord(TokenizationResult result, String parsedName, boolean allowRemovalOfWhiteSpace) throws ParsingException {
        Matcher m = this.matchCompoundWithPhrase.matcher(result.getWorkingName());
        if (m.lookingAt() && this.lastParsedWordWasFullOrFunctionalTerm(result)) {
            result.setUnparsedName(parsedName + result.getWorkingName().substring(m.group().length()));
            return true;
        } else if (this.matchCasCollectiveIndex.matcher(result.getWorkingName()).matches()) {
            result.setUnparsedName(parsedName);
            return true;
        } else {
            if (!allowRemovalOfWhiteSpace) return false;
            List<ParseWord> parsedWords = result.getParse().getWords();
            if (this.reverseSpaceRemoval(parsedWords, result)) return true;
            int indexOfSpace = result.getWorkingName().indexOf(32);
            if (indexOfSpace == -1) return false;
            result.setUnparsedName(parsedName + result.getWorkingName().substring(0, indexOfSpace) + result.getWorkingName().substring(indexOfSpace + 1));
        }
        return true;
    }

    private boolean lastParsedWordWasFullOrFunctionalTerm(TokenizationResult result) throws ParsingException {
        List<ParseWord> parseWords = result.getParse().getWords();
        if (parseWords.size() > 0) {
            List<ParseTokens> parseTokensList = parseWords.get(parseWords.size() - 1).getParseTokens();
            for (ParseTokens parseTokens : parseTokensList) {
                WordType type = OpsinTools.determineWordType(parseTokens.getAnnotations());
                if (!type.equals((Object)WordType.full) && !type.equals((Object)WordType.functionalTerm)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean fixWordInReverse(TokenizationResult result, String parsedName, boolean allowRemovalOfWhiteSpace) {
        int indexOfSpace;
        if (allowRemovalOfWhiteSpace) {
            indexOfSpace = result.getWorkingName().lastIndexOf(32);
            if (indexOfSpace == -1) {
                return false;
            }
        } else {
            return false;
        }
        result.setUnparsedName(result.getWorkingName().substring(0, indexOfSpace) + result.getWorkingName().substring(indexOfSpace + 1) + parsedName);
        return true;
    }

    private boolean reverseSpaceRemoval(List<ParseWord> parsedWords, TokenizationResult result) throws ParsingException {
        boolean successful = false;
        if (!parsedWords.isEmpty()) {
            ParseWord pw = parsedWords.get(parsedWords.size() - 1);
            String lastWordAndUnparsed = pw.getWord() + result.getUnparsedName();
            ParseRulesResults backResults = this.parseRules.getParses(lastWordAndUnparsed);
            List<ParseTokens> backParseTokens = backResults.getParseTokensList();
            String backUninterpretableName = backResults.getUninterpretableName();
            String backParsedName = lastWordAndUnparsed.substring(0, lastWordAndUnparsed.length() - backUninterpretableName.length());
            if (backParsedName.length() > pw.getWord().length() && backParseTokens.size() > 0 && (backUninterpretableName.equals("") || backUninterpretableName.charAt(0) == ' ' || backUninterpretableName.charAt(0) == '-')) {
                result.getParse().removeWord(pw);
                List<ParseWord> parseWords = WordTools.splitIntoParseWords(backParseTokens, backParsedName);
                for (ParseWord parseWord : parseWords) {
                    result.getParse().addWord(parseWord);
                }
                if (!backUninterpretableName.equals("")) {
                    result.setUnparsedName(backUninterpretableName.substring(1));
                } else {
                    result.setUnparsedName(backUninterpretableName);
                }
                successful = true;
            }
        }
        return successful;
    }
}

