/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.ch.wwmm.opsin.AmbiguityChecker;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Attribute;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BuildResults;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.CycleDetector;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.IsotopeSpecificationParser;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.ValencyChecker;
import uk.ac.cam.ch.wwmm.opsin.WordRule;

class StructureBuildingMethods {
    private static final Logger LOG = LogManager.getLogger(StructureBuildingMethods.class);
    private static final Pattern matchCompoundLocant = Pattern.compile("[\\[\\(\\{](\\d+[a-z]?'*)[\\]\\)\\}]");

    private StructureBuildingMethods() {
    }

    static void resolveWordOrBracket(BuildState state, Element word) throws StructureBuildingException {
        if (word.getName().equals("wordRule")) {
            return;
        }
        if (!word.getName().equals("word") && !word.getName().equals("bracket")) {
            throw new StructureBuildingException("A word or bracket is the expected input");
        }
        StructureBuildingMethods.recursivelyResolveLocantedFeatures(state, word);
        StructureBuildingMethods.recursivelyResolveUnLocantedFeatures(state, word);
        List<Element> subsBracketsAndRoots = OpsinTools.getDescendantElementsWithTagNames(word, new String[]{"bracket", "substituent", "root"});
        for (Element subsBracketsAndRoot : subsBracketsAndRoots) {
            if (subsBracketsAndRoot.getAttribute("multiplier") == null) continue;
            throw new StructureBuildingException("Structure building problem: multiplier on :" + subsBracketsAndRoot.getName() + " was never used");
        }
        List<Element> groups = OpsinTools.getDescendantElementsWithTagName(word, "group");
        for (int i = 0; i < groups.size(); ++i) {
            Element group = groups.get(i);
            if (group.getAttribute("resolved") != null || i == groups.size() - 1) continue;
            throw new StructureBuildingException("Structure building problem: Bond was not made from :" + group.getValue() + " but one should of been");
        }
    }

    static void recursivelyResolveLocantedFeatures(BuildState state, Element word) throws StructureBuildingException {
        if (!word.getName().equals("word") && !word.getName().equals("bracket")) {
            throw new StructureBuildingException("A word or bracket is the expected input");
        }
        List<Element> subsBracketsAndRoots = OpsinTools.getChildElementsWithTagNames(word, new String[]{"bracket", "substituent", "root"});
        for (int i = subsBracketsAndRoots.size() - 1; i >= 0; --i) {
            Element subBracketOrRoot = subsBracketsAndRoots.get(i);
            if (subBracketOrRoot.getName().equals("bracket")) {
                StructureBuildingMethods.recursivelyResolveLocantedFeatures(state, subBracketOrRoot);
                if (!StructureBuildingMethods.potentiallyCanSubstitute(subBracketOrRoot)) continue;
                StructureBuildingMethods.performAdditiveOperations(state, subBracketOrRoot);
                StructureBuildingMethods.performLocantedSubstitutiveOperations(state, subBracketOrRoot);
                continue;
            }
            StructureBuildingMethods.resolveRootOrSubstituentLocanted(state, subBracketOrRoot);
        }
    }

    static void recursivelyResolveUnLocantedFeatures(BuildState state, Element word) throws StructureBuildingException {
        if (!word.getName().equals("word") && !word.getName().equals("bracket")) {
            throw new StructureBuildingException("A word or bracket is the expected input");
        }
        List<Element> subsBracketsAndRoots = OpsinTools.getChildElementsWithTagNames(word, new String[]{"bracket", "substituent", "root"});
        for (int i = subsBracketsAndRoots.size() - 1; i >= 0; --i) {
            Element subBracketOrRoot = subsBracketsAndRoots.get(i);
            if (subBracketOrRoot.getName().equals("bracket")) {
                StructureBuildingMethods.recursivelyResolveUnLocantedFeatures(state, subBracketOrRoot);
                if (!StructureBuildingMethods.potentiallyCanSubstitute(subBracketOrRoot)) continue;
                StructureBuildingMethods.performUnLocantedSubstitutiveOperations(state, subBracketOrRoot);
                continue;
            }
            StructureBuildingMethods.resolveRootOrSubstituentUnLocanted(state, subBracketOrRoot);
        }
    }

    static void resolveRootOrSubstituentLocanted(BuildState state, Element subOrRoot) throws StructureBuildingException {
        StructureBuildingMethods.resolveLocantedFeatures(state, subOrRoot);
        boolean foundSomethingToSubstitute = StructureBuildingMethods.potentiallyCanSubstitute(subOrRoot);
        if (foundSomethingToSubstitute) {
            StructureBuildingMethods.performAdditiveOperations(state, subOrRoot);
            StructureBuildingMethods.performLocantedSubstitutiveOperations(state, subOrRoot);
        }
    }

    static void resolveRootOrSubstituentUnLocanted(BuildState state, Element subOrRoot) throws StructureBuildingException {
        boolean foundSomethingToSubstitute = StructureBuildingMethods.potentiallyCanSubstitute(subOrRoot);
        StructureBuildingMethods.resolveUnLocantedFeatures(state, subOrRoot);
        if (foundSomethingToSubstitute) {
            StructureBuildingMethods.performUnLocantedSubstitutiveOperations(state, subOrRoot);
        }
    }

    private static void performLocantedSubstitutiveOperations(BuildState state, Element subBracketOrRoot) throws StructureBuildingException {
        Element group = subBracketOrRoot.getName().equals("bracket") ? StructureBuildingMethods.findRightMostGroupInBracket(subBracketOrRoot) : subBracketOrRoot.getFirstChildElement("group");
        if (group.getAttribute("resolved") != null) {
            return;
        }
        Fragment frag = group.getFrag();
        if (frag.getOutAtomCount() >= 1 && subBracketOrRoot.getAttribute("locant") != null) {
            String locantString = subBracketOrRoot.getAttributeValue("locant");
            if (frag.getOutAtomCount() > 1) {
                StructureBuildingMethods.checkAndApplySpecialCaseWhereOutAtomsCanBeCombinedOrThrow(frag, group);
            }
            if (subBracketOrRoot.getAttribute("multiplier") != null) {
                StructureBuildingMethods.multiplyOutAndSubstitute(state, subBracketOrRoot);
            } else {
                String modifiedLocant;
                Fragment parentFrag = StructureBuildingMethods.findFragmentWithLocant(subBracketOrRoot, locantString);
                if (parentFrag == null && (modifiedLocant = StructureBuildingMethods.checkForBracketedPrimedLocantSpecialCase(subBracketOrRoot, locantString)) != null && (parentFrag = StructureBuildingMethods.findFragmentWithLocant(subBracketOrRoot, modifiedLocant)) != null) {
                    locantString = modifiedLocant;
                }
                if (parentFrag == null) {
                    throw new StructureBuildingException("Cannot find in scope fragment with atom with locant " + locantString + ".");
                }
                group.addAttribute(new Attribute("resolved", "yes"));
                Element groupToAttachTo = parentFrag.getTokenEl();
                if (groupToAttachTo.getAttribute("acceptsAdditiveBonds") != null && parentFrag.getOutAtomCount() > 0 && groupToAttachTo.getAttribute("isAMultiRadical") != null && parentFrag.getAtomByLocantOrThrow(locantString).getOutValency() > 0 && frag.getOutAtom(0).getValency() == 1 && parentFrag.getFirstAtom().equals(parentFrag.getAtomByLocantOrThrow(locantString))) {
                    StructureBuildingMethods.joinFragmentsAdditively(state, frag, parentFrag);
                } else {
                    Atom atomToSubstituteAt = parentFrag.getAtomByLocantOrThrow(locantString);
                    if ("phospho".equals(group.getAttributeValue("subType")) && frag.getOutAtom(0).getValency() == 1 && atomToSubstituteAt.getElement() != ChemEl.O) {
                        for (Atom neighbour : atomToSubstituteAt.getAtomNeighbours()) {
                            if (neighbour.getElement() != ChemEl.O || neighbour.getBondCount() != 1 || neighbour.getFirstBond().getOrder() != 1 || neighbour.getOutValency() != 0 || neighbour.getCharge() != 0) continue;
                            atomToSubstituteAt = neighbour;
                            break;
                        }
                    }
                    StructureBuildingMethods.joinFragmentsSubstitutively(state, frag, atomToSubstituteAt);
                }
            }
        }
    }

    private static void performUnLocantedSubstitutiveOperations(BuildState state, Element subBracketOrRoot) throws StructureBuildingException {
        Element group = subBracketOrRoot.getName().equals("bracket") ? StructureBuildingMethods.findRightMostGroupInBracket(subBracketOrRoot) : subBracketOrRoot.getFirstChildElement("group");
        if (group.getAttribute("resolved") != null) {
            return;
        }
        Fragment frag = group.getFrag();
        if (frag.getOutAtomCount() >= 1) {
            if (subBracketOrRoot.getAttribute("locant") != null) {
                throw new RuntimeException("Substituent has an unused outAtom and has a locant but locanted substitution should already have been performed!");
            }
            if (frag.getOutAtomCount() > 1) {
                StructureBuildingMethods.checkAndApplySpecialCaseWhereOutAtomsCanBeCombinedOrThrow(frag, group);
            }
            if (subBracketOrRoot.getAttribute("multiplier") != null) {
                StructureBuildingMethods.multiplyOutAndSubstitute(state, subBracketOrRoot);
            } else {
                if ("perhalogeno".equals(group.getAttributeValue("subType"))) {
                    StructureBuildingMethods.performPerHalogenoSubstitution(state, frag, subBracketOrRoot);
                } else {
                    Fragment fragment;
                    List<Atom> hydroxyAtoms;
                    List<Fragment> possibleParents;
                    Iterator<Fragment> iterator;
                    List<Atom> atomsToJoinTo = null;
                    if ("phospho".equals(group.getAttributeValue("subType")) && frag.getOutAtom(0).getValency() == 1 && (iterator = (possibleParents = StructureBuildingMethods.findAlternativeFragments(subBracketOrRoot)).iterator()).hasNext() && (hydroxyAtoms = FragmentTools.findHydroxyGroups(fragment = iterator.next())).size() >= 1) {
                        atomsToJoinTo = hydroxyAtoms;
                    }
                    if (atomsToJoinTo == null) {
                        atomsToJoinTo = StructureBuildingMethods.findAtomsForSubstitution(subBracketOrRoot, 1, frag.getOutAtom(0).getValency());
                    }
                    if (atomsToJoinTo == null) {
                        throw new StructureBuildingException("Unlocanted substitution failed: unable to find suitable atom to bond atom with id:" + frag.getOutAtom(0).getAtom().getID() + " to!");
                    }
                    if (AmbiguityChecker.isSubstitutionAmbiguous(atomsToJoinTo, 1)) {
                        state.addIsAmbiguous("Connection of " + group.getValue() + " to " + atomsToJoinTo.get(0).getFrag().getTokenEl().getValue());
                    }
                    StructureBuildingMethods.joinFragmentsSubstitutively(state, frag, atomsToJoinTo.get(0));
                }
                group.addAttribute(new Attribute("resolved", "yes"));
            }
        }
    }

    private static void performPerHalogenoSubstitution(BuildState state, Fragment perhalogenFrag, Element subBracketOrRoot) throws StructureBuildingException {
        int i;
        List<Fragment> fragmentsToAttachTo = StructureBuildingMethods.findAlternativeFragments(subBracketOrRoot);
        ArrayList<Atom> atomsToHalogenate = new ArrayList<Atom>();
        for (Fragment fragment : fragmentsToAttachTo) {
            FragmentTools.convertSpareValenciesToDoubleBonds(fragment);
            for (Atom atom : fragment) {
                int substitutableHydrogen = StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(atom);
                if (substitutableHydrogen > 0 && FragmentTools.isCharacteristicAtom(atom)) continue;
                for (int i2 = 0; i2 < substitutableHydrogen; ++i2) {
                    atomsToHalogenate.add(atom);
                }
            }
        }
        if (atomsToHalogenate.isEmpty()) {
            throw new RuntimeException("Failed to find any substitutable hydrogen to apply " + perhalogenFrag.getTokenEl().getValue() + " to!");
        }
        ArrayList<Fragment> halogens = new ArrayList<Fragment>();
        halogens.add(perhalogenFrag);
        for (i = 0; i < atomsToHalogenate.size() - 1; ++i) {
            halogens.add(state.fragManager.copyFragment(perhalogenFrag));
        }
        for (i = 0; i < atomsToHalogenate.size(); ++i) {
            Fragment halogen = (Fragment)halogens.get(i);
            Atom from = halogen.getOutAtom(0).getAtom();
            halogen.removeOutAtom(0);
            state.fragManager.createBond(from, (Atom)atomsToHalogenate.get(i), 1);
        }
        for (i = 1; i < atomsToHalogenate.size(); ++i) {
            state.fragManager.incorporateFragment((Fragment)halogens.get(i), perhalogenFrag);
        }
    }

    private static void multiplyOutAndSubstitute(BuildState state, Element subOrBracket) throws StructureBuildingException {
        Attribute multiplierAtr = subOrBracket.getAttribute("multiplier");
        int multiplier = Integer.parseInt(multiplierAtr.getValue());
        subOrBracket.removeAttribute(multiplierAtr);
        String[] locants = null;
        String locantsAtrValue = subOrBracket.getAttributeValue("locant");
        if (locantsAtrValue != null) {
            locants = locantsAtrValue.split(",");
        }
        Element parentWordOrBracket = subOrBracket.getParent();
        int indexOfSubOrBracket = parentWordOrBracket.indexOf(subOrBracket);
        subOrBracket.detach();
        ArrayList<Element> elementsNotToBeMultiplied = new ArrayList<Element>();
        Element multiplierEl = subOrBracket.getFirstChildElement("multiplier");
        if (multiplierEl == null) {
            throw new RuntimeException("Multiplier not found where multiplier expected");
        }
        for (int i = subOrBracket.indexOf(multiplierEl) - 1; i >= 0; --i) {
            Element el = subOrBracket.getChild(i);
            el.detach();
            elementsNotToBeMultiplied.add(el);
        }
        multiplierEl.detach();
        ArrayList<Element> multipliedElements = new ArrayList<Element>();
        for (int i = multiplier - 1; i >= 0; --i) {
            Element currentElement;
            if (i != 0) {
                currentElement = state.fragManager.cloneElement(state, subOrBracket, i);
                StructureBuildingMethods.addPrimesToLocantedStereochemistryElements(currentElement, StringTools.multiplyString("'", i));
            } else {
                currentElement = subOrBracket;
            }
            multipliedElements.add(currentElement);
            if (locants == null) continue;
            parentWordOrBracket.insertChild(currentElement, indexOfSubOrBracket);
            currentElement.getAttribute("locant").setValue(locants[i]);
            StructureBuildingMethods.performLocantedSubstitutiveOperations(state, currentElement);
            currentElement.detach();
        }
        if (locants == null) {
            parentWordOrBracket.insertChild((Element)multipliedElements.get(0), indexOfSubOrBracket);
            StructureBuildingMethods.performUnlocantedSubstitutiveOperations(state, multipliedElements);
            ((Element)multipliedElements.get(0)).detach();
        }
        for (Element multipliedElement : multipliedElements) {
            parentWordOrBracket.insertChild(multipliedElement, indexOfSubOrBracket);
        }
        for (Element el : elementsNotToBeMultiplied) {
            subOrBracket.insertChild(el, 0);
        }
    }

    private static void performUnlocantedSubstitutiveOperations(BuildState state, List<Element> multipliedElements) throws StructureBuildingException {
        int numOfSubstituents = multipliedElements.size();
        Element subBracketOrRoot = multipliedElements.get(0);
        Element group = subBracketOrRoot.getName().equals("bracket") ? StructureBuildingMethods.findRightMostGroupInBracket(subBracketOrRoot) : subBracketOrRoot.getFirstChildElement("group");
        Fragment frag = group.getFrag();
        if (frag.getOutAtomCount() >= 1) {
            Fragment fragment;
            List<Atom> hydroxyAtoms;
            List<Fragment> possibleParents;
            Iterator<Fragment> iterator;
            if (subBracketOrRoot.getAttribute("locant") != null) {
                throw new RuntimeException("Substituent has an unused outAtom and has a locant but locanted substitution should already been been performed!");
            }
            if ("perhalogeno".equals(group.getAttributeValue("subType"))) {
                throw new StructureBuildingException(group.getValue() + " cannot be multiplied");
            }
            if (frag.getOutAtomCount() > 1) {
                StructureBuildingMethods.checkAndApplySpecialCaseWhereOutAtomsCanBeCombinedOrThrow(frag, group);
            }
            List<Atom> atomsToJoinTo = null;
            if ("phospho".equals(group.getAttributeValue("subType")) && frag.getOutAtom(0).getValency() == 1 && (iterator = (possibleParents = StructureBuildingMethods.findAlternativeFragments(subBracketOrRoot)).iterator()).hasNext() && (hydroxyAtoms = FragmentTools.findHydroxyGroups(fragment = iterator.next())).size() >= numOfSubstituents) {
                atomsToJoinTo = hydroxyAtoms;
            }
            if (atomsToJoinTo == null) {
                atomsToJoinTo = StructureBuildingMethods.findAtomsForSubstitution(subBracketOrRoot, numOfSubstituents, frag.getOutAtom(0).getValency());
            }
            if (atomsToJoinTo == null) {
                throw new StructureBuildingException("Unlocanted substitution failed: unable to find suitable atom to bond atom with id:" + frag.getOutAtom(0).getAtom().getID() + " to!");
            }
            if (AmbiguityChecker.isSubstitutionAmbiguous(atomsToJoinTo, numOfSubstituents)) {
                state.addIsAmbiguous("Connection of " + group.getValue() + " to " + atomsToJoinTo.get(0).getFrag().getTokenEl().getValue());
                List<Atom> atomsPreferredByEnvironment = AmbiguityChecker.useAtomEnvironmentsToGivePlausibleSubstitution(atomsToJoinTo, numOfSubstituents);
                if (atomsPreferredByEnvironment != null) {
                    atomsToJoinTo = atomsPreferredByEnvironment;
                }
            }
            StructureBuildingMethods.joinFragmentsSubstitutively(state, frag, atomsToJoinTo.get(0));
            group.addAttribute(new Attribute("resolved", "yes"));
            for (int i = 1; i < numOfSubstituents; ++i) {
                subBracketOrRoot = multipliedElements.get(i);
                group = subBracketOrRoot.getName().equals("bracket") ? StructureBuildingMethods.findRightMostGroupInBracket(subBracketOrRoot) : subBracketOrRoot.getFirstChildElement("group");
                frag = group.getFrag();
                if (frag.getOutAtomCount() > 1) {
                    StructureBuildingMethods.checkAndApplySpecialCaseWhereOutAtomsCanBeCombinedOrThrow(frag, group);
                }
                StructureBuildingMethods.joinFragmentsSubstitutively(state, frag, atomsToJoinTo.get(i));
                group.addAttribute(new Attribute("resolved", "yes"));
            }
        }
    }

    static void resolveLocantedFeatures(BuildState state, Element subOrRoot) throws StructureBuildingException {
        String locant;
        int i;
        List<Element> groups = subOrRoot.getChildElements("group");
        if (groups.size() != 1) {
            throw new StructureBuildingException("Each sub or root should only have one group element. This indicates a bug in OPSIN");
        }
        Element group = groups.get(0);
        Fragment thisFrag = group.getFrag();
        ArrayList<Element> unsaturators = new ArrayList<Element>();
        ArrayList<Element> heteroatoms = new ArrayList<Element>();
        ArrayList<Element> hydrogenElements = new ArrayList<Element>();
        ArrayList<Element> subtractivePrefixElements = new ArrayList<Element>();
        ArrayList<Element> isotopeSpecifications = new ArrayList<Element>();
        List<Element> children = subOrRoot.getChildElements();
        for (Element currentEl : children) {
            String elName = currentEl.getName();
            if (elName.equals("unsaturator")) {
                unsaturators.add(currentEl);
                continue;
            }
            if (elName.equals("heteroatom")) {
                heteroatoms.add(currentEl);
                continue;
            }
            if (elName.equals("subtractivePrefix")) {
                subtractivePrefixElements.add(currentEl);
                continue;
            }
            if (elName.equals("hydro")) {
                hydrogenElements.add(currentEl);
                continue;
            }
            if (elName.equals("indicatedHydrogen")) {
                hydrogenElements.add(currentEl);
                continue;
            }
            if (elName.equals("addedHydrogen")) {
                hydrogenElements.add(currentEl);
                continue;
            }
            if (!elName.equals("isotopeSpecification")) continue;
            isotopeSpecifications.add(currentEl);
        }
        if (!subtractivePrefixElements.isEmpty()) {
            ArrayList<Atom> atomsToDehydro = new ArrayList<Atom>();
            HashMap<ChemEl, Integer> unlocantedSubtractivePrefixes = new HashMap<ChemEl, Integer>();
            HashMap<ChemEl, Integer> unlocantedHeteroatomRemovalPrefixes = new HashMap<ChemEl, Integer>();
            for (int i2 = subtractivePrefixElements.size() - 1; i2 >= 0; --i2) {
                Element subtractivePrefix = (Element)subtractivePrefixElements.get(i2);
                String type = subtractivePrefix.getAttributeValue("type");
                String locant2 = subtractivePrefix.getAttributeValue("locant");
                switch (type) {
                    case "deoxy": {
                        ChemEl atomToRemove = ChemEl.valueOf(subtractivePrefix.getAttributeValue("value"));
                        if (locant2 == null) {
                            Integer count = (Integer)unlocantedSubtractivePrefixes.get((Object)atomToRemove);
                            unlocantedSubtractivePrefixes.put(atomToRemove, count != null ? count + 1 : 1);
                            break;
                        }
                        StructureBuildingMethods.applySubtractivePrefix(state, thisFrag, atomToRemove, locant2);
                        break;
                    }
                    case "anhydro": {
                        StructureBuildingMethods.applyAnhydroPrefix(state, thisFrag, subtractivePrefix);
                        break;
                    }
                    case "dehydro": {
                        if (locant2 != null) {
                            atomsToDehydro.add(thisFrag.getAtomByLocantOrThrow(locant2));
                            break;
                        }
                        throw new StructureBuildingException("locants are assumed to be required for the use of dehydro to be unambiguous");
                    }
                    case "heteratomRemoval": {
                        ChemEl heteroatom = ChemEl.valueOf(subtractivePrefix.getAttributeValue("value"));
                        if (locant2 == null) {
                            Integer count = (Integer)unlocantedHeteroatomRemovalPrefixes.get((Object)heteroatom);
                            unlocantedHeteroatomRemovalPrefixes.put(heteroatom, count != null ? count + 1 : 1);
                            break;
                        }
                        StructureBuildingMethods.applyHeteroatomRemovalPrefix(state, thisFrag, heteroatom, locant2);
                        break;
                    }
                    default: {
                        throw new StructureBuildingException("OPSIN bug: Unexpected subtractive prefix type: " + type);
                    }
                }
                subtractivePrefix.detach();
            }
            for (Map.Entry entry : unlocantedSubtractivePrefixes.entrySet()) {
                StructureBuildingMethods.applyUnlocantedSubtractivePrefixes(state, thisFrag, (ChemEl)((Object)entry.getKey()), (Integer)entry.getValue());
            }
            for (Map.Entry entry : unlocantedHeteroatomRemovalPrefixes.entrySet()) {
                StructureBuildingMethods.applyUnlocantedHeteroatomRemovalPrefixes(state, thisFrag, (ChemEl)((Object)entry.getKey()), (Integer)entry.getValue());
            }
            if (atomsToDehydro.size() > 0) {
                Object uniquifiedDehydroAtoms;
                boolean isCarbohydrateDehydro = false;
                if (group.getAttributeValue("type").equals("carbohydrate") && (uniquifiedDehydroAtoms = new HashSet(atomsToDehydro)).size() == atomsToDehydro.size()) {
                    isCarbohydrateDehydro = true;
                }
                if (isCarbohydrateDehydro) {
                    for (Atom a : atomsToDehydro) {
                        List<Atom> hydroxyAtoms = FragmentTools.findHydroxyLikeTerminalAtoms(a.getAtomNeighbours(), ChemEl.O);
                        if (hydroxyAtoms.size() > 0) {
                            hydroxyAtoms.get(0).getFirstBond().setOrder(2);
                            continue;
                        }
                        throw new StructureBuildingException("atom with locant " + a.getFirstLocant() + " did not have a hydroxy group to convert to a ketose");
                    }
                } else {
                    ArrayList<Atom> atomsToFormDoubleBonds = new ArrayList<Atom>();
                    ArrayList<Atom> atomsToFormTripleBondsBetween = new ArrayList<Atom>();
                    for (Atom a : atomsToDehydro) {
                        if (!a.hasSpareValency()) {
                            a.setSpareValency(true);
                            atomsToFormDoubleBonds.add(a);
                            continue;
                        }
                        atomsToFormTripleBondsBetween.add(a);
                    }
                    for (Atom atom : atomsToFormDoubleBonds) {
                        boolean hasSpareValency = false;
                        for (Atom neighbour : atom.getAtomNeighbours()) {
                            if (!neighbour.hasSpareValency()) continue;
                            hasSpareValency = true;
                            break;
                        }
                        if (hasSpareValency) continue;
                        throw new StructureBuildingException("Unexpected use of dehydro; two adjacent atoms were not unsaturated such as to form a double bond");
                    }
                    StructureBuildingMethods.addDehydroInducedTripleBonds(atomsToFormTripleBondsBetween);
                }
            }
        }
        for (i = hydrogenElements.size() - 1; i >= 0; --i) {
            Element hydrogen = (Element)hydrogenElements.get(i);
            locant = hydrogen.getAttributeValue("locant");
            if (locant == null) continue;
            Atom a = thisFrag.getAtomByLocantOrThrow(locant);
            if (a.hasSpareValency()) {
                a.setSpareValency(false);
            } else if (!StructureBuildingMethods.acdNameSpiroIndicatedHydrogenBug(group, locant)) {
                throw new StructureBuildingException("hydrogen addition at locant: " + locant + " was requested, but this atom is not unsaturated");
            }
            hydrogenElements.remove(i);
            hydrogen.detach();
        }
        for (i = unsaturators.size() - 1; i >= 0; --i) {
            Element unsaturator = (Element)unsaturators.get(i);
            locant = unsaturator.getAttributeValue("locant");
            int bondOrder = Integer.parseInt(unsaturator.getAttributeValue("value"));
            if (bondOrder <= 1) {
                unsaturator.detach();
                continue;
            }
            if (locant == null) continue;
            unsaturators.remove(unsaturator);
            Matcher matcher = matchCompoundLocant.matcher(locant);
            if (matcher.find()) {
                String compoundLocant = matcher.group(1);
                locant = matcher.replaceAll("");
                FragmentTools.unsaturate(thisFrag.getAtomByLocantOrThrow(locant), compoundLocant, bondOrder, thisFrag);
            } else {
                FragmentTools.unsaturate(thisFrag.getAtomByLocantOrThrow(locant), bondOrder, thisFrag);
            }
            unsaturator.detach();
        }
        for (i = heteroatoms.size() - 1; i >= 0; --i) {
            Element heteroatomEl = (Element)heteroatoms.get(i);
            locant = heteroatomEl.getAttributeValue("locant");
            if (locant == null) continue;
            Atom heteroatom = state.fragManager.getHeteroatom(heteroatomEl.getAttributeValue("value"));
            Atom atomToBeReplaced = thisFrag.getAtomByLocantOrThrow(locant);
            if (heteroatom.getElement() == atomToBeReplaced.getElement() && heteroatom.getCharge() == atomToBeReplaced.getCharge()) {
                throw new StructureBuildingException("The replacement term " + heteroatomEl.getValue() + " was used on an atom that already is a " + (Object)((Object)heteroatom.getElement()));
            }
            state.fragManager.replaceAtomWithAtom(thisFrag.getAtomByLocantOrThrow(locant), heteroatom, true);
            if (heteroatomEl.getAttribute("lambda") != null) {
                thisFrag.getAtomByLocantOrThrow(locant).setLambdaConventionValency(Integer.parseInt(heteroatomEl.getAttributeValue("lambda")));
            }
            heteroatoms.remove(heteroatomEl);
            heteroatomEl.detach();
        }
        if (isotopeSpecifications.size() > 0) {
            StructureBuildingMethods.applyIsotopeSpecifications(state, thisFrag, isotopeSpecifications, true);
        }
    }

    private static boolean acdNameSpiroIndicatedHydrogenBug(Element group, String indicatedHydrogenLocant) {
        if (group.getValue().startsWith("spiro")) {
            for (Element suffix : group.getParent().getChildElements("suffix")) {
                String suffixLocant = suffix.getAttributeValue("locant");
                if (suffixLocant == null || !suffixLocant.equals(indicatedHydrogenLocant)) continue;
                LOG.debug("Indicated hydrogen at " + indicatedHydrogenLocant + " ignored. Known bug in generated IUPAC name");
                return true;
            }
        }
        return false;
    }

    static void applySubtractivePrefix(BuildState state, Fragment fragment, ChemEl chemEl, String locant) throws StructureBuildingException {
        Atom adjacentAtom = fragment.getAtomByLocantOrThrow(locant);
        List<Atom> applicableTerminalAtoms = FragmentTools.findHydroxyLikeTerminalAtoms(adjacentAtom.getAtomNeighbours(), chemEl);
        if (applicableTerminalAtoms.isEmpty()) {
            throw new StructureBuildingException("Unable to find terminal atom of type: " + (Object)((Object)chemEl) + " at locant " + locant + " for subtractive nomenclature");
        }
        Atom atomToRemove = applicableTerminalAtoms.get(0);
        if (FragmentTools.isFunctionalAtom(atomToRemove)) {
            int len = fragment.getFunctionalAtomCount();
            for (int i = 0; i < len; ++i) {
                if (!atomToRemove.equals(fragment.getFunctionalAtom(i).getAtom())) continue;
                fragment.removeFunctionalAtom(i);
                break;
            }
            fragment.addFunctionalAtom(atomToRemove.getFirstBond().getOtherAtom(atomToRemove));
        }
        FragmentTools.removeTerminalAtom(state, atomToRemove);
    }

    static void applyUnlocantedSubtractivePrefixes(BuildState state, Fragment fragment, ChemEl chemEl, int count) throws StructureBuildingException {
        List<Atom> applicableTerminalAtoms = FragmentTools.findHydroxyLikeTerminalAtoms(fragment.getAtomList(), chemEl);
        if (applicableTerminalAtoms.isEmpty() || applicableTerminalAtoms.size() < count) {
            throw new StructureBuildingException("Unable to find terminal atom of type: " + (Object)((Object)chemEl) + " for subtractive nomenclature");
        }
        if (AmbiguityChecker.isSubstitutionAmbiguous(applicableTerminalAtoms, count)) {
            state.addIsAmbiguous("Group to remove with subtractive prefix");
        }
        for (int i = 0; i < count; ++i) {
            Atom atomToRemove = applicableTerminalAtoms.get(i);
            if (FragmentTools.isFunctionalAtom(atomToRemove)) {
                int len = fragment.getFunctionalAtomCount();
                for (int j = 0; j < len; ++j) {
                    if (!atomToRemove.equals(fragment.getFunctionalAtom(j).getAtom())) continue;
                    fragment.removeFunctionalAtom(j);
                    break;
                }
                fragment.addFunctionalAtom(atomToRemove.getFirstBond().getOtherAtom(atomToRemove));
            }
            FragmentTools.removeTerminalAtom(state, atomToRemove);
        }
    }

    private static void applyAnhydroPrefix(BuildState state, Fragment frag, Element subtractivePrefix) throws StructureBuildingException {
        ChemEl chemEl = ChemEl.valueOf(subtractivePrefix.getAttributeValue("value"));
        String locantStr = subtractivePrefix.getAttributeValue("locant");
        if (locantStr == null) {
            throw new StructureBuildingException("Two locants are required before an anhydro prefix");
        }
        String[] locants = locantStr.split(",");
        Atom backBoneAtom1 = frag.getAtomByLocantOrThrow(locants[0]);
        Atom backBoneAtom2 = frag.getAtomByLocantOrThrow(locants[1]);
        List<Atom> applicableTerminalAtoms = FragmentTools.findHydroxyLikeTerminalAtoms(backBoneAtom1.getAtomNeighbours(), chemEl);
        if (applicableTerminalAtoms.isEmpty()) {
            throw new StructureBuildingException("Unable to find terminal atom of type: " + (Object)((Object)chemEl) + " for subtractive nomenclature");
        }
        FragmentTools.removeTerminalAtom(state, applicableTerminalAtoms.get(0));
        applicableTerminalAtoms = FragmentTools.findHydroxyLikeTerminalAtoms(backBoneAtom2.getAtomNeighbours(), chemEl);
        if (applicableTerminalAtoms.isEmpty()) {
            throw new StructureBuildingException("Unable to find terminal atom of type: " + (Object)((Object)chemEl) + " for subtractive nomenclature");
        }
        state.fragManager.createBond(backBoneAtom1, applicableTerminalAtoms.get(0), 1);
    }

    private static void addDehydroInducedTripleBonds(List<Atom> atomsToFormTripleBondsBetween) throws StructureBuildingException {
        if (atomsToFormTripleBondsBetween.size() > 0) {
            HashSet<Atom> atoms = new HashSet<Atom>(atomsToFormTripleBondsBetween);
            if (atomsToFormTripleBondsBetween.size() != atoms.size()) {
                throw new StructureBuildingException("locants specified for dehydro specify the same atom too many times");
            }
            for (int i = atomsToFormTripleBondsBetween.size() - 1; i >= 0; i -= 2) {
                Atom neighbour2;
                Atom a;
                block4: {
                    a = atomsToFormTripleBondsBetween.get(i);
                    List<Atom> neighbours = a.getAtomNeighbours();
                    for (Atom neighbour2 : neighbours) {
                        if (!atomsToFormTripleBondsBetween.contains(neighbour2)) continue;
                        break block4;
                    }
                    throw new StructureBuildingException("dehydro indicated atom should form a triple bond but no adjacent atoms also had hydrogen removed!");
                }
                atomsToFormTripleBondsBetween.remove(i);
                atomsToFormTripleBondsBetween.remove(neighbour2);
                Bond b = a.getBondToAtomOrThrow(neighbour2);
                b.setOrder(3);
                a.setSpareValency(false);
                neighbour2.setSpareValency(false);
            }
        }
    }

    private static void applyHeteroatomRemovalPrefix(BuildState state, Fragment fragment, ChemEl chemEl, String locant) throws StructureBuildingException {
        Atom atomToChange = fragment.getAtomByLocantOrThrow(locant);
        if (atomToChange.getElement() != chemEl) {
            throw new StructureBuildingException("Removal of " + chemEl.toString() + " requested, but the atom at locant " + locant + " is not this element");
        }
        atomToChange.setElement(ChemEl.C);
        atomToChange.removeElementSymbolLocants();
    }

    private static void applyUnlocantedHeteroatomRemovalPrefixes(BuildState state, Fragment fragment, ChemEl chemEl, int count) throws StructureBuildingException {
        ArrayList<Atom> applicableAtoms = new ArrayList<Atom>();
        for (Atom atom : fragment) {
            if (atom.getElement() != chemEl) continue;
            applicableAtoms.add(atom);
        }
        if (applicableAtoms.isEmpty() || applicableAtoms.size() < count) {
            throw new StructureBuildingException("Unable to find sufficient atoms of element: " + (Object)((Object)chemEl) + " for subtractive nomenclature");
        }
        if (AmbiguityChecker.isSubstitutionAmbiguous(applicableAtoms, count)) {
            state.addIsAmbiguous("Group to remove with subtractive prefix");
        }
        for (int i = 0; i < count; ++i) {
            Atom atomToChange = (Atom)applicableAtoms.get(i);
            atomToChange.setElement(ChemEl.C);
            atomToChange.removeElementSymbolLocants();
        }
    }

    static void resolveUnLocantedFeatures(BuildState state, Element subOrRoot) throws StructureBuildingException {
        List<Element> groups = subOrRoot.getChildElements("group");
        if (groups.size() != 1) {
            throw new StructureBuildingException("Each sub or root should only have one group element. This indicates a bug in OPSIN");
        }
        Fragment frag = groups.get(0).getFrag();
        ArrayList<Integer> unsaturationBondOrders = new ArrayList<Integer>();
        ArrayList<Element> heteroatoms = new ArrayList<Element>();
        ArrayList<Element> hydrogenElements = new ArrayList<Element>();
        ArrayList<Element> isotopeSpecifications = new ArrayList<Element>();
        List<Element> children = subOrRoot.getChildElements();
        for (Element currentEl : children) {
            String elName = currentEl.getName();
            if (elName.equals("unsaturator")) {
                int bondOrder = Integer.parseInt(currentEl.getAttributeValue("value"));
                if (bondOrder > 1) {
                    unsaturationBondOrders.add(bondOrder);
                }
                currentEl.detach();
                continue;
            }
            if (elName.equals("heteroatom")) {
                heteroatoms.add(currentEl);
                currentEl.detach();
                continue;
            }
            if (elName.equals("hydro") || elName.equals("indicatedHydrogen") || elName.equals("addedHydrogen")) {
                hydrogenElements.add(currentEl);
                currentEl.detach();
                continue;
            }
            if (!elName.equals("isotopeSpecification")) continue;
            isotopeSpecifications.add(currentEl);
        }
        if (hydrogenElements.size() > 0) {
            StructureBuildingMethods.applyUnlocantedHydro(state, frag, hydrogenElements);
        }
        if (unsaturationBondOrders.size() > 0) {
            StructureBuildingMethods.unsaturateBonds(state, frag, unsaturationBondOrders);
        }
        if (heteroatoms.size() > 0) {
            StructureBuildingMethods.applyUnlocantedHeteroatoms(state, frag, heteroatoms);
        }
        if (isotopeSpecifications.size() > 0) {
            StructureBuildingMethods.applyIsotopeSpecifications(state, frag, isotopeSpecifications, false);
        }
        if (frag.getOutAtomCount() > 0) {
            int l = frag.getOutAtomCount();
            for (int i = 0; i < l; ++i) {
                OutAtom outAtom = frag.getOutAtom(i);
                if (outAtom.isSetExplicitly()) continue;
                outAtom.setAtom(StructureBuildingMethods.findAtomForUnlocantedRadical(state, frag, outAtom));
                outAtom.setSetExplicitly(true);
            }
        }
    }

    private static void applyUnlocantedHydro(BuildState state, Fragment frag, List<Element> hydrogenElements) throws StructureBuildingException {
        ArrayList<Atom> atomsAcceptingHydroPrefix = new ArrayList<Atom>();
        HashSet<Atom> atomsWhichImplicitlyHadTheirSVRemoved = new HashSet<Atom>();
        List<Atom> atomList = frag.getAtomList();
        for (Atom atom : atomList) {
            if (atom.getType().equals("suffix")) continue;
            atom.ensureSVIsConsistantWithValency(false);
            if (!atom.hasSpareValency()) continue;
            atomsAcceptingHydroPrefix.add(atom);
            atom.ensureSVIsConsistantWithValency(true);
            if (atom.hasSpareValency()) continue;
            atomsWhichImplicitlyHadTheirSVRemoved.add(atom);
        }
        int hydrogenElsCount = hydrogenElements.size();
        for (Element hydrogenElement : hydrogenElements) {
            if (!hydrogenElement.getValue().equals("perhydro")) continue;
            if (hydrogenElsCount != 1) {
                throw new StructureBuildingException("Unexpected indication of hydrogen when perhydro makes such indication redundnant");
            }
            for (Atom atom : atomsAcceptingHydroPrefix) {
                atom.setSpareValency(false);
            }
            return;
        }
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        ArrayList<Atom> otherAtomsThatCanHaveHydro = new ArrayList<Atom>();
        for (Atom atom : atomsAcceptingHydroPrefix) {
            if (atomsWhichImplicitlyHadTheirSVRemoved.contains(atom)) {
                otherAtomsThatCanHaveHydro.add(atom);
                continue;
            }
            boolean canFormDoubleBond = false;
            for (Atom aa : frag.getIntraFragmentAtomNeighbours(atom)) {
                if (!aa.hasSpareValency()) continue;
                canFormDoubleBond = true;
                break;
            }
            if (canFormDoubleBond) {
                arrayList.add(atom);
                continue;
            }
            otherAtomsThatCanHaveHydro.add(atom);
        }
        ArrayList<Atom> prioritisedAtomsAcceptingHydro = new ArrayList<Atom>(arrayList);
        prioritisedAtomsAcceptingHydro.addAll(otherAtomsThatCanHaveHydro);
        if (hydrogenElsCount > prioritisedAtomsAcceptingHydro.size()) {
            throw new StructureBuildingException("Cannot find atom to add hydrogen to (" + hydrogenElsCount + " hydrogens requested but only " + prioritisedAtomsAcceptingHydro.size() + " positions that can be hydrogenated)");
        }
        int n = arrayList.size() - hydrogenElsCount;
        if (n > 1 && (!AmbiguityChecker.allAtomsEquivalent(arrayList) || hydrogenElsCount != 1 && hydrogenElsCount != arrayList.size() - 1)) {
            state.addIsAmbiguous("Ambiguous choice of positions to add hydrogen to on " + frag.getTokenEl().getValue());
        }
        for (int i = 0; i < hydrogenElsCount; ++i) {
            ((Atom)prioritisedAtomsAcceptingHydro.get(i)).setSpareValency(false);
        }
    }

    private static void unsaturateBonds(BuildState state, Fragment frag, List<Integer> unsaturationBondOrders) throws StructureBuildingException {
        int tripleBonds = 0;
        int doublebonds = 0;
        for (Integer bondOrder : unsaturationBondOrders) {
            if (bondOrder == 3) {
                ++tripleBonds;
                continue;
            }
            if (bondOrder == 2) {
                ++doublebonds;
                continue;
            }
            throw new RuntimeException("Unexpected unsaturation bon order: " + bondOrder);
        }
        if (tripleBonds > 0) {
            StructureBuildingMethods.unsaturateBonds(state, frag, 3, tripleBonds);
        }
        if (doublebonds > 0) {
            StructureBuildingMethods.unsaturateBonds(state, frag, 2, doublebonds);
        }
    }

    private static void unsaturateBonds(BuildState state, Fragment frag, int bondOrder, int numToUnsaturate) throws StructureBuildingException {
        List<Bond> bondsThatCouldBeUnsaturated = StructureBuildingMethods.findBondsToUnSaturate(frag, bondOrder, false);
        List<Object> alternativeBondsThatCouldBeUnsaturated = Collections.emptyList();
        if (bondsThatCouldBeUnsaturated.size() < numToUnsaturate) {
            bondsThatCouldBeUnsaturated = StructureBuildingMethods.findBondsToUnSaturate(frag, bondOrder, true);
        } else {
            alternativeBondsThatCouldBeUnsaturated = StructureBuildingMethods.findAlternativeBondsToUnSaturate(frag, bondOrder, bondsThatCouldBeUnsaturated);
        }
        if (bondsThatCouldBeUnsaturated.size() < numToUnsaturate) {
            throw new StructureBuildingException("Failed to find bond to change to a bond of order: " + bondOrder);
        }
        if (bondsThatCouldBeUnsaturated.size() > numToUnsaturate && !StructureBuildingMethods.isCycloAlkaneSpecialCase(frag, numToUnsaturate, bondsThatCouldBeUnsaturated) && !"hantzschWidman".equals(frag.getSubType())) {
            if (alternativeBondsThatCouldBeUnsaturated.size() >= numToUnsaturate) {
                ArrayList<Bond> allBonds = new ArrayList<Bond>(bondsThatCouldBeUnsaturated);
                allBonds.addAll(alternativeBondsThatCouldBeUnsaturated);
                if (!AmbiguityChecker.allBondsEquivalent(allBonds) || numToUnsaturate != 1) {
                    state.addIsAmbiguous("Unsaturation of bonds of " + frag.getTokenEl().getValue());
                }
            } else if (!AmbiguityChecker.allBondsEquivalent(bondsThatCouldBeUnsaturated) || numToUnsaturate != 1 && numToUnsaturate != bondsThatCouldBeUnsaturated.size() - 1) {
                state.addIsAmbiguous("Unsaturation of bonds of " + frag.getTokenEl().getValue());
            }
        }
        for (int i = 0; i < numToUnsaturate; ++i) {
            bondsThatCouldBeUnsaturated.get(i).setOrder(bondOrder);
        }
    }

    private static boolean isCycloAlkaneSpecialCase(Fragment frag, int numToUnsaturate, List<Bond> bondsThatCouldBeUnsaturated) {
        if (numToUnsaturate == 1) {
            Bond b = bondsThatCouldBeUnsaturated.get(0);
            Atom a1 = b.getFromAtom();
            Atom a2 = b.getToAtom();
            if (("alkaneStem".equals(frag.getSubType()) || "heteroStem".equals(frag.getSubType())) && a1.getAtomIsInACycle() && a2.getAtomIsInACycle() && (a1.equals(frag.getFirstAtom()) || a2.equals(frag.getFirstAtom()))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isCycloAlkaneHeteroatomSpecialCase(Fragment frag, int numHeteroatoms, List<Atom> atomsThatCouldBeReplaced) {
        return numHeteroatoms == 1 && ("alkaneStem".equals(frag.getSubType()) || "heteroStem".equals(frag.getSubType())) && frag.getFirstAtom().getAtomIsInACycle() && atomsThatCouldBeReplaced.get(0).equals(frag.getFirstAtom());
    }

    private static void applyUnlocantedHeteroatoms(BuildState state, Fragment frag, List<Element> heteroatoms) throws StructureBuildingException {
        HashMap<HeteroAtomSmilesAndLambda, Integer> heteroatomDescriptionToCount = new HashMap<HeteroAtomSmilesAndLambda, Integer>();
        for (Element heteroatomEl : heteroatoms) {
            String lambdaConvention;
            HeteroAtomSmilesAndLambda desc;
            String smiles = heteroatomEl.getAttributeValue("value");
            Integer count = (Integer)heteroatomDescriptionToCount.get(desc = new HeteroAtomSmilesAndLambda(smiles, lambdaConvention = heteroatomEl.getAttributeValue("lambda")));
            heteroatomDescriptionToCount.put(desc, count != null ? count + 1 : 1);
        }
        List<Atom> atomlist = frag.getAtomList();
        for (Map.Entry entry : heteroatomDescriptionToCount.entrySet()) {
            HeteroAtomSmilesAndLambda desc = (HeteroAtomSmilesAndLambda)entry.getKey();
            int replacementsRequired = (Integer)entry.getValue();
            Atom heteroatom = state.fragManager.getHeteroatom(desc.smiles);
            ChemEl heteroatomChemEl = heteroatom.getElement();
            ArrayList<Atom> atomsThatCouldBeReplaced = new ArrayList<Atom>();
            for (Atom atom : atomlist) {
                if (atom.getType().equals("suffix") || heteroatomChemEl.equals((Object)atom.getElement()) && heteroatom.getCharge() == atom.getCharge() || atom.getElement() != ChemEl.C && heteroatomChemEl != ChemEl.C && (atom.getElement() != ChemEl.O || heteroatomChemEl != ChemEl.S && heteroatomChemEl != ChemEl.Se && heteroatomChemEl != ChemEl.Te) || !ValencyChecker.checkValencyAvailableForReplacementByHeteroatom(atom, heteroatom)) continue;
                atomsThatCouldBeReplaced.add(atom);
            }
            if (atomsThatCouldBeReplaced.size() < replacementsRequired) {
                throw new StructureBuildingException("Cannot find suitable atom for heteroatom replacement");
            }
            if (atomsThatCouldBeReplaced.size() > replacementsRequired && !StructureBuildingMethods.isCycloAlkaneHeteroatomSpecialCase(frag, replacementsRequired, atomsThatCouldBeReplaced) && (!AmbiguityChecker.allAtomsEquivalent(atomsThatCouldBeReplaced) || replacementsRequired != 1 && replacementsRequired != atomsThatCouldBeReplaced.size() - 1)) {
                state.addIsAmbiguous("Heteroatom replacement on " + frag.getTokenEl().getValue());
            }
            for (int i = 0; i < replacementsRequired; ++i) {
                Atom atomToReplaceWithHeteroAtom = (Atom)atomsThatCouldBeReplaced.get(i);
                state.fragManager.replaceAtomWithAtom(atomToReplaceWithHeteroAtom, heteroatom, true);
                if (desc.lambdaConvention == null) continue;
                atomToReplaceWithHeteroAtom.setLambdaConventionValency(Integer.parseInt(desc.lambdaConvention));
            }
        }
    }

    private static void applyIsotopeSpecifications(BuildState state, Fragment frag, List<Element> isotopeSpecifications, boolean applyLocanted) throws StructureBuildingException {
        for (int i = isotopeSpecifications.size() - 1; i >= 0; --i) {
            Element isotopeSpecification = isotopeSpecifications.get(i);
            IsotopeSpecificationParser.IsotopeSpecification isotopeSpec = IsotopeSpecificationParser.parseIsotopeSpecification(isotopeSpecification);
            String[] locants = isotopeSpec.getLocants();
            if (locants != null ? !applyLocanted : applyLocanted) continue;
            ChemEl chemEl = isotopeSpec.getChemEl();
            int isotope = isotopeSpec.getIsotope();
            if (locants != null) {
                int j;
                if (chemEl == ChemEl.H) {
                    for (j = 0; j < locants.length; ++j) {
                        Atom atomWithHydrogenIsotope = frag.getAtomByLocantOrThrow(locants[j]);
                        Atom hydrogen = state.fragManager.createAtom(isotopeSpec.getChemEl(), frag);
                        hydrogen.setIsotope(isotope);
                        state.fragManager.createBond(atomWithHydrogenIsotope, hydrogen, 1);
                    }
                } else {
                    for (j = 0; j < locants.length; ++j) {
                        Atom atom = frag.getAtomByLocantOrThrow(locants[j]);
                        if (chemEl != atom.getElement()) {
                            throw new StructureBuildingException("The atom at locant: " + locants[j] + " was not a " + chemEl.toString());
                        }
                        atom.setIsotope(isotope);
                    }
                }
            } else {
                List<Object> parentAtomsToApplyTo;
                int multiplier = isotopeSpec.getMultiplier();
                if (chemEl == ChemEl.H) {
                    parentAtomsToApplyTo = FragmentTools.findnAtomsForSubstitution(frag, multiplier, 1);
                    if (parentAtomsToApplyTo == null) {
                        throw new StructureBuildingException("Failed to find sufficient hydrogen atoms for unlocanted hydrogen isotope replacement");
                    }
                    if (AmbiguityChecker.isSubstitutionAmbiguous(parentAtomsToApplyTo, multiplier) && !StructureBuildingMethods.casIsotopeAmbiguitySpecialCase(frag, parentAtomsToApplyTo, multiplier)) {
                        state.addIsAmbiguous("Position of hydrogen isotope on " + frag.getTokenEl().getValue());
                    }
                    for (int j = 0; j < multiplier; ++j) {
                        Atom atomWithHydrogenIsotope = (Atom)parentAtomsToApplyTo.get(j);
                        Atom hydrogen = state.fragManager.createAtom(isotopeSpec.getChemEl(), frag);
                        hydrogen.setIsotope(isotope);
                        state.fragManager.createBond(atomWithHydrogenIsotope, hydrogen, 1);
                    }
                } else {
                    parentAtomsToApplyTo = new ArrayList();
                    for (Atom atom : frag) {
                        if (atom.getElement() != chemEl) continue;
                        parentAtomsToApplyTo.add(atom);
                    }
                    if (parentAtomsToApplyTo.size() < multiplier) {
                        throw new StructureBuildingException("Failed to find sufficient atoms for " + chemEl.toString() + " isotope replacement");
                    }
                    if (AmbiguityChecker.isSubstitutionAmbiguous(parentAtomsToApplyTo, multiplier)) {
                        state.addIsAmbiguous("Position of isotope on " + frag.getTokenEl().getValue());
                    }
                    for (int j = 0; j < multiplier; ++j) {
                        ((Atom)parentAtomsToApplyTo.get(j)).setIsotope(isotope);
                    }
                }
            }
            isotopeSpecification.detach();
        }
    }

    private static boolean casIsotopeAmbiguitySpecialCase(Fragment frag, List<Atom> parentAtomsToApplyTo, int multiplier) throws StructureBuildingException {
        if (multiplier != 1) {
            return false;
        }
        List<Atom> atoms = frag.getAtomList();
        Atom firstAtom = atoms.get(0);
        if (!parentAtomsToApplyTo.get(0).equals(firstAtom)) {
            return false;
        }
        ChemEl firstAtomEl = firstAtom.getElement();
        if (atoms.size() == 2) {
            if (firstAtomEl == atoms.get(1).getElement()) {
                return true;
            }
        } else {
            int intraFragValency = frag.getIntraFragmentIncomingValency(firstAtom);
            boolean spareValency = firstAtom.hasSpareValency();
            if (firstAtom.getAtomIsInACycle()) {
                for (int i = 1; i < atoms.size(); ++i) {
                    Atom atom = atoms.get(i);
                    if (atom.getElement() != firstAtomEl) {
                        return false;
                    }
                    if (frag.getIntraFragmentIncomingValency(atom) != intraFragValency) {
                        return false;
                    }
                    if (atom.hasSpareValency() == spareValency) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    static Atom findAtomForUnlocantedRadical(BuildState state, Fragment frag, OutAtom outAtom) throws StructureBuildingException {
        List<Atom> possibleAtoms = FragmentTools.findnAtomsForSubstitution(frag, outAtom.getAtom(), 1, outAtom.getValency(), true);
        if (possibleAtoms == null) {
            throw new StructureBuildingException("Failed to assign all unlocanted radicals to actual atoms without violating valency");
        }
        if ((!"alkaneStem".equals(frag.getSubType()) && !"heteroStem".equals(frag.getSubType()) || !possibleAtoms.get(0).equals(frag.getFirstAtom())) && AmbiguityChecker.isSubstitutionAmbiguous(possibleAtoms, 1)) {
            state.addIsAmbiguous("Positioning of radical on: " + frag.getTokenEl().getValue());
        }
        return possibleAtoms.get(0);
    }

    private static List<Bond> findAlternativeBondsToUnSaturate(Fragment frag, int bondOrder, Collection<Bond> bondsToIgnore) {
        return StructureBuildingMethods.findBondsToUnSaturate(frag, bondOrder, false, new HashSet<Bond>(bondsToIgnore));
    }

    static List<Bond> findBondsToUnSaturate(Fragment frag, int bondOrder, boolean allowAdjacentUnsaturatedBonds) {
        return StructureBuildingMethods.findBondsToUnSaturate(frag, bondOrder, allowAdjacentUnsaturatedBonds, Collections.emptySet());
    }

    private static List<Bond> findBondsToUnSaturate(Fragment frag, int bondOrder, boolean allowAdjacentUnsaturatedBonds, Set<Bond> bondsToIgnore) {
        ArrayList<Bond> bondsToUnsaturate = new ArrayList<Bond>();
        block0: for (Atom atom1 : frag) {
            if (atom1.hasSpareValency() || "suffix".equals(atom1.getType()) || atom1.getProperty(Atom.ISALDEHYDE) != null) continue;
            List<Bond> bonds = atom1.getBonds();
            int incomingValency = 0;
            for (Bond bond : bonds) {
                if (bond.getOrder() != 1 && !allowAdjacentUnsaturatedBonds) continue block0;
                if (bondsToUnsaturate.contains(bond)) {
                    if (!allowAdjacentUnsaturatedBonds) continue block0;
                    incomingValency += bondOrder;
                    continue;
                }
                incomingValency += bond.getOrder();
            }
            Integer maxVal = StructureBuildingMethods.getLambdaValencyOrHwValencyOrMaxValIfCharged(atom1);
            if (maxVal != null && incomingValency + (bondOrder - 1) + atom1.getOutValency() > maxVal) continue;
            block2: for (Bond bond : bonds) {
                Atom atom2;
                if (bond.getOrder() != 1 || bondsToUnsaturate.contains(bond) || bondsToIgnore.contains(bond) || frag.getAtomByID((atom2 = bond.getOtherAtom(atom1)).getID()) == null || atom2.hasSpareValency() || "suffix".equals(atom2.getType()) || atom2.getProperty(Atom.ISALDEHYDE) != null) continue;
                int incomingValency2 = 0;
                for (Bond bond2 : atom2.getBonds()) {
                    if (bond2.getOrder() != 1 && !allowAdjacentUnsaturatedBonds) continue block2;
                    if (bondsToUnsaturate.contains(bond2)) {
                        if (!allowAdjacentUnsaturatedBonds) continue block2;
                        incomingValency2 += bondOrder;
                        continue;
                    }
                    incomingValency2 += bond2.getOrder();
                }
                Integer maxVal2 = StructureBuildingMethods.getLambdaValencyOrHwValencyOrMaxValIfCharged(atom2);
                if (maxVal2 != null && incomingValency2 + (bondOrder - 1) + atom2.getOutValency() > maxVal2) continue;
                bondsToUnsaturate.add(bond);
                continue block0;
            }
        }
        return bondsToUnsaturate;
    }

    static Integer getLambdaValencyOrHwValencyOrMaxValIfCharged(Atom a) {
        if (a.getLambdaConventionValency() != null) {
            return a.getLambdaConventionValency() + a.getProtonsExplicitlyAddedOrRemoved();
        }
        if (a.getCharge() == 0) {
            return ValencyChecker.getHWValency(a.getElement());
        }
        return ValencyChecker.getMaximumValency(a.getElement(), a.getCharge());
    }

    private static void performAdditiveOperations(BuildState state, Element subBracketOrRoot) throws StructureBuildingException {
        block17: {
            int outAtomCount;
            Fragment frag;
            Element group;
            block18: {
                Atom toAtom;
                block20: {
                    block19: {
                        if (subBracketOrRoot.getAttribute("locant") != null) {
                            return;
                        }
                        group = subBracketOrRoot.getName().equals("bracket") ? StructureBuildingMethods.findRightMostGroupInBracket(subBracketOrRoot) : subBracketOrRoot.getFirstChildElement("group");
                        if (group.getAttribute("resolved") != null) {
                            return;
                        }
                        frag = group.getFrag();
                        outAtomCount = frag.getOutAtomCount();
                        if (outAtomCount < 1) break block17;
                        if (subBracketOrRoot.getAttribute("multiplier") != null) break block18;
                        Element nextSiblingEl = OpsinTools.getNextSibling(subBracketOrRoot);
                        if (nextSiblingEl.getAttribute("multiplier") == null || outAtomCount < Integer.parseInt(nextSiblingEl.getAttributeValue("multiplier")) && (outAtomCount != 1 || frag.getOutAtom(0).getValency() != Integer.parseInt(nextSiblingEl.getAttributeValue("multiplier"))) || !StructureBuildingMethods.hasRootLikeOrMultiRadicalGroup(nextSiblingEl)) break block19;
                        if (outAtomCount == 1) {
                            FragmentTools.splitOutAtomIntoValency1OutAtoms(frag.getOutAtom(0));
                        }
                        StructureBuildingMethods.performMultiplicativeOperations(state, group, nextSiblingEl);
                        break block17;
                    }
                    if (group.getAttribute("isAMultiRadical") == null) break block20;
                    Fragment nextFrag = StructureBuildingMethods.getNextInScopeMultiValentFragment(subBracketOrRoot);
                    if (nextFrag == null) break block17;
                    Element nextMultiRadicalGroup = nextFrag.getTokenEl();
                    Element parentSubOrRoot = nextMultiRadicalGroup.getParent();
                    if (state.currentWordRule != WordRule.polymer) {
                        Fragment adjacentFrag;
                        if (nextMultiRadicalGroup.getAttribute("iminoLike") != null && nextFrag != (adjacentFrag = OpsinTools.getNextGroup(subBracketOrRoot).getFrag()) && (StructureBuildingMethods.potentiallyCanSubstitute(nextMultiRadicalGroup.getParent()) || StructureBuildingMethods.potentiallyCanSubstitute(nextMultiRadicalGroup.getParent().getParent()))) {
                            return;
                        }
                        if (group.getAttribute("iminoLike") != null && StructureBuildingMethods.levelsToWordEl(group) > StructureBuildingMethods.levelsToWordEl(nextMultiRadicalGroup)) {
                            return;
                        }
                    }
                    if (parentSubOrRoot.getAttribute("multiplier") != null) {
                        throw new StructureBuildingException("Attempted to form additive bond to a multiplied component");
                    }
                    group.addAttribute(new Attribute("resolved", "yes"));
                    StructureBuildingMethods.joinFragmentsAdditively(state, frag, nextFrag);
                    break block17;
                }
                List<Fragment> siblingFragments = StructureBuildingMethods.findAlternativeFragments(subBracketOrRoot);
                if (siblingFragments.size() <= 0) break block17;
                Fragment nextFrag = siblingFragments.get(siblingFragments.size() - 1);
                Element nextGroup = nextFrag.getTokenEl();
                if (nextGroup.getAttribute("acceptsAdditiveBonds") != null && nextGroup.getAttribute("isAMultiRadical") != null && (nextFrag.getOutAtomCount() > 1 || nextGroup.getAttribute("resolved") != null && nextFrag.getOutAtomCount() >= 1) && StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(toAtom = nextFrag.getOutAtom(0).getAtom()) == 0) {
                    group.addAttribute(new Attribute("resolved", "yes"));
                    StructureBuildingMethods.joinFragmentsAdditively(state, frag, nextFrag);
                }
                if (group.getAttribute("resolved") != null || siblingFragments.size() <= 1) break block17;
                for (int i = 0; i < siblingFragments.size() - 1; ++i) {
                    Fragment lastFrag = siblingFragments.get(i);
                    Element lastGroup = lastFrag.getTokenEl();
                    if (lastGroup.getAttribute("acceptsAdditiveBonds") != null && lastGroup.getAttribute("isAMultiRadical") != null && (lastFrag.getOutAtomCount() > 1 || lastGroup.getAttribute("resolved") != null && lastFrag.getOutAtomCount() >= 1)) {
                        Atom toAtom2 = lastFrag.getOutAtom(0).getAtom();
                        if (StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(toAtom2) != 0) break block17;
                        group.addAttribute(new Attribute("resolved", "yes"));
                        StructureBuildingMethods.joinFragmentsAdditively(state, frag, lastFrag);
                        break block17;
                    }
                    if (FragmentTools.findSubstituableAtoms(lastFrag, frag.getOutAtom(outAtomCount - 1).getValency()).size() <= 0) {
                        continue;
                    }
                    break block17;
                }
                break block17;
            }
            List<Fragment> siblingFragments = StructureBuildingMethods.findAlternativeFragments(subBracketOrRoot);
            if (siblingFragments.size() > 0) {
                Atom toAtom;
                int multiplier = Integer.parseInt(subBracketOrRoot.getAttributeValue("multiplier"));
                Fragment nextFrag = siblingFragments.get(siblingFragments.size() - 1);
                Element nextGroup = nextFrag.getTokenEl();
                if (nextGroup.getAttribute("acceptsAdditiveBonds") != null && nextGroup.getAttribute("isAMultiRadical") != null && (nextFrag.getOutAtomCount() >= multiplier || nextGroup.getAttribute("resolved") != null && nextFrag.getOutAtomCount() >= multiplier + 1) && StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(toAtom = nextFrag.getOutAtom(0).getAtom()) == 0) {
                    group.addAttribute(new Attribute("resolved", "yes"));
                    StructureBuildingMethods.multiplyOutAndAdditivelyBond(state, subBracketOrRoot, nextFrag);
                }
                if (group.getAttribute("resolved") == null && siblingFragments.size() > 1) {
                    for (int i = 0; i < siblingFragments.size() - 1; ++i) {
                        Fragment lastFrag = siblingFragments.get(i);
                        Element lastGroup = lastFrag.getTokenEl();
                        if (lastGroup.getAttribute("acceptsAdditiveBonds") != null && lastGroup.getAttribute("isAMultiRadical") != null && (lastFrag.getOutAtomCount() >= multiplier || lastGroup.getAttribute("resolved") != null && lastFrag.getOutAtomCount() >= multiplier + 1)) {
                            Atom toAtom3 = lastFrag.getOutAtom(0).getAtom();
                            if (StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(toAtom3) != 0) break;
                            group.addAttribute(new Attribute("resolved", "yes"));
                            StructureBuildingMethods.multiplyOutAndAdditivelyBond(state, subBracketOrRoot, lastFrag);
                            break;
                        }
                        if (FragmentTools.findSubstituableAtoms(lastFrag, frag.getOutAtom(outAtomCount - 1).getValency()).size() <= 0) {
                            continue;
                        }
                        break;
                    }
                }
            }
        }
    }

    private static boolean hasRootLikeOrMultiRadicalGroup(Element subBracketOrRoot) {
        List<Element> groups = OpsinTools.getDescendantElementsWithTagName(subBracketOrRoot, "group");
        if (subBracketOrRoot.getAttribute("inLocants") != null) {
            return true;
        }
        for (Element group : groups) {
            Fragment frag = group.getFrag();
            int outAtomCount = frag.getOutAtomCount();
            if (!(group.getAttribute("isAMultiRadical") != null ? outAtomCount >= 1 : outAtomCount == 0 && group.getAttribute("resolved") == null)) continue;
            return true;
        }
        return false;
    }

    private static void multiplyOutAndAdditivelyBond(BuildState state, Element subOrBracket, Fragment fragToAdditivelyBondTo) throws StructureBuildingException {
        int multiplier = Integer.parseInt(subOrBracket.getAttributeValue("multiplier"));
        subOrBracket.removeAttribute(subOrBracket.getAttribute("multiplier"));
        ArrayList<Element> clonedElements = new ArrayList<Element>();
        ArrayList<Element> elementsNotToBeMultiplied = new ArrayList<Element>();
        for (int i = multiplier - 1; i >= 0; --i) {
            Element currentElement;
            if (i != 0) {
                currentElement = state.fragManager.cloneElement(state, subOrBracket, i);
                StructureBuildingMethods.addPrimesToLocantedStereochemistryElements(currentElement, StringTools.multiplyString("'", i));
                clonedElements.add(currentElement);
            } else {
                currentElement = subOrBracket;
                Element multiplierEl = subOrBracket.getFirstChildElement("multiplier");
                if (multiplierEl == null) {
                    throw new StructureBuildingException("Multiplier not found where multiplier expected");
                }
                for (int j = subOrBracket.indexOf(multiplierEl) - 1; j >= 0; --j) {
                    Element el = subOrBracket.getChild(j);
                    el.detach();
                    elementsNotToBeMultiplied.add(el);
                }
                multiplierEl.detach();
            }
            Element group = currentElement.getName().equals("bracket") ? StructureBuildingMethods.findRightMostGroupInBracket(currentElement) : currentElement.getFirstChildElement("group");
            Fragment frag = group.getFrag();
            if (frag.getOutAtomCount() != 1) {
                throw new StructureBuildingException("Additive bond formation failure: Fragment expected to have one OutAtom in this case but had: " + frag.getOutAtomCount());
            }
            StructureBuildingMethods.joinFragmentsAdditively(state, frag, fragToAdditivelyBondTo);
        }
        for (Element clone : clonedElements) {
            OpsinTools.insertAfter(subOrBracket, clone);
        }
        for (Element el : elementsNotToBeMultiplied) {
            subOrBracket.insertChild(el, 0);
        }
    }

    private static void performMultiplicativeOperations(BuildState state, Element group, Element multipliedParent) throws StructureBuildingException {
        BuildResults multiRadicalBR = new BuildResults(group.getParent());
        StructureBuildingMethods.performMultiplicativeOperations(state, multiRadicalBR, multipliedParent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void performMultiplicativeOperations(BuildState state, BuildResults multiRadicalBR, Element multipliedParent) throws StructureBuildingException {
        int multiplier = Integer.parseInt(multipliedParent.getAttributeValue("multiplier"));
        if (multiplier != multiRadicalBR.getOutAtomCount()) {
            if (multiRadicalBR.getOutAtomCount() == multiplier * 2) {
                // empty if block
            }
            if (multiplier != multiRadicalBR.getOutAtomCount()) {
                throw new StructureBuildingException("Multiplication bond formation failure: number of outAtoms disagree with multiplier(multiplier: " + multiplier + ", outAtom count: " + multiRadicalBR.getOutAtomCount() + ")");
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(multiplier + " multiplicative bonds to be formed");
        }
        multipliedParent.removeAttribute(multipliedParent.getAttribute("multiplier"));
        List<Object> inLocants = null;
        String inLocantsString = multipliedParent.getAttributeValue("inLocants");
        if (inLocantsString != null) {
            if (inLocantsString.equals("default")) {
                inLocants = new ArrayList(multiplier);
                for (int i = 0; i < multiplier; ++i) {
                    inLocants.add("default");
                }
            } else {
                inLocants = StringTools.arrayToList(inLocantsString.split(","));
                if (inLocants.size() != multiplier) {
                    throw new StructureBuildingException("Mismatch between multiplier and number of inLocants in multiplicative nomenclature");
                }
            }
        }
        ArrayList<Element> clonedElements = new ArrayList<Element>();
        BuildResults newBr = new BuildResults();
        for (int i = multiplier - 1; i >= 0; --i) {
            boolean bl;
            Element multipliedGroup;
            Element multipliedElement;
            if (i != 0) {
                multipliedElement = state.fragManager.cloneElement(state, multipliedParent, i);
                StructureBuildingMethods.addPrimesToLocantedStereochemistryElements(multipliedElement, StringTools.multiplyString("'", i));
                clonedElements.add(multipliedElement);
            } else {
                multipliedElement = multipliedParent;
            }
            if (multipliedElement.getName().equals("bracket")) {
                multipliedGroup = StructureBuildingMethods.getFirstMultiValentGroup(multipliedElement);
                if (multipliedGroup == null) {
                    List<Element> groups = OpsinTools.getDescendantElementsWithTagName(multipliedElement, "group");
                    if (inLocants == null) {
                        throw new StructureBuildingException("OPSIN Bug? in locants must be specified for a multiplied root in multiplicative nomenclature");
                    }
                    if (((String)inLocants.get(0)).equals("default")) {
                        multipliedGroup = groups.get(groups.size() - 1);
                    } else {
                        block2: for (int j = groups.size() - 1; j >= 0; --j) {
                            Fragment possibleFrag = groups.get(j).getFrag();
                            for (String string : inLocants) {
                                if (!possibleFrag.hasLocant(string)) continue;
                                multipliedGroup = groups.get(j);
                                break block2;
                            }
                        }
                    }
                    if (multipliedGroup == null) {
                        throw new StructureBuildingException("Locants for inAtoms on the root were either misassigned to the root or were invalid: " + inLocants.toString() + " could not be assigned!");
                    }
                }
            } else {
                multipliedGroup = multipliedElement.getFirstChildElement("group");
            }
            Fragment multipliedFrag = multipliedGroup.getFrag();
            OutAtom multiRadicalOutAtom = multiRadicalBR.getOutAtom(i);
            Fragment multiRadicalFrag = multiRadicalOutAtom.getAtom().getFrag();
            Element multiRadicalGroup = multiRadicalFrag.getTokenEl();
            if (multiRadicalGroup.getAttribute("resolved") == null) {
                StructureBuildingMethods.resolveUnLocantedFeatures(state, multiRadicalGroup.getParent());
                multiRadicalGroup.addAttribute(new Attribute("resolved", "yes"));
            }
            boolean bl2 = false;
            if (inLocants != null) {
                Element rightMostGroup = multipliedElement.getName().equals("bracket") ? StructureBuildingMethods.findRightMostGroupInBracket(multipliedElement) : multipliedElement.getFirstChildElement("group");
                rightMostGroup.addAttribute(new Attribute("resolved", "yes"));
                if (multipliedGroup.getAttribute("isAMultiRadical") != null) {
                    if (!multipliedParent.getAttributeValue("inLocants").equals("default")) {
                        throw new StructureBuildingException("inLocants should not be specified for a multiradical parent in multiplicative nomenclature");
                    }
                } else {
                    Atom from = multiRadicalOutAtom.getAtom();
                    int bondOrder = multiRadicalOutAtom.getValency();
                    Atom atomToJoinTo = null;
                    for (int j = inLocants.size() - 1; j >= 0; --j) {
                        String locant = (String)inLocants.get(j);
                        if (locant.equals("default")) {
                            List<Atom> possibleAtoms = StructureBuildingMethods.getPossibleAtomsForUnlocantedConnectionToMultipliedRoot(multipliedGroup, bondOrder, i);
                            if (possibleAtoms.isEmpty()) {
                                throw new StructureBuildingException("No suitable atom found for multiplicative operation");
                            }
                            if (AmbiguityChecker.isSubstitutionAmbiguous(possibleAtoms, 1)) {
                                state.addIsAmbiguous("Connection to multiplied group: " + multipliedGroup.getValue());
                            }
                            atomToJoinTo = possibleAtoms.get(0);
                            inLocants.remove(j);
                            break;
                        }
                        Atom inAtom = multipliedFrag.getAtomByLocant(locant);
                        if (inAtom == null) continue;
                        atomToJoinTo = inAtom;
                        inLocants.remove(j);
                        break;
                    }
                    if (atomToJoinTo == null) {
                        throw new StructureBuildingException("Locants for inAtoms on the root were either misassigned to the root or were invalid: " + inLocants.toString() + " could not be assigned!");
                    }
                    if (!multiRadicalOutAtom.isSetExplicitly()) {
                        from = StructureBuildingMethods.findAtomForUnlocantedRadical(state, from.getFrag(), multiRadicalOutAtom);
                    }
                    multiRadicalFrag.removeOutAtom(multiRadicalOutAtom);
                    state.fragManager.createBond(from, atomToJoinTo, bondOrder);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Substitutively bonded (multiplicative to root) " + from.getID() + " (" + from.getFrag().getTokenEl().getValue() + ") " + atomToJoinTo.getID() + " (" + atomToJoinTo.getFrag().getTokenEl().getValue() + ")");
                    }
                    bl = true;
                }
            }
            if (!bl) {
                StructureBuildingMethods.joinFragmentsAdditively(state, multiRadicalFrag, multipliedFrag);
            }
            if (multipliedElement.getName().equals("bracket")) {
                StructureBuildingMethods.recursivelyResolveUnLocantedFeatures(state, multipliedElement);
            }
            if (inLocants != null) continue;
            newBr.mergeBuildResults(new BuildResults(multipliedElement));
        }
        if (newBr.getFragmentCount() == 1) {
            throw new StructureBuildingException("Multiplicative nomenclature cannot yield only one temporary terminal fragment");
        }
        if (newBr.getFragmentCount() >= 2) {
            List<Element> siblings = OpsinTools.getNextSiblingsOfTypes(multipliedParent, new String[]{"substituent", "bracket", "root"});
            if (siblings.isEmpty()) {
                Element parentOfMultipliedEl = multipliedParent.getParent();
                if (!parentOfMultipliedEl.getName().equals("bracket")) throw new StructureBuildingException("Could not find suitable element to continue multiplicative nomenclature");
                siblings = OpsinTools.getNextSiblingsOfTypes(parentOfMultipliedEl, new String[]{"substituent", "bracket", "root"});
                if (siblings.get(0).getAttribute("multiplier") == null) {
                    throw new StructureBuildingException("Multiplier not found where multiplier was expected for successful multiplicative nomenclature");
                }
                StructureBuildingMethods.performMultiplicativeOperations(state, newBr, siblings.get(0));
            } else {
                if (siblings.get(0).getAttribute("multiplier") == null) {
                    throw new StructureBuildingException("Multiplier not found where multiplier was expected for successful multiplicative nomenclature");
                }
                StructureBuildingMethods.performMultiplicativeOperations(state, newBr, siblings.get(0));
            }
        }
        for (Element clone : clonedElements) {
            OpsinTools.insertAfter(multipliedParent, clone);
        }
    }

    private static List<Atom> getPossibleAtomsForUnlocantedConnectionToMultipliedRoot(Element multipliedGroup, int bondOrder, int primesAdded) throws StructureBuildingException {
        String locant;
        Element previous;
        Fragment multipliedFrag = multipliedGroup.getFrag();
        if ("yes".equals(multipliedGroup.getAttributeValue("usableAsAJoiner")) && multipliedFrag.getDefaultInAtom() == null && (previous = OpsinTools.getPrevious(multipliedGroup)) != null && previous.getName().equals("multiplier") && (locant = StructureBuildingMethods.getLocantOfEndOfChainIfGreaterThan1(multipliedFrag, primesAdded)) != null) {
            Atom preferredAtom = multipliedFrag.getAtomByLocantOrThrow(locant);
            List<Atom> possibleAtoms = FragmentTools.findnAtomsForSubstitution(multipliedFrag.getAtomList(), preferredAtom, 1, bondOrder, true);
            if (possibleAtoms == null) {
                possibleAtoms = Collections.emptyList();
            }
            return possibleAtoms;
        }
        return FragmentTools.findSubstituableAtoms(multipliedFrag, bondOrder);
    }

    private static String getLocantOfEndOfChainIfGreaterThan1(Fragment frag, int primes) {
        String primesStr = StringTools.multiplyString("'", primes);
        int length = 0;
        Atom next = frag.getAtomByLocant(Integer.toString(length + 1) + primesStr);
        Atom previous = null;
        while (next != null && (previous == null || previous.getBondToAtom(next) != null)) {
            previous = next;
            next = frag.getAtomByLocant(Integer.toString(++length + 1) + primesStr);
        }
        if (length > 1) {
            return Integer.toString(length) + primesStr;
        }
        return null;
    }

    private static Fragment getNextInScopeMultiValentFragment(Element substituentOrBracket) throws StructureBuildingException {
        if (!substituentOrBracket.getName().equals("substituent") && !substituentOrBracket.getName().equals("bracket")) {
            throw new StructureBuildingException("Input to this function should be a substituent or bracket");
        }
        if (substituentOrBracket.getParent() == null) {
            throw new StructureBuildingException("substituent did not have a parent!");
        }
        Element parent = substituentOrBracket.getParent();
        List<Element> children = OpsinTools.getChildElementsWithTagNames(parent, new String[]{"substituent", "bracket", "root"});
        int indexOfSubstituent = parent.indexOf(substituentOrBracket);
        for (Element child : children) {
            List<Element> childDescendants;
            if (parent.indexOf(child) <= indexOfSubstituent || child.getAttribute("multiplier") != null) continue;
            if (child.getName().equals("bracket")) {
                childDescendants = OpsinTools.getDescendantElementsWithTagNames(child, new String[]{"substituent", "root"});
            } else {
                childDescendants = new ArrayList<Element>();
                childDescendants.add(child);
            }
            for (Element descendantChild : childDescendants) {
                Element group = descendantChild.getFirstChildElement("group");
                if (group == null) {
                    throw new StructureBuildingException("substituent/root is missing its group");
                }
                Fragment possibleFrag = group.getFrag();
                if (group.getAttribute("isAMultiRadical") == null || possibleFrag.getOutAtomCount() < 2 && (possibleFrag.getOutAtomCount() < 1 || group.getAttribute("resolved") == null)) continue;
                return possibleFrag;
            }
        }
        return null;
    }

    private static Element getFirstMultiValentGroup(Element bracket) throws StructureBuildingException {
        if (!bracket.getName().equals("bracket")) {
            throw new StructureBuildingException("Input to this function should be a bracket");
        }
        List<Element> groups = OpsinTools.getDescendantElementsWithTagName(bracket, "group");
        for (Element group : groups) {
            Fragment possibleFrag = group.getFrag();
            if (group.getAttribute("isAMultiRadical") == null || possibleFrag.getOutAtomCount() < 2 && (possibleFrag.getOutAtomCount() < 1 || group.getAttribute("resolved") == null)) continue;
            return group;
        }
        return null;
    }

    private static void joinFragmentsAdditively(BuildState state, Fragment fragToBeJoined, Fragment parentFrag) throws StructureBuildingException {
        int i;
        int outAtomCountOnFragToBeJoined;
        Element elOfFragToBeJoined = fragToBeJoined.getTokenEl();
        if ("epoxyLike".equals(elOfFragToBeJoined.getAttributeValue("subType"))) {
            int l = fragToBeJoined.getOutAtomCount();
            for (int i2 = 0; i2 < l; ++i2) {
                OutAtom outAtom = fragToBeJoined.getOutAtom(i2);
                if (outAtom.getLocant() == null) continue;
                throw new StructureBuildingException("Inappropriate use of " + elOfFragToBeJoined.getValue());
            }
        }
        if ((outAtomCountOnFragToBeJoined = fragToBeJoined.getOutAtomCount()) == 0) {
            throw new StructureBuildingException("Additive bond formation failure: Fragment expected to have at least one OutAtom but had none");
        }
        if (parentFrag.getOutAtomCount() == 0) {
            throw new StructureBuildingException("Additive bond formation failure: Fragment expected to have at least one OutAtom but had none");
        }
        OutAtom in = null;
        if (parentFrag.getOutAtomCount() > 1) {
            OutAtom outAtom;
            int i3;
            int firstOutAtomOrder = parentFrag.getOutAtom(0).getValency();
            boolean unresolvedAmbiguity = false;
            int l = parentFrag.getOutAtomCount();
            for (i3 = 1; i3 < l; ++i3) {
                outAtom = parentFrag.getOutAtom(i3);
                if (outAtom.getValency() == firstOutAtomOrder) continue;
                unresolvedAmbiguity = true;
            }
            if (unresolvedAmbiguity) {
                firstOutAtomOrder = fragToBeJoined.getOutAtom(0).getValency();
                unresolvedAmbiguity = false;
                l = fragToBeJoined.getOutAtomCount();
                for (i3 = 1; i3 < l; ++i3) {
                    outAtom = fragToBeJoined.getOutAtom(i3);
                    if (outAtom.getValency() == firstOutAtomOrder) continue;
                    unresolvedAmbiguity = true;
                }
                if (unresolvedAmbiguity && outAtomCountOnFragToBeJoined == 2) {
                    Fragment previousFrag;
                    Element previousGroup = OpsinTools.getPreviousGroup(elOfFragToBeJoined);
                    if (previousGroup != null && (previousFrag = previousGroup.getFrag()).getOutAtomCount() > 1) {
                        OutAtom outAtom2;
                        int previousGroupFirstOutAtomOrder = previousFrag.getOutAtom(0).getValency();
                        unresolvedAmbiguity = false;
                        int l2 = previousFrag.getOutAtomCount();
                        for (i = 1; i < l2; ++i) {
                            outAtom2 = previousFrag.getOutAtom(i);
                            if (outAtom2.getValency() == previousGroupFirstOutAtomOrder) continue;
                            unresolvedAmbiguity = true;
                        }
                        if (!unresolvedAmbiguity && previousGroupFirstOutAtomOrder == parentFrag.getOutAtom(0).getValency()) {
                            l2 = parentFrag.getOutAtomCount();
                            for (i = 1; i < l2; ++i) {
                                outAtom2 = parentFrag.getOutAtom(i);
                                if (outAtom2.getValency() == previousGroupFirstOutAtomOrder) continue;
                                in = outAtom2;
                                break;
                            }
                        }
                    }
                } else {
                    l = parentFrag.getOutAtomCount();
                    for (i3 = 0; i3 < l; ++i3) {
                        outAtom = parentFrag.getOutAtom(i3);
                        if (outAtom.getValency() != firstOutAtomOrder) continue;
                        in = outAtom;
                        break;
                    }
                }
            }
        }
        if (in == null) {
            in = parentFrag.getOutAtom(0);
        }
        Atom to = in.getAtom();
        int bondOrder = in.getValency();
        if (!in.isSetExplicitly()) {
            to = StructureBuildingMethods.findAtomForUnlocantedRadical(state, to.getFrag(), in);
        }
        parentFrag.removeOutAtom(in);
        OutAtom out = null;
        for (int i4 = outAtomCountOnFragToBeJoined - 1; i4 >= 0; --i4) {
            if (fragToBeJoined.getOutAtom(i4).getValency() != bondOrder) continue;
            out = fragToBeJoined.getOutAtom(i4);
            break;
        }
        if (out == null) {
            if (outAtomCountOnFragToBeJoined >= bondOrder) {
                int valency = 0;
                Atom lastOutAtom = fragToBeJoined.getOutAtom(outAtomCountOnFragToBeJoined - 1).getAtom();
                for (i = outAtomCountOnFragToBeJoined - 1; i >= 0; --i) {
                    OutAtom nextOutAtom = fragToBeJoined.getOutAtom(i);
                    if (nextOutAtom.getAtom() != lastOutAtom) {
                        throw new StructureBuildingException("Additive bond formation failure: bond order disagreement");
                    }
                    if ((valency += nextOutAtom.getValency()) == bondOrder) {
                        nextOutAtom.setValency(valency);
                        out = nextOutAtom;
                        break;
                    }
                    fragToBeJoined.removeOutAtom(nextOutAtom);
                }
                if (out == null) {
                    throw new StructureBuildingException("Additive bond formation failure: bond order disagreement");
                }
            } else {
                throw new StructureBuildingException("Additive bond formation failure: bond order disagreement");
            }
        }
        Atom from = out.getAtom();
        if (!out.isSetExplicitly()) {
            from = StructureBuildingMethods.findAtomForUnlocantedRadical(state, from.getFrag(), out);
        }
        fragToBeJoined.removeOutAtom(out);
        state.fragManager.createBond(from, to, bondOrder);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Additively bonded " + from.getID() + " (" + from.getFrag().getTokenEl().getValue() + ") " + to.getID() + " (" + to.getFrag().getTokenEl().getValue() + ")");
        }
    }

    private static void joinFragmentsSubstitutively(BuildState state, Fragment fragToBeJoined, Atom atomToJoinTo) throws StructureBuildingException {
        Element elOfFragToBeJoined = fragToBeJoined.getTokenEl();
        if ("epoxyLike".equals(elOfFragToBeJoined.getAttributeValue("subType"))) {
            StructureBuildingMethods.formEpoxide(state, fragToBeJoined, atomToJoinTo);
            return;
        }
        int outAtomCount = fragToBeJoined.getOutAtomCount();
        if (outAtomCount > 1) {
            throw new StructureBuildingException("Substitutive bond formation failure: Fragment expected to have one OutAtom but had: " + outAtomCount);
        }
        if (outAtomCount == 0) {
            throw new StructureBuildingException("Substitutive bond formation failure: Fragment expected to have one OutAtom but had none");
        }
        if (elOfFragToBeJoined.getAttribute("iminoLike") != null && fragToBeJoined.getOutAtomCount() == 1 && fragToBeJoined.getOutAtom(0).getValency() == 1) {
            fragToBeJoined.getOutAtom(0).setValency(2);
        }
        OutAtom out = fragToBeJoined.getOutAtom(0);
        Atom from = out.getAtom();
        int bondOrder = out.getValency();
        if (!out.isSetExplicitly()) {
            List<Atom> possibleAtoms = FragmentTools.findnAtomsForSubstitution(fragToBeJoined.getAtomList(), from, 1, bondOrder, false);
            if (possibleAtoms == null) {
                throw new StructureBuildingException("Failed to assign all unlocanted radicals to actual atoms without violating valency");
            }
            if ((!"alkaneStem".equals(fragToBeJoined.getSubType()) && !"heteroStem".equals(fragToBeJoined.getSubType()) || !possibleAtoms.get(0).equals(fragToBeJoined.getFirstAtom())) && AmbiguityChecker.isSubstitutionAmbiguous(possibleAtoms, 1)) {
                state.addIsAmbiguous("Positioning of radical on: " + fragToBeJoined.getTokenEl().getValue());
            }
            from = possibleAtoms.get(0);
        }
        fragToBeJoined.removeOutAtom(out);
        state.fragManager.createBond(from, atomToJoinTo, bondOrder);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Substitutively bonded " + from.getID() + " (" + from.getFrag().getTokenEl().getValue() + ") " + atomToJoinTo.getID() + " (" + atomToJoinTo.getFrag().getTokenEl().getValue() + ")");
        }
    }

    static Atom[] formEpoxide(BuildState state, Fragment bridgingFragment, Atom atomToJoinTo) throws StructureBuildingException {
        Atom secondAtomToJoinTo;
        Fragment fragToJoinTo = atomToJoinTo.getFrag();
        List<Atom> atomList = fragToJoinTo.getAtomList();
        if (atomList.size() == 1) {
            throw new StructureBuildingException("Epoxides must be formed between two different atoms");
        }
        Atom firstAtomToJoinTo = bridgingFragment.getOutAtom(0).getLocant() != null ? fragToJoinTo.getAtomByLocantOrThrow(bridgingFragment.getOutAtom(0).getLocant()) : atomToJoinTo;
        OutAtom outAtom1 = bridgingFragment.getOutAtom(0);
        bridgingFragment.removeOutAtom(0);
        state.fragManager.createBond(outAtom1.getAtom(), firstAtomToJoinTo, outAtom1.getValency());
        if (bridgingFragment.getOutAtom(0).getLocant() != null) {
            secondAtomToJoinTo = fragToJoinTo.getAtomByLocantOrThrow(bridgingFragment.getOutAtom(0).getLocant());
        } else {
            int index = atomList.indexOf(firstAtomToJoinTo);
            Atom preferredAtom = index + 1 >= atomList.size() ? atomList.get(index - 1) : atomList.get(index + 1);
            List<Atom> possibleSecondAtom = FragmentTools.findnAtomsForSubstitution(fragToJoinTo.getAtomList(), preferredAtom, 1, 1, true);
            if (possibleSecondAtom != null) {
                possibleSecondAtom.removeAll(Collections.singleton(firstAtomToJoinTo));
            }
            if (possibleSecondAtom == null || possibleSecondAtom.isEmpty()) {
                throw new StructureBuildingException("Unable to find suitable atom to form bridge");
            }
            if (AmbiguityChecker.isSubstitutionAmbiguous(possibleSecondAtom, 1)) {
                state.addIsAmbiguous("Addition of bridge to: " + fragToJoinTo.getTokenEl().getValue());
            }
            secondAtomToJoinTo = possibleSecondAtom.get(0);
        }
        OutAtom outAtom2 = bridgingFragment.getOutAtom(0);
        bridgingFragment.removeOutAtom(0);
        if (outAtom1.getAtom().equals(outAtom2.getAtom()) && firstAtomToJoinTo == secondAtomToJoinTo) {
            throw new StructureBuildingException("Epoxides must be formed between two different atoms");
        }
        int bondValency = outAtom2.getValency();
        if (outAtom2.getAtom().hasSpareValency() && !secondAtomToJoinTo.hasSpareValency()) {
            bondValency = 2;
        }
        state.fragManager.createBond(outAtom2.getAtom(), secondAtomToJoinTo, bondValency);
        CycleDetector.assignWhetherAtomsAreInCycles(bridgingFragment);
        return new Atom[]{firstAtomToJoinTo, secondAtomToJoinTo};
    }

    private static List<Atom> findAtomsForSubstitution(Element subOrBracket, int numberOfSubstitutions, int bondOrder) {
        FindAlternativeGroupsResult results = StructureBuildingMethods.findAlternativeGroups(subOrBracket);
        List<Atom> substitutableAtoms = StructureBuildingMethods.findAtomsForSubstitution(results.groups, numberOfSubstitutions, bondOrder, true);
        if (substitutableAtoms != null) {
            return substitutableAtoms;
        }
        substitutableAtoms = StructureBuildingMethods.findAtomsForSubstitution(results.groups, numberOfSubstitutions, bondOrder, false);
        if (substitutableAtoms != null) {
            return substitutableAtoms;
        }
        substitutableAtoms = StructureBuildingMethods.findAtomsForSubstitution(results.groupsSubstitutionUnlikely, numberOfSubstitutions, bondOrder, true);
        if (substitutableAtoms != null) {
            return substitutableAtoms;
        }
        substitutableAtoms = StructureBuildingMethods.findAtomsForSubstitution(results.groupsSubstitutionUnlikely, numberOfSubstitutions, bondOrder, false);
        return substitutableAtoms;
    }

    private static List<Atom> findAtomsForSubstitution(List<Element> possibleParents, int numberOfSubstitutions, int bondOrder, boolean preserveValency) {
        boolean rootHandled = false;
        int l = possibleParents.size();
        for (int i = 0; i < l; ++i) {
            List<Atom> substitutableAtoms;
            Element possibleParent = possibleParents.get(i);
            Fragment frag = possibleParent.getFrag();
            if (possibleParent.getParent().getName().equals("root")) {
                if (rootHandled) continue;
                List<Atom> atoms = frag.getAtomList();
                for (int j = i + 1; j < l; ++j) {
                    Element possibleOtherRoot = possibleParents.get(j);
                    if (!possibleOtherRoot.getParent().getName().equals("root")) continue;
                    atoms.addAll(possibleOtherRoot.getFrag().getAtomList());
                }
                rootHandled = true;
                substitutableAtoms = FragmentTools.findnAtomsForSubstitution(atoms, frag.getDefaultInAtom(), numberOfSubstitutions, bondOrder, true, preserveValency);
            } else {
                substitutableAtoms = FragmentTools.findnAtomsForSubstitution(frag.getAtomList(), frag.getDefaultInAtom(), numberOfSubstitutions, bondOrder, true, preserveValency);
            }
            if (substitutableAtoms == null) continue;
            return substitutableAtoms;
        }
        return null;
    }

    static List<Fragment> findAlternativeFragments(Element startingElement) {
        ArrayList<Fragment> foundFragments = new ArrayList<Fragment>();
        FindAlternativeGroupsResult results = StructureBuildingMethods.findAlternativeGroups(startingElement);
        for (Element group : results.groups) {
            foundFragments.add(group.getFrag());
        }
        for (Element group : results.groupsSubstitutionUnlikely) {
            foundFragments.add(group.getFrag());
        }
        return foundFragments;
    }

    static FindAlternativeGroupsResult findAlternativeGroups(Element startingElement) {
        ArrayDeque<AlternativeGroupFinderState> stack = new ArrayDeque<AlternativeGroupFinderState>();
        stack.add(new AlternativeGroupFinderState(startingElement.getParent(), false));
        ArrayList<Element> groups = new ArrayList<Element>();
        ArrayList<Element> groupsSubstitutionUnlikely = new ArrayList<Element>();
        boolean doneFirstIteration = false;
        while (stack.size() > 0) {
            AlternativeGroupFinderState state = (AlternativeGroupFinderState)stack.removeLast();
            Element currentElement = state.el;
            boolean substitutionUnlikely = state.substitutionUnlikely;
            if (currentElement.getName().equals("group")) {
                if (substitutionUnlikely) {
                    groupsSubstitutionUnlikely.add(currentElement);
                    continue;
                }
                groups.add(currentElement);
                continue;
            }
            List<Element> siblings = OpsinTools.getChildElementsWithTagNames(currentElement, new String[]{"bracket", "substituent", "root"});
            for (Element bracketOrSubOrRoot : siblings) {
                if (!doneFirstIteration && currentElement.indexOf(bracketOrSubOrRoot) <= currentElement.indexOf(startingElement) || bracketOrSubOrRoot.getAttribute("multiplier") != null) continue;
                boolean substitutionUnlikelyForThisEl = substitutionUnlikely;
                if (bracketOrSubOrRoot.getName().equals("bracket")) {
                    if (!"implicit".equals(bracketOrSubOrRoot.getAttributeValue("type"))) {
                        substitutionUnlikelyForThisEl = true;
                    }
                    stack.add(new AlternativeGroupFinderState(bracketOrSubOrRoot, substitutionUnlikelyForThisEl));
                    continue;
                }
                if (bracketOrSubOrRoot.getAttribute("locant") != null) {
                    substitutionUnlikelyForThisEl = true;
                }
                Element group = bracketOrSubOrRoot.getFirstChildElement("group");
                stack.add(new AlternativeGroupFinderState(group, substitutionUnlikelyForThisEl));
            }
            doneFirstIteration = true;
        }
        return new FindAlternativeGroupsResult(groups, groupsSubstitutionUnlikely);
    }

    private static Fragment findFragmentWithLocant(Element startingElement, String locant) throws StructureBuildingException {
        ArrayDeque<Element> stack = new ArrayDeque<Element>();
        stack.add(startingElement.getParent());
        boolean doneFirstIteration = false;
        Fragment monoNuclearHydride = null;
        while (stack.size() > 0) {
            Element currentElement = (Element)stack.removeLast();
            if (currentElement.getName().equals("substituent") || currentElement.getName().equals("root")) {
                Fragment groupFrag = currentElement.getFirstChildElement("group").getFrag();
                if (monoNuclearHydride != null && currentElement.getAttribute("locant") != null) {
                    return monoNuclearHydride;
                }
                if (!groupFrag.hasLocant(locant)) continue;
                if (locant.equals("1") && groupFrag.getAtomCount() == 1) {
                    if (monoNuclearHydride != null) continue;
                    monoNuclearHydride = groupFrag;
                    continue;
                }
                return groupFrag;
            }
            if (monoNuclearHydride != null) {
                return monoNuclearHydride;
            }
            List<Element> siblings = OpsinTools.getChildElementsWithTagNames(currentElement, new String[]{"bracket", "substituent", "root"});
            ArrayList<Element> bracketted = new ArrayList<Element>();
            if (!doneFirstIteration) {
                int indexOfStartingEl = currentElement.indexOf(startingElement);
                Element substituentToTryFirst = null;
                for (Element bracketOrSubOrRoot : siblings) {
                    int indexOfCurrentEl = currentElement.indexOf(bracketOrSubOrRoot);
                    if (indexOfCurrentEl <= indexOfStartingEl || bracketOrSubOrRoot.getAttribute("multiplier") != null) continue;
                    if (bracketOrSubOrRoot.getName().equals("bracket")) {
                        if ("implicit".equals(bracketOrSubOrRoot.getAttributeValue("type")) && bracketOrSubOrRoot.getAttribute("locant") == null) {
                            for (Element descendent : StructureBuildingMethods.getChildrenIgnoringLocantlessImplicitBrackets(bracketOrSubOrRoot)) {
                                if (descendent.getName().equals("bracket")) {
                                    bracketted.add(descendent);
                                    continue;
                                }
                                if (substituentToTryFirst == null && descendent.getAttribute("locant") == null && OpsinTools.MATCH_NUMERIC_LOCANT.matcher(locant).matches()) {
                                    substituentToTryFirst = descendent;
                                    continue;
                                }
                                stack.add(descendent);
                            }
                            continue;
                        }
                        bracketted.add(bracketOrSubOrRoot);
                        continue;
                    }
                    if (substituentToTryFirst == null && bracketOrSubOrRoot.getAttribute("locant") == null && OpsinTools.MATCH_NUMERIC_LOCANT.matcher(locant).matches()) {
                        substituentToTryFirst = bracketOrSubOrRoot;
                        continue;
                    }
                    stack.add(bracketOrSubOrRoot);
                }
                if (substituentToTryFirst != null) {
                    stack.add(substituentToTryFirst);
                }
                doneFirstIteration = true;
            } else {
                for (Element bracketOrSubOrRoot : siblings) {
                    if (bracketOrSubOrRoot.getAttribute("multiplier") != null) continue;
                    if (bracketOrSubOrRoot.getName().equals("bracket")) {
                        if ("implicit".equals(bracketOrSubOrRoot.getAttributeValue("type")) && bracketOrSubOrRoot.getAttribute("locant") == null) {
                            for (Element descendent : StructureBuildingMethods.getChildrenIgnoringLocantlessImplicitBrackets(bracketOrSubOrRoot)) {
                                if (descendent.getName().equals("bracket")) {
                                    bracketted.add(descendent);
                                    continue;
                                }
                                stack.add(descendent);
                            }
                            continue;
                        }
                        bracketted.add(bracketOrSubOrRoot);
                        continue;
                    }
                    stack.add(bracketOrSubOrRoot);
                }
            }
            for (int i = bracketted.size() - 1; i >= 0; --i) {
                stack.addFirst((Element)bracketted.get(i));
            }
        }
        return monoNuclearHydride;
    }

    private static List<Element> getChildrenIgnoringLocantlessImplicitBrackets(Element implicitBracket) {
        ArrayList<Element> childrenAndImplicitBracketChildren = new ArrayList<Element>();
        for (Element child : implicitBracket.getChildElements()) {
            if (child.getName().equals("bracket") && "implicit".equals(child.getAttributeValue("type")) && child.getAttribute("locant") == null) {
                childrenAndImplicitBracketChildren.addAll(StructureBuildingMethods.getChildrenIgnoringLocantlessImplicitBrackets(child));
                continue;
            }
            childrenAndImplicitBracketChildren.add(child);
        }
        return childrenAndImplicitBracketChildren;
    }

    static Element findRightMostGroupInBracket(Element bracket) {
        List<Element> subsBracketsAndRoots = OpsinTools.getChildElementsWithTagNames(bracket, new String[]{"bracket", "substituent", "root"});
        Element lastSubsBracketOrRoot = subsBracketsAndRoots.get(subsBracketsAndRoots.size() - 1);
        while (lastSubsBracketOrRoot.getName().equals("bracket")) {
            subsBracketsAndRoots = OpsinTools.getChildElementsWithTagNames(lastSubsBracketOrRoot, new String[]{"bracket", "substituent", "root"});
            lastSubsBracketOrRoot = subsBracketsAndRoots.get(subsBracketsAndRoots.size() - 1);
        }
        return StructureBuildingMethods.findRightMostGroupInSubOrRoot(lastSubsBracketOrRoot);
    }

    static Element findRightMostGroupInSubBracketOrRoot(Element subBracketOrRoot) {
        if (subBracketOrRoot.getName().equals("bracket")) {
            return StructureBuildingMethods.findRightMostGroupInBracket(subBracketOrRoot);
        }
        return StructureBuildingMethods.findRightMostGroupInSubOrRoot(subBracketOrRoot);
    }

    private static Element findRightMostGroupInSubOrRoot(Element subOrRoot) {
        for (int i = subOrRoot.getChildCount() - 1; i >= 0; --i) {
            Element el = subOrRoot.getChild(i);
            if (!el.getName().equals("group")) continue;
            return el;
        }
        return null;
    }

    private static boolean potentiallyCanSubstitute(Element subBracketOrRoot) {
        Element parent = subBracketOrRoot.getParent();
        List<Element> children = parent.getChildElements();
        for (int i = parent.indexOf(subBracketOrRoot) + 1; i < children.size(); ++i) {
            if (children.get(i).getName().equals("hyphen")) continue;
            return true;
        }
        return false;
    }

    static String checkForBracketedPrimedLocantSpecialCase(Element subBracketOrRoot, String locantString) {
        int terminalPrimes = StringTools.countTerminalPrimes(locantString);
        if (terminalPrimes > 0) {
            int brackettingDepth = 0;
            for (Element parent = subBracketOrRoot.getParent(); parent != null && parent.getName().equals("bracket"); parent = parent.getParent()) {
                if ("implicit".equals(parent.getAttributeValue("type"))) continue;
                ++brackettingDepth;
            }
            if (terminalPrimes == brackettingDepth) {
                return locantString.substring(0, locantString.length() - terminalPrimes);
            }
        }
        return null;
    }

    private static void checkAndApplySpecialCaseWhereOutAtomsCanBeCombinedOrThrow(Fragment frag, Element group) throws StructureBuildingException {
        int outAtomCount = frag.getOutAtomCount();
        if (outAtomCount <= 1) {
            return;
        }
        if ("epoxyLike".equals(group.getAttributeValue("subType"))) {
            return;
        }
        String groupValue = group.getValue();
        if (groupValue.equals("oxy") || groupValue.equals("thio") || groupValue.equals("seleno") || groupValue.equals("telluro")) {
            return;
        }
        Atom firstOutAtom = frag.getOutAtom(0).getAtom();
        int valencyOfOutAtom = 0;
        for (int i = outAtomCount - 1; i >= 0; --i) {
            OutAtom out = frag.getOutAtom(i);
            if (!out.getAtom().equals(firstOutAtom)) {
                throw new StructureBuildingException("Substitutive bond formation failure: Fragment expected to have one OutAtom but had: " + outAtomCount);
            }
            valencyOfOutAtom += out.getValency();
            frag.removeOutAtom(i);
        }
        frag.addOutAtom(firstOutAtom, valencyOfOutAtom, (Boolean)true);
    }

    static int calculateSubstitutableHydrogenAtoms(Atom atom) {
        int currentValency;
        if (!atom.getImplicitHydrogenAllowed()) {
            return 0;
        }
        int valency = atom.determineValency(true);
        int substitutableHydrogen = valency - (currentValency = atom.getIncomingValency() + atom.getOutValency());
        return substitutableHydrogen >= 0 ? substitutableHydrogen : 0;
    }

    private static void addPrimesToLocantedStereochemistryElements(Element subOrBracket, String primesString) {
        List<Element> stereoChemistryElements = OpsinTools.getDescendantElementsWithTagName(subOrBracket, "stereoChemistry");
        for (Element stereoChemistryElement : stereoChemistryElements) {
            if (stereoChemistryElement.getAttribute("locant") == null) continue;
            stereoChemistryElement.getAttribute("locant").setValue(stereoChemistryElement.getAttributeValue("locant") + primesString);
        }
    }

    private static Integer levelsToWordEl(Element element) {
        int count = 0;
        while (!element.getName().equals("word")) {
            if ((element = element.getParent()) == null) {
                return null;
            }
            ++count;
        }
        return count;
    }

    private static class FindAlternativeGroupsResult {
        private final List<Element> groups;
        private final List<Element> groupsSubstitutionUnlikely;

        FindAlternativeGroupsResult(List<Element> groups, List<Element> groupsSubstitutionUnlikely) {
            this.groups = groups;
            this.groupsSubstitutionUnlikely = groupsSubstitutionUnlikely;
        }
    }

    private static class AlternativeGroupFinderState {
        private final Element el;
        private final boolean substitutionUnlikely;

        AlternativeGroupFinderState(Element el, boolean substitutionUnlikely) {
            this.el = el;
            this.substitutionUnlikely = substitutionUnlikely;
        }
    }

    private static class HeteroAtomSmilesAndLambda {
        private final String smiles;
        private final String lambdaConvention;

        public HeteroAtomSmilesAndLambda(String smiles, String lambdaConvention) {
            this.smiles = smiles;
            this.lambdaConvention = lambdaConvention;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.lambdaConvention == null ? 0 : this.lambdaConvention.hashCode());
            result = 31 * result + (this.smiles == null ? 0 : this.smiles.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HeteroAtomSmilesAndLambda other = (HeteroAtomSmilesAndLambda)obj;
            if (this.lambdaConvention == null ? other.lambdaConvention != null : !this.lambdaConvention.equals(other.lambdaConvention)) {
                return false;
            }
            return !(this.smiles == null ? other.smiles != null : !this.smiles.equals(other.smiles));
        }
    }
}

