/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import dk.brics.automaton.RunAutomaton;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import uk.ac.cam.ch.wwmm.opsin.AutomatonInitialiser;
import uk.ac.cam.ch.wwmm.opsin.OpsinRadixTrie;
import uk.ac.cam.ch.wwmm.opsin.ParsingException;
import uk.ac.cam.ch.wwmm.opsin.ResourceGetter;
import uk.ac.cam.ch.wwmm.opsin.TokenEl;

class ResourceManager {
    private static final TokenEl IGNORE_WHEN_WRITING_PARSE_TREE = new TokenEl("");
    private final ResourceGetter resourceGetter;
    private final AutomatonInitialiser automatonInitialiser;
    private final HashMap<String, Map<Character, TokenEl>> tokenDict = new HashMap();
    private final HashMap<Character, TokenEl> reSymbolTokenDict = new HashMap();
    private final OpsinRadixTrie[] symbolTokenNamesDict;
    private final RunAutomaton[] symbolRegexAutomataDict;
    private final Pattern[] symbolRegexesDict;
    private final RunAutomaton chemicalAutomaton;
    private OpsinRadixTrie[] symbolTokenNamesDictReversed;
    private RunAutomaton[] symbolRegexAutomataDictReversed;
    private Pattern[] symbolRegexesDictReversed;
    private RunAutomaton reverseChemicalAutomaton;

    ResourceManager(ResourceGetter resourceGetter) throws IOException {
        this.resourceGetter = resourceGetter;
        this.automatonInitialiser = new AutomatonInitialiser(resourceGetter.getResourcePath() + "serialisedAutomata/");
        this.chemicalAutomaton = this.processChemicalGrammar(false);
        int grammarSymbolsSize = this.chemicalAutomaton.getCharIntervals().length;
        this.symbolTokenNamesDict = new OpsinRadixTrie[grammarSymbolsSize];
        this.symbolRegexAutomataDict = new RunAutomaton[grammarSymbolsSize];
        this.symbolRegexesDict = new Pattern[grammarSymbolsSize];
        this.processTokenFiles(false);
        this.processRegexTokenFiles(false);
    }

    private void processTokenFiles(boolean reversed) throws IOException {
        XMLStreamReader filesToProcessReader = this.resourceGetter.getXMLStreamReader("index.xml");
        try {
            while (filesToProcessReader.hasNext()) {
                int event = filesToProcessReader.next();
                if (event != 1 || !filesToProcessReader.getLocalName().equals("tokenFile")) continue;
                String fileName = filesToProcessReader.getElementText();
                this.processTokenFile(fileName, reversed);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Parsing exception occurred while reading index.xml", e);
        }
        finally {
            try {
                filesToProcessReader.close();
            }
            catch (XMLStreamException e) {
                throw new IOException("Parsing exception occurred while reading index.xml", e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processTokenFile(String fileName, boolean reversed) throws IOException {
        reader = this.resourceGetter.getXMLStreamReader(fileName);
lbl2:
        // 2 sources

        try {
            while (reader.hasNext()) {
                block15: {
                    if (reader.next() != 1) continue;
                    tagName = reader.getLocalName();
                    if (!tagName.equals("tokenLists")) break block15;
                    while (reader.hasNext()) {
                        switch (reader.next()) {
                            case 1: {
                                if (!reader.getLocalName().equals("tokenList")) break;
                                this.processTokenList(reader, reversed);
                            }
                        }
                    }
                    ** GOTO lbl2
                }
                if (!tagName.equals("tokenList")) continue;
                this.processTokenList(reader, reversed);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Parsing exception occurred while reading " + fileName, e);
        }
        finally {
            try {
                reader.close();
            }
            catch (XMLStreamException e) {
                throw new IOException("Parsing exception occurred while reading " + fileName, e);
            }
        }
    }

    private void processTokenList(XMLStreamReader reader, boolean reversed) throws XMLStreamException {
        String tokenTagName = null;
        Character symbol = null;
        String type = null;
        String subType = null;
        boolean ignoreWhenWritingXML = false;
        int l = reader.getAttributeCount();
        for (int i = 0; i < l; ++i) {
            String atrName = reader.getAttributeLocalName(i);
            String atrValue = reader.getAttributeValue(i);
            if (atrName.equals("tagname")) {
                tokenTagName = atrValue;
                continue;
            }
            if (atrName.equals("symbol")) {
                symbol = Character.valueOf(atrValue.charAt(0));
                continue;
            }
            if (atrName.equals("type")) {
                type = atrValue;
                continue;
            }
            if (atrName.equals("subType")) {
                subType = atrValue;
                continue;
            }
            if (atrName.equals("ignoreWhenWritingXML")) {
                ignoreWhenWritingXML = atrValue.equals("yes");
                continue;
            }
            throw new RuntimeException("Malformed tokenlist");
        }
        if (tokenTagName == null || symbol == null) {
            throw new RuntimeException("Malformed tokenlist");
        }
        int index = Arrays.binarySearch(this.chemicalAutomaton.getCharIntervals(), symbol.charValue());
        if (index < 0) {
            throw new RuntimeException(symbol + " is associated with a tokenList of tagname " + tokenTagName + " however it is not actually used in OPSIN's grammar!!!");
        }
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    TokenEl el;
                    if (!reader.getLocalName().equals("token")) break;
                    if (ignoreWhenWritingXML) {
                        el = IGNORE_WHEN_WRITING_PARSE_TREE;
                    } else {
                        el = new TokenEl(tokenTagName);
                        if (type != null) {
                            el.addAttribute("type", type);
                        }
                        if (subType != null) {
                            el.addAttribute("subType", subType);
                        }
                        int l2 = reader.getAttributeCount();
                        for (int i = 0; i < l2; ++i) {
                            el.addAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                        }
                    }
                    String text = reader.getElementText();
                    StringBuilder sb = new StringBuilder(text.length());
                    int len = text.length();
                    for (int i = 0; i < len; ++i) {
                        char ch = text.charAt(i);
                        if (ch == '\\') {
                            if (i + 1 >= len) {
                                throw new RuntimeException("Malformed token text: " + text);
                            }
                            ch = text.charAt(++i);
                        } else if (ch == '|') {
                            this.addToken(sb.toString(), el, symbol, index, reversed);
                            sb.setLength(0);
                            continue;
                        }
                        sb.append(ch);
                    }
                    this.addToken(sb.toString(), el, symbol, index, reversed);
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals("tokenList")) break;
                    return;
                }
            }
        }
    }

    private void addToken(String text, TokenEl el, Character symbol, int index, boolean reversed) {
        Map<Character, TokenEl> symbolToToken = this.tokenDict.get(text);
        if (symbolToToken == null) {
            symbolToToken = new HashMap<Character, TokenEl>();
            this.tokenDict.put(text, symbolToToken);
        }
        symbolToToken.put(symbol, el);
        if (!reversed) {
            OpsinRadixTrie trie = this.symbolTokenNamesDict[index];
            if (trie == null) {
                this.symbolTokenNamesDict[index] = trie = new OpsinRadixTrie();
            }
            trie.addToken(text);
        } else {
            OpsinRadixTrie trie = this.symbolTokenNamesDictReversed[index];
            if (trie == null) {
                this.symbolTokenNamesDictReversed[index] = trie = new OpsinRadixTrie();
            }
            trie.addToken(new StringBuilder(text).reverse().toString());
        }
    }

    private void processRegexTokenFiles(boolean reversed) throws IOException {
        XMLStreamReader reader = this.resourceGetter.getXMLStreamReader("regexTokens.xml");
        HashMap<String, StringBuilder> tempRegexes = new HashMap<String, StringBuilder>();
        Pattern matchRegexReplacement = Pattern.compile("%.*?%");
        try {
            while (reader.hasNext()) {
                String localName;
                if (reader.next() != 1 || !(localName = reader.getLocalName()).equals("regex") && !localName.equals("regexToken")) continue;
                String re = reader.getAttributeValue(null, "regex");
                Matcher m = matchRegexReplacement.matcher(re);
                StringBuilder newValueSB = new StringBuilder();
                int position = 0;
                while (m.find()) {
                    newValueSB.append(re.substring(position, m.start()));
                    StringBuilder replacement = (StringBuilder)tempRegexes.get(m.group());
                    if (replacement == null) {
                        throw new RuntimeException("Regex entry for: " + m.group() + " missing! Check regexTokens.xml");
                    }
                    newValueSB.append((CharSequence)replacement);
                    position = m.end();
                }
                newValueSB.append(re.substring(position));
                if (localName.equals("regex")) {
                    String regexName = reader.getAttributeValue(null, "name");
                    if (regexName == null) {
                        throw new RuntimeException("Regex entry in regexTokenes.xml with no name. regex: " + newValueSB.toString());
                    }
                    tempRegexes.put(regexName, newValueSB);
                    continue;
                }
                this.addRegexToken(reader, newValueSB.toString(), reversed);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Parsing exception occurred while reading regexTokens.xml", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (XMLStreamException e) {
                throw new IOException("Parsing exception occurred while reading regexTokens.xml", e);
            }
        }
    }

    private void addRegexToken(XMLStreamReader reader, String regex, boolean reversed) {
        int index;
        String tokenTagName = null;
        Character symbol = null;
        String type = null;
        String subType = null;
        String value = null;
        boolean determinise = false;
        boolean ignoreWhenWritingXML = false;
        int l = reader.getAttributeCount();
        for (int i = 0; i < l; ++i) {
            String atrName = reader.getAttributeLocalName(i);
            String atrValue = reader.getAttributeValue(i);
            if (atrName.equals("tagname")) {
                tokenTagName = atrValue;
                continue;
            }
            if (atrName.equals("symbol")) {
                symbol = Character.valueOf(atrValue.charAt(0));
                continue;
            }
            if (atrName.equals("type")) {
                type = atrValue;
                continue;
            }
            if (atrName.equals("subType")) {
                subType = atrValue;
                continue;
            }
            if (atrName.equals("value")) {
                value = atrValue;
                continue;
            }
            if (atrName.equals("determinise")) {
                determinise = atrValue.equals("yes");
                continue;
            }
            if (atrName.equals("ignoreWhenWritingXML")) {
                ignoreWhenWritingXML = atrValue.equals("yes");
                continue;
            }
            if (atrName.equals("regex")) continue;
            throw new RuntimeException("Malformed regexToken");
        }
        if (tokenTagName == null || symbol == null) {
            throw new RuntimeException("Malformed regexToken");
        }
        if (!reversed) {
            if (this.reSymbolTokenDict.get(symbol) != null) {
                throw new RuntimeException(symbol + " is associated with multiple regular expressions. The following expression clashes: " + regex + " This should be resolved by combining regular expressions that map the same symbol");
            }
            if (ignoreWhenWritingXML) {
                this.reSymbolTokenDict.put(symbol, IGNORE_WHEN_WRITING_PARSE_TREE);
            } else {
                TokenEl el = new TokenEl(tokenTagName);
                if (type != null) {
                    el.addAttribute("type", type);
                }
                if (subType != null) {
                    el.addAttribute("subType", subType);
                }
                if (value != null) {
                    el.addAttribute("value", value);
                }
                this.reSymbolTokenDict.put(symbol, el);
            }
        }
        if ((index = Arrays.binarySearch(this.chemicalAutomaton.getCharIntervals(), symbol.charValue())) < 0) {
            throw new RuntimeException(symbol + " is associated with the regex " + regex + " however it is not actually used in OPSIN's grammar!!!");
        }
        if (!reversed) {
            if (determinise) {
                this.symbolRegexAutomataDict[index] = this.automatonInitialiser.loadAutomaton(tokenTagName + "_" + symbol.charValue(), regex, false, false);
            } else {
                this.symbolRegexesDict[index] = Pattern.compile(regex);
            }
        } else if (determinise) {
            this.symbolRegexAutomataDictReversed[index] = this.automatonInitialiser.loadAutomaton(tokenTagName + "_" + symbol.charValue(), regex, false, true);
        } else {
            this.symbolRegexesDictReversed[index] = Pattern.compile(regex + "$");
        }
    }

    private RunAutomaton processChemicalGrammar(boolean reversed) throws IOException {
        XMLStreamReader reader = this.resourceGetter.getXMLStreamReader("regexes.xml");
        HashMap<String, StringBuilder> regexDict = new HashMap<String, StringBuilder>();
        Pattern matchRegexReplacement = Pattern.compile("%.*?%");
        try {
            while (reader.hasNext()) {
                if (reader.next() != 1 || !reader.getLocalName().equals("regex")) continue;
                String name = reader.getAttributeValue(null, "name");
                String value = reader.getAttributeValue(null, "value");
                Matcher m = matchRegexReplacement.matcher(value);
                StringBuilder newValueSB = new StringBuilder();
                int position = 0;
                while (m.find()) {
                    newValueSB.append(value.substring(position, m.start()));
                    StringBuilder replacement = (StringBuilder)regexDict.get(m.group());
                    if (replacement == null) {
                        throw new RuntimeException("Regex entry for: " + m.group() + " missing! Check regexes.xml");
                    }
                    newValueSB.append((CharSequence)replacement);
                    position = m.end();
                }
                newValueSB.append(value.substring(position));
                if (regexDict.get(name) != null) {
                    throw new RuntimeException("Regex entry: " + name + " has duplicate definitions! Check regexes.xml");
                }
                regexDict.put(name, newValueSB);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Parsing exception occurred while reading regexes.xml", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (XMLStreamException e) {
                throw new IOException("Parsing exception occurred while reading regexes.xml", e);
            }
        }
        String re = ((StringBuilder)regexDict.get("%chemical%")).toString();
        if (!reversed) {
            return this.automatonInitialiser.loadAutomaton("chemical", re, true, false);
        }
        return this.automatonInitialiser.loadAutomaton("chemical", re, true, true);
    }

    synchronized void populatedReverseTokenMappings() throws IOException {
        if (this.reverseChemicalAutomaton == null) {
            this.reverseChemicalAutomaton = this.processChemicalGrammar(true);
        }
        int grammarSymbolsSize = this.reverseChemicalAutomaton.getCharIntervals().length;
        if (this.symbolTokenNamesDictReversed == null) {
            this.symbolTokenNamesDictReversed = new OpsinRadixTrie[grammarSymbolsSize];
            this.processTokenFiles(true);
        }
        if (this.symbolRegexAutomataDictReversed == null && this.symbolRegexesDictReversed == null) {
            this.symbolRegexAutomataDictReversed = new RunAutomaton[grammarSymbolsSize];
            this.symbolRegexesDictReversed = new Pattern[grammarSymbolsSize];
            this.processRegexTokenFiles(true);
        }
    }

    TokenEl makeTokenElement(String tokenString, Character symbol) throws ParsingException {
        TokenEl token;
        Map<Character, TokenEl> annotationToToken = this.tokenDict.get(tokenString);
        if (annotationToToken != null && (token = annotationToToken.get(symbol)) != null) {
            if (token == IGNORE_WHEN_WRITING_PARSE_TREE) {
                return null;
            }
            return token.copy(tokenString);
        }
        TokenEl regexToken = this.reSymbolTokenDict.get(symbol);
        if (regexToken != null) {
            if (regexToken == IGNORE_WHEN_WRITING_PARSE_TREE) {
                return null;
            }
            return regexToken.copy(tokenString);
        }
        throw new ParsingException("Parsing Error: This is a bug in the program. A token element could not be found for token: " + tokenString + " using annotation symbol: " + symbol);
    }

    RunAutomaton getChemicalAutomaton() {
        return this.chemicalAutomaton;
    }

    OpsinRadixTrie[] getSymbolTokenNamesDict() {
        return this.symbolTokenNamesDict;
    }

    RunAutomaton[] getSymbolRegexAutomataDict() {
        return this.symbolRegexAutomataDict;
    }

    Pattern[] getSymbolRegexesDict() {
        return this.symbolRegexesDict;
    }

    RunAutomaton getReverseChemicalAutomaton() {
        return this.reverseChemicalAutomaton;
    }

    OpsinRadixTrie[] getSymbolTokenNamesDictReversed() {
        return this.symbolTokenNamesDictReversed;
    }

    RunAutomaton[] getSymbolRegexAutomataDictReversed() {
        return this.symbolRegexAutomataDictReversed;
    }

    Pattern[] getSymbolRegexesDictReversed() {
        return this.symbolRegexesDictReversed;
    }
}

