/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.List;
import uk.ac.cam.ch.wwmm.opsin.Attribute;
import uk.ac.cam.ch.wwmm.opsin.Element;

class GroupingEl
extends Element {
    private final List<Element> children = new ArrayList<Element>();

    GroupingEl(String name) {
        super(name);
    }

    @Override
    void addChild(Element child) {
        child.setParent(this);
        this.children.add(child);
    }

    @Override
    Element copy() {
        GroupingEl copy = new GroupingEl(this.name);
        for (Element childEl : this.children) {
            Element newChild = childEl.copy();
            newChild.setParent(copy);
            copy.addChild(newChild);
        }
        int len = this.attributes.size();
        for (int i = 0; i < len; ++i) {
            Attribute atr = (Attribute)this.attributes.get(i);
            copy.addAttribute(new Attribute(atr));
        }
        return copy;
    }

    @Override
    Element getChild(int index) {
        return this.children.get(index);
    }

    @Override
    int getChildCount() {
        return this.children.size();
    }

    @Override
    List<Element> getChildElements() {
        return new ArrayList<Element>(this.children);
    }

    @Override
    List<Element> getChildElements(String name) {
        ArrayList<Element> elements = new ArrayList<Element>(1);
        for (Element element : this.children) {
            if (!element.name.equals(name)) continue;
            elements.add(element);
        }
        return elements;
    }

    @Override
    Element getFirstChildElement(String name) {
        for (Element child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    @Override
    String getValue() {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < childCount; ++i) {
            result.append(this.children.get(i).getValue());
        }
        return result.toString();
    }

    @Override
    int indexOf(Element child) {
        return this.children.indexOf(child);
    }

    @Override
    void insertChild(Element child, int index) {
        child.setParent(this);
        this.children.add(index, child);
    }

    @Override
    boolean removeChild(Element child) {
        child.setParent(null);
        return this.children.remove(child);
    }

    @Override
    Element removeChild(int index) {
        Element removed = this.children.remove(index);
        removed.setParent(null);
        return removed;
    }

    @Override
    void replaceChild(Element oldChild, Element newChild) {
        int index = this.indexOf(oldChild);
        if (index == -1) {
            throw new RuntimeException("oldChild is not a child of this element.");
        }
        this.removeChild(index);
        this.insertChild(newChild, index);
    }

    @Override
    void setValue(String text) {
        throw new UnsupportedOperationException("Token groups do not have a value");
    }
}

