/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.cam.ch.wwmm.opsin.AtomProperties;
import uk.ac.cam.ch.wwmm.opsin.Attribute;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.ComponentGenerationException;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.FunctionalReplacement;
import uk.ac.cam.ch.wwmm.opsin.GroupingEl;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.OpsinWarning;
import uk.ac.cam.ch.wwmm.opsin.StereoGroupType;
import uk.ac.cam.ch.wwmm.opsin.StereochemistryException;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.TokenEl;
import uk.ac.cam.ch.wwmm.opsin.WordRule;

class ComponentGenerator {
    private static final Pattern matchNumberLocantsOnlyFusionBracket = Pattern.compile("\\[\\d+(,\\d+)*\\]");
    private static final Pattern matchCommaOrDot = Pattern.compile("[\\.,]");
    private static final Pattern matchAnnulene = Pattern.compile("[\\[\\(\\{]([1-9]\\d*)[\\]\\)\\}]annul(en|yn)", 2);
    private static final String elementSymbols = "(?:He|Li|Be|B|C|N|O|F|Ne|Na|Mg|Al|Si|P|S|Cl|Ar|K|Ca|Sc|Ti|V|Cr|Mn|Fe|Co|Ni|Cu|Zn|Ga|Ge|As|Se|Br|Kr|Rb|Sr|Y|Zr|Nb|Mo|Tc|Ru|Rh|Pd|Ag|Cd|In|Sn|Sb|Te|I|Xe|Cs|Ba|La|Ce|Pr|Nd|Pm|Sm|Eu|Gd|Tb|Dy|Ho|Er|Tm|Yb|Lu|Hf|Ta|W|Re|Os|Ir|Pt|Au|Hg|Tl|Pb|Po|At|Rn|Fr|Ra|Ac|Th|Pa|U|Np|Pu|Am|Cm|Bk|Cf|Es|Fm|Md|No|Lr|Rf|Db|Sg|Bh|Hs|Mt|Ds)";
    private static final Pattern matchStereochemistry = Pattern.compile("(.*?)(SR|R/?S|r/?s|[Rr]\\^?[*]|[Ss]\\^?[*]|[Ee][Zz]|[EZ][*]|[RSEZrsezabx]|[cC][iI][sS]|[tT][rR][aA][nN][sS]|[aA][lL][pP][hH][aA]|[bB][eE][tT][aA]|[xX][iI]|[eE][xX][oO]|[eE][nN][dD][oO]|[sS][yY][nN]|[aA][nN][tT][iI]|M|P|Ra|Sa|Sp|Rp|R(?:[Oo][Rr]|[Aa][Nn][Dd])S|S(?:[Oo][Rr]|[Aa][Nn][Dd])R|E(?:[Oo][Rr]|[Aa][Nn][Dd])Z|Z(?:[Oo][Rr]|[Aa][Nn][Dd])E)");
    private static final Pattern matchRacemic = Pattern.compile("rac(\\.|em(\\.|ic)?)?-?", 2);
    private static final Pattern matchRS = Pattern.compile("[Rr]/?\\^?[*Ss]?|[Ss]\\^?[*Rr]?|R(?:[Oo][Rr]|[Aa][Nn][Dd])S|S(?:[Oo][Rr]|[Aa][Nn][Dd])R");
    private static final Pattern matchEZ = Pattern.compile("[EZez]|[Ee][Zz]|[EZ]\\*|EandZ|EorZ");
    private static final Pattern matchAlphaBetaStereochem = Pattern.compile("a|b|x|[aA][lL][pP][hH][aA]|[bB][eE][tT][aA]|[xX][iI]");
    private static final Pattern matchCisTrans = Pattern.compile("[cC][iI][sS]|[tT][rR][aA][nN][sS]");
    private static final Pattern matchEndoExoSynAnti = Pattern.compile("[eE][xX][oO]|[eE][nN][dD][oO]|[sS][yY][nN]|[aA][nN][tT][iI]");
    private static final Pattern matchAxialStereo = Pattern.compile("M|P|Ra|Sa|Sp|Rp");
    private static final Pattern matchLambdaConvention = Pattern.compile("(\\S+)?lambda\\D*(\\d+)\\D*", 2);
    private static final Pattern matchHdigit = Pattern.compile("H\\d");
    private static final Pattern matchNonDigit = Pattern.compile("\\D+");
    private static final Pattern matchAddedHydrogenLocantBracket = Pattern.compile("[1-9][0-9]*[a-g]?'*H(,[1-9][0-9]*[a-g]?'*H)*", 2);
    private static final Pattern matchRSLocantBracket = Pattern.compile("[RS]|R[,/]?S", 2);
    private static final Pattern matchSuperscriptedLocant = Pattern.compile("((?:He|Li|Be|B|C|N|O|F|Ne|Na|Mg|Al|Si|P|S|Cl|Ar|K|Ca|Sc|Ti|V|Cr|Mn|Fe|Co|Ni|Cu|Zn|Ga|Ge|As|Se|Br|Kr|Rb|Sr|Y|Zr|Nb|Mo|Tc|Ru|Rh|Pd|Ag|Cd|In|Sn|Sb|Te|I|Xe|Cs|Ba|La|Ce|Pr|Nd|Pm|Sm|Eu|Gd|Tb|Dy|Ho|Er|Tm|Yb|Lu|Hf|Ta|W|Re|Os|Ir|Pt|Au|Hg|Tl|Pb|Po|At|Rn|Fr|Ra|Ac|Th|Pa|U|Np|Pu|Am|Cm|Bk|Cf|Es|Fm|Md|No|Lr|Rf|Db|Sg|Bh|Hs|Mt|Ds)'*)[\\^\\[\\(\\{~\\*\\<]*(?:[sS][uU][pP][ ]?)?([^\\^\\[\\(\\{~\\*\\<\\]\\)\\}\\>]+)[^\\[\\(\\{]*");
    private static final Pattern matchIUPAC2004ElementLocant = Pattern.compile("(\\d+'*)-((?:He|Li|Be|B|C|N|O|F|Ne|Na|Mg|Al|Si|P|S|Cl|Ar|K|Ca|Sc|Ti|V|Cr|Mn|Fe|Co|Ni|Cu|Zn|Ga|Ge|As|Se|Br|Kr|Rb|Sr|Y|Zr|Nb|Mo|Tc|Ru|Rh|Pd|Ag|Cd|In|Sn|Sb|Te|I|Xe|Cs|Ba|La|Ce|Pr|Nd|Pm|Sm|Eu|Gd|Tb|Dy|Ho|Er|Tm|Yb|Lu|Hf|Ta|W|Re|Os|Ir|Pt|Au|Hg|Tl|Pb|Po|At|Rn|Fr|Ra|Ac|Th|Pa|U|Np|Pu|Am|Cm|Bk|Cf|Es|Fm|Md|No|Lr|Rf|Db|Sg|Bh|Hs|Mt|Ds)'*)(.*)");
    private static final Pattern matchGreek = Pattern.compile("alpha|beta|gamma|delta|epsilon|zeta|eta|omega", 2);
    private static final Pattern matchInlineSuffixesThatAreAlsoGroups = Pattern.compile("carbonyl|oxy|sulfenyl|sulfinyl|sulfonyl|selenenyl|seleninyl|selenonyl|tellurenyl|tellurinyl|telluronyl");
    private final BuildState buildState;

    ComponentGenerator(BuildState buildState) {
        this.buildState = buildState;
    }

    void processParse(Element parse) throws ComponentGenerationException {
        List<Element> substituentsAndRoot = OpsinTools.getDescendantElementsWithTagNames(parse, new String[]{"substituent", "root"});
        for (Element subOrRoot : substituentsAndRoot) {
            ComponentGenerator.resolveAmbiguities(subOrRoot);
            ComponentGenerator.processLocants(subOrRoot);
            this.convertOrthoMetaParaToLocants(subOrRoot);
            this.formAlkaneStemsFromComponents(subOrRoot);
            this.processAlkaneStemModifications(subOrRoot);
            this.processHeterogenousHydrides(subOrRoot);
            this.processIndicatedHydrogens(subOrRoot);
            this.processStereochemistry(subOrRoot);
            this.processInfixes(subOrRoot);
            this.processSuffixPrefixes(subOrRoot);
            this.processLambdaConvention(subOrRoot);
        }
        List<Element> groups = OpsinTools.getDescendantElementsWithTagName(parse, "group");
        ArrayList<Element> brackets = new ArrayList<Element>();
        this.findAndStructureBrackets(substituentsAndRoot, brackets);
        for (Element subOrRoot : substituentsAndRoot) {
            this.processHydroCarbonRings(subOrRoot);
            this.handleSuffixIrregularities(subOrRoot);
        }
        for (Element group : groups) {
            this.detectAlkaneFusedRingBridges(group);
            this.processRings(group);
            this.handleGroupIrregularities(group);
        }
        for (Element bracket : brackets) {
            this.moveDetachableHetAtomRepl(bracket);
        }
    }

    static void resolveAmbiguities(Element subOrRoot) throws ComponentGenerationException {
        List<Element> multipliers = subOrRoot.getChildElements("multiplier");
        for (Element apparentMultiplier : multipliers) {
            Element possibleLocantOrMultiplierOrSuffix;
            Element isThisALocant;
            int alkaneChainLength;
            if (!"basic".equals(apparentMultiplier.getAttributeValue("type")) && !"VonBaeyer".equals(apparentMultiplier.getAttributeValue("type"))) continue;
            int multiplierNum = Integer.parseInt(apparentMultiplier.getAttributeValue("value"));
            Element nextEl = OpsinTools.getNextSibling(apparentMultiplier);
            if (multiplierNum >= 3 && nextEl != null && nextEl.getName().equals("alkaneStemComponent") && (alkaneChainLength = Integer.parseInt(nextEl.getAttributeValue("value"))) >= 10 && alkaneChainLength > multiplierNum && ((isThisALocant = OpsinTools.getPreviousSibling(apparentMultiplier)) == null || !isThisALocant.getName().equals("locant") || isThisALocant.getValue().split(",").length != multiplierNum)) {
                throw new ComponentGenerationException(apparentMultiplier.getValue() + nextEl.getValue() + " should not have been lexed as two tokens!");
            }
            if (multiplierNum >= 4 && nextEl != null && nextEl.getName().equals("hydrocarbonFusedRingSystem") && nextEl.getValue().equals("phen") && !"e".equals(nextEl.getAttributeValue("subsequentUnsemanticToken")) && (possibleLocantOrMultiplierOrSuffix = OpsinTools.getNextSibling(nextEl)) != null && possibleLocantOrMultiplierOrSuffix.getName().equals("suffix") && ((isThisALocant = OpsinTools.getPreviousSibling(apparentMultiplier)) == null || !isThisALocant.getName().equals("locant") || isThisALocant.getValue().split(",").length != 1)) {
                String multiplierAndGroup = apparentMultiplier.getValue() + nextEl.getValue();
                throw new ComponentGenerationException(multiplierAndGroup + " should not have been lexed as one token!");
            }
            if (multiplierNum <= 4 || apparentMultiplier.getValue().endsWith("a") || nextEl == null || !nextEl.getName().equals("group") || !matchInlineSuffixesThatAreAlsoGroups.matcher(nextEl.getValue()).matches()) continue;
            throw new ComponentGenerationException(apparentMultiplier.getValue() + nextEl.getValue() + " should have been lexed as [alkane stem, inline suffix], not [multiplier, group]!");
        }
        List<Element> fusions = subOrRoot.getChildElements("fusion");
        for (Element fusion : fusions) {
            Element possibleHWRing;
            String fusionText = fusion.getValue();
            if (!matchNumberLocantsOnlyFusionBracket.matcher(fusionText).matches() || (possibleHWRing = OpsinTools.getNextSiblingIgnoringCertainElements(fusion, new String[]{"multiplier", "heteroatom"})) == null || !"hantzschWidman".equals(possibleHWRing.getAttributeValue("subType"))) continue;
            int heteroCount = 0;
            int multiplierValue = 1;
            Element currentElem = OpsinTools.getNextSibling(fusion);
            while (currentElem != null && !currentElem.getName().equals("group")) {
                if (currentElem.getName().equals("heteroatom")) {
                    heteroCount += multiplierValue;
                    multiplierValue = 1;
                } else if (currentElem.getName().equals("multiplier")) {
                    multiplierValue = Integer.parseInt(currentElem.getAttributeValue("value"));
                }
                currentElem = OpsinTools.getNextSibling(currentElem);
            }
            String[] locants = fusionText.substring(1, fusionText.length() - 1).split(",");
            if (locants.length != heteroCount) continue;
            boolean foundLocantNotInHwSystem = false;
            for (String locant : locants) {
                if (Integer.parseInt(locant) <= possibleHWRing.getAttributeValue("value").length() - 2) continue;
                foundLocantNotInHwSystem = true;
            }
            if (foundLocantNotInHwSystem) continue;
            throw new ComponentGenerationException("This fusion bracket is in fact more likely to be a description of the locants of a HW ring");
        }
    }

    static void processLocants(Element subOrRoot) throws ComponentGenerationException {
        List<Element> children = subOrRoot.getChildElements();
        for (Element el : children) {
            String elName = el.getName();
            if (elName.equals("locant")) {
                Element locantEl = el;
                List<String> individualLocants = ComponentGenerator.splitIntoIndividualLocants(StringTools.removeDashIfPresent(locantEl.getValue()));
                int locantCount = individualLocants.size();
                for (int i = 0; i < locantCount; ++i) {
                    String locantText = individualLocants.get(i);
                    char lastChar = locantText.charAt(locantText.length() - 1);
                    if (lastChar == ')' || lastChar == ']' || lastChar == '}') {
                        int bracketStart = -1;
                        for (int j = locantText.length() - 2; j >= 0; --j) {
                            char ch = locantText.charAt(j);
                            if (ch != '(' && ch != '[' && ch != '{') continue;
                            bracketStart = j;
                            break;
                        }
                        if (bracketStart >= 0) {
                            String brackettedText = locantText.substring(bracketStart + 1, locantText.length() - 1);
                            if (matchAddedHydrogenLocantBracket.matcher(brackettedText).matches()) {
                                String[] addedHydrogens;
                                locantText = StringTools.removeDashIfPresent(locantText.substring(0, bracketStart));
                                for (String addedHydrogen : addedHydrogens = brackettedText.split(",")) {
                                    TokenEl addedHydrogenElement = new TokenEl("addedHydrogen");
                                    String hydrogenLocant = OpsinTools.fixLocantCapitalisation(addedHydrogen.substring(0, addedHydrogen.length() - 1));
                                    addedHydrogenElement.addAttribute(new Attribute("locant", hydrogenLocant));
                                    OpsinTools.insertBefore(locantEl, addedHydrogenElement);
                                }
                                if (locantEl.getAttribute("type") == null) {
                                    locantEl.addAttribute(new Attribute("type", "addedHydrogenLocant"));
                                }
                            } else if (matchRSLocantBracket.matcher(brackettedText).matches()) {
                                locantText = StringTools.removeDashIfPresent(locantText.substring(0, bracketStart));
                                String rs = brackettedText.replaceAll("\\W", "");
                                TokenEl newStereoChemEl = new TokenEl("stereoChemistry", "(" + ComponentGenerator.standardizeLocantVariants(locantText) + rs + ")");
                                newStereoChemEl.addAttribute(new Attribute("type", "stereochemistryBracket"));
                                OpsinTools.insertBefore(locantEl, newStereoChemEl);
                            }
                        } else {
                            throw new ComponentGenerationException("OPSIN bug: malformed locant text");
                        }
                    }
                    individualLocants.set(i, ComponentGenerator.standardizeLocantVariants(locantText));
                }
                locantEl.setValue(StringTools.stringListToString(individualLocants, ","));
                Element afterLocants = OpsinTools.getNextSibling(locantEl);
                if (afterLocants == null) {
                    throw new ComponentGenerationException("Nothing after locant tag: " + locantEl.toXML());
                }
                if (individualLocants.size() != 1) continue;
                ComponentGenerator.ifCarbohydrateLocantConvertToAminoAcidStyleLocant(locantEl);
                continue;
            }
            if (!elName.equals("colonOrSemiColonDelimitedLocant")) continue;
            String locantText = StringTools.removeDashIfPresent(el.getValue());
            StringBuilder updatedLocantText = new StringBuilder();
            StringBuilder sb = new StringBuilder();
            int len = locantText.length();
            for (int i = 0; i < len; ++i) {
                char ch = locantText.charAt(i);
                if (ch == ',' || ch == ':' || ch == ';') {
                    updatedLocantText.append(ComponentGenerator.standardizeLocantVariants(sb.toString()));
                    sb.setLength(0);
                    updatedLocantText.append(ch);
                    continue;
                }
                sb.append(ch);
            }
            updatedLocantText.append(ComponentGenerator.standardizeLocantVariants(sb.toString()));
            el.setValue(updatedLocantText.toString());
        }
    }

    private static String standardizeLocantVariants(String locantText) {
        Matcher m;
        if (locantText.contains("-") && (m = matchIUPAC2004ElementLocant.matcher(locantText)).matches()) {
            locantText = m.group(2) + m.group(1) + m.group(3);
        }
        if (Character.isLetter(locantText.charAt(0))) {
            m = matchSuperscriptedLocant.matcher(locantText);
            if (m.lookingAt()) {
                String replacementString = m.group(1) + m.group(2);
                locantText = m.replaceFirst(replacementString);
            }
            if (locantText.length() >= 3) {
                m = matchGreek.matcher(locantText);
                while (m.find()) {
                    locantText = locantText.substring(0, m.start()) + m.group().toLowerCase(Locale.ROOT) + locantText.substring(m.end());
                }
            }
        }
        locantText = OpsinTools.fixLocantCapitalisation(locantText);
        return locantText;
    }

    private static void ifCarbohydrateLocantConvertToAminoAcidStyleLocant(Element locant) {
        Element possibleMultiplier;
        if (OpsinTools.MATCH_ELEMENT_SYMBOL.matcher(locant.getValue()).matches() && (possibleMultiplier = OpsinTools.getPreviousSibling(locant)) != null && possibleMultiplier.getName().equals("multiplier")) {
            int multiplierValue = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
            Element possibleOtherLocant = OpsinTools.getPreviousSibling(possibleMultiplier);
            if (possibleOtherLocant != null) {
                String[] locantValues = possibleOtherLocant.getValue().split(",");
                if (locantValues.length == Integer.parseInt(possibleMultiplier.getAttributeValue("value"))) {
                    for (int i = 0; i < locantValues.length; ++i) {
                        locantValues[i] = locant.getValue() + locantValues[i];
                    }
                    possibleOtherLocant.setValue(StringTools.arrayToString(locantValues, ","));
                    locant.detach();
                }
            } else {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < multiplierValue - 1; ++i) {
                    sb.append(locant.getValue());
                    sb.append(StringTools.multiplyString("'", i));
                    sb.append(',');
                }
                sb.append(locant.getValue());
                sb.append(StringTools.multiplyString("'", multiplierValue - 1));
                TokenEl newLocant = new TokenEl("locant", sb.toString());
                OpsinTools.insertBefore(possibleMultiplier, newLocant);
                locant.detach();
            }
        }
    }

    private static List<String> splitIntoIndividualLocants(String locantString) {
        ArrayList<String> individualLocants = new ArrayList<String>();
        char[] charArray = locantString.toCharArray();
        boolean inBracket = false;
        int indiceOfLastMatch = 0;
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == ',') {
                if (inBracket) continue;
                individualLocants.add(locantString.substring(indiceOfLastMatch, i));
                indiceOfLastMatch = i + 1;
                continue;
            }
            if (c == '(' || c == '[' || c == '{') {
                inBracket = true;
                continue;
            }
            if (c != ')' && c != ']' && c != '}') continue;
            inBracket = false;
        }
        individualLocants.add(locantString.substring(indiceOfLastMatch, charArray.length));
        return individualLocants;
    }

    private void convertOrthoMetaParaToLocants(Element subOrRoot) throws ComponentGenerationException {
        List<Element> ompLocants = subOrRoot.getChildElements("orthoMetaPara");
        for (Element ompLocant : ompLocants) {
            String locantText = ompLocant.getValue();
            String firstChar = locantText.substring(0, 1);
            ompLocant.setName("locant");
            ompLocant.addAttribute(new Attribute("type", "orthoMetaPara"));
            if (this.orthoMetaParaLocantIsTwoLocants(ompLocant)) {
                if ("o".equalsIgnoreCase(firstChar)) {
                    ompLocant.setValue("1,ortho");
                    continue;
                }
                if ("m".equalsIgnoreCase(firstChar)) {
                    ompLocant.setValue("1,meta");
                    continue;
                }
                if ("p".equalsIgnoreCase(firstChar)) {
                    ompLocant.setValue("1,para");
                    continue;
                }
                throw new ComponentGenerationException(locantText + " was not identified as being either ortho, meta or para but according to the chemical grammar it should of been");
            }
            if ("o".equalsIgnoreCase(firstChar)) {
                ompLocant.setValue("ortho");
                continue;
            }
            if ("m".equalsIgnoreCase(firstChar)) {
                ompLocant.setValue("meta");
                continue;
            }
            if ("p".equalsIgnoreCase(firstChar)) {
                ompLocant.setValue("para");
                continue;
            }
            throw new ComponentGenerationException(locantText + " was not identified as being either ortho, meta or para but according to the chemical grammar it should of been");
        }
    }

    private boolean orthoMetaParaLocantIsTwoLocants(Element ompLocant) {
        Element afterOmpLocant = OpsinTools.getNextSibling(ompLocant);
        if (afterOmpLocant != null) {
            Element suffix;
            Element multiplier;
            String elName = afterOmpLocant.getName();
            if (elName.equals("multiplier") && afterOmpLocant.getAttributeValue("value").equals("2")) {
                return true;
            }
            String outIds = afterOmpLocant.getAttributeValue("outIDs");
            if (outIds != null && outIds.split(",").length > 1) {
                return true;
            }
            if (elName.equals("group") && (multiplier = OpsinTools.getNextSibling(afterOmpLocant)) != null && multiplier.getName().equals("multiplier") && multiplier.getAttributeValue("value").equals("2") && (suffix = OpsinTools.getNextSiblingIgnoringCertainElements(multiplier, new String[]{"infix", "suffixPrefix"})).getName().equals("suffix")) {
                return true;
            }
        }
        return false;
    }

    private void formAlkaneStemsFromComponents(Element subOrRoot) {
        ArrayDeque<Element> alkaneStemComponents = new ArrayDeque<Element>(subOrRoot.getChildElements("alkaneStemComponent"));
        while (!alkaneStemComponents.isEmpty()) {
            Element alkaneStemComponent = (Element)alkaneStemComponents.removeFirst();
            int alkaneChainLength = 0;
            StringBuilder alkaneName = new StringBuilder();
            alkaneChainLength += Integer.parseInt(alkaneStemComponent.getAttributeValue("value"));
            alkaneName.append(alkaneStemComponent.getValue());
            while (!alkaneStemComponents.isEmpty() && OpsinTools.getNextSibling(alkaneStemComponent) == alkaneStemComponents.getFirst()) {
                alkaneStemComponent.detach();
                alkaneStemComponent = (Element)alkaneStemComponents.removeFirst();
                alkaneChainLength += Integer.parseInt(alkaneStemComponent.getAttributeValue("value"));
                alkaneName.append(alkaneStemComponent.getValue());
            }
            TokenEl alkaneStem = new TokenEl("group", alkaneName.toString());
            alkaneStem.addAttribute(new Attribute("type", "chain"));
            alkaneStem.addAttribute(new Attribute("subType", "alkaneStem"));
            alkaneStem.addAttribute(new Attribute("value", StringTools.multiplyString("C", alkaneChainLength)));
            alkaneStem.addAttribute(new Attribute("usableAsAJoiner", "yes"));
            alkaneStem.addAttribute(new Attribute("labels", "numeric"));
            OpsinTools.insertAfter(alkaneStemComponent, alkaneStem);
            alkaneStemComponent.detach();
        }
    }

    private void processAlkaneStemModifications(Element subOrRoot) throws ComponentGenerationException {
        List<Element> alkaneStemModifiers = subOrRoot.getChildElements("alkaneStemModifier");
        for (Element alkaneStemModifier : alkaneStemModifiers) {
            String smiles;
            boolean isAmyl;
            String type;
            Element alkane = OpsinTools.getNextSibling(alkaneStemModifier);
            if (alkaneStemModifier.getAttribute("value") != null) {
                type = alkaneStemModifier.getAttributeValue("value");
            } else if (alkaneStemModifier.getValue().equals("n-")) {
                type = "normal";
            } else if (alkaneStemModifier.getValue().equals("i-")) {
                type = "iso";
            } else if (alkaneStemModifier.getValue().equals("s-")) {
                type = "sec";
            } else {
                throw new ComponentGenerationException("Unrecognised alkaneStem modifier");
            }
            alkaneStemModifier.detach();
            if (alkane == null) {
                throw new ComponentGenerationException("OPSIN Bug: AlkaneStem not found after alkaneStemModifier");
            }
            String subType = alkane.getAttributeValue("subType");
            if ("amyl".equals(subType)) {
                isAmyl = true;
            } else if ("chain".equals(alkane.getAttributeValue("type")) && "alkaneStem".equals(subType)) {
                isAmyl = false;
            } else {
                throw new ComponentGenerationException("OPSIN Bug: AlkaneStem not found after alkaneStemModifier");
            }
            int chainLength = isAmyl ? 5 : alkane.getAttributeValue("value").length();
            String labels = "none";
            if (type.equals("normal")) {
                if (chainLength != 1 && chainLength != 2 || !alkaneStemModifier.getValue().equals("n-")) continue;
                TokenEl locant = new TokenEl("locant", "N");
                OpsinTools.insertBefore(alkane, locant);
                continue;
            }
            if (type.equals("tert")) {
                if (chainLength < 4) {
                    throw new ComponentGenerationException("ChainLength to small for tert modifier, required minLength 4. Found: " + chainLength);
                }
                if (chainLength > 8) {
                    throw new ComponentGenerationException("Interpretation of tert on an alkane chain of length: " + chainLength + " is ambiguous");
                }
                smiles = chainLength == 8 ? "C(C)(C)CC(C)(C)C" : "C(C)(C)C" + StringTools.multiplyString("C", chainLength - 4);
            } else if (type.equals("iso")) {
                boolean suffixPresent;
                if (chainLength < 3) {
                    throw new ComponentGenerationException("ChainLength to small for iso modifier, required minLength 3. Found: " + chainLength);
                }
                boolean bl = suffixPresent = isAmyl || subOrRoot.getChildElements("suffix").size() > 0;
                if (chainLength == 3 && !suffixPresent) {
                    throw new ComponentGenerationException("iso has no meaning without a suffix on an alkane chain of length 3");
                }
                if (chainLength == 8 && !suffixPresent) {
                    smiles = "C(C)(C)CC(C)(C)C";
                } else {
                    smiles = StringTools.multiplyString("C", chainLength - 3) + "C(C)C";
                    StringBuilder sb = new StringBuilder();
                    for (int c = 1; c <= chainLength - 2; ++c) {
                        sb.append(c);
                        sb.append('/');
                    }
                    sb.append('/');
                    labels = sb.toString();
                }
            } else if (type.equals("sec")) {
                boolean suffixPresent;
                if (chainLength < 3) {
                    throw new ComponentGenerationException("ChainLength to small for sec modifier, required minLength 3. Found: " + chainLength);
                }
                boolean bl = suffixPresent = isAmyl || subOrRoot.getChildElements("suffix").size() > 0;
                if (!suffixPresent) {
                    throw new ComponentGenerationException("sec has no meaning without a suffix on an alkane chain");
                }
                smiles = "C(C)C" + StringTools.multiplyString("C", chainLength - 3);
            } else if (type.equals("neo")) {
                if (chainLength < 5) {
                    throw new ComponentGenerationException("ChainLength to small for neo modifier, required minLength 5. Found: " + chainLength);
                }
                smiles = StringTools.multiplyString("C", chainLength - 5) + "CC(C)(C)C";
            } else {
                throw new ComponentGenerationException("Unrecognised alkaneStem modifier");
            }
            if (isAmyl) {
                smiles = alkane.getAttributeValue("value").substring(0, 1) + smiles;
            }
            alkane.getAttribute("value").setValue(smiles);
            alkane.getAttribute("labels").setValue(labels);
            alkane.removeAttribute(alkane.getAttribute("usableAsAJoiner"));
        }
    }

    private void processHeterogenousHydrides(Element subOrRoot) throws ComponentGenerationException {
        Element multipliedElem;
        List<Element> multipliers = subOrRoot.getChildElements("multiplier");
        for (int i = 0; i < multipliers.size(); ++i) {
            Element possibleUnsaturator;
            Element possibleMultiplier;
            Element suffix;
            Element m = multipliers.get(i);
            if (m.getAttributeValue("type").equals("group") || !(multipliedElem = OpsinTools.getNextSibling(m)).getName().equals("group") || multipliedElem.getAttribute("subType") == null || !multipliedElem.getAttributeValue("subType").equals("heteroStem")) continue;
            int mvalue = Integer.parseInt(m.getAttributeValue("value"));
            Element possiblyALocant = OpsinTools.getPreviousSibling(m);
            if (possiblyALocant != null && possiblyALocant.getName().equals("locant") && mvalue == possiblyALocant.getValue().split(",").length && (suffix = OpsinTools.getNextSibling(multipliedElem, "suffix")) != null && suffix.getAttributeValue("type").equals("inline") && !(possibleMultiplier = OpsinTools.getPreviousSibling(suffix)).getName().equals("multiplier")) continue;
            String heteroatomSmiles = multipliedElem.getAttributeValue("value");
            if (heteroatomSmiles.equals("B") && OpsinTools.getPreviousSibling(m) == null && (possibleUnsaturator = OpsinTools.getNextSibling(multipliedElem)) != null && possibleUnsaturator.getName().equals("unsaturator") && possibleUnsaturator.getAttributeValue("value").equals("1")) {
                throw new ComponentGenerationException("Polyboranes are not currently supported");
            }
            String smiles = StringTools.multiplyString(heteroatomSmiles, mvalue);
            multipliedElem.getAttribute("value").setValue(smiles);
            m.detach();
            multipliers.remove(i--);
        }
        for (Element m : multipliers) {
            int expected;
            Element possiblyAnotherHeteroAtom;
            if (m.getAttributeValue("type").equals("group") || !(multipliedElem = OpsinTools.getNextSibling(m)).getName().equals("heteroatom") || (possiblyAnotherHeteroAtom = OpsinTools.getNextSibling(multipliedElem)) == null || !possiblyAnotherHeteroAtom.getName().equals("heteroatom")) continue;
            Element possiblyAnUnsaturator = OpsinTools.getNextSiblingIgnoringCertainElements(possiblyAnotherHeteroAtom, new String[]{"locant", "multiplier"});
            if (possiblyAnUnsaturator != null && possiblyAnUnsaturator.getName().equals("unsaturator")) {
                int j;
                StringBuilder newGroupName = new StringBuilder(m.getValue());
                newGroupName.append(multipliedElem.getValue());
                newGroupName.append(possiblyAnotherHeteroAtom.getValue());
                if (possiblyAnUnsaturator.getAttributeValue("value").equals("1")) {
                    this.checkForAmbiguityWithHWring(multipliedElem.getAttributeValue("value"), possiblyAnotherHeteroAtom.getAttributeValue("value"));
                }
                int mvalue = Integer.parseInt(m.getAttributeValue("value"));
                StringBuilder smilesSB = new StringBuilder();
                Element possiblyARingFormingEl = OpsinTools.getPreviousSibling(m);
                boolean heteroatomChainWillFormARing = false;
                if (possiblyARingFormingEl != null && (possiblyARingFormingEl.getName().equals("cyclo") || possiblyARingFormingEl.getName().equals("vonBaeyer") || possiblyARingFormingEl.getName().equals("spiro"))) {
                    heteroatomChainWillFormARing = true;
                    for (j = 0; j < mvalue; ++j) {
                        smilesSB.append(possiblyAnotherHeteroAtom.getAttributeValue("value"));
                        smilesSB.append(multipliedElem.getAttributeValue("value"));
                    }
                } else {
                    for (j = 0; j < mvalue - 1; ++j) {
                        smilesSB.append(multipliedElem.getAttributeValue("value"));
                        smilesSB.append(possiblyAnotherHeteroAtom.getAttributeValue("value"));
                    }
                    smilesSB.append(multipliedElem.getAttributeValue("value"));
                }
                String smiles = smilesSB.toString();
                smiles = matchHdigit.matcher(smiles).replaceAll("H?");
                multipliedElem.detach();
                TokenEl addedGroup = new TokenEl("group", newGroupName.toString());
                addedGroup.addAttribute(new Attribute("value", smiles));
                addedGroup.addAttribute(new Attribute("labels", "numeric"));
                addedGroup.addAttribute(new Attribute("type", "chain"));
                addedGroup.addAttribute(new Attribute("subType", "heteroStem"));
                if (!heteroatomChainWillFormARing) {
                    addedGroup.addAttribute(new Attribute("usableAsAJoiner", "yes"));
                }
                OpsinTools.insertAfter(possiblyAnotherHeteroAtom, addedGroup);
                possiblyAnotherHeteroAtom.detach();
                m.detach();
                continue;
            }
            if (possiblyAnUnsaturator == null || !possiblyAnUnsaturator.getValue().equals("an") || !"hantzschWidman".equals(possiblyAnUnsaturator.getAttributeValue("subType"))) continue;
            boolean foundLocantIndicatingHwRingHeteroatomPositions = false;
            Element possibleLocant = OpsinTools.getPreviousSibling(m);
            if (possibleLocant != null && possibleLocant.getName().equals("locant") && (expected = Integer.parseInt(m.getAttributeValue("value")) + 1) == possibleLocant.getValue().split(",").length) {
                foundLocantIndicatingHwRingHeteroatomPositions = true;
            }
            if (foundLocantIndicatingHwRingHeteroatomPositions) continue;
            this.checkForAmbiguityWithHeterogenousHydride(multipliedElem.getAttributeValue("value"), possiblyAnotherHeteroAtom.getAttributeValue("value"));
        }
    }

    private void checkForAmbiguityWithHWring(String firstHeteroAtomSMILES, String secondHeteroAtomSMILES) throws ComponentGenerationException {
        Matcher m = OpsinTools.MATCH_ELEMENT_SYMBOL.matcher(firstHeteroAtomSMILES);
        if (!m.find()) {
            throw new ComponentGenerationException("Failed to extract element from heteroatom");
        }
        ChemEl atom1ChemEl = ChemEl.valueOf(m.group());
        m = OpsinTools.MATCH_ELEMENT_SYMBOL.matcher(secondHeteroAtomSMILES);
        if (!m.find()) {
            throw new ComponentGenerationException("Failed to extract element from heteroatom");
        }
        ChemEl atom2ChemEl = ChemEl.valueOf(m.group());
        if (!(AtomProperties.getHwpriority(atom1ChemEl) <= AtomProperties.getHwpriority(atom2ChemEl) || atom2ChemEl != ChemEl.O && atom2ChemEl != ChemEl.S && atom2ChemEl != ChemEl.Se && atom2ChemEl != ChemEl.Te && atom2ChemEl != ChemEl.Bi && atom2ChemEl != ChemEl.Hg || this.hasSiorGeorSnorPb(atom1ChemEl, atom2ChemEl))) {
            throw new ComponentGenerationException("Hantzch-widman ring misparsed as a heterogeneous hydride with alternating atoms");
        }
    }

    private boolean hasSiorGeorSnorPb(ChemEl atom1ChemEl, ChemEl atom2ChemEl) {
        return atom1ChemEl == ChemEl.Si || atom1ChemEl == ChemEl.Ge || atom1ChemEl == ChemEl.Sn || atom1ChemEl == ChemEl.Pb || atom2ChemEl == ChemEl.Si || atom2ChemEl == ChemEl.Ge || atom2ChemEl == ChemEl.Sn || atom2ChemEl == ChemEl.Pb;
    }

    private void checkForAmbiguityWithHeterogenousHydride(String firstHeteroAtomSMILES, String secondHeteroAtomSMILES) throws ComponentGenerationException {
        Matcher m = OpsinTools.MATCH_ELEMENT_SYMBOL.matcher(firstHeteroAtomSMILES);
        if (!m.find()) {
            throw new ComponentGenerationException("Failed to extract element from heteroatom");
        }
        String atom1Element = m.group();
        m = OpsinTools.MATCH_ELEMENT_SYMBOL.matcher(secondHeteroAtomSMILES);
        if (!m.find()) {
            throw new ComponentGenerationException("Failed to extract element from heteroatom");
        }
        String atom2Element = m.group();
        if (AtomProperties.getHwpriority(ChemEl.valueOf(atom2Element)) > AtomProperties.getHwpriority(ChemEl.valueOf(atom1Element))) {
            throw new ComponentGenerationException("heterogeneous hydride with alternating atoms misparsed as a Hantzch-widman ring");
        }
    }

    private void processIndicatedHydrogens(Element subOrRoot) throws ComponentGenerationException {
        List<Element> indicatedHydrogens = subOrRoot.getChildElements("indicatedHydrogen");
        for (Element indicatedHydrogenGroup : indicatedHydrogens) {
            String[] hydrogenLocants;
            String txt = StringTools.removeDashIfPresent(indicatedHydrogenGroup.getValue());
            if (!StringTools.endsWithCaseInsensitive(txt, "h")) {
                txt = txt.substring(1, txt.length() - 1);
            }
            for (String hydrogenLocant : hydrogenLocants = txt.split(",")) {
                if (!StringTools.endsWithCaseInsensitive(hydrogenLocant, "h")) {
                    throw new ComponentGenerationException("OPSIN Bug: malformed indicated hydrogen element!");
                }
                String locant = OpsinTools.fixLocantCapitalisation(hydrogenLocant.substring(0, hydrogenLocant.length() - 1));
                TokenEl indicatedHydrogenEl = new TokenEl("indicatedHydrogen");
                indicatedHydrogenEl.addAttribute(new Attribute("locant", locant));
                OpsinTools.insertBefore(indicatedHydrogenGroup, indicatedHydrogenEl);
            }
            indicatedHydrogenGroup.detach();
        }
    }

    void processStereochemistry(Element subOrRoot) throws ComponentGenerationException {
        List<Element> stereoChemistryElements = subOrRoot.getChildElements("stereoChemistry");
        ArrayList<Element> locantedUnbrackettedEzTerms = new ArrayList<Element>();
        for (Element stereoChemistryElement : stereoChemistryElements) {
            if (stereoChemistryElement.getAttributeValue("type").equals("stereochemistryBracket")) {
                this.processStereochemistryBracket(stereoChemistryElement);
                continue;
            }
            if (stereoChemistryElement.getAttributeValue("type").equals("cisOrTrans")) {
                this.assignLocantUsingPreviousElementIfPresent(stereoChemistryElement);
                continue;
            }
            if (stereoChemistryElement.getAttributeValue("type").equals("EorZ")) {
                stereoChemistryElement.addAttribute(new Attribute("value", stereoChemistryElement.getValue().toUpperCase(Locale.ROOT)));
                if (!this.assignLocantUsingPreviousElementIfPresent(stereoChemistryElement)) continue;
                locantedUnbrackettedEzTerms.add(stereoChemistryElement);
                continue;
            }
            if (stereoChemistryElement.getAttributeValue("type").equals("endoExoSynAnti")) {
                this.processLocantAssigningForEndoExoSynAnti(stereoChemistryElement);
                continue;
            }
            if (stereoChemistryElement.getAttributeValue("type").equals("alphaOrBeta")) {
                this.processUnbracketedAlphaBetaStereochemistry(stereoChemistryElement);
                continue;
            }
            if (stereoChemistryElement.getAttributeValue("type").equals("relativeCisTrans")) {
                this.processRelativeCisTrans(stereoChemistryElement);
                continue;
            }
            if (!stereoChemistryElement.getAttributeValue("type").equals("opticalRotation")) continue;
            this.processOpticalRotation(stereoChemistryElement);
        }
        if (locantedUnbrackettedEzTerms.size() > 0) {
            this.duplicateLocantFromStereoTermIfAdjacentToEneOrYlidene(locantedUnbrackettedEzTerms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStereochemistryBracket(Element stereoChemistryElement) throws ComponentGenerationException {
        block36: {
            try {
                Matcher racemicMacher;
                StereoGroupType stereoType = null;
                String txt = stereoChemistryElement.getValue();
                if (StringTools.startsWithCaseInsensitive(txt, "rel-")) {
                    stereoType = StereoGroupType.Rel;
                    txt = txt.substring(4);
                }
                if ((racemicMacher = matchRacemic.matcher(txt = StringTools.removeDashIfPresent(txt))).lookingAt()) {
                    txt = txt.substring(racemicMacher.group().length());
                    stereoType = StereoGroupType.Rac;
                }
                if ((txt = ComponentGenerator.normaliseBinaryBrackets(txt)).length() > 0) {
                    List<String> stereoChemistryDescriptors = this.splitStereoBracketIntoDescriptors(txt);
                    boolean exclusiveStereoTerm = false;
                    if (stereoChemistryDescriptors.size() == 1) {
                        String stereoChemistryDescriptor = stereoChemistryDescriptors.get(0);
                        if (stereoChemistryDescriptor.equalsIgnoreCase("rel")) {
                            stereoType = StereoGroupType.Rel;
                            exclusiveStereoTerm = true;
                        } else if (matchRacemic.matcher(stereoChemistryDescriptor).matches()) {
                            stereoType = StereoGroupType.Rac;
                            exclusiveStereoTerm = true;
                        }
                    }
                    if (!exclusiveStereoTerm) {
                        for (String stereoChemistryDescriptor : stereoChemistryDescriptors) {
                            Matcher m = matchStereochemistry.matcher(stereoChemistryDescriptor);
                            if (m.matches()) {
                                String symbol;
                                TokenEl stereoChemEl = new TokenEl("stereoChemistry", stereoChemistryDescriptor);
                                String locantVal = m.group(1);
                                if (locantVal.length() > 0) {
                                    stereoChemEl.addAttribute(new Attribute("locant", OpsinTools.fixLocantCapitalisation(StringTools.removeDashIfPresent(locantVal))));
                                }
                                OpsinTools.insertBefore(stereoChemistryElement, stereoChemEl);
                                if (matchRS.matcher(m.group(2)).matches()) {
                                    stereoChemEl.addAttribute(new Attribute("type", "RorS"));
                                    symbol = m.group(2).toUpperCase(Locale.ROOT).replaceAll("/", "");
                                    StereoGroupType localStereoType = stereoType;
                                    if (symbol.equals("RS") || symbol.equals("SR") || symbol.equals("RANDS") || symbol.equals("SANDR")) {
                                        if (localStereoType == null) {
                                            localStereoType = StereoGroupType.Rac;
                                        }
                                        symbol = symbol.substring(0, 1);
                                    } else if (symbol.equals("R*") || symbol.equals("S*") || symbol.equals("R^*") || symbol.equals("S^*") || symbol.equals("RORS") || symbol.equals("SORR")) {
                                        if (localStereoType == null) {
                                            localStereoType = StereoGroupType.Rel;
                                        }
                                        symbol = symbol.substring(0, 1);
                                    }
                                    stereoChemEl.addAttribute(new Attribute("value", symbol));
                                    if (localStereoType == null) {
                                        localStereoType = StereoGroupType.Abs;
                                    }
                                    stereoChemEl.addAttribute(new Attribute("stereoGroup", localStereoType.name()));
                                    continue;
                                }
                                if (matchEZ.matcher(m.group(2)).matches()) {
                                    stereoChemEl.addAttribute(new Attribute("type", "EorZ"));
                                    symbol = m.group(2).toUpperCase(Locale.ROOT);
                                    if (symbol.equalsIgnoreCase("EandZ") || symbol.equalsIgnoreCase("EorZ") || symbol.equalsIgnoreCase("E*") || symbol.equalsIgnoreCase("Z*")) {
                                        symbol = "EZ";
                                    }
                                    stereoChemEl.addAttribute(new Attribute("value", symbol));
                                    continue;
                                }
                                if (matchAlphaBetaStereochem.matcher(m.group(2)).matches()) {
                                    stereoChemEl.addAttribute(new Attribute("type", "alphaOrBeta"));
                                    if (Character.toLowerCase(m.group(2).charAt(0)) == 'a') {
                                        stereoChemEl.addAttribute(new Attribute("value", "alpha"));
                                        continue;
                                    }
                                    if (Character.toLowerCase(m.group(2).charAt(0)) == 'b') {
                                        stereoChemEl.addAttribute(new Attribute("value", "beta"));
                                        continue;
                                    }
                                    if (Character.toLowerCase(m.group(2).charAt(0)) == 'x') {
                                        stereoChemEl.addAttribute(new Attribute("value", "xi"));
                                        continue;
                                    }
                                    throw new ComponentGenerationException("Malformed alpha/beta stereochemistry element: " + stereoChemistryElement.getValue());
                                }
                                if (matchCisTrans.matcher(m.group(2)).matches()) {
                                    stereoChemEl.addAttribute(new Attribute("type", "cisOrTrans"));
                                    stereoChemEl.addAttribute(new Attribute("value", m.group(2).toLowerCase(Locale.ROOT)));
                                    continue;
                                }
                                if (matchEndoExoSynAnti.matcher(m.group(2)).matches()) {
                                    stereoChemEl.addAttribute(new Attribute("type", "endoExoSynAnti"));
                                    stereoChemEl.addAttribute(new Attribute("value", m.group(2).toLowerCase(Locale.ROOT)));
                                    continue;
                                }
                                if (matchAxialStereo.matcher(m.group(2)).matches()) {
                                    stereoChemEl.addAttribute(new Attribute("type", "axial"));
                                    stereoChemEl.addAttribute(new Attribute("value", m.group(2)));
                                    continue;
                                }
                                throw new ComponentGenerationException("Malformed stereochemistry element: " + stereoChemistryElement.getValue());
                            }
                            throw new ComponentGenerationException("Malformed stereochemistry element: " + stereoChemistryElement.getValue());
                        }
                    } else {
                        TokenEl stereoChemEl = new TokenEl("stereoChemistry", stereoChemistryElement.getValue());
                        stereoChemEl.addAttribute(new Attribute("type", stereoType == StereoGroupType.Rac ? "RAC" : "REL"));
                        OpsinTools.insertBefore(stereoChemistryElement, stereoChemEl);
                    }
                } else if (stereoType == StereoGroupType.Rac || stereoType == StereoGroupType.Rel) {
                    TokenEl stereoChemEl = new TokenEl("stereoChemistry", stereoChemistryElement.getValue());
                    stereoChemEl.addAttribute(new Attribute("type", stereoType == StereoGroupType.Rac ? "RAC" : "REL"));
                    OpsinTools.insertBefore(stereoChemistryElement, stereoChemEl);
                }
            }
            catch (StereochemistryException ex) {
                if (this.buildState.n2sConfig.warnRatherThanFailOnUninterpretableStereochemistry()) {
                    this.buildState.addWarning(OpsinWarning.OpsinWarningType.STEREOCHEMISTRY_IGNORED, ex.getMessage());
                    break block36;
                }
                throw new ComponentGenerationException(ex);
            }
            finally {
                stereoChemistryElement.detach();
            }
        }
    }

    static String normaliseBinaryBrackets(String inputStr) throws StereochemistryException {
        StereoGroupType mode;
        int i;
        if (inputStr.isEmpty()) {
            return inputStr;
        }
        int len = inputStr.length() - 1;
        for (i = 1; i < len && inputStr.charAt(i) != ')'; ++i) {
        }
        if (i == len) {
            return inputStr;
        }
        String firstBracket = inputStr.substring(1, i);
        if (++i < len && inputStr.charAt(i) == '-') {
            ++i;
        }
        if (StringTools.startsWithCaseInsensitive(inputStr, i, "AND")) {
            mode = StereoGroupType.Rac;
        } else if (StringTools.startsWithCaseInsensitive(inputStr, i, "OR")) {
            mode = StereoGroupType.Rel;
        } else {
            return inputStr;
        }
        while (i < len && inputStr.charAt(i) != '(') {
            ++i;
        }
        if (i == len) {
            return inputStr;
        }
        int mark = i + 1;
        while (i < len && inputStr.charAt(i) != ')') {
            ++i;
        }
        String secondBracket = inputStr.substring(mark, i);
        if (firstBracket.length() != secondBracket.length()) {
            throw new StereochemistryException("Alternative stereochemistry brackets are different lengths: " + firstBracket + " " + secondBracket);
        }
        StringBuilder generated = new StringBuilder();
        generated.append('(');
        for (int j = 0; j < firstBracket.length(); ++j) {
            generated.append(firstBracket.charAt(j));
            if (firstBracket.charAt(j) == secondBracket.charAt(j)) continue;
            if (firstBracket.charAt(j) == 'R' || firstBracket.charAt(j) == 'S' || firstBracket.charAt(j) == 'r' || firstBracket.charAt(j) == 's' || firstBracket.charAt(j) == 'E' || firstBracket.charAt(j) == 'Z') {
                if (mode == StereoGroupType.Rac) {
                    generated.append(secondBracket.charAt(j));
                    continue;
                }
                generated.append('*');
                continue;
            }
            throw new StereochemistryException("Invalid combination of stereo brackets: " + firstBracket.charAt(j) + " " + secondBracket.charAt(j));
        }
        generated.append(')');
        return generated.toString();
    }

    private List<String> splitStereoBracketIntoDescriptors(String stereoBracket) {
        ArrayList<String> stereoDescriptors = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int l = stereoBracket.length() - 1;
        for (int i = 1; i < l; ++i) {
            char ch = stereoBracket.charAt(i);
            if (ch == ',') {
                stereoDescriptors.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            if (ch == '-') {
                if (matchStereochemistry.matcher(sb.toString()).matches()) {
                    stereoDescriptors.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append(ch);
                continue;
            }
            sb.append(ch);
        }
        stereoDescriptors.add(sb.toString());
        return stereoDescriptors;
    }

    public void processOpticalRotation(Element e) {
        if (e.getValue().startsWith("(+/-)") || e.getValue().startsWith("(+-)")) {
            TokenEl stereoChemEl = new TokenEl("stereoChemistry", e.getValue());
            stereoChemEl.addAttribute(new Attribute("type", "RAC"));
            OpsinTools.insertBefore(e, stereoChemEl);
        }
    }

    private boolean assignLocantUsingPreviousElementIfPresent(Element stereoChemistryElement) {
        Element possibleLocant = OpsinTools.getPrevious(stereoChemistryElement);
        if (possibleLocant != null && possibleLocant.getName().equals("locant") && possibleLocant.getValue().split(",").length == 1) {
            stereoChemistryElement.addAttribute(new Attribute("locant", possibleLocant.getValue()));
            possibleLocant.detach();
            return true;
        }
        return false;
    }

    private void processLocantAssigningForEndoExoSynAnti(Element stereoChemistryElement) {
        Element possibleLocant = OpsinTools.getPrevious(stereoChemistryElement);
        if (possibleLocant != null && possibleLocant.getName().equals("locant") && possibleLocant.getValue().split(",").length == 1) {
            stereoChemistryElement.addAttribute(new Attribute("locant", possibleLocant.getValue()));
            Element group = OpsinTools.getNextSibling(stereoChemistryElement, "group");
            if (group != null && ("cyclicUnsaturableHydrocarbon".equals(group.getAttributeValue("subType")) || OpsinTools.getPreviousSibling(group).getName().equals("vonBaeyer"))) {
                possibleLocant.detach();
            }
        }
    }

    private void processUnbracketedAlphaBetaStereochemistry(Element stereoChemistryElement) throws ComponentGenerationException {
        String txt = StringTools.removeDashIfPresent(stereoChemistryElement.getValue());
        String[] stereoChemistryDescriptors = txt.split(",");
        ArrayList<String> locants = new ArrayList<String>();
        boolean createLocantsEl = false;
        for (String stereoChemistryDescriptor : stereoChemistryDescriptors) {
            Matcher digitMatcher = OpsinTools.MATCH_DIGITS.matcher(stereoChemistryDescriptor);
            if (!digitMatcher.lookingAt()) continue;
            String locant = digitMatcher.group();
            String possibleAlphaBeta = digitMatcher.replaceAll("");
            locants.add(locant);
            Matcher alphaBetaMatcher = matchAlphaBetaStereochem.matcher(possibleAlphaBeta);
            if (alphaBetaMatcher.matches()) {
                TokenEl stereoChemEl = new TokenEl("stereoChemistry", stereoChemistryDescriptor);
                stereoChemEl.addAttribute(new Attribute("locant", locant));
                OpsinTools.insertBefore(stereoChemistryElement, stereoChemEl);
                stereoChemEl.addAttribute(new Attribute("type", "alphaOrBeta"));
                if (Character.toLowerCase(possibleAlphaBeta.charAt(0)) == 'a') {
                    stereoChemEl.addAttribute(new Attribute("value", "alpha"));
                    continue;
                }
                if (Character.toLowerCase(possibleAlphaBeta.charAt(0)) == 'b') {
                    stereoChemEl.addAttribute(new Attribute("value", "beta"));
                    continue;
                }
                if (Character.toLowerCase(possibleAlphaBeta.charAt(0)) == 'x') {
                    stereoChemEl.addAttribute(new Attribute("value", "xi"));
                    continue;
                }
                throw new ComponentGenerationException("Malformed alpha/beta stereochemistry element: " + stereoChemistryElement.getValue());
            }
            createLocantsEl = true;
        }
        if (!createLocantsEl) {
            createLocantsEl = true;
            List<Element> groups = OpsinTools.getNextSiblingsOfType(stereoChemistryElement, "group");
            for (Element group : groups) {
                if (group.getAttributeValue("alphaBetaClockWiseAtomOrdering") == null) continue;
                createLocantsEl = false;
                break;
            }
        }
        if (createLocantsEl) {
            TokenEl newLocantEl = new TokenEl("locant", StringTools.stringListToString(locants, ","));
            OpsinTools.insertAfter(stereoChemistryElement, newLocantEl);
        }
        stereoChemistryElement.detach();
    }

    private void processRelativeCisTrans(Element stereoChemistryElement) {
        String[] terms;
        String value = StringTools.removeDashIfPresent(stereoChemistryElement.getValue());
        StringBuilder sb = new StringBuilder();
        for (String term : terms = value.split(",")) {
            if (term.startsWith("c-") || term.startsWith("t-") || term.startsWith("r-")) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
            } else {
                throw new RuntimeException("Malformed relativeCisTrans element");
            }
            sb.append(term.substring(2));
        }
        TokenEl locantEl = new TokenEl("locant", sb.toString());
        OpsinTools.insertAfter(stereoChemistryElement, locantEl);
    }

    private void duplicateLocantFromStereoTermIfAdjacentToEneOrYlidene(List<Element> locantedUnbrackettedEzTerms) {
        int l = locantedUnbrackettedEzTerms.size();
        for (int i = 0; i < l; ++i) {
            String name;
            Element eneOrYlidene;
            Element currentTerm = locantedUnbrackettedEzTerms.get(i);
            ArrayList<Element> groupedTerms = new ArrayList<Element>();
            groupedTerms.add(currentTerm);
            while (i + 1 < l && locantedUnbrackettedEzTerms.get(i + 1).equals(OpsinTools.getNextSibling(currentTerm))) {
                currentTerm = locantedUnbrackettedEzTerms.get(++i);
                groupedTerms.add(currentTerm);
            }
            Element lastTermInGroup = (Element)groupedTerms.get(groupedTerms.size() - 1);
            if (groupedTerms.size() > 1) {
                Element multiplier = OpsinTools.getNextSibling(lastTermInGroup);
                if (multiplier == null || !multiplier.getName().equals("multiplier") || !String.valueOf(groupedTerms.size()).equals(multiplier.getAttributeValue("value"))) continue;
                eneOrYlidene = OpsinTools.getNextSibling(multiplier);
            } else {
                eneOrYlidene = OpsinTools.getNextSibling(lastTermInGroup);
            }
            if (eneOrYlidene == null || !(name = eneOrYlidene.getName()).equals("unsaturator") && !name.equals("suffix")) continue;
            if (name.equals("unsaturator") && eneOrYlidene.getAttributeValue("value").equals("2") || name.equals("suffix") && eneOrYlidene.getAttributeValue("value").equals("ylidene")) {
                ArrayList<String> locants = new ArrayList<String>();
                for (Element stereochemistryTerm : groupedTerms) {
                    locants.add(stereochemistryTerm.getAttributeValue("locant"));
                }
                TokenEl newLocant = new TokenEl("locant", StringTools.stringListToString(locants, ","));
                OpsinTools.insertAfter(lastTermInGroup, newLocant);
                continue;
            }
            if (name.equals("unsaturator")) {
                throw new RuntimeException("After E/Z stereo expected ene but found: " + eneOrYlidene.getValue());
            }
            throw new RuntimeException("After E/Z stereo expected yldiene but found: " + eneOrYlidene.getValue());
        }
    }

    private void processSuffixPrefixes(Element subOrRoot) throws ComponentGenerationException {
        List<Element> suffixPrefixes = subOrRoot.getChildElements("suffixPrefix");
        for (Element suffixPrefix : suffixPrefixes) {
            Element suffix = OpsinTools.getNextSibling(suffixPrefix);
            if (suffix == null || !suffix.getName().equals("suffix")) {
                throw new ComponentGenerationException("OPSIN bug: suffix not found after suffixPrefix: " + suffixPrefix.getValue());
            }
            suffix.addAttribute(new Attribute("suffixPrefix", suffixPrefix.getAttributeValue("value")));
            suffixPrefix.detach();
        }
    }

    private void processInfixes(Element subOrRoot) throws ComponentGenerationException {
        List<Element> infixes = subOrRoot.getChildElements("infix");
        for (Element infix : infixes) {
            Element possibleBracket;
            List<String> currentInfixInformation;
            Element suffix = OpsinTools.getNextSiblingIgnoringCertainElements(infix, new String[]{"infix", "suffixPrefix", "multiplier"});
            if (suffix == null || !suffix.getName().equals("suffix")) {
                throw new ComponentGenerationException("No suffix found next next to infix: " + infix.getValue());
            }
            if (suffix.getAttribute("infix") == null) {
                suffix.addAttribute(new Attribute("infix", ""));
                currentInfixInformation = new ArrayList<String>();
            } else {
                currentInfixInformation = StringTools.arrayToList(suffix.getAttributeValue("infix").split(";"));
            }
            String infixValue = infix.getAttributeValue("value");
            currentInfixInformation.add(infixValue);
            Element possibleMultiplier = OpsinTools.getPreviousSibling(infix);
            boolean multiplierKnownToIndicateInfixMultiplicationPresent = false;
            if (possibleMultiplier.getName().equals("multiplier")) {
                Element elementBeforeMultiplier;
                Element possibleSuffixPrefix = OpsinTools.getPreviousSiblingIgnoringCertainElements(infix, new String[]{"multiplier", "infix"});
                if (possibleSuffixPrefix != null && possibleSuffixPrefix.getName().equals("suffixPrefix")) {
                    multiplierKnownToIndicateInfixMultiplicationPresent = true;
                }
                if ((elementBeforeMultiplier = OpsinTools.getPreviousSibling(possibleMultiplier)).getName().equals("multiplier") || currentInfixInformation.size() > 1) {
                    multiplierKnownToIndicateInfixMultiplicationPresent = true;
                }
                possibleBracket = elementBeforeMultiplier;
            } else {
                possibleBracket = possibleMultiplier;
                possibleMultiplier = null;
                infix.detach();
            }
            if (possibleBracket.getName().equals("structuralOpenBracket")) {
                Element bracket = OpsinTools.getNextSibling(suffix);
                if (!bracket.getName().equals("structuralCloseBracket")) {
                    throw new ComponentGenerationException("Matching closing bracket not found around infix/suffix block");
                }
                if (possibleMultiplier != null) {
                    int multiplierVal = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
                    for (int i = 1; i < multiplierVal; ++i) {
                        currentInfixInformation.add(infixValue);
                    }
                    possibleMultiplier.detach();
                    infix.detach();
                }
                possibleBracket.detach();
                bracket.detach();
            } else if (multiplierKnownToIndicateInfixMultiplicationPresent) {
                int multiplierVal = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
                for (int i = 1; i < multiplierVal; ++i) {
                    currentInfixInformation.add(infixValue);
                }
                possibleMultiplier.detach();
                infix.detach();
            } else if (possibleMultiplier != null && "group".equals(possibleMultiplier.getAttributeValue("type"))) {
                infix.detach();
            }
            suffix.getAttribute("infix").setValue(StringTools.stringListToString(currentInfixInformation, ";"));
        }
    }

    private void processLambdaConvention(Element subOrRoot) throws ComponentGenerationException {
        List<Element> lambdaConventionEls = subOrRoot.getChildElements("lambdaConvention");
        boolean fusedRingPresent = false;
        if (lambdaConventionEls.size() > 0 && subOrRoot.getChildElements("group").size() > 1) {
            fusedRingPresent = true;
        }
        for (Element lambdaConventionEl : lambdaConventionEls) {
            boolean frontLocantsExpected = false;
            String[] lambdaValues = StringTools.removeDashIfPresent(lambdaConventionEl.getValue()).split(",");
            Element possibleHeteroatomOrMultiplier = OpsinTools.getNextSibling(lambdaConventionEl);
            int heteroCount = 0;
            int multiplierValue = 1;
            while (possibleHeteroatomOrMultiplier != null) {
                if (possibleHeteroatomOrMultiplier.getName().equals("heteroatom")) {
                    heteroCount += multiplierValue;
                    multiplierValue = 1;
                } else {
                    if (!possibleHeteroatomOrMultiplier.getName().equals("multiplier")) break;
                    multiplierValue = Integer.parseInt(possibleHeteroatomOrMultiplier.getAttributeValue("value"));
                }
                possibleHeteroatomOrMultiplier = OpsinTools.getNextSibling(possibleHeteroatomOrMultiplier);
            }
            boolean assignLambdasToHeteroAtoms = false;
            if (lambdaValues.length == heteroCount) {
                if (!(fusedRingPresent && possibleHeteroatomOrMultiplier != null && possibleHeteroatomOrMultiplier.getName().equals("group") && possibleHeteroatomOrMultiplier.getAttributeValue("subType").equals("hantzschWidman"))) {
                    assignLambdasToHeteroAtoms = true;
                }
            } else if (possibleHeteroatomOrMultiplier != null && (heteroCount == 0 && OpsinTools.getNextSibling(lambdaConventionEl).equals(possibleHeteroatomOrMultiplier) && fusedRingPresent && possibleHeteroatomOrMultiplier.getName().equals("group") && (possibleHeteroatomOrMultiplier.getValue().equals("benzo") || possibleHeteroatomOrMultiplier.getValue().equals("benz")) && !OpsinTools.getNextSibling(possibleHeteroatomOrMultiplier).getName().equals("fusion") && !OpsinTools.getNextSibling(possibleHeteroatomOrMultiplier).getName().equals("locant") || possibleHeteroatomOrMultiplier.getName().equals("polyCyclicSpiro") && (possibleHeteroatomOrMultiplier.getAttributeValue("value").equals("spirobi") || possibleHeteroatomOrMultiplier.getAttributeValue("value").equals("spiroter")))) {
                frontLocantsExpected = true;
            }
            ArrayList<Element> heteroAtoms = new ArrayList<Element>();
            if (assignLambdasToHeteroAtoms) {
                Element multiplier = null;
                Element heteroatomOrMultiplier = OpsinTools.getNextSibling(lambdaConventionEl);
                while (heteroatomOrMultiplier != null) {
                    if (heteroatomOrMultiplier.getName().equals("heteroatom")) {
                        heteroAtoms.add(heteroatomOrMultiplier);
                        if (multiplier != null) {
                            for (int i = 1; i < Integer.parseInt(multiplier.getAttributeValue("value")); ++i) {
                                Element newHeteroAtom = heteroatomOrMultiplier.copy();
                                OpsinTools.insertBefore(heteroatomOrMultiplier, newHeteroAtom);
                                heteroAtoms.add(newHeteroAtom);
                            }
                            multiplier.detach();
                            multiplier = null;
                        }
                    } else {
                        if (!heteroatomOrMultiplier.getName().equals("multiplier") || multiplier != null) break;
                        multiplier = heteroatomOrMultiplier;
                    }
                    heteroatomOrMultiplier = OpsinTools.getNextSibling(heteroatomOrMultiplier);
                }
            }
            for (int i = 0; i < lambdaValues.length; ++i) {
                String locant;
                Matcher m = matchLambdaConvention.matcher(lambdaValues[i]);
                if (m.matches()) {
                    String locant2;
                    Attribute valencyChange = new Attribute("lambda", m.group(2));
                    String string = locant2 = m.group(1) != null ? OpsinTools.fixLocantCapitalisation(m.group(1)) : null;
                    if (frontLocantsExpected) {
                        if (locant2 == null) {
                            throw new ComponentGenerationException("Locant not found for lambda convention before a benzo fused ring system");
                        }
                        lambdaValues[i] = locant2;
                    }
                    if (assignLambdasToHeteroAtoms) {
                        Element heteroAtom = (Element)heteroAtoms.get(i);
                        heteroAtom.addAttribute(valencyChange);
                        if (locant2 == null) continue;
                        heteroAtom.addAttribute("locant", locant2);
                        continue;
                    }
                    TokenEl newLambda = new TokenEl("lambdaConvention");
                    newLambda.addAttribute(valencyChange);
                    if (locant2 != null) {
                        newLambda.addAttribute("locant", locant2);
                    }
                    OpsinTools.insertBefore(lambdaConventionEl, newLambda);
                    continue;
                }
                lambdaValues[i] = locant = OpsinTools.fixLocantCapitalisation(lambdaValues[i]);
                if (!assignLambdasToHeteroAtoms) {
                    if (frontLocantsExpected) continue;
                    throw new ComponentGenerationException("Lambda convention not specified for locant: " + locant);
                }
                Element heteroAtom = (Element)heteroAtoms.get(i);
                heteroAtom.addAttribute(new Attribute("locant", locant));
            }
            if (!frontLocantsExpected) {
                lambdaConventionEl.detach();
                continue;
            }
            lambdaConventionEl.setName("locant");
            lambdaConventionEl.setValue(StringTools.arrayToString(lambdaValues, ","));
        }
    }

    private void findAndStructureBrackets(List<Element> substituentsAndRoot, List<Element> brackets) throws ComponentGenerationException {
        int blevel = 0;
        Element openBracket = null;
        boolean nestedBrackets = false;
        for (Element sub : substituentsAndRoot) {
            List<Element> children = sub.getChildElements();
            for (Element child : children) {
                String name = child.getName();
                if (name.equals("openbracket")) {
                    ++blevel;
                    if (openBracket == null) {
                        openBracket = child;
                        continue;
                    }
                    nestedBrackets = true;
                    continue;
                }
                if (!name.equals("closebracket") || --blevel != 0) continue;
                Element bracket = this.structureBrackets(openBracket, child);
                brackets.add(bracket);
                if (nestedBrackets) {
                    this.findAndStructureBrackets(OpsinTools.getDescendantElementsWithTagNames(bracket, new String[]{"substituent", "root"}), brackets);
                }
                openBracket = null;
                nestedBrackets = false;
            }
        }
        if (blevel != 0) {
            throw new ComponentGenerationException("Brackets do not match!");
        }
    }

    private Element structureBrackets(Element openBracket, Element closeBracket) throws ComponentGenerationException {
        Element nextEl;
        GroupingEl bracket = new GroupingEl("bracket");
        Element currentEl = openBracket.getParent();
        OpsinTools.insertBefore(currentEl, bracket);
        Element firstChild = currentEl.getChild(0);
        while (!firstChild.equals(openBracket)) {
            firstChild.detach();
            ((Element)bracket).addChild(firstChild);
            firstChild = currentEl.getChild(0);
        }
        while (!currentEl.equals(closeBracket.getParent())) {
            nextEl = OpsinTools.getNextSibling(currentEl);
            currentEl.detach();
            ((Element)bracket).addChild(currentEl);
            currentEl = nextEl;
            if (currentEl != null) continue;
            throw new ComponentGenerationException("Brackets within a word do not match!");
        }
        currentEl.detach();
        ((Element)bracket).addChild(currentEl);
        currentEl = OpsinTools.getNextSibling(closeBracket);
        while (currentEl != null) {
            nextEl = OpsinTools.getNextSibling(currentEl);
            currentEl.detach();
            ((Element)bracket).addChild(currentEl);
            currentEl = nextEl;
        }
        openBracket.detach();
        closeBracket.detach();
        return bracket;
    }

    private void processHydroCarbonRings(Element subOrRoot) throws ComponentGenerationException {
        List<Element> annulens = subOrRoot.getChildElements("annulen");
        for (Element annulen : annulens) {
            String annulenValue = annulen.getValue();
            Matcher m = matchAnnulene.matcher(annulenValue);
            if (!m.matches()) {
                throw new ComponentGenerationException("Invalid annulen tag");
            }
            int annuleneSize = Integer.valueOf(m.group(1));
            if (annuleneSize < 3) {
                throw new ComponentGenerationException("Invalid annulene size");
            }
            StringBuilder sb = new StringBuilder();
            if (m.group(2).equalsIgnoreCase("yn")) {
                sb.append("C1#C");
            } else {
                sb.append("c1c");
            }
            for (int i = 2; i < annuleneSize; ++i) {
                sb.append("c");
            }
            sb.append('1');
            TokenEl group = new TokenEl("group", annulenValue);
            group.addAttribute(new Attribute("value", sb.toString()));
            group.addAttribute(new Attribute("labels", "numeric"));
            group.addAttribute(new Attribute("type", "ring"));
            group.addAttribute(new Attribute("subType", "ring"));
            annulen.getParent().replaceChild(annulen, group);
        }
        List<Element> hydrocarbonFRSystems = subOrRoot.getChildElements("hydrocarbonFusedRingSystem");
        for (Element hydrocarbonFRSystem : hydrocarbonFRSystems) {
            Element multiplier = OpsinTools.getPreviousSibling(hydrocarbonFRSystem);
            if (multiplier != null && multiplier.getName().equals("multiplier")) {
                int j;
                int multiplierValue = Integer.parseInt(multiplier.getAttributeValue("value"));
                String classOfHydrocarbonFRSystem = hydrocarbonFRSystem.getAttributeValue("value");
                StringBuilder smilesSB = new StringBuilder();
                if (classOfHydrocarbonFRSystem.equals("polyacene")) {
                    if (multiplierValue <= 3) {
                        throw new ComponentGenerationException("Invalid polyacene");
                    }
                    smilesSB.append("c1ccc");
                    for (j = 2; j <= multiplierValue; ++j) {
                        smilesSB.append("c");
                        smilesSB.append(this.ringClosure(j));
                        smilesSB.append("c");
                    }
                    smilesSB.append("ccc");
                    for (j = multiplierValue; j > 2; --j) {
                        smilesSB.append("c");
                        smilesSB.append(this.ringClosure(j));
                        smilesSB.append("c");
                    }
                    smilesSB.append("c12");
                } else if (classOfHydrocarbonFRSystem.equals("polyaphene")) {
                    int j2;
                    int ringsOnPlane;
                    int ringsAbovePlane;
                    if (multiplierValue <= 3) {
                        throw new ComponentGenerationException("Invalid polyaphene");
                    }
                    smilesSB.append("c1ccc");
                    int ringOpeningCounter = 2;
                    if (multiplierValue % 2 == 0) {
                        ringsAbovePlane = (multiplierValue - 2) / 2;
                        ringsOnPlane = ringsAbovePlane + 1;
                    } else {
                        ringsOnPlane = ringsAbovePlane = (multiplierValue - 1) / 2;
                    }
                    for (j2 = 1; j2 <= ringsAbovePlane; ++j2) {
                        smilesSB.append("c");
                        smilesSB.append(this.ringClosure(ringOpeningCounter++));
                        smilesSB.append("c");
                    }
                    for (j2 = 1; j2 <= ringsOnPlane; ++j2) {
                        smilesSB.append("cc");
                        smilesSB.append(this.ringClosure(ringOpeningCounter++));
                    }
                    smilesSB.append("ccc");
                    --ringOpeningCounter;
                    for (j2 = 1; j2 <= ringsOnPlane; ++j2) {
                        smilesSB.append("cc");
                        smilesSB.append(this.ringClosure(ringOpeningCounter--));
                    }
                    for (j2 = 1; j2 < ringsAbovePlane; ++j2) {
                        smilesSB.append("c");
                        smilesSB.append(this.ringClosure(ringOpeningCounter--));
                        smilesSB.append("c");
                    }
                    smilesSB.append("c12");
                } else if (classOfHydrocarbonFRSystem.equals("polyalene")) {
                    if (multiplierValue < 5) {
                        throw new ComponentGenerationException("Invalid polyalene");
                    }
                    smilesSB.append("c1");
                    for (j = 3; j < multiplierValue; ++j) {
                        smilesSB.append("c");
                    }
                    smilesSB.append("c2");
                    for (j = 3; j <= multiplierValue; ++j) {
                        smilesSB.append("c");
                    }
                    smilesSB.append("c12");
                } else if (classOfHydrocarbonFRSystem.equals("polyphenylene")) {
                    if (multiplierValue < 2) {
                        throw new ComponentGenerationException("Invalid polyphenylene");
                    }
                    smilesSB.append("c1cccc2");
                    for (j = 1; j < multiplierValue; ++j) {
                        smilesSB.append("c3ccccc3");
                    }
                    smilesSB.append("c12");
                } else if (classOfHydrocarbonFRSystem.equals("polynaphthylene")) {
                    if (multiplierValue < 3) {
                        throw new ComponentGenerationException("Invalid polynaphthylene");
                    }
                    smilesSB.append("c1cccc2cc3");
                    for (j = 1; j < multiplierValue; ++j) {
                        smilesSB.append("c4cc5ccccc5cc4");
                    }
                    smilesSB.append("c3cc12");
                } else if (classOfHydrocarbonFRSystem.equals("polyhelicene")) {
                    int j3;
                    if (multiplierValue < 4) {
                        throw new ComponentGenerationException("Invalid polyhelicene");
                    }
                    smilesSB.append("c1c");
                    int ringOpeningCounter = 2;
                    for (j3 = 1; j3 < multiplierValue; ++j3) {
                        smilesSB.append("ccc");
                        smilesSB.append(this.ringClosure(ringOpeningCounter++));
                    }
                    smilesSB.append("cccc");
                    --ringOpeningCounter;
                    for (j3 = 2; j3 < multiplierValue; ++j3) {
                        smilesSB.append("c");
                        smilesSB.append(this.ringClosure(ringOpeningCounter--));
                    }
                    smilesSB.append("c12");
                } else {
                    throw new ComponentGenerationException("Unknown semi-trivially named hydrocarbon fused ring system");
                }
                TokenEl newGroup = new TokenEl("group", multiplier.getValue() + hydrocarbonFRSystem.getValue());
                newGroup.addAttribute(new Attribute("value", smilesSB.toString()));
                newGroup.addAttribute(new Attribute("labels", "fusedRing"));
                newGroup.addAttribute(new Attribute("type", "ring"));
                newGroup.addAttribute(new Attribute("subType", "hydrocarbonFusedRingSystem"));
                hydrocarbonFRSystem.getParent().replaceChild(hydrocarbonFRSystem, newGroup);
                multiplier.detach();
                continue;
            }
            throw new ComponentGenerationException("Invalid semi-trivially named hydrocarbon fused ring system");
        }
    }

    private void handleSuffixIrregularities(Element subOrRoot) throws ComponentGenerationException {
        List<Element> suffixes = subOrRoot.getChildElements("suffix");
        for (Element suffix : suffixes) {
            Element precedingGroup;
            String suffixValue = suffix.getValue();
            if (suffixValue.equals("ic") || suffixValue.equals("ous")) {
                Element next;
                if (this.buildState.n2sConfig.allowInterpretationOfAcidsWithoutTheWordAcid() || (next = OpsinTools.getNext(suffix)) != null) continue;
                throw new ComponentGenerationException("\"acid\" not found after " + suffixValue);
            }
            if (suffixValue.equals("quinone") || suffixValue.equals("quinon")) {
                suffix.removeAttribute(suffix.getAttribute("additionalValue"));
                suffix.setValue("one");
                Element multiplier = OpsinTools.getPreviousSibling(suffix);
                if (multiplier.getName().equals("multiplier")) {
                    Attribute multVal = multiplier.getAttribute("value");
                    int newMultiplier = Integer.parseInt(multVal.getValue()) * 2;
                    multVal.setValue(String.valueOf(newMultiplier));
                    continue;
                }
                multiplier = new TokenEl("multiplier", "di");
                multiplier.addAttribute(new Attribute("value", "2"));
                OpsinTools.insertBefore(suffix, multiplier);
                continue;
            }
            if (suffixValue.equals("ylene") || suffixValue.equals("ylen")) {
                suffix.removeAttribute(suffix.getAttribute("additionalValue"));
                suffix.setValue("yl");
                Element alk = OpsinTools.getPreviousSibling(suffix, "group");
                if (alk.getAttribute("usableAsAJoiner") != null) {
                    alk.removeAttribute(alk.getAttribute("usableAsAJoiner"));
                }
                TokenEl multiplier = new TokenEl("multiplier", "di");
                multiplier.addAttribute(new Attribute("value", "2"));
                OpsinTools.insertBefore(suffix, multiplier);
                continue;
            }
            if (suffixValue.equals("ylium") && "acylium".equals(suffix.getAttributeValue("value")) && suffix.getAttribute("suffixPrefix") == null && suffix.getAttribute("infix") == null) {
                Element beforeSuffix;
                String o;
                Element group = OpsinTools.getPreviousSibling(suffix, "group");
                if (group != null && ("acidStem".equals(group.getAttributeValue("type")) || "chalcogenAcidStem".equals(group.getAttributeValue("type")) || "nonCarboxylicAcid".equals(group.getAttributeValue("type"))) || (o = (beforeSuffix = OpsinTools.getPreviousSibling(suffix)).getAttributeValue("subsequentUnsemanticToken")) != null && StringTools.endsWithCaseInsensitive(o, "o")) continue;
                if (group != null && "arylSubstituent".equals(group.getAttributeValue("subType"))) {
                    suffix.getAttribute("value").setValue("ylium");
                    suffix.getAttribute("type").setValue("charge");
                    suffix.removeAttribute(suffix.getAttribute("subType"));
                    continue;
                }
                throw new ComponentGenerationException("ylium is intended to be the removal of H- in this context not the formation of an acylium ion");
            }
            if (!suffixValue.equals("nitrolic acid") && !suffixValue.equals("nitrolicacid") || (precedingGroup = OpsinTools.getPreviousSibling(suffix, "group")) != null) continue;
            if (subOrRoot.getChildCount() != 1) {
                throw new RuntimeException("OPSIN Bug: nitrolic acid not expected to have sibilings");
            }
            Element precedingSubstituent = OpsinTools.getPreviousSibling(subOrRoot);
            if (precedingSubstituent == null || !precedingSubstituent.getName().equals("substituent")) {
                throw new ComponentGenerationException("Expected substituent before nitrolic acid");
            }
            List<Element> existingSuffixes = precedingSubstituent.getChildElements("suffix");
            if (existingSuffixes.size() == 1) {
                if (!existingSuffixes.get(0).getValue().equals("yl")) {
                    throw new ComponentGenerationException("Unexpected suffix found before nitrolic acid");
                }
                existingSuffixes.get(0).detach();
                for (Element child : precedingSubstituent.getChildElements()) {
                    child.detach();
                    OpsinTools.insertBefore(suffix, child);
                }
                precedingSubstituent.detach();
                continue;
            }
            throw new ComponentGenerationException("Only the nitrolic acid case where it is preceded by an yl suffix is supported");
        }
    }

    private void detectAlkaneFusedRingBridges(Element group) {
        Element possibleBridgeFormer;
        Element unsaturator;
        if ("alkaneStem".equals(group.getAttributeValue("subType")) && (unsaturator = OpsinTools.getNextSibling(group)) != null && unsaturator.getName().equals("unsaturator") && (possibleBridgeFormer = OpsinTools.getNextSiblingIgnoringCertainElements(group, new String[]{"unsaturator"})) != null && possibleBridgeFormer.getName().equals("bridgeFormingO")) {
            group.setName("fusedRingBridge");
            Attribute smilesValAtr = group.getAttribute("value");
            smilesValAtr.setValue("-" + smilesValAtr.getValue() + "-");
            possibleBridgeFormer.detach();
            unsaturator.detach();
        }
    }

    private void processRings(Element group) throws ComponentGenerationException {
        Element previous = OpsinTools.getPreviousSiblingIgnoringCertainElements(group, new String[]{"locant"});
        if (previous != null) {
            String previousElType = previous.getName();
            if (previousElType.equals("spiro")) {
                this.processSpiroSystem(group, previous);
            } else if (previousElType.equals("vonBaeyer")) {
                this.processVonBaeyerSystem(group, previous);
            } else if (previousElType.equals("cyclo")) {
                this.processCyclisedChain(group, previous);
            }
        }
    }

    private void processSpiroSystem(Element chainGroup, Element spiroEl) throws NumberFormatException, ComponentGenerationException {
        int[][] spiroDescriptors = this.getSpiroDescriptors(StringTools.removeDashIfPresent(spiroEl.getValue()));
        Element multiplier = OpsinTools.getPreviousSibling(spiroEl);
        int numberOfSpiros = 1;
        if (multiplier != null && multiplier.getName().equals("multiplier") && "basic".equals(multiplier.getAttributeValue("type"))) {
            numberOfSpiros = Integer.parseInt(multiplier.getAttributeValue("value"));
            multiplier.detach();
        }
        int numberOfCarbonInDescriptors = 0;
        boolean hasSuperscripts = false;
        for (int[] spiroDescriptor : spiroDescriptors) {
            numberOfCarbonInDescriptors += spiroDescriptor[0];
            if (spiroDescriptor[1] == -1) continue;
            hasSuperscripts = true;
        }
        int expectedNumberOfCarbons = chainGroup.getAttributeValue("value").length();
        if ((numberOfCarbonInDescriptors += numberOfSpiros) != expectedNumberOfCarbons) {
            if (numberOfCarbonInDescriptors > expectedNumberOfCarbons && spiroDescriptors.length > 2 && !hasSuperscripts) {
                int carbonsWithSuperscriptsInferred = 0;
                for (int i = 0; i < spiroDescriptors.length; ++i) {
                    int[] spiroDescriptor;
                    spiroDescriptor = spiroDescriptors[i];
                    int carbons = spiroDescriptor[0];
                    if (i > 1 && carbons >= 11) {
                        String str = String.valueOf(carbons);
                        carbons = Integer.parseInt(str.substring(0, 1));
                        int locant = Integer.parseInt(str.substring(1));
                        if (locant > 0) {
                            spiroDescriptor[0] = carbons;
                            spiroDescriptor[1] = locant;
                        }
                    }
                    carbonsWithSuperscriptsInferred += carbons;
                }
                if ((carbonsWithSuperscriptsInferred += numberOfSpiros) == expectedNumberOfCarbons) {
                    numberOfCarbonInDescriptors = carbonsWithSuperscriptsInferred;
                }
            }
            if (numberOfCarbonInDescriptors != expectedNumberOfCarbons) {
                throw new ComponentGenerationException("Disagreement between number of atoms in spiro descriptor: " + numberOfCarbonInDescriptors + " and number of atoms in chain: " + expectedNumberOfCarbons);
            }
        }
        int numOfOpenedBrackets = 1;
        int curIndex = 2;
        String smiles = "C0" + StringTools.multiplyString("C", spiroDescriptors[0][0]) + "10(";
        for (int i = 1; i < spiroDescriptors.length; ++i) {
            if (spiroDescriptors[i][1] >= 0) {
                int ringOpeningPos = this.findIndexOfRingOpenings(smiles, spiroDescriptors[i][1]);
                String ringOpeningLabel = String.valueOf(smiles.charAt(ringOpeningPos));
                ++ringOpeningPos;
                if (ringOpeningLabel.equals("%")) {
                    while (smiles.charAt(ringOpeningPos) >= '0' && smiles.charAt(ringOpeningPos) <= '9' && ringOpeningPos < smiles.length()) {
                        ringOpeningLabel = ringOpeningLabel + smiles.charAt(ringOpeningPos);
                        ++ringOpeningPos;
                    }
                }
                if (smiles.indexOf("C" + ringOpeningLabel, ringOpeningPos) >= 0) {
                    smiles = smiles.substring(0, ringOpeningPos) + this.ringClosure(curIndex) + smiles.substring(ringOpeningPos);
                    smiles = smiles + "(" + StringTools.multiplyString("C", spiroDescriptors[i][0]) + this.ringClosure(curIndex) + ")";
                    ++curIndex;
                    continue;
                }
                smiles = smiles + StringTools.multiplyString("C", spiroDescriptors[i][0]) + ringOpeningLabel + ")";
                continue;
            }
            if (numOfOpenedBrackets >= numberOfSpiros) {
                smiles = smiles + StringTools.multiplyString("C", spiroDescriptors[i][0]);
                smiles = smiles + this.ringClosure(--curIndex) + ")";
                continue;
            }
            smiles = smiles + StringTools.multiplyString("C", spiroDescriptors[i][0]);
            smiles = smiles + "C" + this.ringClosure(curIndex++) + "(";
            ++numOfOpenedBrackets;
        }
        chainGroup.getAttribute("value").setValue(smiles);
        chainGroup.getAttribute("type").setValue("ring");
        if (chainGroup.getAttribute("usableAsAJoiner") != null) {
            chainGroup.removeAttribute(chainGroup.getAttribute("usableAsAJoiner"));
        }
        spiroEl.detach();
    }

    private String ringClosure(int ringClosure) {
        if (ringClosure > 9) {
            return "%" + Integer.toString(ringClosure);
        }
        return Integer.toString(ringClosure);
    }

    private int[][] getSpiroDescriptors(String text) {
        text = text.indexOf("-") == 5 ? text.substring(7, text.length() - 1) : text.substring(6, text.length() - 1);
        String[] spiroDescriptorStrings = matchCommaOrDot.split(text);
        int[][] spiroDescriptors = new int[spiroDescriptorStrings.length][2];
        for (int i = 0; i < spiroDescriptorStrings.length; ++i) {
            String[] elements = matchNonDigit.split(spiroDescriptorStrings[i]);
            if (elements.length > 1) {
                spiroDescriptors[i][0] = Integer.parseInt(elements[0]);
                StringBuilder superScriptedNumber = new StringBuilder();
                for (int j = 1; j < elements.length; ++j) {
                    superScriptedNumber.append(elements[j]);
                }
                spiroDescriptors[i][1] = Integer.parseInt(superScriptedNumber.toString());
                continue;
            }
            spiroDescriptors[i][0] = Integer.parseInt(spiroDescriptorStrings[i]);
            spiroDescriptors[i][1] = -1;
        }
        return spiroDescriptors;
    }

    private Integer findIndexOfRingOpenings(String smiles, int locant) throws ComponentGenerationException {
        int count = 0;
        int pos = -1;
        int len = smiles.length();
        for (int i = 0; i < len; ++i) {
            if (smiles.charAt(i) != 'C' || ++count != locant) continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            throw new ComponentGenerationException("Unable to find atom corresponding to number indicated by superscript in spiro descriptor");
        }
        return pos + 1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processVonBaeyerSystem(Element chainEl, Element vonBaeyerBracketEl) throws ComponentGenerationException {
        ArrayList<HashMap> arrayList;
        String vonBaeyerBracket = StringTools.removeDashIfPresent(vonBaeyerBracketEl.getValue());
        Element multiplier = OpsinTools.getPreviousSibling(vonBaeyerBracketEl);
        int numberOfRings = Integer.parseInt(multiplier.getAttributeValue("value"));
        multiplier.detach();
        ArrayDeque<String> elementSymbolArray = new ArrayDeque<String>();
        String smiles = chainEl.getAttributeValue("value");
        char[] smilesArray = smiles.toCharArray();
        for (int i = 0; i < smilesArray.length; ++i) {
            char currentChar = smilesArray[i];
            if (currentChar == '[') {
                if (smilesArray[i + 2] == ']') {
                    elementSymbolArray.add("[" + String.valueOf(smilesArray[i + 1]) + "]");
                    i += 2;
                    continue;
                }
                elementSymbolArray.add("[" + String.valueOf(smilesArray[i + 1]) + String.valueOf(smilesArray[i + 2]) + "]");
                i += 3;
                continue;
            }
            elementSymbolArray.add(String.valueOf(currentChar));
        }
        int alkylChainLength = elementSymbolArray.size();
        int totalLengthOfBridges = 0;
        int bridgeLabelsUsed = 3;
        ArrayList bridges = new ArrayList();
        HashMap bridgeLocations = new HashMap(alkylChainLength);
        vonBaeyerBracket = vonBaeyerBracket.indexOf("-") == 5 ? vonBaeyerBracket.substring(7, vonBaeyerBracket.length() - 1) : vonBaeyerBracket.substring(6, vonBaeyerBracket.length() - 1);
        String[] bridgeDescriptors = matchCommaOrDot.split(vonBaeyerBracket);
        for (int i = 0; i < bridgeDescriptors.length; ++i) {
            String bridgeDescriptor = bridgeDescriptors[i];
            HashMap<String, Integer> bridge = new HashMap<String, Integer>();
            int bridgeLength = 0;
            if (i > 2) {
                void var19_23;
                String string = matchNonDigit.matcher(bridgeDescriptors[++i]).replaceAll("");
                String[] tempArray = matchNonDigit.split(bridgeDescriptor);
                if (tempArray.length == 1) {
                    char[] tempCharArray = bridgeDescriptor.toCharArray();
                    if (tempCharArray.length == 2) {
                        bridgeLength = Character.getNumericValue(tempCharArray[0]);
                        String string2 = Character.toString(tempCharArray[1]);
                    } else if (tempCharArray.length == 3) {
                        bridgeLength = Character.getNumericValue(tempCharArray[0]);
                        String string3 = Character.toString(tempCharArray[1]) + Character.toString(tempCharArray[2]);
                    } else {
                        if (tempCharArray.length != 4) throw new ComponentGenerationException("Unsupported Von Baeyer locant description: " + bridgeDescriptor);
                        bridgeLength = Integer.parseInt(Character.toString(tempCharArray[0]) + Character.toString(tempCharArray[1]));
                        String string4 = Character.toString(tempCharArray[2]) + Character.toString(tempCharArray[3]);
                    }
                } else {
                    bridgeLength = Integer.parseInt(tempArray[0]);
                    String string5 = tempArray[1];
                }
                bridge.put("Bridge Length", bridgeLength);
                int coordinates1 = Integer.parseInt((String)var19_23);
                int coordinates2 = Integer.parseInt(string);
                if (coordinates1 > alkylChainLength || coordinates2 > alkylChainLength) {
                    throw new ComponentGenerationException("Indicated bridge position is not on chain: " + coordinates1 + "," + coordinates2);
                }
                if (coordinates2 > coordinates1) {
                    int swap = coordinates1;
                    coordinates1 = coordinates2;
                    coordinates2 = swap;
                }
                if (bridgeLocations.get(coordinates1) == null) {
                    bridgeLocations.put(coordinates1, new ArrayList());
                }
                if (bridgeLocations.get(coordinates2) == null) {
                    bridgeLocations.put(coordinates2, new ArrayList());
                }
                ((ArrayList)bridgeLocations.get(coordinates1)).add(bridgeLabelsUsed);
                bridge.put("AtomId_Larger_Label", bridgeLabelsUsed);
                ++bridgeLabelsUsed;
                if (bridgeLength == 0) {
                    ((ArrayList)bridgeLocations.get(coordinates2)).add(bridgeLabelsUsed - 1);
                    bridge.put("AtomId_Smaller_Label", bridgeLabelsUsed - 1);
                } else {
                    ((ArrayList)bridgeLocations.get(coordinates2)).add(bridgeLabelsUsed);
                    bridge.put("AtomId_Smaller_Label", bridgeLabelsUsed);
                }
                ++bridgeLabelsUsed;
                bridge.put("AtomId_Larger", coordinates1);
                bridge.put("AtomId_Smaller", coordinates2);
            } else {
                bridgeLength = Integer.parseInt(bridgeDescriptor);
                bridge.put("Bridge Length", bridgeLength);
            }
            totalLengthOfBridges += bridgeLength;
            bridges.add(bridge);
        }
        if (totalLengthOfBridges + 2 != alkylChainLength) {
            throw new ComponentGenerationException("Disagreement between lengths of bridges and alkyl chain length");
        }
        if (numberOfRings + 1 != bridges.size()) {
            throw new ComponentGenerationException("Disagreement between number of rings and number of bridges");
        }
        StringBuilder smilesSB = new StringBuilder();
        int atomCounter = 1;
        int bridgeCounter = 1;
        for (HashMap hashMap : bridges) {
            if (bridgeCounter == 1) {
                smilesSB.append((String)elementSymbolArray.removeFirst());
                smilesSB.append("1");
                if (bridgeLocations.get(atomCounter) != null) {
                    for (Integer bridgeAtomLabel : (ArrayList)bridgeLocations.get(atomCounter)) {
                        smilesSB.append(this.ringClosure(bridgeAtomLabel));
                    }
                }
                smilesSB.append("(");
            }
            int n = (Integer)hashMap.get("Bridge Length");
            for (int i = 0; i < n; ++i) {
                smilesSB.append((String)elementSymbolArray.removeFirst());
                if (bridgeLocations.get(++atomCounter) == null) continue;
                for (Integer bridgeAtomLabel : (ArrayList)bridgeLocations.get(atomCounter)) {
                    smilesSB.append(this.ringClosure(bridgeAtomLabel));
                }
            }
            if (bridgeCounter == 1) {
                smilesSB.append((String)elementSymbolArray.removeFirst());
                smilesSB.append("2");
                if (bridgeLocations.get(++atomCounter) != null) {
                    for (Integer bridgeAtomLabel : (ArrayList)bridgeLocations.get(atomCounter)) {
                        smilesSB.append(this.ringClosure(bridgeAtomLabel));
                    }
                }
            }
            if (bridgeCounter == 2) {
                smilesSB.append("1)");
            }
            if (bridgeCounter == 3) {
                smilesSB.append("2");
            }
            if (++bridgeCounter <= 3) continue;
            break;
        }
        ArrayList<HashMap> secondaryBridges = new ArrayList<HashMap>();
        for (HashMap hashMap : bridges) {
            if (hashMap.get("AtomId_Larger") == null || (Integer)hashMap.get("Bridge Length") == 0) continue;
            secondaryBridges.add(hashMap);
        }
        VonBaeyerSecondaryBridgeSort vonBaeyerSecondaryBridgeSort = new VonBaeyerSecondaryBridgeSort();
        Collections.sort(secondaryBridges, vonBaeyerSecondaryBridgeSort);
        do {
            arrayList = new ArrayList<HashMap>();
            for (HashMap bridge : secondaryBridges) {
                int bridgeLength = (Integer)bridge.get("Bridge Length");
                if ((Integer)bridge.get("AtomId_Larger") > atomCounter) {
                    arrayList.add(bridge);
                    continue;
                }
                smilesSB.append(".");
                for (int i = 0; i < bridgeLength; ++i) {
                    ++atomCounter;
                    smilesSB.append((String)elementSymbolArray.removeFirst());
                    if (i == 0) {
                        smilesSB.append(this.ringClosure((Integer)bridge.get("AtomId_Larger_Label")));
                    }
                    if (bridgeLocations.get(atomCounter) == null) continue;
                    for (Integer bridgeAtomLabel : (ArrayList)bridgeLocations.get(atomCounter)) {
                        smilesSB.append(this.ringClosure(bridgeAtomLabel));
                    }
                }
                smilesSB.append(this.ringClosure((Integer)bridge.get("AtomId_Smaller_Label")));
            }
            if (arrayList.size() > 0 && arrayList.size() == secondaryBridges.size()) {
                throw new ComponentGenerationException("Unable to resolve all dependant bridges!!!");
            }
            secondaryBridges = arrayList;
        } while (arrayList.size() > 0);
        chainEl.getAttribute("value").setValue(smilesSB.toString());
        chainEl.getAttribute("type").setValue("ring");
        if (chainEl.getAttribute("usableAsAJoiner") != null) {
            chainEl.removeAttribute(chainEl.getAttribute("usableAsAJoiner"));
        }
        vonBaeyerBracketEl.detach();
    }

    private void processCyclisedChain(Element chainGroup, Element cycloEl) throws ComponentGenerationException {
        String smiles = chainGroup.getAttributeValue("value");
        int chainlen = 0;
        for (int i = smiles.length() - 1; i >= 0; --i) {
            if (!Character.isUpperCase(smiles.charAt(i)) || smiles.charAt(i) == 'H') continue;
            ++chainlen;
        }
        if (chainlen < 3) {
            throw new ComponentGenerationException("Heteroatom chain too small to create a ring: " + chainlen);
        }
        if ((smiles = smiles + "1").charAt(0) == '[') {
            int closeBracketIndex = smiles.indexOf(93);
            smiles = smiles.substring(0, closeBracketIndex + 1) + "1" + smiles.substring(closeBracketIndex + 1);
        } else {
            smiles = Character.getType(smiles.charAt(1)) == 2 ? smiles.substring(0, 2) + "1" + smiles.substring(2) : smiles.substring(0, 1) + "1" + smiles.substring(1);
        }
        chainGroup.getAttribute("value").setValue(smiles);
        if (chainlen == 6) {
            if (chainGroup.getAttribute("labels") != null) {
                chainGroup.getAttribute("labels").setValue("1/2,ortho/3,meta/4,para/5/6");
            } else {
                chainGroup.addAttribute(new Attribute("labels", "1/2,ortho/3,meta/4,para/5/6"));
            }
        }
        chainGroup.getAttribute("type").setValue("ring");
        if (chainGroup.getAttribute("usableAsAJoiner") != null) {
            chainGroup.removeAttribute(chainGroup.getAttribute("usableAsAJoiner"));
        }
        cycloEl.detach();
    }

    private void handleGroupIrregularities(Element group) throws ComponentGenerationException {
        Element suffix;
        Element possibleAcid;
        List<Element> groups;
        Element multiplier;
        Element enclosingSubOrRoot;
        Element previous;
        Element possibleLocant;
        Element next;
        Element next2;
        String groupValue = group.getValue();
        if (!this.buildState.n2sConfig.allowInterpretationOfAcidsWithoutTheWordAcid() && group.getAttribute("functionalIDs") != null && (groupValue.endsWith("ic") || groupValue.endsWith("ous")) && (next2 = OpsinTools.getNext(group)) == null) {
            throw new ComponentGenerationException("\"acid\" not found after " + groupValue);
        }
        String groupType = group.getAttributeValue("type");
        String groupSubType = group.getAttributeValue("subType");
        if ("ousIcAtom".equals(groupSubType) && (next = OpsinTools.getNext(group, false)) == null) {
            throw new ComponentGenerationException("counter anion not found after " + groupValue);
        }
        if (groupValue.equals("thiophen") || groupValue.equals("selenophen") || groupValue.equals("tellurophen")) {
            Element isThisALocant;
            Element possibleSuffix = OpsinTools.getNextSibling(group);
            if (!"e".equals(group.getAttributeValue("subsequentUnsemanticToken")) && possibleSuffix != null && possibleSuffix.getName().equals("suffix") && possibleSuffix.getValue().startsWith("ol") && ((isThisALocant = OpsinTools.getPreviousSibling(group)) == null || !isThisALocant.getName().equals("locant") || isThisALocant.getValue().split(",").length != 1)) {
                throw new ComponentGenerationException(groupValue + "ol has been incorrectly interpreted as " + groupValue + ", ol instead of phenol with the oxgen replaced");
            }
        } else if (groupValue.equals("chromen")) {
            Element possibleSuffix;
            possibleLocant = OpsinTools.getPreviousSibling(group);
            if (possibleLocant != null && possibleLocant.getName().equals("locant") && (possibleLocant.getValue().equals("2") || possibleLocant.getValue().equals("3")) && ((possibleSuffix = OpsinTools.getNextSibling(group)) == null || possibleSuffix.getName().equals("locant"))) {
                group.getAttribute("value").setValue("O1CCCc2ccccc12");
                group.addAttribute("addBond", "2 locant required");
                group.addAttribute("frontLocantsExpected", "2,3");
            }
        } else if (groupValue.equals("methylene") || groupValue.equals("methylen")) {
            List<Element> children;
            Element nextSub = OpsinTools.getNextSibling(group.getParent());
            if (nextSub != null && nextSub.getName().equals("substituent") && OpsinTools.getNextSibling(group) == null && (OpsinTools.getPreviousSibling(group) == null || !OpsinTools.getPreviousSibling(group).getName().equals("multiplier")) && (children = nextSub.getChildElements()).size() >= 2 && children.get(0).getValue().equals("di") && children.get(1).getValue().equals("oxy")) {
                group.setValue(groupValue + "dioxy");
                group.getAttribute("value").setValue("C(O)O");
                group.getAttribute("outIDs").setValue("2,3");
                group.getAttribute("subType").setValue("epoxyLike");
                if (group.getAttribute("labels") != null) {
                    group.getAttribute("labels").setValue("none");
                } else {
                    group.addAttribute(new Attribute("labels", "none"));
                }
                nextSub.detach();
                for (int i = children.size() - 1; i >= 2; --i) {
                    children.get(i).detach();
                    OpsinTools.insertAfter(group, children.get(i));
                }
            }
        } else if (groupValue.equals("ethylene") || groupValue.equals("ethylen")) {
            previous = OpsinTools.getPreviousSibling(group);
            if (previous != null && previous.getName().equals("multiplier")) {
                List<Element> children;
                int multiplierValue = Integer.parseInt(previous.getAttributeValue("value"));
                Element possibleRoot = OpsinTools.getNextSibling(group.getParent());
                if (possibleRoot == null && OpsinTools.getParentWordRule(group).getAttributeValue("wordRule").equals(WordRule.glycol.toString())) {
                    StringBuilder smiles = new StringBuilder("CC");
                    for (int i = 1; i < multiplierValue; ++i) {
                        smiles.append("OCC");
                    }
                    group.getAttribute("outIDs").setValue("1," + Integer.toString(3 * (multiplierValue - 1) + 2));
                    group.getAttribute("value").setValue(smiles.toString());
                    previous.detach();
                    if (group.getAttribute("labels") != null) {
                        group.getAttribute("labels").setValue("numeric");
                    } else {
                        group.addAttribute(new Attribute("labels", "numeric"));
                    }
                } else if (possibleRoot != null && possibleRoot.getName().equals("root") && (children = possibleRoot.getChildElements()).size() == 2) {
                    Element amineMultiplier = children.get(0);
                    Element amine = children.get(1);
                    if (amineMultiplier.getName().equals("multiplier") && (amine.getValue().equals("amine") || amine.getValue().equals("amin"))) {
                        if (Integer.parseInt(amineMultiplier.getAttributeValue("value")) != multiplierValue + 1) {
                            throw new ComponentGenerationException("Invalid polyethylene amine!");
                        }
                        StringBuilder smiles = new StringBuilder();
                        for (int i = 0; i < multiplierValue; ++i) {
                            smiles.append("NCC");
                        }
                        smiles.append("N");
                        group.removeAttribute(group.getAttribute("outIDs"));
                        group.getAttribute("value").setValue(smiles.toString());
                        previous.detach();
                        possibleRoot.detach();
                        group.getParent().setName("root");
                        if (group.getAttribute("labels") != null) {
                            group.getAttribute("labels").setValue("numeric");
                        } else {
                            group.addAttribute(new Attribute("labels", "numeric"));
                        }
                    }
                }
            } else {
                List<Element> children;
                Element nextSub = OpsinTools.getNextSibling(group.getParent());
                if (nextSub != null && nextSub.getName().equals("substituent") && OpsinTools.getNextSibling(group) == null && (children = nextSub.getChildElements()).size() >= 2 && children.get(0).getValue().equals("di") && children.get(1).getValue().equals("oxy")) {
                    group.setValue(groupValue + "dioxy");
                    group.getAttribute("value").setValue("C(O)CO");
                    group.getAttribute("outIDs").setValue("2,4");
                    group.getAttribute("subType").setValue("epoxyLike");
                    if (group.getAttribute("labels") != null) {
                        group.getAttribute("labels").setValue("none");
                    } else {
                        group.addAttribute(new Attribute("labels", "none"));
                    }
                    nextSub.detach();
                    for (int i = children.size() - 1; i >= 2; --i) {
                        children.get(i).detach();
                        OpsinTools.insertAfter(group, children.get(i));
                    }
                }
            }
        } else if (groupValue.equals("propylene") || groupValue.equals("propylen")) {
            previous = OpsinTools.getPreviousSibling(group);
            if (previous != null && previous.getName().equals("multiplier")) {
                int multiplierValue = Integer.parseInt(previous.getAttributeValue("value"));
                Element possibleRoot = OpsinTools.getNextSibling(group.getParent());
                if (possibleRoot == null && OpsinTools.getParentWordRule(group).getAttributeValue("wordRule").equals(WordRule.glycol.toString())) {
                    StringBuilder smiles = new StringBuilder("CCC");
                    for (int i = 1; i < multiplierValue; ++i) {
                        smiles.append("OC(C)C");
                    }
                    group.getAttribute("outIDs").setValue("2," + Integer.toString(4 * (multiplierValue - 1) + 3));
                    group.getAttribute("value").setValue(smiles.toString());
                    if (group.getAttribute("labels") != null) {
                        group.getAttribute("labels").setValue("none");
                    } else {
                        group.addAttribute(new Attribute("labels", "none"));
                    }
                    previous.detach();
                }
            }
        } else if (groupValue.equals("anthr") || groupValue.equals("anthran") || groupValue.equals("phenanthr") || groupValue.equals("acrid") || groupValue.equals("xanth") || groupValue.equals("thioxanth") || groupValue.equals("selenoxanth") || groupValue.equals("telluroxanth") || groupValue.equals("xanthen")) {
            possibleLocant = OpsinTools.getPreviousSibling(group);
            if (possibleLocant == null || !possibleLocant.getName().equals("locant")) {
                String suffixVal;
                Element possibleSuffix = OpsinTools.getNextSibling(group);
                if (possibleSuffix != null && "one".equals(possibleSuffix.getAttributeValue("value"))) {
                    TokenEl newLocant = new TokenEl("locant", "9");
                    OpsinTools.insertBefore(possibleSuffix, newLocant);
                    TokenEl newAddedHydrogen = new TokenEl("addedHydrogen");
                    newAddedHydrogen.addAttribute(new Attribute("locant", "10"));
                    OpsinTools.insertBefore(newLocant, newAddedHydrogen);
                } else if ((possibleSuffix != null && possibleSuffix.getName().equals("suffix") && groupValue.equals("xanth") || groupValue.equals("thioxanth") || groupValue.equals("selenoxanth") || groupValue.equals("telluroxanth")) && ((suffixVal = possibleSuffix.getAttributeValue("value")).equals("ic") || suffixVal.equals("ate"))) {
                    throw new ComponentGenerationException(groupValue + possibleSuffix.getValue() + " is not a derivative of xanthene");
                }
            }
        } else if (groupValue.equals("phospho")) {
            Element wordRule = OpsinTools.getParentWordRule(group);
            for (Element otherGroup : OpsinTools.getDescendantElementsWithTagName(wordRule, "group")) {
                String subType;
                String type = otherGroup.getAttributeValue("type");
                if (!OpsinTools.isBiochemical(type, subType = otherGroup.getAttributeValue("subType")) && (!"ylForAcyl".equals(subType) || !"glycol".equals(otherGroup.getValue()) && !"diglycol".equals(otherGroup.getValue()))) continue;
                group.getAttribute("value").setValue("-P(=O)(O)O");
                group.addAttribute(new Attribute("usableAsAJoiner", "yes"));
                break;
            }
        } else if (groupValue.equals("hydrogen")) {
            Element hydrogenParentEl = group.getParent();
            Element nextSubOrRoot = OpsinTools.getNextSibling(hydrogenParentEl);
            if (nextSubOrRoot != null) {
                Element possibleSuitableAteGroup = nextSubOrRoot.getChild(0);
                if (!possibleSuitableAteGroup.getName().equals("group") || !"nonCarboxylicAcid".equals(possibleSuitableAteGroup.getAttributeValue("type"))) {
                    throw new ComponentGenerationException("Hydrogen is not meant as a substituent in this context!");
                }
                Element possibleMultiplier = OpsinTools.getPreviousSibling(group);
                String multiplier2 = "1";
                if (possibleMultiplier != null && possibleMultiplier.getName().equals("multiplier")) {
                    multiplier2 = possibleMultiplier.getAttributeValue("value");
                    possibleMultiplier.detach();
                }
                possibleSuitableAteGroup.addAttribute(new Attribute("numberOfFunctionalAtomsToRemove", multiplier2));
                group.detach();
                List<Element> childrenToMove = hydrogenParentEl.getChildElements();
                for (int i = childrenToMove.size() - 1; i >= 0; --i) {
                    childrenToMove.get(i).detach();
                    nextSubOrRoot.insertChild(childrenToMove.get(i), 0);
                }
                hydrogenParentEl.detach();
            }
        } else if (groupValue.equals("acryl")) {
            Element nextEl;
            if ("simpleSubstituent".equals(groupSubType) && (nextEl = OpsinTools.getNext(group)) != null && nextEl.getValue().equals("amid")) {
                throw new ComponentGenerationException("amide in acrylamide is not [NH2-]");
            }
        } else if (groupValue.equals("azo") || groupValue.equals("azoxy") || groupValue.equals("nno-azoxy") || groupValue.equals("non-azoxy") || groupValue.equals("onn-azoxy") || groupValue.equals("diazoamino") || groupValue.equals("hydrazo")) {
            List<Element> suffixes;
            Element enclosingSub = group.getParent();
            Element next3 = OpsinTools.getNextSiblingIgnoringCertainElements(enclosingSub, new String[]{"hyphen"});
            if (next3 == null && OpsinTools.getPreviousSibling(enclosingSub) == null) {
                next3 = OpsinTools.getNextSiblingIgnoringCertainElements(enclosingSub.getParent(), new String[]{"hyphen"});
            }
            if (next3 != null && next3.getName().equals("root") && !next3.getChild(0).getName().equals("multiplier") && (suffixes = next3.getChildElements("suffix")).isEmpty()) {
                TokenEl newMultiplier = new TokenEl("multiplier");
                newMultiplier.addAttribute(new Attribute("value", "2"));
                next3.insertChild(newMultiplier, 0);
                Element interSubstituentHyphen = OpsinTools.getPrevious(group);
                if (interSubstituentHyphen != null && !interSubstituentHyphen.getName().equals("hyphen")) {
                    OpsinTools.insertAfter(interSubstituentHyphen, new TokenEl("hyphen"));
                }
            }
        } else if (groupValue.equals("coenzyme a") || groupValue.equals("coa")) {
            Element enclosingBracketOrWord;
            int indexOfCoa;
            Element possibleAcid2;
            List<Element> groups2;
            enclosingSubOrRoot = group.getParent();
            Element previous2 = OpsinTools.getPreviousSibling(enclosingSubOrRoot);
            if (previous2 != null && (groups2 = OpsinTools.getDescendantElementsWithTagName(previous2, "group")).size() > 0 && "acidStem".equals((possibleAcid2 = groups2.get(groups2.size() - 1)).getAttributeValue("type"))) {
                String subType;
                Element suffix2;
                if (possibleAcid2.getAttribute("suffixAppliesTo") != null && possibleAcid2.getAttributeValue("suffixAppliesTo").split(",").length > 1 && (suffix2 = OpsinTools.getNextSibling(possibleAcid2, "suffix")).getAttribute("additionalValue") == null) {
                    suffix2.addAttribute(new Attribute("additionalValue", "ic"));
                }
                if ((subType = possibleAcid2.getAttributeValue("subType")).equals("ylForYl") || subType.equals("ylForNothing")) {
                    possibleAcid2.getAttribute("subType").setValue("ylForAcyl");
                }
            }
            if ((indexOfCoa = (enclosingBracketOrWord = enclosingSubOrRoot.getParent()).indexOf(enclosingSubOrRoot)) > 0) {
                GroupingEl newBracket = new GroupingEl("bracket");
                List<Element> precedingElements = enclosingBracketOrWord.getChildElements();
                for (int i = 0; i < indexOfCoa; ++i) {
                    Element precedingElement = precedingElements.get(i);
                    precedingElement.detach();
                    ((Element)newBracket).addChild(precedingElement);
                }
                OpsinTools.insertBefore(enclosingSubOrRoot, newBracket);
            }
        } else if (groupValue.equals("sphinganine") || groupValue.equals("icosasphinganine") || groupValue.equals("eicosasphinganine") || groupValue.equals("phytosphingosine") || groupValue.equals("sphingosine") || groupValue.equals("sphinganin") || groupValue.equals("icosasphinganin") || groupValue.equals("eicosasphinganin") || groupValue.equals("phytosphingosin") || groupValue.equals("sphingosin")) {
            List<Element> inlineSuffixes;
            Element possibleAcid3;
            List<Element> groups3;
            enclosingSubOrRoot = group.getParent();
            Element previous3 = OpsinTools.getPreviousSibling(enclosingSubOrRoot);
            if (previous3 != null && (groups3 = OpsinTools.getDescendantElementsWithTagName(previous3, "group")).size() > 0 && "alkaneStem".equals((possibleAcid3 = groups3.get(groups3.size() - 1)).getAttributeValue("subType")) && (inlineSuffixes = OpsinTools.getChildElementsWithTagNameAndAttribute(possibleAcid3.getParent(), "suffix", "type", "inline")).size() == 1 && inlineSuffixes.get(0).getAttributeValue("value").equals("yl")) {
                inlineSuffixes.get(0).getAttribute("value").setValue("oyl");
            }
        } else if (groupValue.equals("sel")) {
            Element ium;
            Element unsaturator;
            if ("heteroStem".equals(groupSubType) && group.getAttribute("subsequentUnsemanticToken") == null && (unsaturator = OpsinTools.getNextSibling(group)) != null && unsaturator.getName().equals("unsaturator") && unsaturator.getValue().equals("en") && group.getAttribute("subsequentUnsemanticToken") == null && (ium = OpsinTools.getNextSibling(unsaturator)) != null && ium.getName().equals("suffix") && ium.getValue().equals("ium")) {
                throw new ComponentGenerationException("<multiplier>selenium does not indicate a chain of selenium atoms with a double bond and a positive charge");
            }
        } else if ((groupValue.equals("keto") || groupValue.equals("aldehydo")) && "simpleSubstituent".equals(groupSubType)) {
            Element previousEl = OpsinTools.getPreviousSibling(group);
            if (previousEl == null || !previousEl.getName().equals("locant") || groupValue.equals("aldehydo")) {
                Element nextSubOrRoot;
                Element parentSubstituent = group.getParent();
                Element parentOfCarbohydate = nextSubOrRoot = OpsinTools.getNextSibling(parentSubstituent);
                Element carbohydrate = null;
                while (parentOfCarbohydate != null) {
                    Element possibleCarbohydrate = parentOfCarbohydate.getFirstChildElement("group");
                    if (possibleCarbohydrate != null && possibleCarbohydrate.getAttributeValue("type").equals("carbohydrate")) {
                        carbohydrate = possibleCarbohydrate;
                        break;
                    }
                    parentOfCarbohydate = OpsinTools.getNextSibling(parentOfCarbohydate);
                }
                if (carbohydrate != null) {
                    String value;
                    if (parentOfCarbohydate.getChildElements("carbohydrateRingSize").size() > 0) {
                        throw new ComponentGenerationException("Carbohydrate has a specified ring size but " + groupValue + " indicates the open chain form!");
                    }
                    for (Element suffix3 : parentOfCarbohydate.getChildElements("suffix")) {
                        if (!"yl".equals(suffix3.getAttributeValue("value"))) continue;
                        throw new ComponentGenerationException("Carbohydrate appears to be a glycosyl, but " + groupValue + " indicates the open chain form!");
                    }
                    Element alphaOrBetaLocantEl = OpsinTools.getPreviousSiblingIgnoringCertainElements(carbohydrate, new String[]{"stereoChemistry"});
                    if (alphaOrBetaLocantEl != null && alphaOrBetaLocantEl.getName().equals("locant") && ((value = alphaOrBetaLocantEl.getValue()).equals("alpha") || value.equals("beta") || value.equals("alpha,beta") || value.equals("beta,alpha"))) {
                        throw new ComponentGenerationException("Carbohydrate has alpha/beta anomeric form but " + groupValue + " indicates the open chain form!");
                    }
                    group.detach();
                    List<Element> childrenToMove = parentSubstituent.getChildElements();
                    for (int i = childrenToMove.size() - 1; i >= 0; --i) {
                        Element el = childrenToMove.get(i);
                        if (el.getName().equals("hyphen")) continue;
                        el.detach();
                        nextSubOrRoot.insertChild(el, 0);
                    }
                    parentSubstituent.detach();
                    if ("ring".equals(carbohydrate.getAttributeValue("subType"))) {
                        String carbohydrateAdditionValue = carbohydrate.getAttributeValue("additionalValue");
                        if (carbohydrateAdditionValue == null) {
                            throw new ComponentGenerationException(carbohydrate.getValue() + " can only describe the cyclic form but " + groupValue + " indicates the open chain form!");
                        }
                        carbohydrate.getAttribute("value").setValue(carbohydrateAdditionValue);
                    }
                } else if (groupValue.equals("aldehydo")) {
                    throw new ComponentGenerationException("aldehydo is only a valid prefix when it precedes a carbohydrate!");
                }
            }
        } else if (groupValue.equals("bor") || groupValue.equals("antimon") || groupValue.equals("arsen") || groupValue.equals("phosphor") || groupValue.equals("phosphate") || groupValue.equals("phosphat") || groupValue.equals("silicicacid") || groupValue.equals("silicic acid") || groupValue.equals("silicate") || groupValue.equals("silicat")) {
            Element substituent;
            Element suffix4 = null;
            Boolean isAcid = null;
            if (groupValue.endsWith("acid")) {
                if (OpsinTools.getNext(group) == null) {
                    isAcid = true;
                }
            } else if (groupValue.endsWith("ate") || groupValue.endsWith("at")) {
                if (OpsinTools.getNext(group) == null) {
                    isAcid = false;
                }
            } else {
                suffix4 = OpsinTools.getNextSibling(group);
                if (suffix4 != null && suffix4.getName().equals("suffix") && suffix4.getAttribute("infix") == null && OpsinTools.getNext(suffix4) == null) {
                    String suffixValue = suffix4.getAttributeValue("value");
                    if (suffixValue.equals("ic")) {
                        isAcid = true;
                    } else if (suffixValue.equals("ate")) {
                        isAcid = false;
                    }
                }
            }
            if (isAcid != null && (substituent = OpsinTools.getPreviousSibling(group.getParent())) != null && (substituent.getName().equals("substituent") || substituent.getName().equals("bracket"))) {
                List<Element> children = substituent.getChildElements();
                Element firstChild = children.get(0);
                boolean matched = false;
                if (children.size() == 1 && firstChild.getName().equals("group") && (firstChild.getValue().equals("fluoro") || firstChild.getValue().equals("fluor"))) {
                    if (groupValue.equals("bor")) {
                        group.getAttribute("value").setValue(isAcid != false ? "F[B-](F)(F)F.[H+]" : "F[B-](F)(F)F");
                        matched = true;
                    } else if (groupValue.equals("antimon")) {
                        group.getAttribute("value").setValue(isAcid != false ? "F[Sb-](F)(F)(F)(F)F.[H+]" : "F[Sb-](F)(F)(F)(F)F");
                        matched = true;
                    } else if (groupValue.startsWith("silicic") || groupValue.startsWith("silicat")) {
                        group.getAttribute("value").setValue(isAcid != false ? "F[Si|6-2](F)(F)(F)(F)F.[H+].[H+]" : "F[Si|6-2](F)(F)(F)(F)F");
                        matched = true;
                    }
                    if (matched) {
                        substituent.detach();
                    }
                } else if (firstChild.getName().equals("multiplier")) {
                    String multiplierVal = firstChild.getAttributeValue("value");
                    if (groupValue.equals("bor")) {
                        if (multiplierVal.equals("4") || multiplierVal.equals("3") && OpsinTools.getPreviousSibling(substituent) != null) {
                            group.getAttribute("value").setValue(isAcid != false ? "[B-].[H+]" : "[B-]");
                            matched = true;
                        }
                    } else if (groupValue.equals("antimon") && multiplierVal.equals("6")) {
                        group.getAttribute("value").setValue(isAcid != false ? "[Sb-].[H+]" : "[Sb-]");
                        matched = true;
                    } else if (groupValue.equals("arsen") && multiplierVal.equals("6")) {
                        group.getAttribute("value").setValue(isAcid != false ? "[As-].[H+]" : "[As-]");
                        matched = true;
                    } else if (groupValue.startsWith("phosph") && multiplierVal.equals("6")) {
                        group.getAttribute("value").setValue(isAcid != false ? "[P-].[H+]" : "[P-]");
                        matched = true;
                    } else if (groupValue.startsWith("silic") && multiplierVal.equals("6")) {
                        group.getAttribute("value").setValue(isAcid != false ? "[Si|6-2].[H+].[H+]" : "[Si|6-2]");
                        matched = true;
                    }
                }
                if (matched) {
                    Attribute functionalIds;
                    Attribute acceptsAdditiveBonds;
                    group.getAttribute("type").setValue("simpleGroup");
                    group.getAttribute("subType").setValue("simpleGroup");
                    Attribute usableAsJoiner = group.getAttribute("usableAsAJoiner");
                    if (usableAsJoiner != null) {
                        group.removeAttribute(usableAsJoiner);
                    }
                    if ((acceptsAdditiveBonds = group.getAttribute("acceptsAdditiveBonds")) != null) {
                        group.removeAttribute(acceptsAdditiveBonds);
                    }
                    if ((functionalIds = group.getAttribute("functionalIDs")) != null) {
                        group.removeAttribute(functionalIds);
                    }
                    if (suffix4 != null) {
                        suffix4.detach();
                    }
                }
            }
        } else if (groupValue.equals("pyruv")) {
            Element subGroup;
            Element precedingSubstituent = OpsinTools.getPreviousSibling(group.getParent());
            if (precedingSubstituent != null && OpsinTools.getPreviousSibling(precedingSubstituent) != null && (subGroup = precedingSubstituent.getFirstChildElement("group")) != null && FunctionalReplacement.matchChalcogenReplacement.matcher(subGroup.getValue()).matches() && OpsinTools.getNextSibling(subGroup) == null) {
                OpsinTools.insertAfter(subGroup, new TokenEl("hyphen"));
            }
        } else if ("endInIc".equals(groupSubType) && "aminoAcid".equals(groupType)) {
            Element yl;
            String[] suffixAppliesTo = group.getAttributeValue("suffixAppliesTo").split(",");
            if (suffixAppliesTo.length == 2 && (yl = OpsinTools.getNextSibling(group)).getAttributeValue("value").equals("yl") && yl.getAttribute("additionalValue") == null) {
                yl.addAttribute(new Attribute("additionalValue", "ic"));
            }
        } else if ("saltComponent".equals(groupSubType)) {
            char firstChar;
            Element parse = null;
            for (Element tempParent = group.getParent(); tempParent != null; tempParent = tempParent.getParent()) {
                parse = tempParent;
            }
            if (parse.getChildCount() <= 1) {
                throw new ComponentGenerationException("Group expected to be part of a salt but only one component found. Could be a class of compound: " + groupValue);
            }
            if (groupValue.length() > 0 && (firstChar = groupValue.charAt(0)) >= '1' && firstChar <= '9') {
                Element shouldntBeAmultiplier = OpsinTools.getPreviousSibling(group);
                if (shouldntBeAmultiplier != null && shouldntBeAmultiplier.getName().equals("multiplier")) {
                    throw new ComponentGenerationException("Unepxected multiplier found before: " + groupValue);
                }
                TokenEl multiplier3 = new TokenEl("multiplier", String.valueOf(firstChar));
                multiplier3.addAttribute("type", "basic");
                multiplier3.addAttribute("value", String.valueOf(firstChar));
                OpsinTools.insertBefore(group, multiplier3);
                group.setValue(groupValue.substring(1));
            }
        } else if ("elementaryAtom".equals(groupType) && (multiplier = OpsinTools.getPreviousSibling(group)) != null && "2".equals(multiplier.getAttributeValue("value"))) {
            Element temp;
            Element parent = temp = group.getParent();
            while (temp != null) {
                parent = temp;
                temp = parent.getParent();
            }
            if (OpsinTools.countNumberOfElementsAndNumberOfChildLessElements(parent)[1] == 2) {
                String newVal;
                switch (group.getAttributeValue("value")) {
                    case "[H]": {
                        newVal = "[H][H]";
                        break;
                    }
                    case "[N]": {
                        newVal = "N#N";
                        break;
                    }
                    case "[O]": {
                        newVal = "O=O";
                        break;
                    }
                    case "[F]": {
                        newVal = "FF";
                        break;
                    }
                    case "[Cl]": {
                        newVal = "ClCl";
                        break;
                    }
                    case "[Br]": {
                        newVal = "BrBr";
                        break;
                    }
                    case "[I]": {
                        newVal = "II";
                        break;
                    }
                    default: {
                        newVal = null;
                    }
                }
                if (newVal != null) {
                    TokenEl newGroup = new TokenEl("group", groupValue);
                    newGroup.addAttribute("type", "simpleGroup");
                    newGroup.addAttribute("subType", "simpleGroup");
                    newGroup.addAttribute("value", newVal);
                    OpsinTools.insertAfter(group, newGroup);
                    group.detach();
                    multiplier.detach();
                }
            }
        }
        if ("aminoAcid".equals(groupType) && (previous = OpsinTools.getPreviousSibling(group.getParent())) != null && (groups = OpsinTools.getDescendantElementsWithTagName(previous, "group")).size() > 0 && "acidStem".equals((possibleAcid = groups.get(groups.size() - 1)).getAttributeValue("type")) && possibleAcid.getAttribute("suffixAppliesTo") != null && possibleAcid.getAttributeValue("suffixAppliesTo").split(",").length > 1 && (suffix = OpsinTools.getNextSibling(possibleAcid, "suffix")).getAttribute("additionalValue") == null) {
            suffix.addAttribute(new Attribute("additionalValue", "ic"));
        }
    }

    private void moveDetachableHetAtomRepl(Element bracket) throws ComponentGenerationException {
        int indexOfLastHeteroatom = -1;
        for (int i = bracket.getChildCount() - 1; i >= 0; --i) {
            Element child = bracket.getChild(i);
            if (!child.getName().equals("heteroatom")) continue;
            indexOfLastHeteroatom = i;
            break;
        }
        if (indexOfLastHeteroatom >= 0) {
            Element rightMostGroup = null;
            Element nextSubOrRootOrBracket = OpsinTools.getNextSibling(bracket);
            while (nextSubOrRootOrBracket != null) {
                Element groupToConsider = nextSubOrRootOrBracket.getFirstChildElement("group");
                if (groupToConsider != null) {
                    rightMostGroup = groupToConsider;
                }
                nextSubOrRootOrBracket = OpsinTools.getNextSibling(nextSubOrRootOrBracket);
            }
            if (rightMostGroup == null) {
                throw new ComponentGenerationException("Unable to find group for: " + bracket.getChild(0).getValue() + " to apply to!");
            }
            Element rightMostGroupParent = rightMostGroup.getParent();
            for (int i = indexOfLastHeteroatom; i >= 0; --i) {
                Element locantededHeteroAtomRepl = bracket.getChild(i);
                locantededHeteroAtomRepl.detach();
                rightMostGroupParent.insertChild(locantededHeteroAtomRepl, 0);
            }
        }
    }

    private static class VonBaeyerSecondaryBridgeSort
    implements Comparator<HashMap<String, Integer>> {
        private VonBaeyerSecondaryBridgeSort() {
        }

        @Override
        public int compare(HashMap<String, Integer> bridge1, HashMap<String, Integer> bridge2) {
            int bridgelength2;
            int smallerCoordinate2;
            int largerCoordinate2;
            int largerCoordinate1 = bridge1.get("AtomId_Larger");
            if (largerCoordinate1 > (largerCoordinate2 = bridge2.get("AtomId_Larger").intValue())) {
                return -1;
            }
            if (largerCoordinate2 > largerCoordinate1) {
                return 1;
            }
            int smallerCoordinate1 = bridge1.get("AtomId_Smaller");
            if (smallerCoordinate1 > (smallerCoordinate2 = bridge2.get("AtomId_Smaller").intValue())) {
                return -1;
            }
            if (smallerCoordinate2 > smallerCoordinate1) {
                return 1;
            }
            int bridgelength1 = bridge1.get("Bridge Length");
            if (bridgelength1 > (bridgelength2 = bridge2.get("Bridge Length").intValue())) {
                return -1;
            }
            if (bridgelength2 > bridgelength1) {
                return 1;
            }
            return 0;
        }
    }
}

