/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.ParseRules;
import uk.ac.cam.ch.wwmm.opsin.ParseRulesResults;
import uk.ac.cam.ch.wwmm.opsin.ParseTokens;
import uk.ac.cam.ch.wwmm.opsin.ParseWord;
import uk.ac.cam.ch.wwmm.opsin.ParsingException;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.WordTools;
import uk.ac.cam.ch.wwmm.opsin.WordType;

class CASTools {
    private static final Pattern matchCasCollectiveIndex = Pattern.compile("([\\[\\(\\{]([1-9][0-9]?[cC][iI][, ]?)+[\\]\\)\\}])+|[1-9][0-9]?[cC][iI]", 2);
    private static final Pattern matchAcid = Pattern.compile("acid[\\]\\)\\}]*", 2);
    private static final Pattern matchCommaSpace = Pattern.compile(", ");
    private static final Pattern matchCompoundWithPhrase = Pattern.compile("(compd\\. with|compound with|and) ", 2);
    private static final Pattern matchFunctionalTermAllowingSubstituentPrefix = Pattern.compile("(amide|hydrazide|(thi|selen|tellur)?oxime|hydrazone|(iso)?(semicarbazone|thiosemicarbazone|selenosemicarbazone|tellurosemicarbazone)|imide|imine|semioxamazone)[\\]\\)\\}]*", 2);

    CASTools() {
    }

    static String uninvertCASName(String name, ParseRules parseRules) throws ParsingException {
        ArrayList<String> nameComponents = new ArrayList<String>(Arrays.asList(matchCommaSpace.split(name)));
        ArrayList<String> substituents = new ArrayList<String>();
        ArrayList<String> seperateWordSubstituents = new ArrayList<String>();
        ArrayList<String> functionalTerms = new ArrayList<String>();
        String parent = (String)nameComponents.get(0);
        String[] parentNameParts = parent.split(" ");
        if (parentNameParts.length != 1) {
            if (matchCasCollectiveIndex.matcher(parentNameParts[parentNameParts.length - 1]).matches()) {
                StringBuilder parentSB = new StringBuilder();
                for (int i = 0; i < parentNameParts.length - 1; ++i) {
                    parentSB.append(parentNameParts[i]);
                }
                parent = parentSB.toString();
                parentNameParts = parent.split(" ");
            }
            for (int i = 1; i < parentNameParts.length; ++i) {
                ParseRulesResults results;
                List<ParseTokens> parseTokens;
                if (matchAcid.matcher(parentNameParts[i]).matches() || !(parseTokens = (results = parseRules.getParses(parentNameParts[i])).getParseTokensList()).isEmpty()) continue;
                throw new ParsingException("Invalid CAS name. Parent compound was followed by an unexpected term");
            }
        }
        boolean addedBracket = false;
        boolean esterEncountered = false;
        for (int i = 1; i < nameComponents.size(); ++i) {
            Object nameComponent = (String)nameComponents.get(i);
            Matcher m = matchCompoundWithPhrase.matcher((CharSequence)nameComponent);
            boolean compoundWithcomponent = false;
            if (m.lookingAt()) {
                nameComponent = ((String)nameComponent).substring(m.group().length());
                compoundWithcomponent = true;
            }
            String[] components = ((String)nameComponents.get(i)).split(" ");
            int componentLen = components.length;
            block8: for (int c = 0; c < componentLen; ++c) {
                String component = components[c];
                if (compoundWithcomponent) {
                    functionalTerms.add(component);
                    continue;
                }
                if (component.endsWith("-")) {
                    Character missingCloseBracket = CASTools.missingCloseBracketCharIfApplicable(component);
                    if (missingCloseBracket != null) {
                        if (addedBracket) {
                            throw new ParsingException("Close bracket appears to be missing");
                        }
                        parent = parent + missingCloseBracket;
                        addedBracket = true;
                    }
                    substituents.add(component);
                    continue;
                }
                ParseRulesResults results = parseRules.getParses(component);
                List<ParseTokens> parseTokens = results.getParseTokensList();
                if (parseTokens.size() > 0) {
                    List<ParseWord> parseWords = WordTools.splitIntoParseWords(parseTokens, component);
                    List<ParseTokens> firstParseWordTokens = parseWords.get(0).getParseTokens();
                    WordType firstWordType = OpsinTools.determineWordType(firstParseWordTokens.get(0).getAnnotations());
                    for (int j = 1; j < firstParseWordTokens.size(); ++j) {
                        if (firstWordType.equals((Object)OpsinTools.determineWordType(firstParseWordTokens.get(j).getAnnotations()))) continue;
                        throw new ParsingException(component + "can be interpreted in multiple ways. For the sake of precision OPSIN has decided not to process this as a CAS name");
                    }
                    if (parseWords.size() == 1) {
                        switch (firstWordType) {
                            case functionalTerm: {
                                if (component.equalsIgnoreCase("ester")) {
                                    if (seperateWordSubstituents.isEmpty()) {
                                        throw new ParsingException("ester encountered but no substituents were specified in potential CAS name!");
                                    }
                                    if (esterEncountered) {
                                        throw new ParsingException("ester formation was mentioned more than once in CAS name!");
                                    }
                                    parent = CASTools.uninvertEster(parent);
                                    esterEncountered = true;
                                    continue block8;
                                }
                                functionalTerms.add(component);
                                continue block8;
                            }
                            case substituent: {
                                seperateWordSubstituents.add(component);
                                continue block8;
                            }
                            case full: {
                                if (StringTools.endsWithCaseInsensitive(component, "ate") || StringTools.endsWithCaseInsensitive(component, "ite") || StringTools.endsWithCaseInsensitive(component, "ium") || StringTools.endsWithCaseInsensitive(component, "hydrofluoride") || StringTools.endsWithCaseInsensitive(component, "hydrochloride") || StringTools.endsWithCaseInsensitive(component, "hydrobromide") || StringTools.endsWithCaseInsensitive(component, "hydroiodide")) {
                                    functionalTerms.add(component);
                                    continue block8;
                                }
                                if (StringTools.endsWithCaseInsensitive(component, "ic") && c + 1 < componentLen && components[c + 1].equalsIgnoreCase("acid")) {
                                    functionalTerms.add(component);
                                    functionalTerms.add(components[++c]);
                                    continue block8;
                                }
                                throw new ParsingException("Unable to interpret: " + component + " (as part of a CAS index name)- A full word was encountered where a substituent or functionalTerm was expected");
                            }
                            default: {
                                throw new ParsingException("Unrecognised CAS index name form");
                            }
                        }
                    }
                    if (parseWords.size() == 2 && firstWordType.equals((Object)WordType.substituent)) {
                        List<ParseTokens> secondParseWordTokens = parseWords.get(1).getParseTokens();
                        WordType secondWordType = OpsinTools.determineWordType(secondParseWordTokens.get(0).getAnnotations());
                        for (int j = 1; j < secondParseWordTokens.size(); ++j) {
                            if (secondWordType.equals((Object)OpsinTools.determineWordType(secondParseWordTokens.get(j).getAnnotations()))) continue;
                            throw new ParsingException(component + "can be interpreted in multiple ways. For the sake of precision OPSIN has decided not to process this as a CAS name");
                        }
                        if (secondWordType.equals((Object)WordType.functionalTerm) && matchFunctionalTermAllowingSubstituentPrefix.matcher(parseWords.get(1).getWord()).matches()) {
                            functionalTerms.add(component);
                            continue;
                        }
                        throw new ParsingException("Unrecognised CAS index name form, could have a missing space?");
                    }
                    throw new ParsingException("Unrecognised CAS index name form");
                }
                if (matchCasCollectiveIndex.matcher(component).matches()) continue;
                throw new ParsingException("Unable to interpret: " + component + " (as part of a CAS index name)");
            }
        }
        StringBuilder casName = new StringBuilder();
        for (String prefixFunctionalTerm : seperateWordSubstituents) {
            casName.append(prefixFunctionalTerm);
            casName.append(" ");
        }
        for (int i = substituents.size() - 1; i >= 0; --i) {
            casName.append((String)substituents.get(i));
        }
        casName.append(parent);
        for (String functionalTerm : functionalTerms) {
            casName.append(" ");
            casName.append(functionalTerm);
        }
        return casName.toString();
    }

    private static Character missingCloseBracketCharIfApplicable(String component) {
        int bracketLevel = 0;
        Character missingCloseBracket = null;
        int l = component.length();
        for (int i = 0; i < l; ++i) {
            char character = component.charAt(i);
            if ((character == '(' || character == '[' || character == '{') && ++bracketLevel == 1) {
                missingCloseBracket = Character.valueOf(character);
            }
            if (character != ')' && character != ']' && character != '}' || --bracketLevel >= 0) continue;
            return null;
        }
        if (bracketLevel == 1) {
            if (missingCloseBracket.charValue() == '(') {
                return Character.valueOf(')');
            }
            if (missingCloseBracket.charValue() == '[') {
                return Character.valueOf(']');
            }
            if (missingCloseBracket.charValue() == '{') {
                return Character.valueOf('}');
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String uninvertEster(String parent) throws ParsingException {
        int len = parent.length();
        if (len == 0) {
            throw new ParsingException("Failed to uninvert CAS ester");
        }
        char lastChar = parent.charAt(len - 1);
        if (lastChar == ')') {
            if (StringTools.endsWithCaseInsensitive(parent, "ic acid)")) {
                return parent.substring(0, parent.length() - 8) + "ate)";
            }
            if (StringTools.endsWithCaseInsensitive(parent, "ous acid)")) {
                return parent.substring(0, parent.length() - 9) + "ite)";
            }
            if (!StringTools.endsWithCaseInsensitive(parent, "ine)")) throw new ParsingException("Failed to uninvert CAS ester");
            return parent.substring(0, parent.length() - 2) + "ate)";
        }
        if (StringTools.endsWithCaseInsensitive(parent, "ic acid")) {
            return parent.substring(0, parent.length() - 7) + "ate";
        }
        if (StringTools.endsWithCaseInsensitive(parent, "ous acid")) {
            return parent.substring(0, parent.length() - 8) + "ite";
        }
        if (!StringTools.endsWithCaseInsensitive(parent, "ine")) throw new ParsingException("Failed to uninvert CAS ester");
        return parent.substring(0, parent.length() - 1) + "ate";
    }
}

