#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = [ ]

test_requirements = [ ]

setup(
    author="Mohammed Salim Dason",
    author_email='salimdason@outlook.com',
    python_requires='>=3.6',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU General Public License v3 (GPLv3)',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    description="A suite of maintenance tools for Wasabi S3 buckets ",
    entry_points={
        'console_scripts': [
            'wasabis3=wasabis3.cli:main',
        ],
    },
    install_requires=requirements,
    license="GNU General Public License v3",
    long_description=readme + '\n\n' + history,
    include_package_data=True,
    keywords='wasabis3',
    name='wasabis3',
    packages=find_packages(include=['wasabis3', 'wasabis3.*']),
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/salimdason/wasabis3',
    version='0.1.3',
    zip_safe=False,
)
