# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from .app_yaml import (
    ApiConfigHandler,
    ApiEndpointHandler,
    AuthFailAction,
    ErrorHandler,
    HealthCheck,
    Library,
    LivenessCheck,
    LoginRequirement,
    ReadinessCheck,
    ScriptHandler,
    SecurityLevel,
    StaticFilesHandler,
    UrlMap,
)
from .appengine import (
    AuthorizedCertificateView,
    BatchUpdateIngressRulesRequest,
    BatchUpdateIngressRulesResponse,
    CreateApplicationRequest,
    CreateAuthorizedCertificateRequest,
    CreateDomainMappingRequest,
    CreateIngressRuleRequest,
    CreateVersionRequest,
    DebugInstanceRequest,
    DeleteAuthorizedCertificateRequest,
    DeleteDomainMappingRequest,
    DeleteIngressRuleRequest,
    DeleteInstanceRequest,
    DeleteServiceRequest,
    DeleteVersionRequest,
    DomainOverrideStrategy,
    GetApplicationRequest,
    GetAuthorizedCertificateRequest,
    GetDomainMappingRequest,
    GetIngressRuleRequest,
    GetInstanceRequest,
    GetServiceRequest,
    GetVersionRequest,
    ListAuthorizedCertificatesRequest,
    ListAuthorizedCertificatesResponse,
    ListAuthorizedDomainsRequest,
    ListAuthorizedDomainsResponse,
    ListDomainMappingsRequest,
    ListDomainMappingsResponse,
    ListIngressRulesRequest,
    ListIngressRulesResponse,
    ListInstancesRequest,
    ListInstancesResponse,
    ListServicesRequest,
    ListServicesResponse,
    ListVersionsRequest,
    ListVersionsResponse,
    RepairApplicationRequest,
    UpdateApplicationRequest,
    UpdateAuthorizedCertificateRequest,
    UpdateDomainMappingRequest,
    UpdateIngressRuleRequest,
    UpdateServiceRequest,
    UpdateVersionRequest,
    VersionView,
)
from .application import Application, UrlDispatchRule
from .audit_data import AuditData, CreateVersionMethod, UpdateServiceMethod
from .certificate import (
    AuthorizedCertificate,
    CertificateRawData,
    ManagedCertificate,
    ManagementStatus,
)
from .deploy import CloudBuildOptions, ContainerInfo, Deployment, FileInfo, ZipInfo
from .domain import AuthorizedDomain
from .domain_mapping import DomainMapping, ResourceRecord, SslSettings
from .firewall import FirewallRule
from .instance import Instance
from .location import LocationMetadata
from .network_settings import NetworkSettings
from .operation import CreateVersionMetadataV1, OperationMetadataV1
from .service import Service, TrafficSplit
from .version import (
    AutomaticScaling,
    BasicScaling,
    CpuUtilization,
    DiskUtilization,
    EndpointsApiService,
    Entrypoint,
    InboundServiceType,
    ManualScaling,
    Network,
    NetworkUtilization,
    RequestUtilization,
    Resources,
    ServingStatus,
    StandardSchedulerSettings,
    Version,
    Volume,
    VpcAccessConnector,
)

__all__ = (
    "ApiConfigHandler",
    "ApiEndpointHandler",
    "ErrorHandler",
    "HealthCheck",
    "Library",
    "LivenessCheck",
    "ReadinessCheck",
    "ScriptHandler",
    "StaticFilesHandler",
    "UrlMap",
    "AuthFailAction",
    "LoginRequirement",
    "SecurityLevel",
    "BatchUpdateIngressRulesRequest",
    "BatchUpdateIngressRulesResponse",
    "CreateApplicationRequest",
    "CreateAuthorizedCertificateRequest",
    "CreateDomainMappingRequest",
    "CreateIngressRuleRequest",
    "CreateVersionRequest",
    "DebugInstanceRequest",
    "DeleteAuthorizedCertificateRequest",
    "DeleteDomainMappingRequest",
    "DeleteIngressRuleRequest",
    "DeleteInstanceRequest",
    "DeleteServiceRequest",
    "DeleteVersionRequest",
    "GetApplicationRequest",
    "GetAuthorizedCertificateRequest",
    "GetDomainMappingRequest",
    "GetIngressRuleRequest",
    "GetInstanceRequest",
    "GetServiceRequest",
    "GetVersionRequest",
    "ListAuthorizedCertificatesRequest",
    "ListAuthorizedCertificatesResponse",
    "ListAuthorizedDomainsRequest",
    "ListAuthorizedDomainsResponse",
    "ListDomainMappingsRequest",
    "ListDomainMappingsResponse",
    "ListIngressRulesRequest",
    "ListIngressRulesResponse",
    "ListInstancesRequest",
    "ListInstancesResponse",
    "ListServicesRequest",
    "ListServicesResponse",
    "ListVersionsRequest",
    "ListVersionsResponse",
    "RepairApplicationRequest",
    "UpdateApplicationRequest",
    "UpdateAuthorizedCertificateRequest",
    "UpdateDomainMappingRequest",
    "UpdateIngressRuleRequest",
    "UpdateServiceRequest",
    "UpdateVersionRequest",
    "AuthorizedCertificateView",
    "DomainOverrideStrategy",
    "VersionView",
    "Application",
    "UrlDispatchRule",
    "AuditData",
    "CreateVersionMethod",
    "UpdateServiceMethod",
    "AuthorizedCertificate",
    "CertificateRawData",
    "ManagedCertificate",
    "ManagementStatus",
    "CloudBuildOptions",
    "ContainerInfo",
    "Deployment",
    "FileInfo",
    "ZipInfo",
    "AuthorizedDomain",
    "DomainMapping",
    "ResourceRecord",
    "SslSettings",
    "FirewallRule",
    "Instance",
    "LocationMetadata",
    "NetworkSettings",
    "CreateVersionMetadataV1",
    "OperationMetadataV1",
    "Service",
    "TrafficSplit",
    "AutomaticScaling",
    "BasicScaling",
    "CpuUtilization",
    "DiskUtilization",
    "EndpointsApiService",
    "Entrypoint",
    "ManualScaling",
    "Network",
    "NetworkUtilization",
    "RequestUtilization",
    "Resources",
    "StandardSchedulerSettings",
    "Version",
    "Volume",
    "VpcAccessConnector",
    "InboundServiceType",
    "ServingStatus",
)
