# AUTOGENERATED! DO NOT EDIT! File to edit: ../13_CutOutHideAndSeek.ipynb.

# %% auto 0
__all__ = ['CutOutHideAndSeek']

# %% ../13_CutOutHideAndSeek.ipynb 2
from .holemakertechnique import *
from .holemakerpoint import *
from .holesfilling import *
import numpy as np
import random
import torch

# %% ../13_CutOutHideAndSeek.ipynb 4
class CutOutHideAndSeek(HolesFilling):
    "Defines the amount of holes, the probability of deactivation, the technique used to make them and the probability of apply the technique."
    def __init__(self,
                 deactivation_p = 0.1, # The probability of deactivate a region.
                 hole_maker: "HoleMakerTechnique" = None, # The strategy used to make the holes.
                 p = 0.5): # The probability of applying this technique.
        hole_maker = hole_maker if hole_maker else HoleMakerPoint()
        super().__init__(hole_maker)
        self.deactivation_p = deactivation_p
        self.p = p

    def before_batch(self):
        "Applies the CutOut Hide & Seek technique (divides the image into a grid and deactivates some portions with a determinated probability)."
        for image, mask in zip(self.x, self.y):
            if random.random() < self.p:
                shape = image.shape[1:]
                for randy in range(0, shape[0], self.hole_maker.hole_size[0]):
                    for randx in range(0, shape[1], self.hole_maker.hole_size[1]):
                        if random.random() < self.deactivation_p:
                            self.hole_maker.x = randx
                            self.hole_maker.y = randy
                            xhole, yhole = self.make_hole(mask)
                            self.fill_hole(image, mask, xhole, yhole, [torch.min(image), 0])
