# Generated by Django 3.2.7 on 2022-08-13 20:05

from django.db import migrations, models
import django.db.models.deletion
import django_nats_nkeys.models


class Migration(migrations.Migration):
    dependencies = [
        ("django_nats_nkeys", "0002_auto_20220807_2036"),
    ]

    operations = [
        migrations.CreateModel(
            name="NatsMessageExport",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255, unique=True)),
                ("subject_pattern", models.CharField(max_length=255, unique=True)),
                ("public", models.BooleanField()),
                (
                    "export_type",
                    models.CharField(
                        choices=[
                            (
                                "service",
                                "Export is a service: https://docs.nats.io/using-nats/nats-tools/nsc/services",
                            ),
                            (
                                "stream",
                                "Export is a stream: https://docs.nats.io/using-nats/nats-tools/nsc/streams",
                            ),
                        ],
                        max_length=8,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="NatsOrganizationApp",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "app_name",
                    models.CharField(
                        default=django_nats_nkeys.models._default_name, max_length=255
                    ),
                ),
                (
                    "json",
                    models.JSONField(
                        help_text="Output of `nsc describe account`", max_length=255
                    ),
                ),
                (
                    "allow_pub",
                    models.CharField(
                        help_text="add publish permissions, comma separated list. equivalent to `nsc add user ... --allow-pub=<permissions>`",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "allow_pubsub",
                    models.CharField(
                        help_text="add publish/subscribe permissions, comma separated list. equivalent to `nsc add user ... --allow-pubsub=<permissions>`",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "allow_sub",
                    models.CharField(
                        help_text="add subscribe permissions, comma separated list. equivalent to `nsc add user ... --allow-sub=<permissions>`",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "deny_pub",
                    models.CharField(
                        help_text="deny publish permissions, comma separated list. equivalent to `nsc add user ... --deny-pub=<permissions>`",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "deny_pubsub",
                    models.CharField(
                        help_text="deny publish/subscribe permissions, comma separated list. equivalent to `nsc add user ... --deny-pubsub=<permissions>`",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "deny_sub",
                    models.CharField(
                        help_text="deny subscribe permissions, comma separated list. equivalent to `nsc add user ... --deny-sub=<permissions>`",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="nats_apps",
                        to="django_nats_nkeys.natsorganization",
                    ),
                ),
                (
                    "organization_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="nats_apps",
                        to="django_nats_nkeys.natsorganizationuser",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="NatsRobotAccount",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255, unique=True)),
                (
                    "json",
                    models.JSONField(
                        help_text="Output of `nsc describe account`", max_length=255
                    ),
                ),
                (
                    "exports",
                    models.ManyToManyField(
                        related_name="nats_robot_exports",
                        to="django_nats_nkeys.NatsMessageExport",
                    ),
                ),
                (
                    "imports",
                    models.ManyToManyField(
                        related_name="nats_robot_imports",
                        to="django_nats_nkeys.NatsMessageExport",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="NatsRobotApp",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "app_name",
                    models.CharField(
                        default=django_nats_nkeys.models._default_name, max_length=255
                    ),
                ),
                (
                    "json",
                    models.JSONField(
                        help_text="Output of `nsc describe account`", max_length=255
                    ),
                ),
                (
                    "allow_pub",
                    models.CharField(
                        help_text="add publish permissions, comma separated list. equivalent to `nsc add user ... --allow-pub=<permissions>`",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "allow_pubsub",
                    models.CharField(
                        help_text="add publish/subscribe permissions, comma separated list. equivalent to `nsc add user ... --allow-pubsub=<permissions>`",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "allow_sub",
                    models.CharField(
                        help_text="add subscribe permissions, comma separated list. equivalent to `nsc add user ... --allow-sub=<permissions>`",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "deny_pub",
                    models.CharField(
                        help_text="deny publish permissions, comma separated list. equivalent to `nsc add user ... --deny-pub=<permissions>`",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "deny_pubsub",
                    models.CharField(
                        help_text="deny publish/subscribe permissions, comma separated list. equivalent to `nsc add user ... --deny-pubsub=<permissions>`",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "deny_sub",
                    models.CharField(
                        help_text="deny subscribe permissions, comma separated list. equivalent to `nsc add user ... --deny-sub=<permissions>`",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "account",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="robot_apps",
                        to="django_nats_nkeys.natsrobotaccount",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.DeleteModel(
            name="NatsApp",
        ),
        migrations.AddField(
            model_name="natsorganization",
            name="exports",
            field=models.ManyToManyField(
                related_name="nats_organization_exports",
                to="django_nats_nkeys.NatsMessageExport",
            ),
        ),
        migrations.AddField(
            model_name="natsorganization",
            name="imports",
            field=models.ManyToManyField(
                related_name="nats_organization_imports",
                to="django_nats_nkeys.NatsMessageExport",
            ),
        ),
        migrations.AddConstraint(
            model_name="natsorganizationapp",
            constraint=models.UniqueConstraint(
                fields=("app_name", "organization_user"),
                name="unique_app_name_per_org_user",
            ),
        ),
    ]
