# AUTOGENERATED! DO NOT EDIT! File to edit: fiducial_detect.ipynb (unless otherwise specified).

__all__ = ['DotVisionCheckerDLDetector']

# Cell
import copy
import math
import warnings

import torch
from skimage.measure import label, regionprops
from torchvision import transforms

from .utils import *

# Cell
class DotVisionCheckerDLDetector():
    def __init__(self, file_model, device=None):
        self.model = torch.jit.load(file_model.as_posix(), map_location=device).eval()

    def to(self, device):
        if device is None: return self
        self = copy.deepcopy(self)
        with warnings.catch_warnings():
            warnings.simplefilter("ignore")
            self.model.to(device)
        return self

    def format_arr(self, arr):
        if arr.min() < 0: warnings.warn('Value less than zero detected')
        if arr.max() > 1: warnings.warn('Value greater than 1 detected')

        arr = arr.float()                   # Must be single precision
        arr = imresize(arr, 384)            # Network trained on grayscale 384 sized images
        arr = rescale(arr, (0, 1), (-1, 1)) # Network trained on images between [-1,1]
        arr = arr[None, None]               # Add batch and channel dimension
        return arr

    def get_mask(self, arr):
        with torch.no_grad():
            mask = self.model(self.format_arr(arr)) # Inference
            mask = mask.argmax(dim=1)               # Convert from scores to labels
            mask = mask.squeeze(0)                  # Remove batch dimension
        return mask

    def __call__(self, arr):
        mask = self.get_mask(arr)

        # Extract fiducial points from mask
        ps_f = arr.new_full((4,2), math.nan)
        for idx, p_f in enumerate(ps_f):
            regions = regionprops(label(torch2np(mask) == (idx+1))) # regionprops doesnt work for gpu
            if len(regions) > 0:
                region = regions[arr.new_tensor([r.area for r in regions]).argmax()]
                ps_f[idx] = arr.new_tensor(reverse(region.centroid))
        ps_f *= (shape(arr)/shape(mask)).mean()

        return ps_f