# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubeNodePoolArgs', 'KubeNodePool']

@pulumi.input_type
class KubeNodePoolArgs:
    def __init__(__self__, *,
                 flavor_name: pulumi.Input[str],
                 kube_id: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 anti_affinity: Optional[pulumi.Input[bool]] = None,
                 autoscale: Optional[pulumi.Input[bool]] = None,
                 desired_nodes: Optional[pulumi.Input[int]] = None,
                 max_nodes: Optional[pulumi.Input[int]] = None,
                 min_nodes: Optional[pulumi.Input[int]] = None,
                 monthly_billed: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input['KubeNodePoolTemplateArgs']] = None):
        """
        The set of arguments for constructing a KubeNodePool resource.
        :param pulumi.Input[str] flavor_name: a valid OVHcloud public cloud flavor ID in which the nodes will be started. Ex: "b2-7". You can find the list of flavor IDs: https://www.ovhcloud.com/fr/public-cloud/prices/.
               **Changing this value recreates the resource.**
        :param pulumi.Input[str] kube_id: The id of the managed kubernetes cluster. **Changing this value recreates the resource.**
        :param pulumi.Input[str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        :param pulumi.Input[bool] anti_affinity: should the pool use the anti-affinity feature. Default to `false`. **Changing this value recreates the resource.**
        :param pulumi.Input[bool] autoscale: Enable auto-scaling for the pool. Default to `false`.
               * `template ` - (Optional) Managed Kubernetes nodepool template, which is a complex object constituted by two main nested objects:
        :param pulumi.Input[int] desired_nodes: number of nodes to start.
        :param pulumi.Input[int] max_nodes: maximum number of nodes allowed in the pool. Setting `desired_nodes` over this value will raise an error.
        :param pulumi.Input[int] min_nodes: minimum number of nodes allowed in the pool. Setting `desired_nodes` under this value will raise an error.
        :param pulumi.Input[bool] monthly_billed: should the nodes be billed on a monthly basis. Default to `false`. **Changing this value recreates the resource.**
        :param pulumi.Input[str] name: The name of the nodepool. Warning: `_` char is not allowed! **Changing this value recreates the resource.**
        :param pulumi.Input['KubeNodePoolTemplateArgs'] template: Node pool template
        """
        pulumi.set(__self__, "flavor_name", flavor_name)
        pulumi.set(__self__, "kube_id", kube_id)
        pulumi.set(__self__, "service_name", service_name)
        if anti_affinity is not None:
            pulumi.set(__self__, "anti_affinity", anti_affinity)
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if desired_nodes is not None:
            pulumi.set(__self__, "desired_nodes", desired_nodes)
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if monthly_billed is not None:
            pulumi.set(__self__, "monthly_billed", monthly_billed)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> pulumi.Input[str]:
        """
        a valid OVHcloud public cloud flavor ID in which the nodes will be started. Ex: "b2-7". You can find the list of flavor IDs: https://www.ovhcloud.com/fr/public-cloud/prices/.
        **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "flavor_name")

    @flavor_name.setter
    def flavor_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor_name", value)

    @property
    @pulumi.getter(name="kubeId")
    def kube_id(self) -> pulumi.Input[str]:
        """
        The id of the managed kubernetes cluster. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "kube_id")

    @kube_id.setter
    def kube_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "kube_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="antiAffinity")
    def anti_affinity(self) -> Optional[pulumi.Input[bool]]:
        """
        should the pool use the anti-affinity feature. Default to `false`. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "anti_affinity")

    @anti_affinity.setter
    def anti_affinity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "anti_affinity", value)

    @property
    @pulumi.getter
    def autoscale(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable auto-scaling for the pool. Default to `false`.
        * `template ` - (Optional) Managed Kubernetes nodepool template, which is a complex object constituted by two main nested objects:
        """
        return pulumi.get(self, "autoscale")

    @autoscale.setter
    def autoscale(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autoscale", value)

    @property
    @pulumi.getter(name="desiredNodes")
    def desired_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        number of nodes to start.
        """
        return pulumi.get(self, "desired_nodes")

    @desired_nodes.setter
    def desired_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_nodes", value)

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        maximum number of nodes allowed in the pool. Setting `desired_nodes` over this value will raise an error.
        """
        return pulumi.get(self, "max_nodes")

    @max_nodes.setter
    def max_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_nodes", value)

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        minimum number of nodes allowed in the pool. Setting `desired_nodes` under this value will raise an error.
        """
        return pulumi.get(self, "min_nodes")

    @min_nodes.setter
    def min_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_nodes", value)

    @property
    @pulumi.getter(name="monthlyBilled")
    def monthly_billed(self) -> Optional[pulumi.Input[bool]]:
        """
        should the nodes be billed on a monthly basis. Default to `false`. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "monthly_billed")

    @monthly_billed.setter
    def monthly_billed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monthly_billed", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the nodepool. Warning: `_` char is not allowed! **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['KubeNodePoolTemplateArgs']]:
        """
        Node pool template
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['KubeNodePoolTemplateArgs']]):
        pulumi.set(self, "template", value)


@pulumi.input_type
class _KubeNodePoolState:
    def __init__(__self__, *,
                 anti_affinity: Optional[pulumi.Input[bool]] = None,
                 autoscale: Optional[pulumi.Input[bool]] = None,
                 available_nodes: Optional[pulumi.Input[int]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 current_nodes: Optional[pulumi.Input[int]] = None,
                 desired_nodes: Optional[pulumi.Input[int]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 flavor_name: Optional[pulumi.Input[str]] = None,
                 kube_id: Optional[pulumi.Input[str]] = None,
                 max_nodes: Optional[pulumi.Input[int]] = None,
                 min_nodes: Optional[pulumi.Input[int]] = None,
                 monthly_billed: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 size_status: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input['KubeNodePoolTemplateArgs']] = None,
                 up_to_date_nodes: Optional[pulumi.Input[int]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KubeNodePool resources.
        :param pulumi.Input[bool] anti_affinity: should the pool use the anti-affinity feature. Default to `false`. **Changing this value recreates the resource.**
        :param pulumi.Input[bool] autoscale: Enable auto-scaling for the pool. Default to `false`.
               * `template ` - (Optional) Managed Kubernetes nodepool template, which is a complex object constituted by two main nested objects:
        :param pulumi.Input[int] available_nodes: Number of nodes which are actually ready in the pool
        :param pulumi.Input[str] created_at: Creation date
        :param pulumi.Input[int] current_nodes: Number of nodes present in the pool
        :param pulumi.Input[int] desired_nodes: number of nodes to start.
        :param pulumi.Input[str] flavor: Flavor name
        :param pulumi.Input[str] flavor_name: a valid OVHcloud public cloud flavor ID in which the nodes will be started. Ex: "b2-7". You can find the list of flavor IDs: https://www.ovhcloud.com/fr/public-cloud/prices/.
               **Changing this value recreates the resource.**
        :param pulumi.Input[str] kube_id: The id of the managed kubernetes cluster. **Changing this value recreates the resource.**
        :param pulumi.Input[int] max_nodes: maximum number of nodes allowed in the pool. Setting `desired_nodes` over this value will raise an error.
        :param pulumi.Input[int] min_nodes: minimum number of nodes allowed in the pool. Setting `desired_nodes` under this value will raise an error.
        :param pulumi.Input[bool] monthly_billed: should the nodes be billed on a monthly basis. Default to `false`. **Changing this value recreates the resource.**
        :param pulumi.Input[str] name: The name of the nodepool. Warning: `_` char is not allowed! **Changing this value recreates the resource.**
        :param pulumi.Input[str] project_id: Project id
        :param pulumi.Input[str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        :param pulumi.Input[str] size_status: Status describing the state between number of nodes wanted and available ones
        :param pulumi.Input[str] status: Current status
        :param pulumi.Input['KubeNodePoolTemplateArgs'] template: Node pool template
        :param pulumi.Input[int] up_to_date_nodes: Number of nodes with the latest version installed in the pool
        :param pulumi.Input[str] updated_at: Last update date
        """
        if anti_affinity is not None:
            pulumi.set(__self__, "anti_affinity", anti_affinity)
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if available_nodes is not None:
            pulumi.set(__self__, "available_nodes", available_nodes)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if current_nodes is not None:
            pulumi.set(__self__, "current_nodes", current_nodes)
        if desired_nodes is not None:
            pulumi.set(__self__, "desired_nodes", desired_nodes)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if flavor_name is not None:
            pulumi.set(__self__, "flavor_name", flavor_name)
        if kube_id is not None:
            pulumi.set(__self__, "kube_id", kube_id)
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if monthly_billed is not None:
            pulumi.set(__self__, "monthly_billed", monthly_billed)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if size_status is not None:
            pulumi.set(__self__, "size_status", size_status)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if up_to_date_nodes is not None:
            pulumi.set(__self__, "up_to_date_nodes", up_to_date_nodes)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="antiAffinity")
    def anti_affinity(self) -> Optional[pulumi.Input[bool]]:
        """
        should the pool use the anti-affinity feature. Default to `false`. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "anti_affinity")

    @anti_affinity.setter
    def anti_affinity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "anti_affinity", value)

    @property
    @pulumi.getter
    def autoscale(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable auto-scaling for the pool. Default to `false`.
        * `template ` - (Optional) Managed Kubernetes nodepool template, which is a complex object constituted by two main nested objects:
        """
        return pulumi.get(self, "autoscale")

    @autoscale.setter
    def autoscale(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autoscale", value)

    @property
    @pulumi.getter(name="availableNodes")
    def available_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        Number of nodes which are actually ready in the pool
        """
        return pulumi.get(self, "available_nodes")

    @available_nodes.setter
    def available_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "available_nodes", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Creation date
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="currentNodes")
    def current_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        Number of nodes present in the pool
        """
        return pulumi.get(self, "current_nodes")

    @current_nodes.setter
    def current_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "current_nodes", value)

    @property
    @pulumi.getter(name="desiredNodes")
    def desired_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        number of nodes to start.
        """
        return pulumi.get(self, "desired_nodes")

    @desired_nodes.setter
    def desired_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_nodes", value)

    @property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[str]]:
        """
        Flavor name
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> Optional[pulumi.Input[str]]:
        """
        a valid OVHcloud public cloud flavor ID in which the nodes will be started. Ex: "b2-7". You can find the list of flavor IDs: https://www.ovhcloud.com/fr/public-cloud/prices/.
        **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "flavor_name")

    @flavor_name.setter
    def flavor_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor_name", value)

    @property
    @pulumi.getter(name="kubeId")
    def kube_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the managed kubernetes cluster. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "kube_id")

    @kube_id.setter
    def kube_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kube_id", value)

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        maximum number of nodes allowed in the pool. Setting `desired_nodes` over this value will raise an error.
        """
        return pulumi.get(self, "max_nodes")

    @max_nodes.setter
    def max_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_nodes", value)

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        minimum number of nodes allowed in the pool. Setting `desired_nodes` under this value will raise an error.
        """
        return pulumi.get(self, "min_nodes")

    @min_nodes.setter
    def min_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_nodes", value)

    @property
    @pulumi.getter(name="monthlyBilled")
    def monthly_billed(self) -> Optional[pulumi.Input[bool]]:
        """
        should the nodes be billed on a monthly basis. Default to `false`. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "monthly_billed")

    @monthly_billed.setter
    def monthly_billed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monthly_billed", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the nodepool. Warning: `_` char is not allowed! **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Project id
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="sizeStatus")
    def size_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status describing the state between number of nodes wanted and available ones
        """
        return pulumi.get(self, "size_status")

    @size_status.setter
    def size_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_status", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Current status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['KubeNodePoolTemplateArgs']]:
        """
        Node pool template
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['KubeNodePoolTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="upToDateNodes")
    def up_to_date_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        Number of nodes with the latest version installed in the pool
        """
        return pulumi.get(self, "up_to_date_nodes")

    @up_to_date_nodes.setter
    def up_to_date_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "up_to_date_nodes", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        Last update date
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


class KubeNodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anti_affinity: Optional[pulumi.Input[bool]] = None,
                 autoscale: Optional[pulumi.Input[bool]] = None,
                 desired_nodes: Optional[pulumi.Input[int]] = None,
                 flavor_name: Optional[pulumi.Input[str]] = None,
                 kube_id: Optional[pulumi.Input[str]] = None,
                 max_nodes: Optional[pulumi.Input[int]] = None,
                 min_nodes: Optional[pulumi.Input[int]] = None,
                 monthly_billed: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['KubeNodePoolTemplateArgs']]] = None,
                 __props__=None):
        """
        Creates a nodepool in a OVHcloud Managed Kubernetes Service cluster.

        ## Example Usage

        Create a simple node pool in your Kubernetes cluster:

        ```python
        import pulumi
        import lbrlabs_pulumi_ovh as ovh

        node_pool = ovh.cloud_project.KubeNodePool("nodePool",
            desired_nodes=3,
            flavor_name="b2-7",
            kube_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",
            max_nodes=3,
            min_nodes=3,
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx")
        ```

        Create an advanced node pool in your Kubernetes cluster:

        ```python
        import pulumi
        import lbrlabs_pulumi_ovh as ovh

        pool = ovh.cloud_project.KubeNodePool("pool",
            desired_nodes=3,
            flavor_name="b2-7",
            kube_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",
            max_nodes=3,
            min_nodes=3,
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            template=ovh.cloud_project.KubeNodePoolTemplateArgs(
                metadata=ovh.cloud_project.KubeNodePoolTemplateMetadataArgs(
                    annotations={
                        "k1": "v1",
                        "k2": "v2",
                    },
                    finalizers=[
                        "F1",
                        "F2",
                    ],
                    labels={
                        "k3": "v3",
                        "k4": "v4",
                    },
                ),
                spec=ovh.cloud_project.KubeNodePoolTemplateSpecArgs(
                    taints=[{
                        "effect": "PreferNoSchedule",
                        "key": "k",
                        "value": "v",
                    }],
                    unschedulable=False,
                ),
            ))
        ```

        ## Import

        OVHcloud Managed Kubernetes Service cluster node pool can be imported using the `service_name`, the `id` of the cluster, and the `id` of the nodepool separated by "/" E.g., bash

        ```sh
         $ pulumi import ovh:CloudProject/kubeNodePool:KubeNodePool pool service_name/kube_id/poolid
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] anti_affinity: should the pool use the anti-affinity feature. Default to `false`. **Changing this value recreates the resource.**
        :param pulumi.Input[bool] autoscale: Enable auto-scaling for the pool. Default to `false`.
               * `template ` - (Optional) Managed Kubernetes nodepool template, which is a complex object constituted by two main nested objects:
        :param pulumi.Input[int] desired_nodes: number of nodes to start.
        :param pulumi.Input[str] flavor_name: a valid OVHcloud public cloud flavor ID in which the nodes will be started. Ex: "b2-7". You can find the list of flavor IDs: https://www.ovhcloud.com/fr/public-cloud/prices/.
               **Changing this value recreates the resource.**
        :param pulumi.Input[str] kube_id: The id of the managed kubernetes cluster. **Changing this value recreates the resource.**
        :param pulumi.Input[int] max_nodes: maximum number of nodes allowed in the pool. Setting `desired_nodes` over this value will raise an error.
        :param pulumi.Input[int] min_nodes: minimum number of nodes allowed in the pool. Setting `desired_nodes` under this value will raise an error.
        :param pulumi.Input[bool] monthly_billed: should the nodes be billed on a monthly basis. Default to `false`. **Changing this value recreates the resource.**
        :param pulumi.Input[str] name: The name of the nodepool. Warning: `_` char is not allowed! **Changing this value recreates the resource.**
        :param pulumi.Input[str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        :param pulumi.Input[pulumi.InputType['KubeNodePoolTemplateArgs']] template: Node pool template
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubeNodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a nodepool in a OVHcloud Managed Kubernetes Service cluster.

        ## Example Usage

        Create a simple node pool in your Kubernetes cluster:

        ```python
        import pulumi
        import lbrlabs_pulumi_ovh as ovh

        node_pool = ovh.cloud_project.KubeNodePool("nodePool",
            desired_nodes=3,
            flavor_name="b2-7",
            kube_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",
            max_nodes=3,
            min_nodes=3,
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx")
        ```

        Create an advanced node pool in your Kubernetes cluster:

        ```python
        import pulumi
        import lbrlabs_pulumi_ovh as ovh

        pool = ovh.cloud_project.KubeNodePool("pool",
            desired_nodes=3,
            flavor_name="b2-7",
            kube_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",
            max_nodes=3,
            min_nodes=3,
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            template=ovh.cloud_project.KubeNodePoolTemplateArgs(
                metadata=ovh.cloud_project.KubeNodePoolTemplateMetadataArgs(
                    annotations={
                        "k1": "v1",
                        "k2": "v2",
                    },
                    finalizers=[
                        "F1",
                        "F2",
                    ],
                    labels={
                        "k3": "v3",
                        "k4": "v4",
                    },
                ),
                spec=ovh.cloud_project.KubeNodePoolTemplateSpecArgs(
                    taints=[{
                        "effect": "PreferNoSchedule",
                        "key": "k",
                        "value": "v",
                    }],
                    unschedulable=False,
                ),
            ))
        ```

        ## Import

        OVHcloud Managed Kubernetes Service cluster node pool can be imported using the `service_name`, the `id` of the cluster, and the `id` of the nodepool separated by "/" E.g., bash

        ```sh
         $ pulumi import ovh:CloudProject/kubeNodePool:KubeNodePool pool service_name/kube_id/poolid
        ```

        :param str resource_name: The name of the resource.
        :param KubeNodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubeNodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anti_affinity: Optional[pulumi.Input[bool]] = None,
                 autoscale: Optional[pulumi.Input[bool]] = None,
                 desired_nodes: Optional[pulumi.Input[int]] = None,
                 flavor_name: Optional[pulumi.Input[str]] = None,
                 kube_id: Optional[pulumi.Input[str]] = None,
                 max_nodes: Optional[pulumi.Input[int]] = None,
                 min_nodes: Optional[pulumi.Input[int]] = None,
                 monthly_billed: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['KubeNodePoolTemplateArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubeNodePoolArgs.__new__(KubeNodePoolArgs)

            __props__.__dict__["anti_affinity"] = anti_affinity
            __props__.__dict__["autoscale"] = autoscale
            __props__.__dict__["desired_nodes"] = desired_nodes
            if flavor_name is None and not opts.urn:
                raise TypeError("Missing required property 'flavor_name'")
            __props__.__dict__["flavor_name"] = flavor_name
            if kube_id is None and not opts.urn:
                raise TypeError("Missing required property 'kube_id'")
            __props__.__dict__["kube_id"] = kube_id
            __props__.__dict__["max_nodes"] = max_nodes
            __props__.__dict__["min_nodes"] = min_nodes
            __props__.__dict__["monthly_billed"] = monthly_billed
            __props__.__dict__["name"] = name
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["template"] = template
            __props__.__dict__["available_nodes"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["current_nodes"] = None
            __props__.__dict__["flavor"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["size_status"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["up_to_date_nodes"] = None
            __props__.__dict__["updated_at"] = None
        super(KubeNodePool, __self__).__init__(
            'ovh:CloudProject/kubeNodePool:KubeNodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            anti_affinity: Optional[pulumi.Input[bool]] = None,
            autoscale: Optional[pulumi.Input[bool]] = None,
            available_nodes: Optional[pulumi.Input[int]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            current_nodes: Optional[pulumi.Input[int]] = None,
            desired_nodes: Optional[pulumi.Input[int]] = None,
            flavor: Optional[pulumi.Input[str]] = None,
            flavor_name: Optional[pulumi.Input[str]] = None,
            kube_id: Optional[pulumi.Input[str]] = None,
            max_nodes: Optional[pulumi.Input[int]] = None,
            min_nodes: Optional[pulumi.Input[int]] = None,
            monthly_billed: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            size_status: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            template: Optional[pulumi.Input[pulumi.InputType['KubeNodePoolTemplateArgs']]] = None,
            up_to_date_nodes: Optional[pulumi.Input[int]] = None,
            updated_at: Optional[pulumi.Input[str]] = None) -> 'KubeNodePool':
        """
        Get an existing KubeNodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] anti_affinity: should the pool use the anti-affinity feature. Default to `false`. **Changing this value recreates the resource.**
        :param pulumi.Input[bool] autoscale: Enable auto-scaling for the pool. Default to `false`.
               * `template ` - (Optional) Managed Kubernetes nodepool template, which is a complex object constituted by two main nested objects:
        :param pulumi.Input[int] available_nodes: Number of nodes which are actually ready in the pool
        :param pulumi.Input[str] created_at: Creation date
        :param pulumi.Input[int] current_nodes: Number of nodes present in the pool
        :param pulumi.Input[int] desired_nodes: number of nodes to start.
        :param pulumi.Input[str] flavor: Flavor name
        :param pulumi.Input[str] flavor_name: a valid OVHcloud public cloud flavor ID in which the nodes will be started. Ex: "b2-7". You can find the list of flavor IDs: https://www.ovhcloud.com/fr/public-cloud/prices/.
               **Changing this value recreates the resource.**
        :param pulumi.Input[str] kube_id: The id of the managed kubernetes cluster. **Changing this value recreates the resource.**
        :param pulumi.Input[int] max_nodes: maximum number of nodes allowed in the pool. Setting `desired_nodes` over this value will raise an error.
        :param pulumi.Input[int] min_nodes: minimum number of nodes allowed in the pool. Setting `desired_nodes` under this value will raise an error.
        :param pulumi.Input[bool] monthly_billed: should the nodes be billed on a monthly basis. Default to `false`. **Changing this value recreates the resource.**
        :param pulumi.Input[str] name: The name of the nodepool. Warning: `_` char is not allowed! **Changing this value recreates the resource.**
        :param pulumi.Input[str] project_id: Project id
        :param pulumi.Input[str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        :param pulumi.Input[str] size_status: Status describing the state between number of nodes wanted and available ones
        :param pulumi.Input[str] status: Current status
        :param pulumi.Input[pulumi.InputType['KubeNodePoolTemplateArgs']] template: Node pool template
        :param pulumi.Input[int] up_to_date_nodes: Number of nodes with the latest version installed in the pool
        :param pulumi.Input[str] updated_at: Last update date
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubeNodePoolState.__new__(_KubeNodePoolState)

        __props__.__dict__["anti_affinity"] = anti_affinity
        __props__.__dict__["autoscale"] = autoscale
        __props__.__dict__["available_nodes"] = available_nodes
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["current_nodes"] = current_nodes
        __props__.__dict__["desired_nodes"] = desired_nodes
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["flavor_name"] = flavor_name
        __props__.__dict__["kube_id"] = kube_id
        __props__.__dict__["max_nodes"] = max_nodes
        __props__.__dict__["min_nodes"] = min_nodes
        __props__.__dict__["monthly_billed"] = monthly_billed
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["size_status"] = size_status
        __props__.__dict__["status"] = status
        __props__.__dict__["template"] = template
        __props__.__dict__["up_to_date_nodes"] = up_to_date_nodes
        __props__.__dict__["updated_at"] = updated_at
        return KubeNodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="antiAffinity")
    def anti_affinity(self) -> pulumi.Output[bool]:
        """
        should the pool use the anti-affinity feature. Default to `false`. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "anti_affinity")

    @property
    @pulumi.getter
    def autoscale(self) -> pulumi.Output[bool]:
        """
        Enable auto-scaling for the pool. Default to `false`.
        * `template ` - (Optional) Managed Kubernetes nodepool template, which is a complex object constituted by two main nested objects:
        """
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="availableNodes")
    def available_nodes(self) -> pulumi.Output[int]:
        """
        Number of nodes which are actually ready in the pool
        """
        return pulumi.get(self, "available_nodes")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Creation date
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="currentNodes")
    def current_nodes(self) -> pulumi.Output[int]:
        """
        Number of nodes present in the pool
        """
        return pulumi.get(self, "current_nodes")

    @property
    @pulumi.getter(name="desiredNodes")
    def desired_nodes(self) -> pulumi.Output[int]:
        """
        number of nodes to start.
        """
        return pulumi.get(self, "desired_nodes")

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[str]:
        """
        Flavor name
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> pulumi.Output[str]:
        """
        a valid OVHcloud public cloud flavor ID in which the nodes will be started. Ex: "b2-7". You can find the list of flavor IDs: https://www.ovhcloud.com/fr/public-cloud/prices/.
        **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "flavor_name")

    @property
    @pulumi.getter(name="kubeId")
    def kube_id(self) -> pulumi.Output[str]:
        """
        The id of the managed kubernetes cluster. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "kube_id")

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> pulumi.Output[int]:
        """
        maximum number of nodes allowed in the pool. Setting `desired_nodes` over this value will raise an error.
        """
        return pulumi.get(self, "max_nodes")

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> pulumi.Output[int]:
        """
        minimum number of nodes allowed in the pool. Setting `desired_nodes` under this value will raise an error.
        """
        return pulumi.get(self, "min_nodes")

    @property
    @pulumi.getter(name="monthlyBilled")
    def monthly_billed(self) -> pulumi.Output[bool]:
        """
        should the nodes be billed on a monthly basis. Default to `false`. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "monthly_billed")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the nodepool. Warning: `_` char is not allowed! **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        Project id
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="sizeStatus")
    def size_status(self) -> pulumi.Output[str]:
        """
        Status describing the state between number of nodes wanted and available ones
        """
        return pulumi.get(self, "size_status")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Current status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional['outputs.KubeNodePoolTemplate']]:
        """
        Node pool template
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="upToDateNodes")
    def up_to_date_nodes(self) -> pulumi.Output[int]:
        """
        Number of nodes with the latest version installed in the pool
        """
        return pulumi.get(self, "up_to_date_nodes")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        Last update date
        """
        return pulumi.get(self, "updated_at")

