# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ContainerRegistryPlanArgs',
    'ContainerRegistryPlanFeatureArgs',
    'ContainerRegistryPlanRegistryLimitArgs',
    'DatabaseEndpointArgs',
    'DatabaseNodeArgs',
    'KubeCustomizationArgs',
    'KubeCustomizationApiserverArgs',
    'KubeCustomizationApiserverAdmissionpluginArgs',
    'KubeCustomizationKubeProxyArgs',
    'KubeCustomizationKubeProxyIptablesArgs',
    'KubeCustomizationKubeProxyIpvsArgs',
    'KubeKubeconfigAttributeArgs',
    'KubeNodePoolTemplateArgs',
    'KubeNodePoolTemplateMetadataArgs',
    'KubeNodePoolTemplateSpecArgs',
    'KubePrivateNetworkConfigurationArgs',
    'NetworkPrivateRegionsAttributeArgs',
    'NetworkPrivateRegionsStatusArgs',
    'NetworkPrivateSubnetIpPoolArgs',
    'ProjectOrderArgs',
    'ProjectOrderDetailArgs',
    'ProjectPlanArgs',
    'ProjectPlanConfigurationArgs',
    'ProjectPlanOptionArgs',
    'ProjectPlanOptionConfigurationArgs',
    'UserRoleArgs',
    'GetKubeCustomizationArgs',
    'GetKubeCustomizationApiserverArgs',
    'GetKubeCustomizationApiserverAdmissionpluginArgs',
    'GetKubeCustomizationKubeProxyArgs',
    'GetKubeCustomizationKubeProxyIptablesArgs',
    'GetKubeCustomizationKubeProxyIpvsArgs',
    'GetKubeNodePoolTemplateArgs',
    'GetKubeNodePoolTemplateMetadataArgs',
    'GetKubeNodePoolTemplateSpecArgs',
]

@pulumi.input_type
class ContainerRegistryPlanArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRegistryPlanFeatureArgs']]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 registry_limits: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRegistryPlanRegistryLimitArgs']]]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] code: Plan code from the catalog
        :param pulumi.Input[str] created_at: Plan creation date
        :param pulumi.Input[Sequence[pulumi.Input['ContainerRegistryPlanFeatureArgs']]] features: Features of the plan
        :param pulumi.Input[str] id: Plan ID
        :param pulumi.Input[str] name: Registry name
        :param pulumi.Input[Sequence[pulumi.Input['ContainerRegistryPlanRegistryLimitArgs']]] registry_limits: Container registry limits
        :param pulumi.Input[str] updated_at: Registry last update date
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if registry_limits is not None:
            pulumi.set(__self__, "registry_limits", registry_limits)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        """
        Plan code from the catalog
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Plan creation date
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRegistryPlanFeatureArgs']]]]:
        """
        Features of the plan
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRegistryPlanFeatureArgs']]]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Plan ID
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Registry name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="registryLimits")
    def registry_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRegistryPlanRegistryLimitArgs']]]]:
        """
        Container registry limits
        """
        return pulumi.get(self, "registry_limits")

    @registry_limits.setter
    def registry_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRegistryPlanRegistryLimitArgs']]]]):
        pulumi.set(self, "registry_limits", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        Registry last update date
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.input_type
class ContainerRegistryPlanFeatureArgs:
    def __init__(__self__, *,
                 vulnerability: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] vulnerability: Vulnerability scanning
        """
        if vulnerability is not None:
            pulumi.set(__self__, "vulnerability", vulnerability)

    @property
    @pulumi.getter
    def vulnerability(self) -> Optional[pulumi.Input[bool]]:
        """
        Vulnerability scanning
        """
        return pulumi.get(self, "vulnerability")

    @vulnerability.setter
    def vulnerability(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vulnerability", value)


@pulumi.input_type
class ContainerRegistryPlanRegistryLimitArgs:
    def __init__(__self__, *,
                 image_storage: Optional[pulumi.Input[int]] = None,
                 parallel_request: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] image_storage: Docker image storage limits in bytes
        :param pulumi.Input[int] parallel_request: Parallel requests on Docker image API (/v2 Docker registry API)
        """
        if image_storage is not None:
            pulumi.set(__self__, "image_storage", image_storage)
        if parallel_request is not None:
            pulumi.set(__self__, "parallel_request", parallel_request)

    @property
    @pulumi.getter(name="imageStorage")
    def image_storage(self) -> Optional[pulumi.Input[int]]:
        """
        Docker image storage limits in bytes
        """
        return pulumi.get(self, "image_storage")

    @image_storage.setter
    def image_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "image_storage", value)

    @property
    @pulumi.getter(name="parallelRequest")
    def parallel_request(self) -> Optional[pulumi.Input[int]]:
        """
        Parallel requests on Docker image API (/v2 Docker registry API)
        """
        return pulumi.get(self, "parallel_request")

    @parallel_request.setter
    def parallel_request(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parallel_request", value)


@pulumi.input_type
class DatabaseEndpointArgs:
    def __init__(__self__, *,
                 component: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 scheme: Optional[pulumi.Input[str]] = None,
                 ssl: Optional[pulumi.Input[bool]] = None,
                 ssl_mode: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] component: Type of component the URI relates to.
        :param pulumi.Input[str] domain: Domain of the cluster.
        :param pulumi.Input[str] path: Path of the endpoint.
        :param pulumi.Input[int] port: Connection port for the endpoint.
        :param pulumi.Input[str] scheme: Scheme used to generate the URI.
        :param pulumi.Input[bool] ssl: Defines whether the endpoint uses SSL.
        :param pulumi.Input[str] ssl_mode: SSL mode used to connect to the service if the SSL is enabled.
        :param pulumi.Input[str] uri: URI of the endpoint.
        """
        if component is not None:
            pulumi.set(__self__, "component", component)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def component(self) -> Optional[pulumi.Input[str]]:
        """
        Type of component the URI relates to.
        """
        return pulumi.get(self, "component")

    @component.setter
    def component(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "component", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        Domain of the cluster.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path of the endpoint.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Connection port for the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Scheme used to generate the URI.
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheme", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the endpoint uses SSL.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[str]]:
        """
        SSL mode used to connect to the service if the SSL is enabled.
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_mode", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI of the endpoint.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class DatabaseNodeArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[str],
                 network_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] region: Public cloud region in which the node should be deployed.
               Ex: "GRA'.
        :param pulumi.Input[str] network_id: Private network id in which the node should be deployed. It's the regional openstackId of the private network
        :param pulumi.Input[str] subnet_id: Private subnet ID in which the node is.
        """
        pulumi.set(__self__, "region", region)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Public cloud region in which the node should be deployed.
        Ex: "GRA'.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Private network id in which the node should be deployed. It's the regional openstackId of the private network
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Private subnet ID in which the node is.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class KubeCustomizationArgs:
    def __init__(__self__, *,
                 apiservers: Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationApiserverArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['KubeCustomizationApiserverArgs']]] apiservers: Kubernetes API server customization
        """
        if apiservers is not None:
            warnings.warn("""Use customization_apiserver instead""", DeprecationWarning)
            pulumi.log.warn("""apiservers is deprecated: Use customization_apiserver instead""")
        if apiservers is not None:
            pulumi.set(__self__, "apiservers", apiservers)

    @property
    @pulumi.getter
    def apiservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationApiserverArgs']]]]:
        """
        Kubernetes API server customization
        """
        return pulumi.get(self, "apiservers")

    @apiservers.setter
    def apiservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationApiserverArgs']]]]):
        pulumi.set(self, "apiservers", value)


@pulumi.input_type
class KubeCustomizationApiserverArgs:
    def __init__(__self__, *,
                 admissionplugins: Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationApiserverAdmissionpluginArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['KubeCustomizationApiserverAdmissionpluginArgs']]] admissionplugins: Kubernetes API server admission plugins customization
        """
        if admissionplugins is not None:
            pulumi.set(__self__, "admissionplugins", admissionplugins)

    @property
    @pulumi.getter
    def admissionplugins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationApiserverAdmissionpluginArgs']]]]:
        """
        Kubernetes API server admission plugins customization
        """
        return pulumi.get(self, "admissionplugins")

    @admissionplugins.setter
    def admissionplugins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationApiserverAdmissionpluginArgs']]]]):
        pulumi.set(self, "admissionplugins", value)


@pulumi.input_type
class KubeCustomizationApiserverAdmissionpluginArgs:
    def __init__(__self__, *,
                 disableds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enableds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disableds: Array of admission plugins disabled, default is [] and only AlwaysPulImages can be disabled at this time.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enableds: Array of admission plugins enabled, default is ["NodeRestriction","AlwaysPulImages"] and only these admission plugins can be enabled at this time.
        """
        if disableds is not None:
            pulumi.set(__self__, "disableds", disableds)
        if enableds is not None:
            pulumi.set(__self__, "enableds", enableds)

    @property
    @pulumi.getter
    def disableds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of admission plugins disabled, default is [] and only AlwaysPulImages can be disabled at this time.
        """
        return pulumi.get(self, "disableds")

    @disableds.setter
    def disableds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "disableds", value)

    @property
    @pulumi.getter
    def enableds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of admission plugins enabled, default is ["NodeRestriction","AlwaysPulImages"] and only these admission plugins can be enabled at this time.
        """
        return pulumi.get(self, "enableds")

    @enableds.setter
    def enableds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enableds", value)


@pulumi.input_type
class KubeCustomizationKubeProxyArgs:
    def __init__(__self__, *,
                 iptables: Optional[pulumi.Input['KubeCustomizationKubeProxyIptablesArgs']] = None,
                 ipvs: Optional[pulumi.Input['KubeCustomizationKubeProxyIpvsArgs']] = None):
        """
        :param pulumi.Input['KubeCustomizationKubeProxyIptablesArgs'] iptables: Kubernetes cluster kube-proxy customization of iptables specific config (durations format is RFC3339 duration, e.g. `PT60S`)
        :param pulumi.Input['KubeCustomizationKubeProxyIpvsArgs'] ipvs: Kubernetes cluster kube-proxy customization of IPVS specific config (durations format is [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration, e.g. `PT60S`)
        """
        if iptables is not None:
            pulumi.set(__self__, "iptables", iptables)
        if ipvs is not None:
            pulumi.set(__self__, "ipvs", ipvs)

    @property
    @pulumi.getter
    def iptables(self) -> Optional[pulumi.Input['KubeCustomizationKubeProxyIptablesArgs']]:
        """
        Kubernetes cluster kube-proxy customization of iptables specific config (durations format is RFC3339 duration, e.g. `PT60S`)
        """
        return pulumi.get(self, "iptables")

    @iptables.setter
    def iptables(self, value: Optional[pulumi.Input['KubeCustomizationKubeProxyIptablesArgs']]):
        pulumi.set(self, "iptables", value)

    @property
    @pulumi.getter
    def ipvs(self) -> Optional[pulumi.Input['KubeCustomizationKubeProxyIpvsArgs']]:
        """
        Kubernetes cluster kube-proxy customization of IPVS specific config (durations format is [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration, e.g. `PT60S`)
        """
        return pulumi.get(self, "ipvs")

    @ipvs.setter
    def ipvs(self, value: Optional[pulumi.Input['KubeCustomizationKubeProxyIpvsArgs']]):
        pulumi.set(self, "ipvs", value)


@pulumi.input_type
class KubeCustomizationKubeProxyIptablesArgs:
    def __init__(__self__, *,
                 min_sync_period: Optional[pulumi.Input[str]] = None,
                 sync_period: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] min_sync_period: Minimum period that IPVS rules are refreshed in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration (e.g. `PT60S`).
        :param pulumi.Input[str] sync_period: Minimum period that IPVS rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format (e.g. `PT60S`).
        """
        if min_sync_period is not None:
            pulumi.set(__self__, "min_sync_period", min_sync_period)
        if sync_period is not None:
            pulumi.set(__self__, "sync_period", sync_period)

    @property
    @pulumi.getter(name="minSyncPeriod")
    def min_sync_period(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum period that IPVS rules are refreshed in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration (e.g. `PT60S`).
        """
        return pulumi.get(self, "min_sync_period")

    @min_sync_period.setter
    def min_sync_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_sync_period", value)

    @property
    @pulumi.getter(name="syncPeriod")
    def sync_period(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum period that IPVS rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format (e.g. `PT60S`).
        """
        return pulumi.get(self, "sync_period")

    @sync_period.setter
    def sync_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sync_period", value)


@pulumi.input_type
class KubeCustomizationKubeProxyIpvsArgs:
    def __init__(__self__, *,
                 min_sync_period: Optional[pulumi.Input[str]] = None,
                 scheduler: Optional[pulumi.Input[str]] = None,
                 sync_period: Optional[pulumi.Input[str]] = None,
                 tcp_fin_timeout: Optional[pulumi.Input[str]] = None,
                 tcp_timeout: Optional[pulumi.Input[str]] = None,
                 udp_timeout: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] min_sync_period: Minimum period that IPVS rules are refreshed in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration (e.g. `PT60S`).
        :param pulumi.Input[str] scheduler: IPVS scheduler.
        :param pulumi.Input[str] sync_period: Minimum period that IPVS rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format (e.g. `PT60S`).
        :param pulumi.Input[str] tcp_fin_timeout: Timeout value used for IPVS TCP sessions after receiving a FIN in RFC3339 duration (e.g. `PT60S`). The default value is `PT0S`, which preserves the current timeout value on the system.
        :param pulumi.Input[str] tcp_timeout: Timeout value used for idle IPVS TCP sessions in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration (e.g. `PT60S`). The default value is `PT0S`, which preserves the current timeout value on the system.
        :param pulumi.Input[str] udp_timeout: timeout value used for IPVS UDP packets in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration (e.g. `PT60S`). The default value is `PT0S`, which preserves the current timeout value on the system.
        """
        if min_sync_period is not None:
            pulumi.set(__self__, "min_sync_period", min_sync_period)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if sync_period is not None:
            pulumi.set(__self__, "sync_period", sync_period)
        if tcp_fin_timeout is not None:
            pulumi.set(__self__, "tcp_fin_timeout", tcp_fin_timeout)
        if tcp_timeout is not None:
            pulumi.set(__self__, "tcp_timeout", tcp_timeout)
        if udp_timeout is not None:
            pulumi.set(__self__, "udp_timeout", udp_timeout)

    @property
    @pulumi.getter(name="minSyncPeriod")
    def min_sync_period(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum period that IPVS rules are refreshed in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration (e.g. `PT60S`).
        """
        return pulumi.get(self, "min_sync_period")

    @min_sync_period.setter
    def min_sync_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_sync_period", value)

    @property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input[str]]:
        """
        IPVS scheduler.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduler", value)

    @property
    @pulumi.getter(name="syncPeriod")
    def sync_period(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum period that IPVS rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format (e.g. `PT60S`).
        """
        return pulumi.get(self, "sync_period")

    @sync_period.setter
    def sync_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sync_period", value)

    @property
    @pulumi.getter(name="tcpFinTimeout")
    def tcp_fin_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Timeout value used for IPVS TCP sessions after receiving a FIN in RFC3339 duration (e.g. `PT60S`). The default value is `PT0S`, which preserves the current timeout value on the system.
        """
        return pulumi.get(self, "tcp_fin_timeout")

    @tcp_fin_timeout.setter
    def tcp_fin_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tcp_fin_timeout", value)

    @property
    @pulumi.getter(name="tcpTimeout")
    def tcp_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Timeout value used for idle IPVS TCP sessions in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration (e.g. `PT60S`). The default value is `PT0S`, which preserves the current timeout value on the system.
        """
        return pulumi.get(self, "tcp_timeout")

    @tcp_timeout.setter
    def tcp_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tcp_timeout", value)

    @property
    @pulumi.getter(name="udpTimeout")
    def udp_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        timeout value used for IPVS UDP packets in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration (e.g. `PT60S`). The default value is `PT0S`, which preserves the current timeout value on the system.
        """
        return pulumi.get(self, "udp_timeout")

    @udp_timeout.setter
    def udp_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "udp_timeout", value)


@pulumi.input_type
class KubeKubeconfigAttributeArgs:
    def __init__(__self__, *,
                 client_certificate: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 cluster_ca_certificate: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] client_certificate: The kubernetes API server client certificate.
        :param pulumi.Input[str] client_key: The kubernetes API server client key.
        :param pulumi.Input[str] cluster_ca_certificate: The kubernetes API server CA certificate.
        :param pulumi.Input[str] host: The kubernetes API server URL.
        """
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_certificate is not None:
            pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The kubernetes API server client certificate.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The kubernetes API server client key.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The kubernetes API server CA certificate.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @cluster_ca_certificate.setter
    def cluster_ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ca_certificate", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        The kubernetes API server URL.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)


@pulumi.input_type
class KubeNodePoolTemplateArgs:
    def __init__(__self__, *,
                 metadata: Optional[pulumi.Input['KubeNodePoolTemplateMetadataArgs']] = None,
                 spec: Optional[pulumi.Input['KubeNodePoolTemplateSpecArgs']] = None):
        """
        :param pulumi.Input['KubeNodePoolTemplateMetadataArgs'] metadata: Metadata of each node in the pool
        :param pulumi.Input['KubeNodePoolTemplateSpecArgs'] spec: Spec of each node in the pool
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['KubeNodePoolTemplateMetadataArgs']]:
        """
        Metadata of each node in the pool
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['KubeNodePoolTemplateMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['KubeNodePoolTemplateSpecArgs']]:
        """
        Spec of each node in the pool
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['KubeNodePoolTemplateSpecArgs']]):
        pulumi.set(self, "spec", value)


@pulumi.input_type
class KubeNodePoolTemplateMetadataArgs:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 finalizers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations to apply to each node
        :param pulumi.Input[Sequence[pulumi.Input[str]]] finalizers: Finalizers to apply to each node
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to each node
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if finalizers is not None:
            pulumi.set(__self__, "finalizers", finalizers)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations to apply to each node
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def finalizers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Finalizers to apply to each node
        """
        return pulumi.get(self, "finalizers")

    @finalizers.setter
    def finalizers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "finalizers", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to each node
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class KubeNodePoolTemplateSpecArgs:
    def __init__(__self__, *,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]] = None,
                 unschedulable: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]] taints: Taints to apply to each node
        :param pulumi.Input[bool] unschedulable: If true, set nodes as un-schedulable
        """
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if unschedulable is not None:
            pulumi.set(__self__, "unschedulable", unschedulable)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]]:
        """
        Taints to apply to each node
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter
    def unschedulable(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, set nodes as un-schedulable
        """
        return pulumi.get(self, "unschedulable")

    @unschedulable.setter
    def unschedulable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unschedulable", value)


@pulumi.input_type
class KubePrivateNetworkConfigurationArgs:
    def __init__(__self__, *,
                 default_vrack_gateway: pulumi.Input[str],
                 private_network_routing_as_default: pulumi.Input[bool]):
        """
        :param pulumi.Input[str] default_vrack_gateway: If defined, all egress traffic will be routed towards this IP address, which should belong to the private network. Empty string means disabled.
        :param pulumi.Input[bool] private_network_routing_as_default: Defines whether routing should default to using the nodes' private interface, instead of their public interface. Default is false.
        """
        pulumi.set(__self__, "default_vrack_gateway", default_vrack_gateway)
        pulumi.set(__self__, "private_network_routing_as_default", private_network_routing_as_default)

    @property
    @pulumi.getter(name="defaultVrackGateway")
    def default_vrack_gateway(self) -> pulumi.Input[str]:
        """
        If defined, all egress traffic will be routed towards this IP address, which should belong to the private network. Empty string means disabled.
        """
        return pulumi.get(self, "default_vrack_gateway")

    @default_vrack_gateway.setter
    def default_vrack_gateway(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_vrack_gateway", value)

    @property
    @pulumi.getter(name="privateNetworkRoutingAsDefault")
    def private_network_routing_as_default(self) -> pulumi.Input[bool]:
        """
        Defines whether routing should default to using the nodes' private interface, instead of their public interface. Default is false.
        """
        return pulumi.get(self, "private_network_routing_as_default")

    @private_network_routing_as_default.setter
    def private_network_routing_as_default(self, value: pulumi.Input[bool]):
        pulumi.set(self, "private_network_routing_as_default", value)


@pulumi.input_type
class NetworkPrivateRegionsAttributeArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[str],
                 openstackid: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] status: the status of the network. should be normally set to 'ACTIVE'.
        """
        pulumi.set(__self__, "status", status)
        if openstackid is not None:
            pulumi.set(__self__, "openstackid", openstackid)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        the status of the network. should be normally set to 'ACTIVE'.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def openstackid(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "openstackid")

    @openstackid.setter
    def openstackid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "openstackid", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class NetworkPrivateRegionsStatusArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] status: the status of the network. should be normally set to 'ACTIVE'.
        """
        pulumi.set(__self__, "status", status)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        the status of the network. should be normally set to 'ACTIVE'.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class NetworkPrivateSubnetIpPoolArgs:
    def __init__(__self__, *,
                 dhcp: Optional[pulumi.Input[bool]] = None,
                 end: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] dhcp: Enable DHCP.
               Changing this forces a new resource to be created. Defaults to false.
               _
        :param pulumi.Input[str] end: Last ip for this region.
               Changing this value recreates the subnet.
        :param pulumi.Input[str] network: Global network in CIDR format.
               Changing this value recreates the subnet
        :param pulumi.Input[str] region: The region in which the network subnet will be created.
               Ex.: "GRA1". Changing this value recreates the resource.
        :param pulumi.Input[str] start: First ip for this region.
               Changing this value recreates the subnet.
        """
        if dhcp is not None:
            pulumi.set(__self__, "dhcp", dhcp)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def dhcp(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable DHCP.
        Changing this forces a new resource to be created. Defaults to false.
        _
        """
        return pulumi.get(self, "dhcp")

    @dhcp.setter
    def dhcp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcp", value)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[str]]:
        """
        Last ip for this region.
        Changing this value recreates the subnet.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        Global network in CIDR format.
        Changing this value recreates the subnet
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which the network subnet will be created.
        Ex.: "GRA1". Changing this value recreates the resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[str]]:
        """
        First ip for this region.
        Changing this value recreates the subnet.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class ProjectOrderArgs:
    def __init__(__self__, *,
                 date: Optional[pulumi.Input[str]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectOrderDetailArgs']]]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 order_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] date: date
        :param pulumi.Input[Sequence[pulumi.Input['ProjectOrderDetailArgs']]] details: Information about a Bill entry
        :param pulumi.Input[str] expiration_date: expiration date
        :param pulumi.Input[int] order_id: order id, the same as the `id`
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @property
    @pulumi.getter
    def date(self) -> Optional[pulumi.Input[str]]:
        """
        date
        """
        return pulumi.get(self, "date")

    @date.setter
    def date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectOrderDetailArgs']]]]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectOrderDetailArgs']]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[pulumi.Input[int]]:
        """
        order id, the same as the `id`
        """
        return pulumi.get(self, "order_id")

    @order_id.setter
    def order_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order_id", value)


@pulumi.input_type
class ProjectOrderDetailArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 order_detail_id: Optional[pulumi.Input[int]] = None,
                 quantity: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: A description associated with the user.
        :param pulumi.Input[str] domain: expiration date
        :param pulumi.Input[int] order_detail_id: order detail id
        :param pulumi.Input[str] quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description associated with the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[pulumi.Input[int]]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @order_detail_id.setter
    def order_detail_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order_detail_id", value)

    @property
    @pulumi.getter
    def quantity(self) -> Optional[pulumi.Input[str]]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quantity", value)


@pulumi.input_type
class ProjectPlanArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[str],
                 plan_code: pulumi.Input[str],
                 pricing_mode: pulumi.Input[str],
                 catalog_name: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectPlanConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[str] duration: duration
        :param pulumi.Input[str] plan_code: Plan code
        :param pulumi.Input[str] pricing_mode: Pricing model identifier
        :param pulumi.Input[str] catalog_name: Catalog name
        :param pulumi.Input[Sequence[pulumi.Input['ProjectPlanConfigurationArgs']]] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[str]:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Input[str]:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_code", value)

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> pulumi.Input[str]:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @pricing_mode.setter
    def pricing_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "pricing_mode", value)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[str]]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_name", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectPlanConfigurationArgs']]]]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectPlanConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)


@pulumi.input_type
class ProjectPlanConfigurationArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Identifier of the resource
        :param pulumi.Input[str] value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ProjectPlanOptionArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[str],
                 plan_code: pulumi.Input[str],
                 pricing_mode: pulumi.Input[str],
                 catalog_name: Optional[pulumi.Input[str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectPlanOptionConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[str] duration: duration
        :param pulumi.Input[str] plan_code: Plan code
        :param pulumi.Input[str] pricing_mode: Pricing model identifier
        :param pulumi.Input[str] catalog_name: Catalog name
        :param pulumi.Input[Sequence[pulumi.Input['ProjectPlanOptionConfigurationArgs']]] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[str]:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Input[str]:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_code", value)

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> pulumi.Input[str]:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @pricing_mode.setter
    def pricing_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "pricing_mode", value)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[str]]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_name", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectPlanOptionConfigurationArgs']]]]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectPlanOptionConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)


@pulumi.input_type
class ProjectPlanOptionConfigurationArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Identifier of the resource
        :param pulumi.Input[str] value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class UserRoleArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] description: A description associated with the user.
        :param pulumi.Input[str] id: id of the role
        :param pulumi.Input[str] name: name of the role
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: list of permissions associated with the role
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description associated with the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        id of the role
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the role
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        list of permissions associated with the role
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class GetKubeCustomizationArgs:
    def __init__(__self__, *,
                 apiservers: Sequence['GetKubeCustomizationApiserverArgs']):
        """
        :param Sequence['GetKubeCustomizationApiserverArgs'] apiservers: Kubernetes API server customization
        """
        if apiservers is not None:
            warnings.warn("""Use customization_apiserver instead""", DeprecationWarning)
            pulumi.log.warn("""apiservers is deprecated: Use customization_apiserver instead""")
        pulumi.set(__self__, "apiservers", apiservers)

    @property
    @pulumi.getter
    def apiservers(self) -> Sequence['GetKubeCustomizationApiserverArgs']:
        """
        Kubernetes API server customization
        """
        return pulumi.get(self, "apiservers")

    @apiservers.setter
    def apiservers(self, value: Sequence['GetKubeCustomizationApiserverArgs']):
        pulumi.set(self, "apiservers", value)


@pulumi.input_type
class GetKubeCustomizationApiserverArgs:
    def __init__(__self__, *,
                 admissionplugins: Sequence['GetKubeCustomizationApiserverAdmissionpluginArgs']):
        """
        :param Sequence['GetKubeCustomizationApiserverAdmissionpluginArgs'] admissionplugins: Kubernetes API server admission plugins customization
        """
        pulumi.set(__self__, "admissionplugins", admissionplugins)

    @property
    @pulumi.getter
    def admissionplugins(self) -> Sequence['GetKubeCustomizationApiserverAdmissionpluginArgs']:
        """
        Kubernetes API server admission plugins customization
        """
        return pulumi.get(self, "admissionplugins")

    @admissionplugins.setter
    def admissionplugins(self, value: Sequence['GetKubeCustomizationApiserverAdmissionpluginArgs']):
        pulumi.set(self, "admissionplugins", value)


@pulumi.input_type
class GetKubeCustomizationApiserverAdmissionpluginArgs:
    def __init__(__self__, *,
                 disableds: Sequence[str],
                 enableds: Sequence[str]):
        """
        :param Sequence[str] disableds: Array of admission plugins disabled, default is [] and only AlwaysPulImages can be disabled at this time.
        :param Sequence[str] enableds: Array of admission plugins enabled, default is ["NodeRestriction","AlwaysPulImages"] and only these admission plugins can be enabled at this time.
        """
        pulumi.set(__self__, "disableds", disableds)
        pulumi.set(__self__, "enableds", enableds)

    @property
    @pulumi.getter
    def disableds(self) -> Sequence[str]:
        """
        Array of admission plugins disabled, default is [] and only AlwaysPulImages can be disabled at this time.
        """
        return pulumi.get(self, "disableds")

    @disableds.setter
    def disableds(self, value: Sequence[str]):
        pulumi.set(self, "disableds", value)

    @property
    @pulumi.getter
    def enableds(self) -> Sequence[str]:
        """
        Array of admission plugins enabled, default is ["NodeRestriction","AlwaysPulImages"] and only these admission plugins can be enabled at this time.
        """
        return pulumi.get(self, "enableds")

    @enableds.setter
    def enableds(self, value: Sequence[str]):
        pulumi.set(self, "enableds", value)


@pulumi.input_type
class GetKubeCustomizationKubeProxyArgs:
    def __init__(__self__, *,
                 iptables: Optional['GetKubeCustomizationKubeProxyIptablesArgs'] = None,
                 ipvs: Optional['GetKubeCustomizationKubeProxyIpvsArgs'] = None):
        """
        :param 'GetKubeCustomizationKubeProxyIptablesArgs' iptables: Kubernetes cluster kube-proxy customization of iptables specific config.
        :param 'GetKubeCustomizationKubeProxyIpvsArgs' ipvs: Kubernetes cluster kube-proxy customization of IPVS specific config (durations format is [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        """
        if iptables is not None:
            pulumi.set(__self__, "iptables", iptables)
        if ipvs is not None:
            pulumi.set(__self__, "ipvs", ipvs)

    @property
    @pulumi.getter
    def iptables(self) -> Optional['GetKubeCustomizationKubeProxyIptablesArgs']:
        """
        Kubernetes cluster kube-proxy customization of iptables specific config.
        """
        return pulumi.get(self, "iptables")

    @iptables.setter
    def iptables(self, value: Optional['GetKubeCustomizationKubeProxyIptablesArgs']):
        pulumi.set(self, "iptables", value)

    @property
    @pulumi.getter
    def ipvs(self) -> Optional['GetKubeCustomizationKubeProxyIpvsArgs']:
        """
        Kubernetes cluster kube-proxy customization of IPVS specific config (durations format is [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        """
        return pulumi.get(self, "ipvs")

    @ipvs.setter
    def ipvs(self, value: Optional['GetKubeCustomizationKubeProxyIpvsArgs']):
        pulumi.set(self, "ipvs", value)


@pulumi.input_type
class GetKubeCustomizationKubeProxyIptablesArgs:
    def __init__(__self__, *,
                 min_sync_period: Optional[str] = None,
                 sync_period: Optional[str] = None):
        """
        :param str min_sync_period: Minimum period that IPVS rules are refreshed in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        :param str sync_period: Minimum period that IPVS rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format.
        """
        if min_sync_period is not None:
            pulumi.set(__self__, "min_sync_period", min_sync_period)
        if sync_period is not None:
            pulumi.set(__self__, "sync_period", sync_period)

    @property
    @pulumi.getter(name="minSyncPeriod")
    def min_sync_period(self) -> Optional[str]:
        """
        Minimum period that IPVS rules are refreshed in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        """
        return pulumi.get(self, "min_sync_period")

    @min_sync_period.setter
    def min_sync_period(self, value: Optional[str]):
        pulumi.set(self, "min_sync_period", value)

    @property
    @pulumi.getter(name="syncPeriod")
    def sync_period(self) -> Optional[str]:
        """
        Minimum period that IPVS rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format.
        """
        return pulumi.get(self, "sync_period")

    @sync_period.setter
    def sync_period(self, value: Optional[str]):
        pulumi.set(self, "sync_period", value)


@pulumi.input_type
class GetKubeCustomizationKubeProxyIpvsArgs:
    def __init__(__self__, *,
                 min_sync_period: Optional[str] = None,
                 scheduler: Optional[str] = None,
                 sync_period: Optional[str] = None,
                 tcp_fin_timeout: Optional[str] = None,
                 tcp_timeout: Optional[str] = None,
                 udp_timeout: Optional[str] = None):
        """
        :param str min_sync_period: Minimum period that IPVS rules are refreshed in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        :param str scheduler: IPVS scheduler.
        :param str sync_period: Minimum period that IPVS rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format.
        :param str tcp_fin_timeout: Timeout value used for IPVS TCP sessions after receiving a FIN in RFC3339 duration.
        :param str tcp_timeout: Timeout value used for idle IPVS TCP sessions in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        :param str udp_timeout: timeout value used for IPVS UDP packets in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        """
        if min_sync_period is not None:
            pulumi.set(__self__, "min_sync_period", min_sync_period)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if sync_period is not None:
            pulumi.set(__self__, "sync_period", sync_period)
        if tcp_fin_timeout is not None:
            pulumi.set(__self__, "tcp_fin_timeout", tcp_fin_timeout)
        if tcp_timeout is not None:
            pulumi.set(__self__, "tcp_timeout", tcp_timeout)
        if udp_timeout is not None:
            pulumi.set(__self__, "udp_timeout", udp_timeout)

    @property
    @pulumi.getter(name="minSyncPeriod")
    def min_sync_period(self) -> Optional[str]:
        """
        Minimum period that IPVS rules are refreshed in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        """
        return pulumi.get(self, "min_sync_period")

    @min_sync_period.setter
    def min_sync_period(self, value: Optional[str]):
        pulumi.set(self, "min_sync_period", value)

    @property
    @pulumi.getter
    def scheduler(self) -> Optional[str]:
        """
        IPVS scheduler.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[str]):
        pulumi.set(self, "scheduler", value)

    @property
    @pulumi.getter(name="syncPeriod")
    def sync_period(self) -> Optional[str]:
        """
        Minimum period that IPVS rules are refreshed, in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration format.
        """
        return pulumi.get(self, "sync_period")

    @sync_period.setter
    def sync_period(self, value: Optional[str]):
        pulumi.set(self, "sync_period", value)

    @property
    @pulumi.getter(name="tcpFinTimeout")
    def tcp_fin_timeout(self) -> Optional[str]:
        """
        Timeout value used for IPVS TCP sessions after receiving a FIN in RFC3339 duration.
        """
        return pulumi.get(self, "tcp_fin_timeout")

    @tcp_fin_timeout.setter
    def tcp_fin_timeout(self, value: Optional[str]):
        pulumi.set(self, "tcp_fin_timeout", value)

    @property
    @pulumi.getter(name="tcpTimeout")
    def tcp_timeout(self) -> Optional[str]:
        """
        Timeout value used for idle IPVS TCP sessions in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        """
        return pulumi.get(self, "tcp_timeout")

    @tcp_timeout.setter
    def tcp_timeout(self, value: Optional[str]):
        pulumi.set(self, "tcp_timeout", value)

    @property
    @pulumi.getter(name="udpTimeout")
    def udp_timeout(self) -> Optional[str]:
        """
        timeout value used for IPVS UDP packets in [RFC3339](https://www.rfc-editor.org/rfc/rfc3339) duration.
        """
        return pulumi.get(self, "udp_timeout")

    @udp_timeout.setter
    def udp_timeout(self, value: Optional[str]):
        pulumi.set(self, "udp_timeout", value)


@pulumi.input_type
class GetKubeNodePoolTemplateArgs:
    def __init__(__self__, *,
                 metadata: Optional['GetKubeNodePoolTemplateMetadataArgs'] = None,
                 spec: Optional['GetKubeNodePoolTemplateSpecArgs'] = None):
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional['GetKubeNodePoolTemplateMetadataArgs']:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional['GetKubeNodePoolTemplateMetadataArgs']):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional['GetKubeNodePoolTemplateSpecArgs']:
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional['GetKubeNodePoolTemplateSpecArgs']):
        pulumi.set(self, "spec", value)


@pulumi.input_type
class GetKubeNodePoolTemplateMetadataArgs:
    def __init__(__self__, *,
                 annotations: Optional[Mapping[str, str]] = None,
                 finalizers: Optional[Sequence[str]] = None,
                 labels: Optional[Mapping[str, str]] = None):
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if finalizers is not None:
            pulumi.set(__self__, "finalizers", finalizers)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[Mapping[str, str]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def finalizers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "finalizers")

    @finalizers.setter
    def finalizers(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "finalizers", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[Mapping[str, str]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class GetKubeNodePoolTemplateSpecArgs:
    def __init__(__self__, *,
                 taints: Optional[Sequence[Mapping[str, Any]]] = None,
                 unschedulable: Optional[bool] = None):
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if unschedulable is not None:
            pulumi.set(__self__, "unschedulable", unschedulable)

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence[Mapping[str, Any]]]:
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[Sequence[Mapping[str, Any]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter
    def unschedulable(self) -> Optional[bool]:
        return pulumi.get(self, "unschedulable")

    @unschedulable.setter
    def unschedulable(self, value: Optional[bool]):
        pulumi.set(self, "unschedulable", value)


