"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolClientRedirects = void 0;
const core_1 = require("@aws-cdk/core");
const custom_resources_1 = require("@aws-cdk/custom-resources");
class UserPoolClientRedirects extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new custom_resources_1.AwsCustomResource(this, 'Resource', {
            onUpdate: {
                service: 'CognitoIdentityServiceProvider',
                action: 'updateUserPoolClient',
                parameters: {
                    UserPoolId: props.userPool.userPoolId,
                    ClientId: props.userPoolClient.userPoolClientId,
                    AllowedOAuthFlows: ['code'],
                    AllowedOAuthFlowsUserPoolClient: true,
                    SupportedIdentityProviders: props.identityProviders.map((provider) => provider.name),
                    AllowedOAuthScopes: props.oauthScopes.map((scope) => scope.scopeName),
                    CallbackURLs: props.callbackUrls,
                    LogoutURLs: props.logoutUrls,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(`${props.userPool.userPoolId}-${props.userPoolClient.userPoolClientId}-updated-client`),
            },
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: [props.userPool.userPoolArn],
            }),
        });
    }
}
exports.UserPoolClientRedirects = UserPoolClientRedirects;
//# sourceMappingURL=data:application/json;base64,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