# pulp_ansible-client
Fetch, Upload, Organize, and Distribute Software Packages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 0.2.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pulpproject.org](https://pulpproject.org)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_ansible
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_ansible
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import pulpcore.client.pulp_ansible
from pulpcore.client.pulp_ansible.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://pulp
# See configuration.py for a list of all supported configuration parameters.
configuration = pulpcore.client.pulp_ansible.Configuration(
    host = "http://pulp"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = pulpcore.client.pulp_ansible.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure API key authorization: cookieAuth
configuration = pulpcore.client.pulp_ansible.Configuration(
    host = "http://pulp",
    api_key = {
        'Session': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Session'] = 'Bearer'


# Enter a context with an instance of the API client
with pulpcore.client.pulp_ansible.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_ansible.AnsibleCollectionsApi(api_client)
    file = '/path/to/file' # file | The Collection tarball.
sha256 = 'sha256_example' # str | An optional sha256 checksum of the uploaded file. (optional)
expected_namespace = 'expected_namespace_example' # str | The expected 'namespace' of the Collection to be verified against the metadata during import. (optional)
expected_name = 'expected_name_example' # str | The expected 'name' of the Collection to be verified against the metadata during import. (optional)
expected_version = 'expected_version_example' # str | The expected version of the Collection to be verified against the metadata during import. (optional)

    try:
        # Upload a collection
        api_response = api_instance.create(file, sha256=sha256, expected_namespace=expected_namespace, expected_name=expected_name, expected_version=expected_version)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AnsibleCollectionsApi->create: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://pulp*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnsibleCollectionsApi* | [**create**](docs/AnsibleCollectionsApi.md#create) | **POST** /ansible/collections/ | Upload a collection
*AnsibleCollectionsApi* | [**list**](docs/AnsibleCollectionsApi.md#list) | **GET** /pulp/api/v3/ansible/collections/ | List collections
*CollectionImportApi* | [**read**](docs/CollectionImportApi.md#read) | **GET** {ansible_collection_import_href} | Inspect a collection import
*ContentCollectionVersionsApi* | [**create**](docs/ContentCollectionVersionsApi.md#create) | **POST** /pulp/api/v3/content/ansible/collection_versions/ | Create a collection version
*ContentCollectionVersionsApi* | [**list**](docs/ContentCollectionVersionsApi.md#list) | **GET** /pulp/api/v3/content/ansible/collection_versions/ | List collection versions
*ContentCollectionVersionsApi* | [**read**](docs/ContentCollectionVersionsApi.md#read) | **GET** {ansible_collection_version_href} | Inspect a collection version
*ContentRolesApi* | [**create**](docs/ContentRolesApi.md#create) | **POST** /pulp/api/v3/content/ansible/roles/ | Create a role
*ContentRolesApi* | [**list**](docs/ContentRolesApi.md#list) | **GET** /pulp/api/v3/content/ansible/roles/ | List roles
*ContentRolesApi* | [**read**](docs/ContentRolesApi.md#read) | **GET** {ansible_role_href} | Inspect a role
*DistributionsAnsibleApi* | [**create**](docs/DistributionsAnsibleApi.md#create) | **POST** /pulp/api/v3/distributions/ansible/ansible/ | Create an ansible distribution
*DistributionsAnsibleApi* | [**delete**](docs/DistributionsAnsibleApi.md#delete) | **DELETE** {ansible_ansible_distribution_href} | Delete an ansible distribution
*DistributionsAnsibleApi* | [**list**](docs/DistributionsAnsibleApi.md#list) | **GET** /pulp/api/v3/distributions/ansible/ansible/ | List ansible distributions
*DistributionsAnsibleApi* | [**partial_update**](docs/DistributionsAnsibleApi.md#partial_update) | **PATCH** {ansible_ansible_distribution_href} | Update an ansible distribution
*DistributionsAnsibleApi* | [**read**](docs/DistributionsAnsibleApi.md#read) | **GET** {ansible_ansible_distribution_href} | Inspect an ansible distribution
*DistributionsAnsibleApi* | [**update**](docs/DistributionsAnsibleApi.md#update) | **PUT** {ansible_ansible_distribution_href} | Update an ansible distribution
*GalaxyCollectionListApi* | [**list**](docs/GalaxyCollectionListApi.md#list) | **GET** {ansible_collection_version_href}versions/ | 
*GalaxyDetailApi* | [**read**](docs/GalaxyDetailApi.md#read) | **GET** {ansible_collection_href} | 
*PulpAnsibleApiApi* | [**read**](docs/PulpAnsibleApiApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/ | 
*PulpAnsibleGalaxyApiCollectionsApi* | [**list**](docs/PulpAnsibleGalaxyApiCollectionsApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/ | 
*PulpAnsibleGalaxyApiCollectionsApi* | [**read**](docs/PulpAnsibleGalaxyApiCollectionsApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleGalaxyApiCollectionsApi* | [**update**](docs/PulpAnsibleGalaxyApiCollectionsApi.md#update) | **PUT** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/ | 
*PulpAnsibleGalaxyApiV2VersionsApi* | [**read**](docs/PulpAnsibleGalaxyApiV2VersionsApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v2/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleGalaxyApiV3CollectionsApi* | [**create**](docs/PulpAnsibleGalaxyApiV3CollectionsApi.md#create) | **POST** /pulp_ansible/galaxy/{path}/api/v3/artifacts/collections/ | Upload a collection
*PulpAnsibleGalaxyApiV3CollectionsCertifiedApi* | [**set_certified**](docs/PulpAnsibleGalaxyApiV3CollectionsCertifiedApi.md#set_certified) | **PUT** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/versions/{version}/certified/ | 
*PulpAnsibleGalaxyApiV3VersionsApi* | [**list**](docs/PulpAnsibleGalaxyApiV3VersionsApi.md#list) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/versions/ | 
*PulpAnsibleGalaxyApiV3VersionsApi* | [**read**](docs/PulpAnsibleGalaxyApiV3VersionsApi.md#read) | **GET** /pulp_ansible/galaxy/{path}/api/v3/collections/{namespace}/{name}/versions/{version}/ | 
*PulpAnsibleTagsApi* | [**list**](docs/PulpAnsibleTagsApi.md#list) | **GET** /pulp/api/v3/pulp_ansible/tags/ | List tags
*RemotesCollectionApi* | [**create**](docs/RemotesCollectionApi.md#create) | **POST** /pulp/api/v3/remotes/ansible/collection/ | Create a collection remote
*RemotesCollectionApi* | [**delete**](docs/RemotesCollectionApi.md#delete) | **DELETE** {ansible_collection_remote_href} | Delete a collection remote
*RemotesCollectionApi* | [**list**](docs/RemotesCollectionApi.md#list) | **GET** /pulp/api/v3/remotes/ansible/collection/ | List collection remotes
*RemotesCollectionApi* | [**partial_update**](docs/RemotesCollectionApi.md#partial_update) | **PATCH** {ansible_collection_remote_href} | Update a collection remote
*RemotesCollectionApi* | [**read**](docs/RemotesCollectionApi.md#read) | **GET** {ansible_collection_remote_href} | Inspect a collection remote
*RemotesCollectionApi* | [**update**](docs/RemotesCollectionApi.md#update) | **PUT** {ansible_collection_remote_href} | Update a collection remote
*RemotesRoleApi* | [**create**](docs/RemotesRoleApi.md#create) | **POST** /pulp/api/v3/remotes/ansible/role/ | Create a role remote
*RemotesRoleApi* | [**delete**](docs/RemotesRoleApi.md#delete) | **DELETE** {ansible_role_remote_href} | Delete a role remote
*RemotesRoleApi* | [**list**](docs/RemotesRoleApi.md#list) | **GET** /pulp/api/v3/remotes/ansible/role/ | List role remotes
*RemotesRoleApi* | [**partial_update**](docs/RemotesRoleApi.md#partial_update) | **PATCH** {ansible_role_remote_href} | Update a role remote
*RemotesRoleApi* | [**read**](docs/RemotesRoleApi.md#read) | **GET** {ansible_role_remote_href} | Inspect a role remote
*RemotesRoleApi* | [**update**](docs/RemotesRoleApi.md#update) | **PUT** {ansible_role_remote_href} | Update a role remote
*RepositoriesAnsibleApi* | [**create**](docs/RepositoriesAnsibleApi.md#create) | **POST** /pulp/api/v3/repositories/ansible/ansible/ | Create an ansible repository
*RepositoriesAnsibleApi* | [**delete**](docs/RepositoriesAnsibleApi.md#delete) | **DELETE** {ansible_ansible_repository_href} | Delete an ansible repository
*RepositoriesAnsibleApi* | [**list**](docs/RepositoriesAnsibleApi.md#list) | **GET** /pulp/api/v3/repositories/ansible/ansible/ | List ansible repositorys
*RepositoriesAnsibleApi* | [**modify**](docs/RepositoriesAnsibleApi.md#modify) | **POST** {ansible_ansible_repository_href}modify/ | Modify Repository Content
*RepositoriesAnsibleApi* | [**partial_update**](docs/RepositoriesAnsibleApi.md#partial_update) | **PATCH** {ansible_ansible_repository_href} | Update an ansible repository
*RepositoriesAnsibleApi* | [**read**](docs/RepositoriesAnsibleApi.md#read) | **GET** {ansible_ansible_repository_href} | Inspect an ansible repository
*RepositoriesAnsibleApi* | [**sync**](docs/RepositoriesAnsibleApi.md#sync) | **POST** {ansible_ansible_repository_href}sync/ | 
*RepositoriesAnsibleApi* | [**update**](docs/RepositoriesAnsibleApi.md#update) | **PUT** {ansible_ansible_repository_href} | Update an ansible repository
*RepositoriesAnsibleVersionsApi* | [**delete**](docs/RepositoriesAnsibleVersionsApi.md#delete) | **DELETE** {ansible_ansible_repository_version_href} | Delete a repository version
*RepositoriesAnsibleVersionsApi* | [**list**](docs/RepositoriesAnsibleVersionsApi.md#list) | **GET** {ansible_ansible_repository_href}versions/ | List repository versions
*RepositoriesAnsibleVersionsApi* | [**read**](docs/RepositoriesAnsibleVersionsApi.md#read) | **GET** {ansible_ansible_repository_version_href} | Inspect a repository version
*RepositoriesAnsibleVersionsApi* | [**repair**](docs/RepositoriesAnsibleVersionsApi.md#repair) | **POST** {ansible_ansible_repository_version_href}repair/ | 
*RoleListApi* | [**list**](docs/RoleListApi.md#list) | **GET** {ansible_role_href}versions/ | 
*V1RolesApi* | [**list**](docs/V1RolesApi.md#list) | **GET** {ansible_role_href}api/v1/roles/ | 
*V2CollectionsApi* | [**create**](docs/V2CollectionsApi.md#create) | **POST** {ansible_collection_href}api/v2/collections/ | 
*V2CollectionsApi* | [**list**](docs/V2CollectionsApi.md#list) | **GET** {ansible_collection_href}api/v2/collections/ | 


## Documentation For Models

 - [AnsibleAnsibleDistribution](docs/AnsibleAnsibleDistribution.md)
 - [AnsibleAnsibleDistributionResponse](docs/AnsibleAnsibleDistributionResponse.md)
 - [AnsibleAnsibleRepository](docs/AnsibleAnsibleRepository.md)
 - [AnsibleAnsibleRepositoryResponse](docs/AnsibleAnsibleRepositoryResponse.md)
 - [AnsibleCollectionRemote](docs/AnsibleCollectionRemote.md)
 - [AnsibleCollectionRemoteResponse](docs/AnsibleCollectionRemoteResponse.md)
 - [AnsibleCollectionResponse](docs/AnsibleCollectionResponse.md)
 - [AnsibleCollectionVersion](docs/AnsibleCollectionVersion.md)
 - [AnsibleCollectionVersionResponse](docs/AnsibleCollectionVersionResponse.md)
 - [AnsibleRole](docs/AnsibleRole.md)
 - [AnsibleRoleRemote](docs/AnsibleRoleRemote.md)
 - [AnsibleRoleRemoteResponse](docs/AnsibleRoleRemoteResponse.md)
 - [AnsibleRoleResponse](docs/AnsibleRoleResponse.md)
 - [AnsibleTagResponse](docs/AnsibleTagResponse.md)
 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [CertificationEnum](docs/CertificationEnum.md)
 - [Collection](docs/Collection.md)
 - [CollectionImportDetailResponse](docs/CollectionImportDetailResponse.md)
 - [CollectionMetadata](docs/CollectionMetadata.md)
 - [CollectionMetadataResponse](docs/CollectionMetadataResponse.md)
 - [CollectionNamespace](docs/CollectionNamespace.md)
 - [CollectionNamespaceResponse](docs/CollectionNamespaceResponse.md)
 - [CollectionOneShot](docs/CollectionOneShot.md)
 - [CollectionRef](docs/CollectionRef.md)
 - [CollectionRefResponse](docs/CollectionRefResponse.md)
 - [CollectionResponse](docs/CollectionResponse.md)
 - [CollectionVersion](docs/CollectionVersion.md)
 - [CollectionVersionResponse](docs/CollectionVersionResponse.md)
 - [ContentSummary](docs/ContentSummary.md)
 - [ContentSummaryResponse](docs/ContentSummaryResponse.md)
 - [GalaxyCollection](docs/GalaxyCollection.md)
 - [GalaxyCollectionResponse](docs/GalaxyCollectionResponse.md)
 - [GalaxyCollectionVersionResponse](docs/GalaxyCollectionVersionResponse.md)
 - [GalaxyRoleResponse](docs/GalaxyRoleResponse.md)
 - [GalaxyRoleVersionResponse](docs/GalaxyRoleVersionResponse.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse20010](docs/InlineResponse20010.md)
 - [InlineResponse20011](docs/InlineResponse20011.md)
 - [InlineResponse20012](docs/InlineResponse20012.md)
 - [InlineResponse20013](docs/InlineResponse20013.md)
 - [InlineResponse20014](docs/InlineResponse20014.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [InlineResponse2007](docs/InlineResponse2007.md)
 - [InlineResponse2008](docs/InlineResponse2008.md)
 - [InlineResponse2009](docs/InlineResponse2009.md)
 - [PatchedansibleAnsibleDistribution](docs/PatchedansibleAnsibleDistribution.md)
 - [PatchedansibleAnsibleRepository](docs/PatchedansibleAnsibleRepository.md)
 - [PatchedansibleCollectionRemote](docs/PatchedansibleCollectionRemote.md)
 - [PatchedansibleRoleRemote](docs/PatchedansibleRoleRemote.md)
 - [PolicyEnum](docs/PolicyEnum.md)
 - [RepositoryAddRemoveContent](docs/RepositoryAddRemoveContent.md)
 - [RepositorySyncURL](docs/RepositorySyncURL.md)
 - [RepositoryVersion](docs/RepositoryVersion.md)
 - [RepositoryVersionResponse](docs/RepositoryVersionResponse.md)
 - [TagResponse](docs/TagResponse.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## cookieAuth

- **Type**: API key
- **API key parameter name**: Session
- **Location**: 


## Author

pulp-list@redhat.com


