# LPDENSITY

The `lpdensity` package provides Stata and R implementations of bandwidth selection, point estimation and inference procedures for local polynomial distribution and density methods.

This work was supported by the National Science Foundation through grant SES-1459931, SES-1459967, SES-1947805 and SES-1947662.

## Authors

Matias D. Cattaneo (<cattaneo@princeton.edu>)

Xinwei Ma (<x1ma@ucsd.edu>)

Michael Jansson (<mjansson@econ.berkeley.edu>)

Rajita Chandak (maintainer) (<rchandak@princeton.edu>)

## Website

https://nppackages.github.io/lpdensity/

## ReadTheDocs Manual
https://lpdensity.readthedocs.io/en/latest/

## Installation
To install/update use pip
```
pip install lpdensity
```

# Usage
```
from lpdensity import lpdensity, lpbwdensity
```
## Dependencies
- numpy
- pandas
- math
- scipy
- plotnine

## References

For overviews and introductions, see [lpdensity website](https://nppackages.github.io/lpdensity/)

### Software Implementation

-Cattaneo, Jansson and Ma (2021): [lpdensity: Local Polynomial Density Estimation and Inference.](https://nppackages.github.io/references/Cattaneo-Jansson-Ma_2021_JSS.pdf). <br>
Journal of Statistical Software, forthcoming.

### Technical and Methodological

- Cattaneo, Jansson and Ma (2020): [Simple Local Polynomial Density Estimators.](https://nppackages.github.io/references/Cattaneo-Jansson-Ma_2020_JASA.pdf).<br>
Journal of the American Statistical Association 115(531): 1449-1455.
[Supplemental Appendix](https://nppackages.github.io/references/Cattaneo-Jansson-Ma_2020_JASA--Supplement.pdf).

- Cattaneo, Jansson and Ma (2021): [Local Regression Distribution Estimators](https://nppackages.github.io/references/Cattaneo-Jansson-Ma_2021_JoE.pdf).<br>
Journal of Econometrics, forthcoming.<br>
[Supplemental Appendix](https://nppackages.github.io/references/Cattaneo-Jansson-Ma_2021_JoE--Supplement.pdf).

<br><br> 
