# coding: utf-8

"""
    EOD STOCK API

     <h2>Intelligent EOD Stocks API</h2>     <p>     End of day stock world wide STOCK API, this api is intended for use by web application developers,      and service providers looking for up-to-date always available.     <ul>         <li>Exchange Information</li>         <li>Stock Tickers Data</li>         <li>End of Day (EOD) Stock Data</li>         <li>Fundamental Data</li>         <li>Stock Options And Splits Data</li>         <li>Financial News API</li>         <li>Social Media Trend Data For Stocks</li>         <li>Sentiment Analysis for News & Social Media</li>     </ul>                The information provided covers more than 150 000 tickers, stocks, mutual funds and more around the world.         we provide information for any period, including daily, weekly.     </p>    # noqa: E501

    The version of the OpenAPI document: v1
    Contact: support@eod-stock-api.site
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from src.IntelligentStockMarketAPI.api_client import ApiClient
from src.IntelligentStockMarketAPI.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class EodApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def v1_eod_date_exchange_code_get(self, date, exchange_code, **kwargs):  # noqa: E501
        """v1_eod_date_exchange_code_get  # noqa: E501

        will return end of day data for a certain stock at a given date  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_eod_date_exchange_code_get(date, exchange_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str date: (required)
        :param str exchange_code: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EODStockResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_eod_date_exchange_code_get_with_http_info(date, exchange_code, **kwargs)  # noqa: E501

    def v1_eod_date_exchange_code_get_with_http_info(self, date, exchange_code, **kwargs):  # noqa: E501
        """v1_eod_date_exchange_code_get  # noqa: E501

        will return end of day data for a certain stock at a given date  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_eod_date_exchange_code_get_with_http_info(date, exchange_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str date: (required)
        :param str exchange_code: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EODStockResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'date',
            'exchange_code'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_eod_date_exchange_code_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'date' is set
        if self.api_client.client_side_validation and ('date' not in local_var_params or  # noqa: E501
                                                        local_var_params['date'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `date` when calling `v1_eod_date_exchange_code_get`")  # noqa: E501
        # verify the required parameter 'exchange_code' is set
        if self.api_client.client_side_validation and ('exchange_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['exchange_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_code` when calling `v1_eod_date_exchange_code_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'date' in local_var_params:
            path_params['_date'] = local_var_params['date']  # noqa: E501
        if 'exchange_code' in local_var_params:
            path_params['exchange_code'] = local_var_params['exchange_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/eod/{_date}/{exchange_code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EODStockResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_eod_date_exchange_code_stock_code_get(self, date, exchange_code, stock_code, **kwargs):  # noqa: E501
        """v1_eod_date_exchange_code_stock_code_get  # noqa: E501

        will return end of day data for a certain stock at a given date  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_eod_date_exchange_code_stock_code_get(date, exchange_code, stock_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str date: (required)
        :param str exchange_code: (required)
        :param str stock_code: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EODStockResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_eod_date_exchange_code_stock_code_get_with_http_info(date, exchange_code, stock_code, **kwargs)  # noqa: E501

    def v1_eod_date_exchange_code_stock_code_get_with_http_info(self, date, exchange_code, stock_code, **kwargs):  # noqa: E501
        """v1_eod_date_exchange_code_stock_code_get  # noqa: E501

        will return end of day data for a certain stock at a given date  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_eod_date_exchange_code_stock_code_get_with_http_info(date, exchange_code, stock_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str date: (required)
        :param str exchange_code: (required)
        :param str stock_code: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EODStockResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'date',
            'exchange_code',
            'stock_code'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_eod_date_exchange_code_stock_code_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'date' is set
        if self.api_client.client_side_validation and ('date' not in local_var_params or  # noqa: E501
                                                        local_var_params['date'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `date` when calling `v1_eod_date_exchange_code_stock_code_get`")  # noqa: E501
        # verify the required parameter 'exchange_code' is set
        if self.api_client.client_side_validation and ('exchange_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['exchange_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_code` when calling `v1_eod_date_exchange_code_stock_code_get`")  # noqa: E501
        # verify the required parameter 'stock_code' is set
        if self.api_client.client_side_validation and ('stock_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['stock_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stock_code` when calling `v1_eod_date_exchange_code_stock_code_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'date' in local_var_params:
            path_params['_date'] = local_var_params['date']  # noqa: E501
        if 'exchange_code' in local_var_params:
            path_params['exchange_code'] = local_var_params['exchange_code']  # noqa: E501
        if 'stock_code' in local_var_params:
            path_params['stock_code'] = local_var_params['stock_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/eod/{_date}/{exchange_code}.{stock_code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EODStockResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_eod_from_to_exchange_code_get(self, exchange_code, to, _from, **kwargs):  # noqa: E501
        """v1_eod_from_to_exchange_code_get  # noqa: E501

        return a list of eod historical data on exchange_code from one date to the other  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_eod_from_to_exchange_code_get(exchange_code, to, _from, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str exchange_code: (required)
        :param str to: (required)
        :param str _from: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EODStockListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_eod_from_to_exchange_code_get_with_http_info(exchange_code, to, _from, **kwargs)  # noqa: E501

    def v1_eod_from_to_exchange_code_get_with_http_info(self, exchange_code, to, _from, **kwargs):  # noqa: E501
        """v1_eod_from_to_exchange_code_get  # noqa: E501

        return a list of eod historical data on exchange_code from one date to the other  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_eod_from_to_exchange_code_get_with_http_info(exchange_code, to, _from, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str exchange_code: (required)
        :param str to: (required)
        :param str _from: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EODStockListResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'exchange_code',
            'to',
            '_from'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_eod_from_to_exchange_code_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange_code' is set
        if self.api_client.client_side_validation and ('exchange_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['exchange_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange_code` when calling `v1_eod_from_to_exchange_code_get`")  # noqa: E501
        # verify the required parameter 'to' is set
        if self.api_client.client_side_validation and ('to' not in local_var_params or  # noqa: E501
                                                        local_var_params['to'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `to` when calling `v1_eod_from_to_exchange_code_get`")  # noqa: E501
        # verify the required parameter '_from' is set
        if self.api_client.client_side_validation and ('_from' not in local_var_params or  # noqa: E501
                                                        local_var_params['_from'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `_from` when calling `v1_eod_from_to_exchange_code_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'exchange_code' in local_var_params:
            path_params['exchange_code'] = local_var_params['exchange_code']  # noqa: E501
        if 'to' in local_var_params:
            path_params['_to'] = local_var_params['to']  # noqa: E501
        if '_from' in local_var_params:
            path_params['_from'] = local_var_params['_from']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/eod/{_from}.{_to}/{exchange_code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EODStockListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_eod_from_to_stock_code_get(self, stock_code, to, _from, **kwargs):  # noqa: E501
        """v1_eod_from_to_stock_code_get  # noqa: E501

        will return end of day data for a certain stock at a given date  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_eod_from_to_stock_code_get(stock_code, to, _from, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str to: (required)
        :param str _from: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EODStockResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_eod_from_to_stock_code_get_with_http_info(stock_code, to, _from, **kwargs)  # noqa: E501

    def v1_eod_from_to_stock_code_get_with_http_info(self, stock_code, to, _from, **kwargs):  # noqa: E501
        """v1_eod_from_to_stock_code_get  # noqa: E501

        will return end of day data for a certain stock at a given date  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_eod_from_to_stock_code_get_with_http_info(stock_code, to, _from, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stock_code: (required)
        :param str to: (required)
        :param str _from: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EODStockResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stock_code',
            'to',
            '_from'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_eod_from_to_stock_code_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stock_code' is set
        if self.api_client.client_side_validation and ('stock_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['stock_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stock_code` when calling `v1_eod_from_to_stock_code_get`")  # noqa: E501
        # verify the required parameter 'to' is set
        if self.api_client.client_side_validation and ('to' not in local_var_params or  # noqa: E501
                                                        local_var_params['to'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `to` when calling `v1_eod_from_to_stock_code_get`")  # noqa: E501
        # verify the required parameter '_from' is set
        if self.api_client.client_side_validation and ('_from' not in local_var_params or  # noqa: E501
                                                        local_var_params['_from'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `_from` when calling `v1_eod_from_to_stock_code_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stock_code' in local_var_params:
            path_params['stock_code'] = local_var_params['stock_code']  # noqa: E501
        if 'to' in local_var_params:
            path_params['_to'] = local_var_params['to']  # noqa: E501
        if '_from' in local_var_params:
            path_params['_from'] = local_var_params['_from']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/eod/{_from}.{_to}/{stock_code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EODStockResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
