#
# Copyright 2021, Flyreel. All Rights Reserved.
# =============================================#
"""Interface definition for backbones."""
import torch.nn as nn


class Backbone(nn.Module):
    """The interface for image classification backbones.

    Attributes:
        out_features: The number of output features generated by the backbone.
    """

    out_features: int

    def freeze(self):
        """Freezes the backbone's parameters."""
        for m in self.modules():
            m.eval()
            for param in m.parameters():
                param.requires_grad = False
