# -*- coding: utf-8 -*-

"""
mycalculator

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

import json
import dateutil.parser

from tests.controllers.controller_test_base import ControllerTestBase
from tests.test_helper import TestHelper
from tests.http_response_catcher import HttpResponseCatcher
from mycalculator.api_helper import APIHelper
from mycalculator.controllers.simple_calculator_controller import SimpleCalculatorController


class SimpleCalculatorControllerTests(ControllerTestBase):

    @classmethod
    def setUpClass(cls):
        super(SimpleCalculatorControllerTests, cls).setUpClass()
        cls.response_catcher = HttpResponseCatcher()
        cls.controller = SimpleCalculatorController(cls.config, cls.response_catcher)

    # Checks if the test case returns the correct value after adding the input variables.
    def test_sum(self):
        # Parameters for the API call
        operation = 'SUM'
        x = 20
        y = 30

        # Perform the API call through the SDK function
        result = self.controller.get_calculate(operation, x, y)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)
        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        self.assertEqual('50', self.response_catcher.response.text)


    # Checks if the test case returns the correct value after subtracting the input variables.
    def test_subtract(self):
        # Parameters for the API call
        operation = 'SUBTRACT'
        x = 30
        y = 20

        # Perform the API call through the SDK function
        result = self.controller.get_calculate(operation, x, y)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)
        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        self.assertEqual('10', self.response_catcher.response.text)


    # Checks if the test case returns the correct value after multiplying the input variables.
    def test_multiply(self):
        # Parameters for the API call
        operation = 'MULTIPLY'
        x = 20
        y = 3.5

        # Perform the API call through the SDK function
        result = self.controller.get_calculate(operation, x, y)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)
        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        self.assertEqual('70', self.response_catcher.response.text)


    # Checks if the test case returns the correct value after dividing the input variables.
    def test_divide(self):
        # Parameters for the API call
        operation = 'DIVIDE'
        x = 30
        y = 2

        # Perform the API call through the SDK function
        result = self.controller.get_calculate(operation, x, y)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)
        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        self.assertEqual('15', self.response_catcher.response.text)


