from typing import (
    Dict,
    Iterable,
    Iterator,
    List,
    SupportsInt,
    Tuple,
    Type,
    TypeVar,
    Union,
)

_T = TypeVar("_T", bound=EnumBase)

class EnumType(type):
    def __contains__(self, k: int) -> bool: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[EnumBase]: ...
    def __call__(  # type: ignore
        self, value: str, default: EnumBase = ...
    ) -> EnumBase: ...
    def process(self) -> None: ...

class EnumBase(metaclass=EnumType):
    def __init__(self, value: object) -> None: ...
    @property
    def short_name(self) -> str: ...
    @property
    def long_name(self) -> str: ...
    @property
    def title(self) -> str: ...
    @property
    def full_name(self) -> str: ...
    def is_valid(self) -> bool: ...
    def assert_valid(self) -> None: ...
    def __int__(self) -> int: ...
    def __call__(self) -> int: ...
    @classmethod
    def get_names(cls) -> List[str]: ...
    @classmethod
    def get_members(cls: Type[_T]) -> List[_T]: ...
    @classmethod
    def create(
        cls: Type[_T],
        name: str,
        members: Union[Dict[str, int], Iterable[Tuple[str, int]], Iterable[EnumBase]],
    ) -> Type[_T]: ...
    @classmethod
    def parse(cls: Type[_T], value: object, default: object = ...) -> _T: ...

class Enum(EnumBase):
    def is_valid(self) -> bool: ...
    @property
    def short_name(self) -> str: ...
    @classmethod
    def parse(cls: Type[_T], value: object, default: object = ...) -> _T: ...

_FlagsT = TypeVar("_FlagsT", bound=Flags)

class Flags(EnumBase):
    def is_valid(self) -> bool: ...
    @property
    def short_name(self) -> str: ...
    @classmethod
    def parse(cls: Type[_T], value: object, default: object = ...) -> _T: ...
    def __contains__(self, item: SupportsInt) -> bool: ...
    def __or__(self: _FlagsT, other: SupportsInt) -> _FlagsT: ...
    def __and__(self: _FlagsT, other: SupportsInt) -> _FlagsT: ...
    def __xor__(self: _FlagsT, other: SupportsInt) -> _FlagsT: ...

class IntEnum(int, Enum): ...

class EnumValueGenerator(object):
    def __init__(self, start: int = ...) -> None: ...
    def reset(self, start: int = ...) -> None: ...
    def next(self) -> int: ...
    def __call__(self) -> int: ...
