import threading
import inspect
from typing import (
    Any,
    Callable,
    Dict,
    Generic,
    Iterable,
    Iterator,
    List,
    Mapping,
    MutableMapping,
    overload,
    Sequence,
    Tuple,
    TypeVar,
    Optional,
    Union,
)

from . import helpers
from .helpers import miss as miss

_ArgSpec = Union[inspect.ArgSpec, inspect.FullArgSpec]

_T = TypeVar("_T")
_KT = TypeVar("_KT")
_VT = TypeVar("_VT")
_CallableT = TypeVar("_CallableT", bound=Callable[..., Any])

not_computed: helpers.MarkerObject

class LazyConstant(Generic[_T]):
    value_provider: Callable[[], _T]
    value: Union[helpers.MarkerObject, _T]
    def __init__(self, value_provider: Callable[[], _T]) -> None: ...
    def get_value(self) -> Optional[_T]: ...
    def compute(self) -> Optional[_T]: ...
    def clear(self) -> None: ...

class _NewLazyConstant(LazyConstant[_T]):
    def __call__(self) -> _T: ...

def lazy_constant(fn: Callable[[], _T]) -> _NewLazyConstant[_T]: ...

class ThreadLocalLazyConstant(threading.local, Generic[_T]):
    value_provider: Callable[[], _T]
    value: Union[helpers.MarkerObject, _T]
    def __init__(self, value_provider: Callable[[], _T]) -> None: ...
    def get_value(self) -> Optional[_T]: ...
    def compute(self) -> Optional[_T]: ...
    def clear(self) -> None: ...

class LRUCache(MutableMapping[_KT, _VT]):
    def __init__(
        self, capacity: int, item_evicted: Optional[Callable[[_KT, _VT], object]] = ...
    ) -> None: ...
    def get_capacity(self) -> int: ...
    def __len__(self) -> int: ...
    def __contains__(self, key: object) -> bool: ...
    def __getitem__(self, key: _KT) -> _VT: ...
    def __iter__(self) -> Iterator[_KT]: ...
    @overload  # type: ignore
    def get(self, key: _KT) -> Union[_VT, helpers.MarkerObject]: ...
    @overload
    def get(self, key: _KT, default: _T) -> Union[_VT, _T]: ...
    def __setitem__(self, key: _KT, value: _VT) -> None: ...
    def __delitem__(self, key: _KT) -> None: ...
    def clear(self, omit_item_evicted: bool = ...) -> None: ...

def lru_cache(
    maxsize: int = ...,
    key_fn: Optional[Callable[[List[Any], Dict[str, Any]], object]] = ...,
) -> Callable[[_CallableT], _CallableT]: ...
def cached_per_instance() -> Callable[[_CallableT], _CallableT]: ...
def get_args_tuple(
    args: Iterable[object],
    kwargs: Mapping[str, object],
    arg_names: Sequence[str],
    kwargs_defaults: Mapping[str, object],
) -> Tuple[object, ...]: ...
def get_kwargs_defaults(argspec: _ArgSpec) -> Dict[str, object]: ...
def memoize(fun: _CallableT) -> _CallableT: ...
def memoize_with_ttl(ttl_secs: int = ...) -> Callable[[_CallableT], _CallableT]: ...
