# DO NOT EDIT! This file is automatically generated
import typing

from commercetools.helpers import RemoveEmptyValuesMixin
from commercetools.platform.models.review import (
    Review,
    ReviewDraft,
    ReviewPagedQueryResponse,
    ReviewUpdate,
    ReviewUpdateAction,
)
from commercetools.typing import OptionalListStr

from . import abstract, traits


class _ReviewQuerySchema(
    traits.ExpandableSchema,
    traits.SortableSchema,
    traits.PagingSchema,
    traits.QuerySchema,
):
    pass


class _ReviewUpdateSchema(traits.ExpandableSchema, traits.VersionedSchema):
    pass


class _ReviewDeleteSchema(
    traits.VersionedSchema, traits.ExpandableSchema, traits.DataErasureSchema
):
    pass


class ReviewService(abstract.AbstractService):
    """Reviews are used to evaluate products and channels."""

    def get_by_id(self, id: str, *, expand: OptionalListStr = None) -> Review:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"reviews/{id}", params=params, response_class=Review
        )

    def get_by_key(self, key: str, *, expand: OptionalListStr = None) -> Review:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"reviews/key={key}", params=params, response_class=Review
        )

    def query(
        self,
        *,
        expand: OptionalListStr = None,
        sort: OptionalListStr = None,
        limit: int = None,
        offset: int = None,
        with_total: bool = None,
        where: OptionalListStr = None,
        predicate_var: typing.Dict[str, str] = None,
    ) -> ReviewPagedQueryResponse:
        """Reviews are used to evaluate products and channels."""
        params = self._serialize_params(
            {
                "expand": expand,
                "sort": sort,
                "limit": limit,
                "offset": offset,
                "with_total": with_total,
                "where": where,
                "predicate_var": predicate_var,
            },
            _ReviewQuerySchema,
        )
        return self._client._get(
            endpoint="reviews", params=params, response_class=ReviewPagedQueryResponse
        )

    def create(self, draft: ReviewDraft, *, expand: OptionalListStr = None) -> Review:
        """Reviews are used to evaluate products and channels."""
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._post(
            endpoint="reviews", params=params, data_object=draft, response_class=Review
        )

    def update_by_id(
        self,
        id: str,
        version: int,
        actions: typing.List[ReviewUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> Review:
        params = self._serialize_params({"expand": expand}, _ReviewUpdateSchema)
        update_action = ReviewUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"reviews/{id}",
            params=params,
            data_object=update_action,
            response_class=Review,
            force_update=force_update,
        )

    def update_by_key(
        self,
        key: str,
        version: int,
        actions: typing.List[ReviewUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> Review:
        params = self._serialize_params({"expand": expand}, _ReviewUpdateSchema)
        update_action = ReviewUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"reviews/key={key}",
            params=params,
            data_object=update_action,
            response_class=Review,
            force_update=force_update,
        )

    def delete_by_id(
        self,
        id: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        data_erasure: bool = None,
        force_delete: bool = False,
    ) -> Review:
        params = self._serialize_params(
            {"version": version, "expand": expand, "data_erasure": data_erasure},
            _ReviewDeleteSchema,
        )
        return self._client._delete(
            endpoint=f"reviews/{id}",
            params=params,
            response_class=Review,
            force_delete=force_delete,
        )

    def delete_by_key(
        self,
        key: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        data_erasure: bool = None,
        force_delete: bool = False,
    ) -> Review:
        params = self._serialize_params(
            {"version": version, "expand": expand, "data_erasure": data_erasure},
            _ReviewDeleteSchema,
        )
        return self._client._delete(
            endpoint=f"reviews/key={key}",
            params=params,
            response_class=Review,
            force_delete=force_delete,
        )
