from __future__ import annotations

from typing import Any, Optional

from ..._typing import DataLayout1D, DataLayout2D, DataLayout3D, IntSequence, Tensor
from .. import Layer
from .conv import PaddingSizeStr

class AvgPool1D(Layer):
    kernel_size: Any = ...
    stride: Any = ...
    padding: Any = ...
    ceil_mode: Any = ...
    exclusive: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: int | IntSequence,
        stride: Optional[int | IntSequence] = ...,
        padding: int | IntSequence | PaddingSizeStr = ...,
        exclusive: bool = ...,
        ceil_mode: bool = ...,
        name: Optional[str] = ...,
    ) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    __call__ = forward

class AvgPool2D(Layer):
    ksize: Any = ...
    stride: Any = ...
    padding: Any = ...
    ceil_mode: Any = ...
    exclusive: Any = ...
    divisor: Any = ...
    data_format: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: int | IntSequence,
        stride: Optional[int | IntSequence] = ...,
        padding: int | IntSequence | PaddingSizeStr = ...,
        ceil_mode: bool = ...,
        exclusive: bool = ...,
        divisor_override: Optional[float] = ...,
        data_format: DataLayout2D = ...,
        name: Optional[str] = ...,
    ) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    __call__ = forward

class AvgPool3D(Layer):
    ksize: Any = ...
    stride: Any = ...
    padding: Any = ...
    ceil_mode: Any = ...
    exclusive: Any = ...
    divisor: Any = ...
    data_format: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: int | IntSequence,
        stride: Optional[int | IntSequence] = ...,
        padding: int | IntSequence | PaddingSizeStr = ...,
        ceil_mode: bool = ...,
        exclusive: bool = ...,
        divisor_override: Optional[float] = ...,
        data_format: DataLayout3D = ...,
        name: Optional[str] = ...,
    ) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    __call__ = forward

class MaxPool1D(Layer):
    kernel_size: Any = ...
    stride: Any = ...
    padding: Any = ...
    ceil_mode: Any = ...
    return_mask: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: int | IntSequence,
        stride: Optional[int | IntSequence] = ...,
        padding: int | IntSequence | PaddingSizeStr = ...,
        return_mask: bool = ...,
        ceil_mode: bool = ...,
        name: Optional[str] = ...,
    ) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    __call__ = forward

class MaxPool2D(Layer):
    ksize: Any = ...
    stride: Any = ...
    padding: Any = ...
    return_mask: Any = ...
    ceil_mode: Any = ...
    data_format: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: int | IntSequence,
        stride: Optional[int | IntSequence] = ...,
        padding: int | IntSequence | PaddingSizeStr = ...,
        return_mask: bool = ...,
        ceil_mode: bool = ...,
        data_format: DataLayout2D = ...,
        name: Optional[str] = ...,
    ) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    __call__ = forward

class MaxPool3D(Layer):
    ksize: Any = ...
    stride: Any = ...
    padding: Any = ...
    return_mask: Any = ...
    ceil_mode: Any = ...
    data_format: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: int | IntSequence,
        stride: Optional[int | IntSequence] = ...,
        padding: int | IntSequence | PaddingSizeStr = ...,
        return_mask: bool = ...,
        ceil_mode: bool = ...,
        data_format: DataLayout3D = ...,
        name: Optional[str] = ...,
    ) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    __call__ = forward

class AdaptiveAvgPool1D(Layer):
    output_size: Any = ...
    name: Any = ...
    def __init__(self, output_size: int | IntSequence, name: Optional[str] = ...) -> None: ...
    def forward(self, input: Tensor) -> Tensor: ...
    __call__ = forward

class AdaptiveAvgPool2D(Layer):
    def __init__(
        self,
        output_size: int | IntSequence,
        data_format: DataLayout2D = ...,
        name: Optional[str] = ...,
    ) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    __call__ = forward

class AdaptiveAvgPool3D(Layer):
    def __init__(
        self,
        output_size: int | IntSequence,
        data_format: DataLayout3D = ...,
        name: Optional[str] = ...,
    ) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    __call__ = forward

class AdaptiveMaxPool1D(Layer):
    output_size: Any = ...
    return_mask: Any = ...
    name: Any = ...
    def __init__(
        self,
        output_size: int | IntSequence,
        return_mask: bool = ...,
        name: Optional[str] = ...,
    ) -> None: ...
    def forward(self, input: Tensor) -> Tensor: ...
    __call__ = forward

class AdaptiveMaxPool2D(Layer):
    def __init__(
        self,
        output_size: int | IntSequence,
        return_mask: bool = ...,
        name: Optional[str] = ...,
    ) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    __call__ = forward

class AdaptiveMaxPool3D(Layer):
    def __init__(
        self,
        output_size: int | IntSequence,
        return_mask: bool = ...,
        name: Optional[str] = ...,
    ) -> None: ...
    def forward(self, x: Tensor) -> Tensor: ...
    __call__ = forward

class MaxUnPool1D(Layer):
    ksize: Any = ...
    stride: Any = ...
    padding: Any = ...
    data_format: Any = ...
    output_size: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: int | IntSequence,
        stride: Optional[int | IntSequence] = ...,
        padding: int | IntSequence = ...,
        data_format: DataLayout1D = ...,
        output_size: Optional[IntSequence] = ...,
        name: Optional[str] = ...,
    ) -> None: ...
    def forward(self, x: Tensor, indices: Tensor) -> Tensor: ...
    __call__ = forward

class MaxUnPool2D(Layer):
    ksize: Any = ...
    stride: Any = ...
    padding: Any = ...
    data_format: Any = ...
    output_size: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: int | IntSequence,
        stride: Optional[int | IntSequence] = ...,
        padding: int | IntSequence = ...,
        data_format: DataLayout2D = ...,
        output_size: Optional[IntSequence] = ...,
        name: Optional[str] = ...,
    ) -> None: ...
    def forward(self, x: Tensor, indices: Tensor) -> Tensor: ...
    __call__ = forward

class MaxUnPool3D(Layer):
    ksize: Any = ...
    stride: Any = ...
    padding: Any = ...
    data_format: Any = ...
    output_size: Any = ...
    name: Any = ...
    def __init__(
        self,
        kernel_size: int | IntSequence,
        stride: Optional[int | IntSequence] = ...,
        padding: int | IntSequence = ...,
        data_format: DataLayout3D = ...,
        output_size: Optional[IntSequence] = ...,
        name: Optional[str] = ...,
    ) -> None: ...
    def forward(self, x: Tensor, indices: Tensor) -> Tensor: ...
    __call__ = forward
