#!/usr/bin/env python3

# MIT License
#
# Copyright (c) 2021 Eugenio Parodi <ceccopierangiolieugenio AT googlemail DOT com>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from TermTk.TTkCore.log import TTkLog
from TermTk.TTkCore.color import TTkColor
from TermTk import TTkAbout, TTkWindow
from .cfg import TTKodeCfg

class About(TTkAbout):
    ttkode = [
        "__________________    __       ___      ",
        "\_______________ /   / /       | |      ",
        "    /\    /\   | |__/ /___   __| |_____ ",
        "   |  |  |  |  |  _  // _ \ / _  | ___ |",
        "   |  |  |  |  | | \ \ |_| ( (_| | ____|",
        "   |__|  |__|  |_|  \_)___/ \____|_____)",]

    __slots__=('_image')
    def __init__(self, *args, **kwargs):
        TTkAbout.__init__(self, *args, **kwargs)
        self._name = kwargs.get('name' , 'About' )
        self.setTitle('[PierCecco Cecco] Eugenio Parodi proudly presents...')
        self.resize(56,16)

    def paintEvent(self):
        c = [0xFF,0xFF,0xFF]
        for y, line in enumerate(About.ttkode):
            self._canvas.drawText(pos=(13,3+y),text=line, color=TTkColor.fg(f'#{c[0]:02X}{c[1]:02X}{c[2]:02X}'))
            c[2]-=0x18
            c[0]-=0x08
        self._canvas.drawText(pos=(26,4),text=f"  Version: {TTKodeCfg.version}", color=TTkColor.fg('#AAAAFF'))
        self._canvas.drawText(pos=(14,11),text=f"Powered By, pyTermTk")
        self._canvas.drawText(pos=(2,13),text=f"https://github.com/ceccopierangiolieugenio/ttkode", color=TTkColor.fg('#44FFFF'))
        self._canvas.drawText(pos=(2,14),text=f"https://github.com/ceccopierangiolieugenio/pyTermTk", color=TTkColor.fg('#44FFFF'))

        TTkWindow.paintEvent(self)
