import pprint


class Singleton(object):

    _instances = {}

    def __new__(cls, *args, **kwargs):
        """"
        called before __init__
        """
        if cls not in cls._instances:
            cls._instances[cls] = super(Singleton, cls).__new__(cls, *args, **kwargs)

        return cls._instances[cls]
