from setuptools import setup, find_packages

setup(
    name = "real-deepfakes-detect",
    version = "0.0.7",
    description='Realworld DeepFakes Detection',
    long_description='The rapid development of deep learning methods enables the generation of fake images and videos. As one of the most impressive topics in the field, Deepfake has gained a lot of attention over the years. However, the malicious use of videos with fake faces generated by Deepfake, such as to defame or attack face recognition systems, raises serious social and security concerns. To address this issue, our project aims to propose a novel and easy-to-use Deepfake video detection toolkit and improve the generalization capabilities of the current state-of-the-art methods. Specifically, we propose a learning framework based on a two-stream network, combined with spatial-temporal and frequency models. The spatial-temporal model, which is based on X3D visual backbone, captures the RGB feature. The frequency model extracts frequency features by applying patch-wise Discrete Cosine Transform (DCT) operation. Extensive experiments on the Faceforensics++ dataset show that our method reaches the state-of-the-art face forgery detection performance. An open-source and easy-to-use toolbox for deploying the proposed robust Deepfake detection system is released on GitHub.',
    license = "MIT Licence",

    # author='vg450',
    # author_email='gward@python.net',
    url='https://github.com/ThreeCatsLoveFish/RDD',

    packages = find_packages(),
    include_package_data = True,
     package_data = {
        'real_deepfakes_detect': ['configs/*.yaml']},
    install_requires = [
        'pytorchvideo==0.1.5',
        'decord==0.6.0',
        'omegaconf==2.2.2',
        'torch==1.8.1',
        'torchvision==0.9.1',
        'opencv-python==4.5.5.64',
        'scikit-learn==1.0.2',
        'easydict',
        'einops',
        'requests',
        'thop',
        'seaborn',
        'pandas',
    ],

    scripts = [],
    entry_points = {
        'console_scripts': [
            'deepfakes_detect = real_deepfakes_detect:main'
        ]
    }
)
