import datetime
import pandas as pd
import numpy as np

_cal_date_range = pd.date_range("2010-01-01", "2011-02-04")
_bus_date_range = pd.bdate_range("2010-01-01", "2011-02-04")

_levels = [
    25.50276311975548, 29.73909566020162, 84.91559149997373, 67.43909527273073, 44.262716358453034,
    6.147504900024769, 10.678747229307806, 26.299719326106253, 36.111311625677025, 67.41855505810136,
    1.2290739649645444, 91.69552435269938, 21.985766615108016, 81.25960974308794, 78.88380866178491,
    56.8295914297137, 84.89098425470726, 43.23871237453567, 48.22865684472211, 69.5266080672824,
    42.2690407174492, 91.80419242676507, 8.049144001043562, 45.35083366593005, 50.108603762192786,
    24.93967955012352, 52.7807826018201, 97.07769528025796, 58.115478045130196, 48.60963061202133,
    23.061913451658334, 46.306828367414774, 78.89684825441256, 83.9988510049271, 12.747671538119643,
    12.30123739240775, 14.440290948377378, 90.99400806773022, 59.19853676931902, 35.69138834322707,
    37.41992423441262, 37.39853155790224, 60.50746081510403, 64.5782244563637, 56.09817425898276,
    0.9774263070719602, 73.20606495218274, 60.98741761813879, 54.431294367290114, 28.387660980296204,
    67.5123162182173, 37.82365274076116, 6.857520520071114, 80.03637082606956, 77.05566969547748,
    92.48109677190202, 36.098391785783235, 25.27598089305625, 80.91214007613956, 50.63939649716453,
    70.18040975564675, 49.12311681736754, 31.485424333487387, 26.894923544699157, 34.6328659236264,
    55.18698724186365, 29.53211822602466, 7.925481110063326, 50.35053530027056, 3.112457362709853,
    11.026144570530526, 12.025253350599929, 24.45563192571134, 11.170549068090974, 88.35472845508345,
    26.93149398789334, 13.982984613021475, 87.11320628438047, 47.173474399084206, 93.13212489672638,
    97.72128618584567, 93.43356155667719, 80.69063605265588, 53.66639703495869, 41.09941740107331,
    45.75143845615246, 44.96761789588838, 44.574678700416634, 62.32589463931235, 25.48942736768206,
    87.62626206717655, 62.196547517743916, 52.64041705585616, 5.0847601830198546, 83.29990190620542,
    71.02420394004176, 24.862461720660356, 66.75052249569777, 1.5883067132723472, 52.77241934180712,
    68.0935868820744, 37.98112961377783, 77.1258381679741, 24.39046671811044, 80.78950589750747,
    73.02673194249279, 46.815682436013475, 24.918722085192, 93.08799523295494, 74.35534084614164,
    37.81885043326195, 30.754634781761503, 6.745684195112522, 52.88771733840295, 31.249886312457186,
    14.157324738026045, 21.49761561389876, 21.348976822068643, 21.604554470343352, 41.17551207431126,
    85.47603548942186, 67.55960593293526, 52.12424979063937, 65.38334892405196, 35.22852935150236,
    97.49764360691302, 98.82077345344796, 61.6703647557142, 86.95577464417995, 88.09266489681639,
    20.69842037595624, 94.8661354792377, 88.63261367742005, 39.84487640898177, 31.529004265913596,
    12.3904366300984, 8.83011455790179, 40.75973088976568, 41.48323191108151, 65.6310234949471,
    83.72206609693612, 50.59611287340794, 61.41499108342803, 3.274097724265257, 46.9695824369635,
    87.58800198787559, 38.83524149736446, 72.33513147546302, 4.744385059151057, 86.7271969533559,
    33.38921874310039, 45.2229716416104, 22.35574251163198, 43.40690642714209, 87.36153037559433,
    6.231966311941084, 42.24251969505977, 14.250793575289878, 82.58289849692322, 95.79597670149386,
    96.20045642557325, 8.740479288355107, 36.9373841046032, 37.618441466212374, 41.76928228577618,
    8.22349673570766, 85.43929391137584, 49.52060367583028, 31.506010938038663, 19.798840950943266,
    85.93350583565659, 93.31786471575401, 93.62337530345296, 33.01991489063132, 92.66808455974194,
    39.969833653468534, 1.8172505996472132, 91.28754180268001, 7.714444781212615, 45.405633750423426,
    20.664410118511856, 28.014861149451665, 12.099852433520352, 91.33873645205823, 52.4109790890262,
    74.71751096995129, 15.34233389081604, 87.85667926598127, 32.11419582051379, 7.732844796153316,
    13.984210930781348, 69.69374294283269, 16.657047078833653, 68.91599532489433, 82.17551235322038,
    59.53289726624966, 1.898166271373869, 2.851844710709328, 93.56518330718924, 16.457979851646055,
    47.43219977886035, 4.569535429448002, 21.200698225928495, 93.15404577468126, 7.919129065413156,
    43.10797834281359, 87.86850239134053, 38.46411293685135, 57.563774819591394, 57.10399250418621,
    90.91831165284721, 38.517931085192735, 48.19141686335563, 47.007495607473146, 76.62209119838667,
    83.79744293713128, 21.709410764469105, 79.69782275857776, 70.53800640805137, 27.85030993145724,
    82.29968928908097, 26.539139097458985, 55.51922172882874, 93.15674154771885, 52.82368026285869,
    72.23610540203111, 35.10680659657428, 45.02209222311476, 4.946478295768609, 59.367900812660714,
    25.523832186070305, 99.53063593563489, 57.66643557533434, 69.07296934504019, 50.29373690952489,
    16.669361140754823, 52.92568660494328, 5.884309232927243, 20.86129557456128, 14.368416986477328,
    16.414773154733087, 46.238510623220854, 70.3536256704909, 31.746469687296287, 3.5246323759633102,
    14.572955621250582, 50.325174597870074, 34.82387168656377, 67.26776894752409, 32.08121134479999,
    90.6855063947925, 31.293989556206505, 52.63824233154794, 98.63559089446763, 91.5959228966557,
    59.68792512022052, 64.87827374322838, 57.04104356154044, 3.2367386631177664, 40.50335470180403,
    67.44145889905879, 42.86778972821966, 74.24702135228111, 82.54369536234525, 69.58335513358405,
    28.682765520266063, 29.646213213262573, 70.5301781351122, 2.8476303595107666, 0.3170963062793075,
    66.9748925834475, 70.65276683483332, 13.309332199017621, 44.799374830717674, 95.1890659079834,
    11.363917153873349, 49.13734261559986, 12.916622047796423, 0.9929922782094036, 85.23045697148972,
    32.57839318940179, 77.97599481904113, 57.502396180867855, 22.78308855029083, 41.63403734266238,
    79.61022733457872, 22.218668016581955, 98.14398126565324, 49.22878187271251, 62.021269966714634,
    14.714503901436427, 62.912454951702, 43.0325985971205, 27.791686904639157, 77.31005572426281,
    90.52918051090722, 55.08767775191927, 66.62650964825934, 62.72998789364892, 8.211942987414734,
    59.06780634119437, 72.02261767239656, 0.8320844408146844, 77.6640312596447, 57.9593268535493,
    10.535684351741581, 43.86466941997388, 1.9018643317442074, 31.005354405068186, 53.169375275085095,
    16.716467518591294, 44.75962874894257, 74.18034409135167, 24.124901419500166, 1.9501652507035727,
    23.05525382765299, 88.43004926226996, 18.37961768711448, 62.59291135650004, 23.259137366701687,
    55.977779879369706, 38.74659791890329, 12.891539016365439, 63.534582475075005, 66.9306440870756,
    32.90655797785513, 77.09009860126773, 7.216467300039775, 46.955949666258675, 10.13379317849531,
    14.973624804556751, 45.6557539976876, 12.829809082869236, 9.066217171938762, 74.03248588220663,
    26.05445331684767, 1.9250681529695557, 70.04525443611173, 29.865434998439223, 59.95864515816521,
    33.26842636437569, 15.831753219357768, 38.12477439576043, 6.929649004206495, 65.1825624220736,
    20.686261456984433, 23.059484935635066, 34.92713646763561, 8.091510263781965, 28.646278487759545,
    11.491647513066884, 53.15634275165667, 19.945262544467113, 74.27837452871776, 79.03893351270203,
    33.63638848190666, 32.98334878754772, 65.10307375837786, 61.246318045229344, 86.49011515630683,
    62.721756157274996, 95.99912411854355, 78.62073235138526, 87.12838423204944, 97.82028990431601,
    47.75282563633723, 78.61344369267712, 70.5003690332183, 63.32155777804309, 71.85285940112833,
    59.50924981191276, 37.98166083882266, 84.96759355192414, 73.99309363113419, 80.23907802469029,
    78.2946276698006, 69.1472504003067, 52.607925843400636, 97.94605976642967, 82.27228660245012,
    7.691971039032186, 19.003426223939723, 66.85093292069278, 49.80215862616909, 14.271205702043021,
    88.2163975783427, 67.91790941081241, 67.27009022204487, 3.6620021942959324, 63.73020623860683,
    46.661419777688394, 24.346877294316172, 8.374659849226296, 12.873424107343123, 79.31544954575138,
    15.495438358191594, 74.36089633008534, 39.85274481456646, 52.56670674031548, 3.231678633482926
]

_prices = [
    1493.38031776, 1443.16980802, 1169.25869339, 1231.91470965, 1226.59619499,
    1424.83984147, 1271.70713354, 1401.62642148, 1310.01147566, 1428.22032057,
    1210.25857262, 1242.27369795, 1255.03805053, 1323.75081949, 1315.1060624,
    1432.77838701, 1554.06241387, 1584.93901048, 1187.92168551, 1377.48186754,
    1363.83613427, 1530.03990018, 1449.7435644, 1606.4458871, 1356.40700079,
    1290.47160723, 1306.03136702, 1317.40599474, 1316.95433797, 1334.30569227,
    1307.76274674, 1318.32323126, 1341.89193102, 1435.99909372, 1504.96411162,
    1322.31902436, 1138.61211276, 1145.57224127, 1448.02416107, 1327.39148104,
    1558.1514457, 1048.60404271, 1479.86406259, 1381.58434356, 1549.20103397,
    1226.50099928, 1338.81859666, 1320.94868253, 1235.28318432, 1531.07366337,
    1402.38869733, 1537.24393381, 1372.51604075, 1395.25034706, 1105.51486535,
    1225.52331483, 1571.53079805, 1454.51641947, 1395.61429294, 1489.903843,
    1341.05680471, 1518.60656285, 1272.14346009, 1400.55292099, 1468.36893572,
    1262.81987279, 1184.33010272, 1519.90728087, 1471.11083394, 1371.74324618,
    1243.27481084, 1505.99272522, 1385.62037149, 1171.90693379, 1180.67986953,
    1500.78287176, 1352.55897035, 1713.16665873, 1270.50626495, 1547.16266107,
    1382.36954922, 1629.17358309, 1272.87122769, 1312.71687819, 1794.94914525,
    1281.86694961, 1357.78089152, 1318.20308034, 1263.82511898, 1527.60780095,
    1290.02153172, 1318.48235309, 1397.95789912, 1589.29991765, 1467.34045703,
    1426.37923233, 1356.18314728, 1651.71665977, 1318.26351146, 1112.81809466,
    1512.49409613, 1253.00281133, 1181.95024087, 1240.03338584, 1491.57739446,
    1308.86215681, 1341.72028609, 1398.95420968, 1397.4409234, 1387.88022068,
    1468.14926302, 1411.07768657, 1301.55015142, 1460.04381809, 1164.35738065,
    1092.14746091, 1533.40636703, 1425.27688178, 1401.04549851, 1257.51782162,
    1439.88277745, 1396.96745971, 1513.54020941, 1287.17502244, 1497.0443934,
    1135.13659666, 1271.60667534, 1314.61547569, 1575.63264081, 1458.76907266,
    1340.33837359, 1347.71637867, 1370.96984204, 1552.37816379, 1518.31619971,
    1363.3196162, 1467.6991476, 1476.06380663, 1625.19398593, 1477.39733487,
    1423.37034354, 1431.64291186, 1368.25390479, 1374.69248233, 1338.31774043,
    1183.10962005, 1356.04068386, 1288.73566573, 1179.52656965, 1534.90052476,
    1388.99971938, 1291.89384134, 1390.42635876, 1448.80714053, 1196.5068677,
    1088.76399881, 1385.06475551, 1402.61798538, 1249.65576667, 1478.71799082,
    1653.45903861, 1626.80187119, 1229.97167299, 1302.30719238, 1380.39432339,
    1772.38977874, 1094.34926787, 1180.04407064, 1280.83295362, 1315.78522945,
    1369.93771729, 1255.35515323, 1487.13823162, 1393.69047152, 1301.56746119,
    1591.33662153, 1484.41633522, 1391.04641689, 1420.14918209, 1567.8609791,
    1606.472234, 1416.8008782, 1517.74653825, 1561.57720041, 1273.44044518,
    1243.10396235, 1363.05423143, 1417.17135746, 1227.52436772, 1269.86094366,
    1502.09075854, 1466.5912439, 1239.37596467, 1337.2496715, 1396.29810689,
    1241.06146101, 1465.88708745, 1497.24543773, 1180.91710301, 1540.49277662,
    1331.01548646, 1425.13156008, 1454.06365664, 1660.97347451, 1330.21192872,
    1401.83063628, 1225.61257159, 1435.78052657, 1743.89082026, 1427.85712887,
    1150.44130978, 1283.06608094, 1379.25571159, 1613.08259132, 1516.65435085,
    1510.4154702, 1185.04871989, 1316.6491035, 1295.92823806, 1240.98903742,
    1153.35889802, 1404.5364371, 1723.57503221, 1486.08610027, 1413.96209396,
    1560.59986847, 1285.03971629, 1363.7210173, 1443.72734722, 1343.23617529,
    1380.27252901, 1182.26419826, 1532.05227876, 1269.23208093, 1527.90567871,
    1407.42961963, 1289.2217601, 1487.69895426, 1417.90092872, 1207.06209202,
    1145.85398303, 1380.51550202, 1261.71992652, 1153.74986297, 1358.08187916,
    1271.28623791, 1468.91294962, 1366.58730661, 1389.61170584, 1535.03958146,
    1287.4413038, 1340.91215536, 1410.60338537, 1548.29647891, 1088.68007028,
    1183.76149028, 1581.14710361, 1263.30666261, 1520.40661014, 1577.56134669,
    1093.01513867, 1417.33142542, 1334.47045391, 1648.98917284, 1432.03997248,
    1267.68522012, 1334.34500137, 1341.80089338, 1713.47475967, 1455.56233591,
    1142.1826298, 1338.56512726, 1560.5546375, 1390.64330872, 1427.46078272,
    1511.78844455, 1264.39200582, 1264.37361138, 1367.04501995, 1212.70754782,
    1368.05902705, 1423.2641062, 1279.92520985, 1241.08810787, 1568.55223267,
    1649.50223709
]

_cumulative_returns = [
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.25838723367880145, 0.09689891921143368, 0.1930910269729541, 0.049027965383277805, 0.049027965383277805,
    0.049027965383277805, 0.2570067709386771, 0.2337482920878582, -0.04773761274377519, 0.2517558387692007,
    0.2517558387692007, 0.2517558387692007, 0.2517558387692007, 0.2517558387692007, 0.2517558387692007,
    0.2517558387692007, 0.2517558387692007, 0.22969355479162012, 0.22969355479162012, 0.22969355479162012,
    0.1680856326943554, 0.019760962272086235, 0.11430160180497073, 0.146053959182592, 0.20046862073975746,
    0.20046862073975746, 0.20046862073975746, 0.20046862073975746, 0.20046862073975746, 0.20046862073975746,
    0.20046862073975746, 0.20046862073975746, 0.20046862073975746, 0.20046862073975746, 0.20046862073975746,
    0.20046862073975746, 0.20046862073975746, 0.20046862073975746, 0.20046862073975746, 0.20046862073975746,
    0.20046862073975746, 0.20046862073975746, 0.20046862073975746, 0.20046862073975746, 0.20046862073975746,
    0.20046862073975746, 0.20046862073975746, 0.20046862073975746, 0.20046862073975746, 0.20046862073975746,
    0.20046862073975746, 0.2624855933119492, -0.11648645895749077, -0.11648645895749077, -0.11648645895749077,
    -0.02362022471793357, -0.0028092746842998118, 0.12045844300721864, -0.03616439364126389, 0.0006931197418200696,
    0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696,
    0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696,
    0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696,
    0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696,
    0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696,
    0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696,
    0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696,
    0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696,
    0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696,
    0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696,
    0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696,
    0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696,
    0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696, 0.0006931197418200696,
    -0.07761350985623605, -0.1697128842873732, -0.20165175138967406, -0.25113548517550677, -0.1464316511947712,
    -0.1464316511947712, -0.1464316511947712, -0.358231562973516, -0.27284039687726325, -0.18865976731527256,
    -0.18865976731527256, -0.18865976731527256, -0.18865976731527256, -0.18865976731527256, -0.18865976731527256,
    -0.18865976731527256, -0.18865976731527256, -0.18865976731527256, -0.18865976731527256, -0.18865976731527256,
    -0.18865976731527256, -0.25990877739370233, -0.29084513749512, -0.08747375365177545, -0.06606179428840919,
    -0.1507245517200626, -0.1507245517200626, -0.1507245517200626, -0.1889212573141148, -0.05506547513748283,
    -0.08494728604783963, -0.08494728604783963, -0.08494728604783963, -0.08494728604783963, -0.08494728604783963,
    -0.08494728604783963, -0.08494728604783963, -0.08494728604783963, -0.08494728604783963, -0.08494728604783963,
    -0.08494728604783963, -0.08494728604783963, -0.10633934997177374, 0.10945376085388503, -0.1358418534457837,
    0.0070595282182014385, -0.057144648505751294, -0.057144648505751294, -0.057144648505751294, -0.07688156876905006,
    -0.21803147017784963, 0.007607699865853856, 0.007607699865853856, 0.007607699865853856, 0.007607699865853856,
    0.007607699865853856, -0.16387222768363818, -0.4152651236379328, -0.1574073807298242, 0.06894132482408966,
    -0.03926968266251296, -0.03926968266251296, -0.03926968266251296, -0.11775258409457989, -0.3085362665976519,
    -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797,
    -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797,
    -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797,
    -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797,
    -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797,
    -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797,
    -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797,
    -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797,
    -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797,
    -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797,
    -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797,
    -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797, -0.22985867899351797,
    -0.22985867899351797, -0.028839785637977844, -0.19144321889412563, -0.22759085905961485, 0.07886146717474196,
    -0.12625308921886402, -0.12625308921886402, -0.12625308921886402, -0.0738474836171995, -0.2727655464665737,
    -0.13555554249877588, -0.13555554249877588, -0.13555554249877588, -0.13555554249877588, -0.13555554249877588,
    -0.13555554249877588, -0.13555554249877588, -0.13555554249877588, -0.13555554249877588, -0.13555554249877588,
    -0.13555554249877588, -0.13555554249877588, -0.30139693916985555, -0.17446151756074568, -0.20196669698773728,
    -0.2649652467875635, -0.0801431311566172, -0.0801431311566172, -0.0801431311566172, -0.08012938924774393,
    -0.15683197657733106, -0.04153129453586468, -0.04153129453586468, -0.04153129453586468, -0.04153129453586468,
    -0.04153129453586468, -0.04153129453586468, -0.04153129453586468, -0.04153129453586468, -0.04153129453586468
]

_daily_returns = [
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.25838723367880156, -0.12832958738405886, 0.08769459617179076, -0.12074775380314884, 0.0,
    0.0, 0.19825859025541903, -0.018503065686313325, -0.2281550512668009, 0.31450727816302093,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, -0.0176250697574325, 0.0, 0.0,
    -0.05010022363474498, -0.12698099032357524, 0.09270862783592193, 0.028495299052059275, 0.0474800170805012,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.05166063610556959, -0.3001793084032439, 0.0, 0.0,
    0.10511014254515993, 0.021314400974376646, 0.12361498614268918, -0.13978460122815417, 0.038240456297653935,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    -0.0782523913207871, -0.09984900626285453, -0.03846725608272039, -0.06198264212637572, 0.13981679183353268,
    0.0, 0.0, -0.24813468315127774, 0.1330560388602111, 0.11576637260992317,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, -0.08781643903281677, -0.041800739093314054, 0.2867799328414604, 0.02346448603429585,
    -0.0906513481447595, 0.0, 0.0, -0.04497563855332576, 0.16503426255922937,
    -0.03162315496378376, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, -0.02337795801024478, 0.24147097762315362, -0.22109584279643912,
    0.16536484928574313, -0.06375410283595617, 0.0, 0.0, -0.020933137020455406,
    -0.15290551746494818, 0.2885527504476715, 0.0, 0.0, 0.0,
    0.0, -0.17018520955360084, -0.30066325300719254, 0.4409823209321335, 0.26863362006418856,
    -0.10123194320736961, 0.0, 0.0, -0.08169087621755289, -0.21624736900734043,
    0.11378411303945146, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.26101559268736896, -0.16743214029104947, -0.0447063719087849, 0.3967487047878022,
    -0.19012131087668538, 0.0, 0.0, 0.059978015321179745, -0.21477894766865446,
    0.1886736846709245, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0,
    0.0, 0.0, -0.19184737114338524, 0.18169891992496212, -0.03331786465692177,
    -0.07894225662266396, 0.2514467714937143, 0.0, 0.0, 1.4939181669060275e-05,
    -0.08338410471322799, 0.13674698143013853, 0.0, 0.0, 0.0,
    0.0, 0.0, 0.0, 0.0, 0.0
]

_benchmark_returns = [
    0.0, 0.03362205135749574, 0.03362205135749574, 0.03362205135749574, 0.21703890195644682,
    0.1750830682583161, 0.17864446155964053, 0.04589619635057696, 0.14843719418540302, 0.14843719418540302,
    0.14843719418540302, 0.061440408172531935, 0.12278777208945979, 0.043632553888038994, 0.18958448947865425,
    0.16814646398088873, 0.16814646398088873, 0.16814646398088873, 0.15959917537114876, 0.11358760809465895,
    0.11937632580252766, 0.04058037328421471, -0.04063405375599194, -0.04063405375599194, -0.04063405375599194,
    -0.061309695615470394, 0.20454175578540734, 0.07760812757586244, 0.08674560790000907, -0.024548055163193583,
    -0.024548055163193583, -0.024548055163193583, 0.029220120850027786, -0.07571116881304074, 0.09172031755142829,
    0.13587209374391207, 0.12545293955729542, 0.12545293955729542, 0.12545293955729542, 0.11783624099449297,
    0.11813868020882357, 0.10651983530130116, 0.1242935699717923, 0.11722203943505649, 0.11722203943505649,
    0.11722203943505649, 0.10143992453792716, 0.03842371789529753, -0.007756760767662518, 0.11454636931105666,
    0.23756052010390472, 0.23756052010390472, 0.23756052010390472, 0.23289986639953564, 0.03037147078383362,
    0.11114974179449177, -0.04337215856517629, 0.2978318849930629, 0.2978318849930629, 0.2978318849930629,
    0.00905077896719153, 0.07486102024411889, -0.03737876785046179, 0.1787082066812734, 0.10349789619019178,
    0.10349789619019178, 0.10349789619019178, 0.11546398005876979, 0.17282746422367046, -0.025240285519859018,
    0.06092997165416181, -0.029372033050357516, -0.029372033050357516, -0.029372033050357516, 0.08093335339472718,
    0.06570996653229655, 0.2597231581247701, 0.17936288549173662, -0.05233126442112357, -0.05233126442112357,
    -0.05233126442112357, 0.02602411309953112, 0.06546626044104054, 0.0023279232481210332, 0.10199914331165016,
    -0.016892043366312892, -0.016892043366312892, -0.016892043366312892, 0.14814502042041433, 0.062159247491112346,
    0.016748166386386987, 0.15438829762791417, 0.20694675787850259, 0.20694675787850259, 0.20694675787850259,
    -0.017763032493818498, 0.014912131595120504, 0.0814508334772015, 0.16747609697651988, -0.008445542846659437,
    -0.008445542846659437, -0.008445542846659437, 0.07215840800127515, 0.2152655824821602, 0.20939103355737,
    -0.0049569114524714575, 0.0942970425786952, 0.0942970425786952, 0.0942970425786952, -0.1471737228328207,
    0.1492413219589639, -0.036013828942563775, 0.07433522942535564, -0.09093012926116728, -0.09093012926116728,
    -0.09093012926116728, 0.14765769137814344, 0.12097617560742102, -0.20193705776324866, 0.1416339599729426,
    0.09080033038294799, 0.09080033038294799, 0.09080033038294799, 0.117302495109054, 0.1537151628758051,
    -0.02291946852583382, 0.13617347411209257, 0.1171154879905868, 0.1171154879905868, 0.1171154879905868,
    0.06389693067813362, -0.06422985407620407, 0.017436858126708588, 0.044865386688970554, 0.09187021473926305,
    0.09187021473926305, 0.09187021473926305, -0.10602546459665207, 0.11726202911436978, 0.2548327566489059,
    -0.01279900246621013, 0.16096201588524683, 0.16096201588524683, 0.16096201588524683, 0.20854036522801533,
    0.1696466257838516, 0.0012072767255324468, 0.12355738103390068, 0.10155486172302242, 0.10155486172302242,
    0.10155486172302242, 0.06322977941857078, 0.06424310888461726, 0.07064516374385132, 0.01689526401275021,
    0.05511163513487982, 0.05511163513487982, 0.05511163513487982, 0.12845365916415463, 0.022322846547223274,
    0.2203209277617364, 0.2686742633998487, -0.02680231471781891, -0.02680231471781891, -0.02680231471781891,
    0.0456035446363402, 0.06182940685096072, 0.1579386666176119, 0.03582311864819787, 0.06456015048773023,
    0.06456015048773023, 0.06456015048773023, -0.013499502712235323, 0.13807955874850297, -0.0024535448850002695,
    0.23988780141240162, 0.14850446318500432, 0.14850446318500432, 0.14850446318500432, 0.1197048333529257,
    -0.05507794770817309, 0.023176443862548912, 0.10248022044348071, 0.09753974748273697, 0.09753974748273697,
    0.09753974748273697, 0.08196872174102976, -0.03950624320433915, -0.0166976098810534, 0.08709147965408104,
    0.017196671105536243, 0.017196671105536243, 0.017196671105536243, 0.011595513161693383, -0.08826530429148449,
    0.010702553595974718, 0.04688020418336014, 0.04134071218549562, 0.04134071218549562, 0.04134071218549562,
    0.08378737250112134, 0.0794759606903257, 0.10383328043494411, 0.2077640196674021, 0.09196561134942705,
    0.09196561134942705, 0.09196561134942705, 0.13703451799669986, 0.2101633082862413, -0.027802835289993943,
    0.06989552302160107, 0.13491973479483121, 0.13491973479483121, 0.13491973479483121, 0.06894021420774177,
    0.029847170677096968, 0.19879293072865478, 0.27093990334418316, 0.07253046056778645, 0.07253046056778645,
    0.07253046056778645, 0.06077643537993005, 0.1632032699182585, 0.00981821359611379, -0.10719219943256686,
    -0.08934197929575372, -0.08934197929575372, -0.08934197929575372, 0.17638416794263145, 0.12794672804219132,
    0.07565788367927184, -0.18683081440265736, 0.2671998854843137, 0.2671998854843137, 0.2671998854843137,
    0.20981677834752077, 0.14232634621756035, 0.11892154074749306, 0.08265985496257122, 0.15938683649388552,
    0.15938683649388552, 0.15938683649388552, 0.0041798368880091585, 0.06675449318197124, 0.1284420681650006,
    -0.06559367537194394, 0.0060024780247843745, 0.0060024780247843745, 0.0060024780247843745, 0.0685250097734621,
    0.0490371640760896, -0.04987387369060636, -0.075728811271353, 0.05127926131694682, 0.05127926131694682,
    0.05127926131694682, -0.016316152155097408, -0.045666118562679436, 0.14727653094417326, 0.16759050084803762,
    0.08726918707853526, 0.08726918707853526, 0.08726918707853526, 0.05103118033208698, 0.17802293687569903,
    0.14967344315563802, -0.0058327009378731365, 0.017938547563143392, 0.017938547563143392, 0.017938547563143392,
    0.17008684932381757, 0.10454848266260042, 0.06500836372051466, 0.1689582042493144, 0.018410066064911357,
    0.018410066064911357, 0.018410066064911357, -0.0025881685489184125, 0.20923217685008744, -0.03154752898489144,
    0.10872302880189266, 0.0457008552130711, 0.0457008552130711, 0.0457008552130711, 0.026327292955737547,
    -0.1122240294430703, 0.10926110857329685, 0.06130366149282074, 0.17930311722042713, 0.17930311722042713,
    0.17930311722042713, 0.038570075221291966, -0.1677472908413271, 0.043875754963934255, 0.22963943203322268,
    0.14083099550653078, 0.14083099550653078, 0.14083099550653078, 0.076420322949737, -0.08015525056574169,
    -0.015584799674412286, -0.011407109252351777, 0.20646555616353834, 0.20646555616353834, 0.20646555616353834,
    0.11834307186068216, 0.13221821484574592, 0.16900670066321422, 0.22768575137645852, 0.05949179830711948,
    0.05949179830711948, 0.05949179830711948, -0.1541433965028287, 0.004884366964833742, 0.0531801730982524,
    -0.045011675800593176, 0.1395094062726775, 0.1395094062726775, 0.1395094062726775, 0.08682269273140197,
    0.03324871096096749, 0.10053978928502905, 0.07573943984989462, 0.20833013251886123, 0.20833013251886123,
    0.20833013251886123, -0.025895587708030243, 0.15009454334192096, -0.02311893396438114, 0.05755446024554689,
    0.13670901861504925, 0.13670901861504925, 0.13670901861504925, 0.0038043647906930156, 0.05054264351978044,
    0.19172492253645335, 0.23271120597817507, 0.07557673982826552, 0.07557673982826552, 0.07557673982826552,
    0.15512484561700912, 0.2274239527272125, 0.09059878250099163, 0.14871903507013584, 0.01638388282544112,
    0.01638388282544112, 0.01638388282544112, 0.08490336295591705, 0.06948572355342675, -0.027895950686216864,
    0.13790125094784877, 0.1020960036681714, 0.1020960036681714, 0.1020960036681714, 0.05542923755293727,
    -0.036773058072957276, 0.2709961037165879, 0.2073275131578094, -0.058770552153550426, -0.058770552153550426,
    -0.058770552153550426, 0.15406233255779045, -0.018097394252884147, -0.05636945118994707, 0.2680932474659429,
    0.05092399533835412, 0.05092399533835412, 0.05092399533835412, 0.1064095073171697, -0.10419907991917698,
    0.041074831742799245, 0.1511303550448101, 0.10649351307143606, 0.10649351307143606, 0.10649351307143606,
    0.10150088532528811, -0.14738003393544874, 0.025323744661858938, 0.2351696240960105, 0.1036676248232703,
    0.1036676248232703, 0.1036676248232703, -0.04498138815754471, 0.06879493978740836, 0.04414115698195098,
    -0.012326482792816895, 0.15333556309585739, 0.15333556309585739, 0.15333556309585739, 0.1533478804136773,
    0.08459686813034795, 0.1879446023240724, 0.08391786688201175, 0.04695134302102699, 0.04695134302102699,
    0.04695134302102699, 0.14293419122475948, 0.16894036093125053, -0.05033675214278599, -0.10454263892012161
]

SIGNAL_SERIES = pd.Series(_levels, index=_cal_date_range)
ASSET_SERIES = pd.Series(_prices, index=_bus_date_range)

TRADE_STATISTICS = {
    "trade_details": [
        {
            "return": 0.2517558387692007,
            "z_scores": 1.5628200329184,
            "open_price": 1713.16665873,
            "close_date": datetime.date(2010, 4, 30),
            "date": datetime.date(2010, 4, 20),
            "close_price": 1281.86694961,
            "trigger_date": datetime.date(2010, 4, 19)
        }, {
            "return": -0.05128721802944324,
            "z_scores": 1.799357211036568,
            "open_price": 1290.02153172,
            "close_date": datetime.date(2010, 5, 17),
            "date": datetime.date(2010, 5, 7),
            "close_price": 1356.18314728,
            "trigger_date": datetime.date(2010, 5, 6)
        }, {
            "return": -0.1997755009979374,
            "z_scores": 1.6234440648436947,
            "open_price": 1164.35738065,
            "close_date": datetime.date(2010, 6, 21),
            "date": datetime.date(2010, 6, 10),
            "close_price": 1396.96745971,
            "trigger_date": datetime.date(2010, 6, 9)
        }, {
            "return": -0.1893528870570925,
            "z_scores": 1.6788125448317828,
            "open_price": 1094.34926787,
            "close_date": datetime.date(2010, 9, 2),
            "date": datetime.date(2010, 8, 23),
            "close_price": 1301.56746119,
            "trigger_date": datetime.date(2010, 8, 20)
        }, {
            "return": 0.10371248126743289,
            "z_scores": 1.672113222523256,
            "open_price": 1416.8008782,
            "close_date": datetime.date(2010, 9, 23),
            "date": datetime.date(2010, 9, 13),
            "close_price": 1269.86094366,
            "trigger_date": datetime.date(2010, 9, 11)
        }, {
            "return": 0.09255498591369354,
            "z_scores": 1.6439762493189847,
            "open_price": 1465.88708745,
            "close_date": datetime.date(2010, 10, 14),
            "date": datetime.date(2010, 10, 4),
            "close_price": 1330.21192872,
            "trigger_date": datetime.date(2010, 10, 2)
        }, {
            "return": -0.2374663788593718,
            "z_scores": 1.749238164030433,
            "open_price": 1225.61257159,
            "close_date": datetime.date(2010, 10, 28),
            "date": datetime.date(2010, 10, 18),
            "close_price": 1516.65435085,
            "trigger_date": datetime.date(2010, 10, 15)
        }, {
            "return": 0.09430313649474212,
            "z_scores": 1.6037846726643559,
            "open_price": 1581.14710361,
            "close_date": datetime.date(2011, 1, 6),
            "date": datetime.date(2010, 12, 27),
            "close_price": 1432.03997248,
            "trigger_date": datetime.date(2010, 12, 26)
        }, {
            "return": 0.09402424796291126,
            "z_scores": 1.798110816530546,
            "open_price": 1338.56512726,
            "close_date": datetime.date(2011, 1, 27),
            "date": datetime.date(2011, 1, 17),
            "close_price": 1212.70754782,
            "trigger_date": datetime.date(2011, 1, 14)
        }
    ], "summary_statistics": [
        {
            "number_of_trades": 8.0,
            "year": 2010,
            "hit_rate": 0.5,
            "mean_return": -0.016944442812346961
        }, {
            "number_of_trades": 1.0,
            "year": 2011,
            "hit_rate": 1.0,
            "mean_return": 0.094024247962911256
        }, {
            "number_of_trades": 9,
            "mean_return": -0.0046145882817627175,
            "hit_rate": 0.55555555555555558,
            "year": "Total"
        }
    ]
}

TRADE_PERCENTILES = {
    1: {
        25: -0.10019032136631202,
        50: -0.029827014148520285,
        75: 0.036440705691883589
    }, 2: {
        25: -0.23356155409496115,
        50: -0.0389059750619698,
        75: 0.057084866612464383
    }, 3: {
        25: -0.18367997586358609,
        50: -0.050894567397944096,
        75: 0.039011046529719755
    }, 4: {
        25: -0.10653995518181646,
        50: 0.061333624958235841,
        75: 0.098794942907955902
    }, 5: {
        25: -0.14175690866993262,
        50: -0.009537372493139247,
        75: 0.046254777936260857
    }, 6: {
        25: -0.13745423696423009,
        50: 0.027802637542088393,
        75: 0.049027965383277805
    }, 7: {
        25: -0.080010177732538809,
        50: 0.027802637542088393,
        75: 0.05541241134215872
    }, 8: {
        25: -0.1253602839604338,
        50: -0.00026148999884219461,
        75: 0.055426153251032062
    }, 9: {
        25: -0.19977550099793739,
        50: -0.051287218029443242,
        75: -0.042906867473055679
    }, 10: {
        25: -0.18935288705709249,
        50: 0.092554985913693544,
        75: 0.094303136494742118
    }
}

TRADE_RETURNS = {
    "daily_returns": pd.Series(_daily_returns, _cal_date_range),
    "cumulative_returns": pd.Series(_cumulative_returns, _cal_date_range),
    "benchmark_returns": pd.Series(_benchmark_returns, _cal_date_range)
}