module.exports =
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_sdk_1 = __webpack_require__(1);
const get_env_or_die_1 = __webpack_require__(2);
const codeCommit = new aws_sdk_1.CodeCommit();
const handler = async (event) => {
    const { region, detail } = event;
    const shouldUpdateApprovalState = get_env_or_die_1.getBoolEnv('UPDATE_APPROVAL_STATE', false);
    const shouldPostComment = get_env_or_die_1.getBoolEnv('POST_COMMENT', false);
    const { pullRequestId, revisionId, repositoryName, beforeCommitId, afterCommitId } = getPullRequestProps(detail);
    const s3Prefix = region === 'us-east-1' ? 's3' : `s3-${region}`;
    switch (detail['build-status']) {
        case CodeBuildState.IN_PROGRESS:
            if (shouldUpdateApprovalState) {
                await codeCommit
                    .updatePullRequestApprovalState({
                    pullRequestId,
                    revisionId,
                    approvalState: 'REVOKE',
                })
                    .promise();
            }
            if (shouldPostComment) {
                await codeCommit
                    .postCommentForPullRequest({
                    pullRequestId,
                    repositoryName,
                    beforeCommitId,
                    afterCommitId,
                    content: `** Build started at ${'time'} **`,
                })
                    .promise();
            }
            break;
        case CodeBuildState.FAILED:
            if (shouldPostComment) {
                const badge = `https://${s3Prefix}.amazonaws.com/codefactory-${region}-prod-default-build-badges/failing.svg`;
                const content = `![Failing](${badge} "Failing") - See the [Logs](${detail['additional-information'].logs['deep-link']})`;
                await codeCommit
                    .postCommentForPullRequest({
                    pullRequestId,
                    repositoryName,
                    beforeCommitId,
                    afterCommitId,
                    content,
                })
                    .promise();
            }
            break;
        case CodeBuildState.SUCCEEDED:
            if (shouldUpdateApprovalState) {
                await codeCommit
                    .updatePullRequestApprovalState({
                    pullRequestId,
                    revisionId,
                    approvalState: 'APPROVE',
                })
                    .promise();
            }
            if (shouldPostComment) {
                const badge = `https://${s3Prefix}.amazonaws.com/codefactory-${region}-prod-default-build-badges/passing.svg`;
                const content = `![Passing](${badge} "Passing") - See the [Logs](${detail['additional-information'].logs['deep-link']})`;
                await codeCommit
                    .postCommentForPullRequest({
                    pullRequestId,
                    repositoryName,
                    beforeCommitId,
                    afterCommitId,
                    content,
                })
                    .promise();
            }
            break;
        case CodeBuildState.STOPPED:
            console.log('Build stopped!');
            break;
        default:
            throw new Error(`Invalid build status: ${detail['build-status']}`);
    }
};
exports.handler = handler;
const getPullRequestProps = (detail) => {
    let repositoryName = '';
    let pullRequestId = '';
    let beforeCommitId = '';
    let afterCommitId = '';
    let revisionId = '';
    detail['additional-information'].environment['environment-variables'].forEach(({ name, value }) => {
        switch (name) {
            case 'pullRequestId':
                pullRequestId = value;
                break;
            case 'repositoryName':
                repositoryName = value;
                break;
            case 'sourceCommit':
                beforeCommitId = value;
                break;
            case 'destinationCommit':
                afterCommitId = value;
                break;
            case 'revisionId':
                revisionId = value;
                break;
        }
    });
    return {
        repositoryName,
        pullRequestId,
        beforeCommitId,
        afterCommitId,
        revisionId,
    };
};
var CodeBuildState;
(function (CodeBuildState) {
    CodeBuildState["IN_PROGRESS"] = "IN_PROGRESS";
    CodeBuildState["SUCCEEDED"] = "SUCCEEDED";
    CodeBuildState["FAILED"] = "FAILED";
    CodeBuildState["STOPPED"] = "STOPPED";
})(CodeBuildState || (CodeBuildState = {}));


/***/ }),
/* 1 */
/***/ (function(module, exports) {

module.exports = require("aws-sdk");

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getRegExpEnv = exports.getDateEnv = exports.getUrlEnv = exports.getArrayEnv = exports.getBoolEnv = exports.getIntEnv = exports.getStringEnv = exports.getEnv = void 0;
const url_1 = __webpack_require__(3);
const getEnv = (name, fallback) => {
    return (0, exports.getStringEnv)(name, fallback);
};
exports.getEnv = getEnv;
const getStringEnv = (name, fallback) => {
    return genericGetEnv(name, fallback);
};
exports.getStringEnv = getStringEnv;
const getIntEnv = (name, fallback) => {
    const env = genericGetEnv(name, fallback);
    const int = parseInt(env, 10);
    if (isNaN(int)) {
        throw new Error(`Env ${name} is not an integer.`);
    }
    return int;
};
exports.getIntEnv = getIntEnv;
const getBoolEnv = (name, fallback) => {
    let env = genericGetEnv(name, fallback);
    if (typeof env === 'boolean')
        return env;
    env = env.toLowerCase();
    if (env === '1' || env === 'true')
        return true;
    if (env === '0' || env === 'false')
        return false;
    throw new Error(`Env ${name} is not a boolean.`);
};
exports.getBoolEnv = getBoolEnv;
const getArrayEnv = (name, fallback) => {
    const env = genericGetEnv(name, fallback);
    if (Array.isArray(env))
        return env;
    return env.split(',');
};
exports.getArrayEnv = getArrayEnv;
const getUrlEnv = (name, fallback) => {
    const env = genericGetEnv(name, fallback);
    try {
        return new url_1.URL(env);
    }
    catch (_a) {
        throw new Error(`Env ${name} is not an url.`);
    }
};
exports.getUrlEnv = getUrlEnv;
const getDateEnv = (name, fallback) => {
    const env = genericGetEnv(name, fallback);
    const date = new Date(env);
    if (date.toString() === 'Invalid Date') {
        throw new Error(`Env ${name} is not a date.`);
    }
    return date;
};
exports.getDateEnv = getDateEnv;
const getRegExpEnv = (name, fallback) => {
    const env = genericGetEnv(name, fallback);
    if (env instanceof RegExp)
        return env;
    try {
        const match = env.match(new RegExp('^/(.*?)/([gimy]*)$'));
        return new RegExp(match[1], match[2]);
    }
    catch (_a) {
        throw new Error(`Env ${name} is not a regExp.`);
    }
};
exports.getRegExpEnv = getRegExpEnv;
const genericGetEnv = (name, fallback) => {
    const env = process.env[name];
    if (env)
        return env;
    if (fallback)
        return fallback;
    throw new Error(`Env ${name} does not exist and no fallback value provided.`);
};
//# sourceMappingURL=data:application/json;base64,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

/***/ }),
/* 3 */
/***/ (function(module, exports) {

module.exports = require("url");

/***/ })
/******/ ]);
//# sourceMappingURL=index.js.map