# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_workshop.ipynb.

# %% auto 0
__all__ = ['wiener_hammerstein', 'silverbox', 'cascaded_tanks', 'emps', 'noisy_wh']

# %% ../nbs/01_workshop.ipynb 2
from .core import *
import nonlinear_benchmarks
from nonlinear_benchmarks.utilities import Input_output_data
from pathlib import Path

# %% ../nbs/01_workshop.ipynb 6
def wiener_hammerstein(
        save_path: Path #directory the files are written to, created if it does not exist
):
    train_val, test = nonlinear_benchmarks.WienerHammerBenchMark()
    split_idx = 80_000
    train = train_val[:split_idx]
    valid = train_val[split_idx:]

    dataset_to_hdf5(train,valid,test,save_path)

# %% ../nbs/01_workshop.ipynb 9
def silverbox(
        save_path: Path #directory the files are written to, created if it does not exist
):
    train_val, test = nonlinear_benchmarks.Silverbox()
    split_idx = 50_000
    train = train_val[:split_idx]
    valid = train_val[split_idx:]

    dataset_to_hdf5(train,valid,test,save_path)

# %% ../nbs/01_workshop.ipynb 12
def cascaded_tanks(
        save_path: Path #directory the files are written to, created if it does not exist
):
    'the cascaded_tanks dataset, '
    train_val, test = nonlinear_benchmarks.Cascaded_Tanks()
    train = train_val
    valid = train_val

    dataset_to_hdf5(train,valid,test,save_path)

# %% ../nbs/01_workshop.ipynb 15
def emps(
        save_path: Path #directory the files are written to, created if it does not exist
):
    'the emps dataset, '
    train_val, test = nonlinear_benchmarks.EMPS()
    split_idx = 18_000
    train = train_val[:split_idx]
    valid = train_val[split_idx:]

    dataset_to_hdf5(train,valid,test,save_path)

# %% ../nbs/01_workshop.ipynb 18
from scipy.io import loadmat
def noisy_wh(
        save_path: Path #directory the files are written to, created if it does not exist
):
    'the wiener hammerstein dataset with process noise'

    #extract raw .mat files, to preserve filenames necessary for train, valid split
    matfiles = nonlinear_benchmarks.not_splitted_benchmarks.WienerHammerstein_Process_Noise(data_file_locations=True,train_test_split=False)

    for file in matfiles:
        f_path = Path(file)
        save_path = Path(save_path)

        if 'Test' in f_path.stem:
            hdf_path = save_path / 'test'
        elif 'Combined' in f_path.stem:
            hdf_path = save_path / 'valid'
        else:
            hdf_path = save_path / 'train'

        out = loadmat(f_path)
        _,u,y,fs = out['dataMeas'][0,0]
        fs = fs[0,0]
        for idx,(ui,yi) in enumerate(zip(u.T,y.T)):
            iodata = Input_output_data(u=ui,y=yi, sampling_time=1/fs)
            fname = f'{f_path.stem}_{idx+1}'
            iodata_to_hdf5(iodata,hdf_path,fname)
