# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801


from typing import List

from pcluster.api import util
from pcluster.api.models.base_model_ import Model
from pcluster.api.models.ec2_ami_state import Ec2AmiState
from pcluster.api.models.tag import Tag


class Ec2AmiInfo(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, ami_name=None, ami_id=None, description=None, state=None, tags=None, architecture=None):
        """Ec2AmiInfo - a model defined in OpenAPI

        :param ami_name: The ami_name of this Ec2AmiInfo.
        :type ami_name: str
        :param ami_id: The ami_id of this Ec2AmiInfo.
        :type ami_id: str
        :param description: The description of this Ec2AmiInfo.
        :type description: str
        :param state: The state of this Ec2AmiInfo.
        :type state: Ec2AmiState
        :param tags: The tags of this Ec2AmiInfo.
        :type tags: List[Tag]
        :param architecture: The architecture of this Ec2AmiInfo.
        :type architecture: str
        """
        self.openapi_types = {
            "ami_name": str,
            "ami_id": str,
            "description": str,
            "state": Ec2AmiState,
            "tags": List[Tag],
            "architecture": str,
        }

        self.attribute_map = {
            "ami_name": "amiName",
            "ami_id": "amiId",
            "description": "description",
            "state": "state",
            "tags": "tags",
            "architecture": "architecture",
        }

        self._ami_name = ami_name
        self._ami_id = ami_id
        self._description = description
        self._state = state
        self._tags = tags
        self._architecture = architecture

    @classmethod
    def from_dict(cls, dikt) -> "Ec2AmiInfo":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Ec2AmiInfo of this Ec2AmiInfo.
        :rtype: Ec2AmiInfo
        """
        return util.deserialize_model(dikt, cls)

    @property
    def ami_name(self):
        """Gets the ami_name of this Ec2AmiInfo.

        EC2 AMI name

        :return: The ami_name of this Ec2AmiInfo.
        :rtype: str
        """
        return self._ami_name

    @ami_name.setter
    def ami_name(self, ami_name):
        """Sets the ami_name of this Ec2AmiInfo.

        EC2 AMI name

        :param ami_name: The ami_name of this Ec2AmiInfo.
        :type ami_name: str
        """
        if ami_name is None:
            raise ValueError("Invalid value for `ami_name`, must not be `None`")

        self._ami_name = ami_name

    @property
    def ami_id(self):
        """Gets the ami_id of this Ec2AmiInfo.

        EC2 AMI id

        :return: The ami_id of this Ec2AmiInfo.
        :rtype: str
        """
        return self._ami_id

    @ami_id.setter
    def ami_id(self, ami_id):
        """Sets the ami_id of this Ec2AmiInfo.

        EC2 AMI id

        :param ami_id: The ami_id of this Ec2AmiInfo.
        :type ami_id: str
        """
        if ami_id is None:
            raise ValueError("Invalid value for `ami_id`, must not be `None`")

        self._ami_id = ami_id

    @property
    def description(self):
        """Gets the description of this Ec2AmiInfo.

        EC2 AMI description  # noqa: E501

        :return: The description of this Ec2AmiInfo.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Ec2AmiInfo.

        EC2 AMI description  # noqa: E501

        :param description: The description of this Ec2AmiInfo.
        :type description: str
        """
        if description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def state(self):
        """Gets the state of this Ec2AmiInfo.


        :return: The state of this Ec2AmiInfo.
        :rtype: Ec2AmiState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Ec2AmiInfo.


        :param state: The state of this Ec2AmiInfo.
        :type state: Ec2AmiState
        """
        if state is None:
            raise ValueError("Invalid value for `state`, must not be `None`")

        self._state = state

    @property
    def tags(self):
        """Gets the tags of this Ec2AmiInfo.

        EC2 AMI Tags

        :return: The tags of this Ec2AmiInfo.
        :rtype: List[Tag]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this Ec2AmiInfo.

        EC2 AMI Tags

        :param tags: The tags of this Ec2AmiInfo.
        :type tags: List[Tag]
        """
        if tags is None:
            raise ValueError("Invalid value for `tags`, must not be `None`")

        self._tags = tags

    @property
    def architecture(self):
        """Gets the architecture of this Ec2AmiInfo.

        EC2 AMI architecture

        :return: The architecture of this Ec2AmiInfo.
        :rtype: str
        """
        return self._architecture

    @architecture.setter
    def architecture(self, architecture):
        """Sets the architecture of this Ec2AmiInfo.

        EC2 AMI architecture

        :param architecture: The architecture of this Ec2AmiInfo.
        :type architecture: str
        """
        if architecture is None:
            raise ValueError("Invalid value for `architecture`, must not be `None`")

        self._architecture = architecture
