# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

from __future__ import absolute_import

from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from pcluster.api import util
from pcluster.api.models.base_model_ import Model
from pcluster.api.models.instance_state import InstanceState  # noqa: E501
from pcluster.api.models.node_type import NodeType  # noqa: E501


class ClusterInstance(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self,
        launch_time=None,
        instance_id=None,
        queue_name=None,
        public_ip_address=None,
        instance_type=None,
        state=None,
        node_type=None,
        private_ip_address=None,
    ):  # noqa: E501
        """ClusterInstance - a model defined in OpenAPI

        :param launch_time: The launch_time of this ClusterInstance.  # noqa: E501
        :type launch_time: datetime
        :param instance_id: The instance_id of this ClusterInstance.  # noqa: E501
        :type instance_id: str
        :param queue_name: The queue_name of this ClusterInstance.  # noqa: E501
        :type queue_name: str
        :param public_ip_address: The public_ip_address of this ClusterInstance.  # noqa: E501
        :type public_ip_address: str
        :param instance_type: The instance_type of this ClusterInstance.  # noqa: E501
        :type instance_type: str
        :param state: The state of this ClusterInstance.  # noqa: E501
        :type state: InstanceState
        :param node_type: The node_type of this ClusterInstance.  # noqa: E501
        :type node_type: NodeType
        :param private_ip_address: The private_ip_address of this ClusterInstance.  # noqa: E501
        :type private_ip_address: str
        """
        self.openapi_types = {
            "launch_time": datetime,
            "instance_id": str,
            "queue_name": str,
            "public_ip_address": str,
            "instance_type": str,
            "state": InstanceState,
            "node_type": NodeType,
            "private_ip_address": str,
        }

        self.attribute_map = {
            "launch_time": "launchTime",
            "instance_id": "instanceId",
            "queue_name": "queueName",
            "public_ip_address": "publicIpAddress",
            "instance_type": "instanceType",
            "state": "state",
            "node_type": "nodeType",
            "private_ip_address": "privateIpAddress",
        }

        self._launch_time = launch_time
        self._instance_id = instance_id
        self._queue_name = queue_name
        self._public_ip_address = public_ip_address
        self._instance_type = instance_type
        self._state = state
        self._node_type = node_type
        self._private_ip_address = private_ip_address

    @classmethod
    def from_dict(cls, dikt) -> "ClusterInstance":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ClusterInstance of this ClusterInstance.  # noqa: E501
        :rtype: ClusterInstance
        """
        return util.deserialize_model(dikt, cls)

    @property
    def launch_time(self):
        """Gets the launch_time of this ClusterInstance.


        :return: The launch_time of this ClusterInstance.
        :rtype: datetime
        """
        return self._launch_time

    @launch_time.setter
    def launch_time(self, launch_time):
        """Sets the launch_time of this ClusterInstance.


        :param launch_time: The launch_time of this ClusterInstance.
        :type launch_time: datetime
        """
        if launch_time is None:
            raise ValueError("Invalid value for `launch_time`, must not be `None`")  # noqa: E501

        self._launch_time = launch_time

    @property
    def instance_id(self):
        """Gets the instance_id of this ClusterInstance.


        :return: The instance_id of this ClusterInstance.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """Sets the instance_id of this ClusterInstance.


        :param instance_id: The instance_id of this ClusterInstance.
        :type instance_id: str
        """
        if instance_id is None:
            raise ValueError("Invalid value for `instance_id`, must not be `None`")  # noqa: E501

        self._instance_id = instance_id

    @property
    def queue_name(self):
        """Gets the queue_name of this ClusterInstance.


        :return: The queue_name of this ClusterInstance.
        :rtype: str
        """
        return self._queue_name

    @queue_name.setter
    def queue_name(self, queue_name):
        """Sets the queue_name of this ClusterInstance.


        :param queue_name: The queue_name of this ClusterInstance.
        :type queue_name: str
        """

        self._queue_name = queue_name

    @property
    def public_ip_address(self):
        """Gets the public_ip_address of this ClusterInstance.


        :return: The public_ip_address of this ClusterInstance.
        :rtype: str
        """
        return self._public_ip_address

    @public_ip_address.setter
    def public_ip_address(self, public_ip_address):
        """Sets the public_ip_address of this ClusterInstance.


        :param public_ip_address: The public_ip_address of this ClusterInstance.
        :type public_ip_address: str
        """

        self._public_ip_address = public_ip_address

    @property
    def instance_type(self):
        """Gets the instance_type of this ClusterInstance.


        :return: The instance_type of this ClusterInstance.
        :rtype: str
        """
        return self._instance_type

    @instance_type.setter
    def instance_type(self, instance_type):
        """Sets the instance_type of this ClusterInstance.


        :param instance_type: The instance_type of this ClusterInstance.
        :type instance_type: str
        """
        if instance_type is None:
            raise ValueError("Invalid value for `instance_type`, must not be `None`")  # noqa: E501

        self._instance_type = instance_type

    @property
    def state(self):
        """Gets the state of this ClusterInstance.


        :return: The state of this ClusterInstance.
        :rtype: InstanceState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this ClusterInstance.


        :param state: The state of this ClusterInstance.
        :type state: InstanceState
        """
        if state is None:
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501

        self._state = state

    @property
    def node_type(self):
        """Gets the node_type of this ClusterInstance.


        :return: The node_type of this ClusterInstance.
        :rtype: NodeType
        """
        return self._node_type

    @node_type.setter
    def node_type(self, node_type):
        """Sets the node_type of this ClusterInstance.


        :param node_type: The node_type of this ClusterInstance.
        :type node_type: NodeType
        """
        if node_type is None:
            raise ValueError("Invalid value for `node_type`, must not be `None`")  # noqa: E501

        self._node_type = node_type

    @property
    def private_ip_address(self):
        """Gets the private_ip_address of this ClusterInstance.


        :return: The private_ip_address of this ClusterInstance.
        :rtype: str
        """
        return self._private_ip_address

    @private_ip_address.setter
    def private_ip_address(self, private_ip_address):
        """Sets the private_ip_address of this ClusterInstance.


        :param private_ip_address: The private_ip_address of this ClusterInstance.
        :type private_ip_address: str
        """
        if private_ip_address is None:
            raise ValueError("Invalid value for `private_ip_address`, must not be `None`")  # noqa: E501

        self._private_ip_address = private_ip_address
