# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801


from pcluster.api import util
from pcluster.api.models.base_model_ import Model


class ClusterConfigurationStructure(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, url=None):
        """ClusterConfigurationStructure - a model defined in OpenAPI

        :param url: The url of this ClusterConfigurationStructure.
        :type url: str
        """
        self.openapi_types = {"url": str}

        self.attribute_map = {"url": "url"}

        self._url = url

    @classmethod
    def from_dict(cls, dikt) -> "ClusterConfigurationStructure":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ClusterConfigurationStructure of this ClusterConfigurationStructure.
        :rtype: ClusterConfigurationStructure
        """
        return util.deserialize_model(dikt, cls)

    @property
    def url(self):
        """Gets the url of this ClusterConfigurationStructure.

        S3 Url pointing to the cluster configuration file.

        :return: The url of this ClusterConfigurationStructure.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this ClusterConfigurationStructure.

        S3 Url pointing to the cluster configuration file.

        :param url: The url of this ClusterConfigurationStructure.
        :type url: str
        """

        self._url = url
