"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessRule = exports.AccessRuleProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dfs_generated_1 = require("./dfs.generated");
Object.defineProperty(exports, "AccessRuleProperty", { enumerable: true, get: function () { return dfs_generated_1.RosAccessRule; } });
/**
 * A ROS resource type:  `ALIYUN::DFS::AccessRule`
 */
class AccessRule extends ros.Resource {
    /**
     * Create a new `ALIYUN::DFS::AccessRule`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAccessRule = new dfs_generated_1.RosAccessRule(this, id, {
            description: props.description,
            priority: props.priority,
            networkSegment: props.networkSegment,
            accessGroupId: props.accessGroupId,
            rwAccessType: props.rwAccessType === undefined || props.rwAccessType === null ? 'RDWR' : props.rwAccessType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAccessRule;
        this.attrAccessRuleId = rosAccessRule.attrAccessRuleId;
    }
}
exports.AccessRule = AccessRule;
//# sourceMappingURL=data:application/json;base64,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