# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixTunnelArgs', 'AviatrixTunnel']

@pulumi.input_type
class AviatrixTunnelArgs:
    def __init__(__self__, *,
                 gw_name1: pulumi.Input[str],
                 gw_name2: pulumi.Input[str],
                 enable_ha: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AviatrixTunnel resource.
        :param pulumi.Input[str] gw_name1: The first VPC Container name to make a peer pair.
        :param pulumi.Input[str] gw_name2: The second VPC Container name to make a peer pair.
        :param pulumi.Input[bool] enable_ha: Whether Peering HA is enabled. Valid inputs: true or false.
        """
        pulumi.set(__self__, "gw_name1", gw_name1)
        pulumi.set(__self__, "gw_name2", gw_name2)
        if enable_ha is not None:
            pulumi.set(__self__, "enable_ha", enable_ha)

    @property
    @pulumi.getter(name="gwName1")
    def gw_name1(self) -> pulumi.Input[str]:
        """
        The first VPC Container name to make a peer pair.
        """
        return pulumi.get(self, "gw_name1")

    @gw_name1.setter
    def gw_name1(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name1", value)

    @property
    @pulumi.getter(name="gwName2")
    def gw_name2(self) -> pulumi.Input[str]:
        """
        The second VPC Container name to make a peer pair.
        """
        return pulumi.get(self, "gw_name2")

    @gw_name2.setter
    def gw_name2(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name2", value)

    @property
    @pulumi.getter(name="enableHa")
    def enable_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Peering HA is enabled. Valid inputs: true or false.
        """
        return pulumi.get(self, "enable_ha")

    @enable_ha.setter
    def enable_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ha", value)


@pulumi.input_type
class _AviatrixTunnelState:
    def __init__(__self__, *,
                 enable_ha: Optional[pulumi.Input[bool]] = None,
                 gw_name1: Optional[pulumi.Input[str]] = None,
                 gw_name2: Optional[pulumi.Input[str]] = None,
                 peering_hastatus: Optional[pulumi.Input[str]] = None,
                 peering_link: Optional[pulumi.Input[str]] = None,
                 peering_state: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixTunnel resources.
        :param pulumi.Input[bool] enable_ha: Whether Peering HA is enabled. Valid inputs: true or false.
        :param pulumi.Input[str] gw_name1: The first VPC Container name to make a peer pair.
        :param pulumi.Input[str] gw_name2: The second VPC Container name to make a peer pair.
        :param pulumi.Input[str] peering_hastatus: Status of the HA tunnel.
        :param pulumi.Input[str] peering_link: Name of the peering link.
        :param pulumi.Input[str] peering_state: Status of the tunnel.
        """
        if enable_ha is not None:
            pulumi.set(__self__, "enable_ha", enable_ha)
        if gw_name1 is not None:
            pulumi.set(__self__, "gw_name1", gw_name1)
        if gw_name2 is not None:
            pulumi.set(__self__, "gw_name2", gw_name2)
        if peering_hastatus is not None:
            pulumi.set(__self__, "peering_hastatus", peering_hastatus)
        if peering_link is not None:
            pulumi.set(__self__, "peering_link", peering_link)
        if peering_state is not None:
            pulumi.set(__self__, "peering_state", peering_state)

    @property
    @pulumi.getter(name="enableHa")
    def enable_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Peering HA is enabled. Valid inputs: true or false.
        """
        return pulumi.get(self, "enable_ha")

    @enable_ha.setter
    def enable_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ha", value)

    @property
    @pulumi.getter(name="gwName1")
    def gw_name1(self) -> Optional[pulumi.Input[str]]:
        """
        The first VPC Container name to make a peer pair.
        """
        return pulumi.get(self, "gw_name1")

    @gw_name1.setter
    def gw_name1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name1", value)

    @property
    @pulumi.getter(name="gwName2")
    def gw_name2(self) -> Optional[pulumi.Input[str]]:
        """
        The second VPC Container name to make a peer pair.
        """
        return pulumi.get(self, "gw_name2")

    @gw_name2.setter
    def gw_name2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name2", value)

    @property
    @pulumi.getter(name="peeringHastatus")
    def peering_hastatus(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the HA tunnel.
        """
        return pulumi.get(self, "peering_hastatus")

    @peering_hastatus.setter
    def peering_hastatus(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_hastatus", value)

    @property
    @pulumi.getter(name="peeringLink")
    def peering_link(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the peering link.
        """
        return pulumi.get(self, "peering_link")

    @peering_link.setter
    def peering_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_link", value)

    @property
    @pulumi.getter(name="peeringState")
    def peering_state(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the tunnel.
        """
        return pulumi.get(self, "peering_state")

    @peering_state.setter
    def peering_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_state", value)


class AviatrixTunnel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_ha: Optional[pulumi.Input[bool]] = None,
                 gw_name1: Optional[pulumi.Input[str]] = None,
                 gw_name2: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixTunnel resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_ha: Whether Peering HA is enabled. Valid inputs: true or false.
        :param pulumi.Input[str] gw_name1: The first VPC Container name to make a peer pair.
        :param pulumi.Input[str] gw_name2: The second VPC Container name to make a peer pair.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixTunnelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixTunnel resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixTunnelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixTunnelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_ha: Optional[pulumi.Input[bool]] = None,
                 gw_name1: Optional[pulumi.Input[str]] = None,
                 gw_name2: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixTunnelArgs.__new__(AviatrixTunnelArgs)

            __props__.__dict__["enable_ha"] = enable_ha
            if gw_name1 is None and not opts.urn:
                raise TypeError("Missing required property 'gw_name1'")
            __props__.__dict__["gw_name1"] = gw_name1
            if gw_name2 is None and not opts.urn:
                raise TypeError("Missing required property 'gw_name2'")
            __props__.__dict__["gw_name2"] = gw_name2
            __props__.__dict__["peering_hastatus"] = None
            __props__.__dict__["peering_link"] = None
            __props__.__dict__["peering_state"] = None
        super(AviatrixTunnel, __self__).__init__(
            'aviatrix:index/aviatrixTunnel:AviatrixTunnel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_ha: Optional[pulumi.Input[bool]] = None,
            gw_name1: Optional[pulumi.Input[str]] = None,
            gw_name2: Optional[pulumi.Input[str]] = None,
            peering_hastatus: Optional[pulumi.Input[str]] = None,
            peering_link: Optional[pulumi.Input[str]] = None,
            peering_state: Optional[pulumi.Input[str]] = None) -> 'AviatrixTunnel':
        """
        Get an existing AviatrixTunnel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_ha: Whether Peering HA is enabled. Valid inputs: true or false.
        :param pulumi.Input[str] gw_name1: The first VPC Container name to make a peer pair.
        :param pulumi.Input[str] gw_name2: The second VPC Container name to make a peer pair.
        :param pulumi.Input[str] peering_hastatus: Status of the HA tunnel.
        :param pulumi.Input[str] peering_link: Name of the peering link.
        :param pulumi.Input[str] peering_state: Status of the tunnel.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixTunnelState.__new__(_AviatrixTunnelState)

        __props__.__dict__["enable_ha"] = enable_ha
        __props__.__dict__["gw_name1"] = gw_name1
        __props__.__dict__["gw_name2"] = gw_name2
        __props__.__dict__["peering_hastatus"] = peering_hastatus
        __props__.__dict__["peering_link"] = peering_link
        __props__.__dict__["peering_state"] = peering_state
        return AviatrixTunnel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enableHa")
    def enable_ha(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether Peering HA is enabled. Valid inputs: true or false.
        """
        return pulumi.get(self, "enable_ha")

    @property
    @pulumi.getter(name="gwName1")
    def gw_name1(self) -> pulumi.Output[str]:
        """
        The first VPC Container name to make a peer pair.
        """
        return pulumi.get(self, "gw_name1")

    @property
    @pulumi.getter(name="gwName2")
    def gw_name2(self) -> pulumi.Output[str]:
        """
        The second VPC Container name to make a peer pair.
        """
        return pulumi.get(self, "gw_name2")

    @property
    @pulumi.getter(name="peeringHastatus")
    def peering_hastatus(self) -> pulumi.Output[str]:
        """
        Status of the HA tunnel.
        """
        return pulumi.get(self, "peering_hastatus")

    @property
    @pulumi.getter(name="peeringLink")
    def peering_link(self) -> pulumi.Output[str]:
        """
        Name of the peering link.
        """
        return pulumi.get(self, "peering_link")

    @property
    @pulumi.getter(name="peeringState")
    def peering_state(self) -> pulumi.Output[str]:
        """
        Status of the tunnel.
        """
        return pulumi.get(self, "peering_state")

