# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixTransitVpcArgs', 'AviatrixTransitVpc']

@pulumi.input_type
class AviatrixTransitVpcArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 cloud_type: pulumi.Input[int],
                 gw_name: pulumi.Input[str],
                 subnet: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 vpc_reg: pulumi.Input[str],
                 vpc_size: pulumi.Input[str],
                 connected_transit: Optional[pulumi.Input[str]] = None,
                 enable_firenet_interfaces: Optional[pulumi.Input[bool]] = None,
                 enable_hybrid_connection: Optional[pulumi.Input[bool]] = None,
                 enable_nat: Optional[pulumi.Input[str]] = None,
                 ha_gw_size: Optional[pulumi.Input[str]] = None,
                 ha_insane_mode_az: Optional[pulumi.Input[str]] = None,
                 ha_subnet: Optional[pulumi.Input[str]] = None,
                 insane_mode: Optional[pulumi.Input[bool]] = None,
                 insane_mode_az: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AviatrixTransitVpc resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider, requires an integer value. Use 1 for AWS.
        :param pulumi.Input[str] gw_name: Name of the gateway which is going to be created.
        :param pulumi.Input[str] subnet: Public Subnet Name.
        :param pulumi.Input[str] vpc_id: VPC-ID/VNet-Name of cloud provider.
        :param pulumi.Input[str] vpc_reg: Region of cloud provider.
        :param pulumi.Input[str] vpc_size: Size of the gateway instance.
        :param pulumi.Input[str] connected_transit: Specify Connected Transit status.
        :param pulumi.Input[bool] enable_firenet_interfaces: Specify whether to enable firenet interfaces or not.
        :param pulumi.Input[bool] enable_hybrid_connection: Sign of readiness for TGW connection.
        :param pulumi.Input[str] enable_nat: Enable NAT for this container.
        :param pulumi.Input[str] ha_gw_size: HA Gateway Size. Mandatory if HA is enabled (ha_subnet is set).
        :param pulumi.Input[str] ha_insane_mode_az: AZ of subnet being created for Insane Mode Transit HA Gateway. Required if insane_mode is enabled and ha_subnet is set.
        :param pulumi.Input[str] ha_subnet: HA Subnet.
        :param pulumi.Input[bool] insane_mode: Enable Insane Mode for Transit. Valid values: true, false. If insane mode is enabled, gateway size has to at least be c5
               size.
        :param pulumi.Input[str] insane_mode_az: AZ of subnet being created for Insane Mode Transit Gateway. Required if insane_mode is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: Instance tag of cloud provider.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "cloud_type", cloud_type)
        pulumi.set(__self__, "gw_name", gw_name)
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_reg", vpc_reg)
        pulumi.set(__self__, "vpc_size", vpc_size)
        if connected_transit is not None:
            pulumi.set(__self__, "connected_transit", connected_transit)
        if enable_firenet_interfaces is not None:
            pulumi.set(__self__, "enable_firenet_interfaces", enable_firenet_interfaces)
        if enable_hybrid_connection is not None:
            pulumi.set(__self__, "enable_hybrid_connection", enable_hybrid_connection)
        if enable_nat is not None:
            pulumi.set(__self__, "enable_nat", enable_nat)
        if ha_gw_size is not None:
            pulumi.set(__self__, "ha_gw_size", ha_gw_size)
        if ha_insane_mode_az is not None:
            pulumi.set(__self__, "ha_insane_mode_az", ha_insane_mode_az)
        if ha_subnet is not None:
            pulumi.set(__self__, "ha_subnet", ha_subnet)
        if insane_mode is not None:
            pulumi.set(__self__, "insane_mode", insane_mode)
        if insane_mode_az is not None:
            pulumi.set(__self__, "insane_mode_az", insane_mode_az)
        if tag_lists is not None:
            pulumi.set(__self__, "tag_lists", tag_lists)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Input[int]:
        """
        Type of cloud service provider, requires an integer value. Use 1 for AWS.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: pulumi.Input[int]):
        pulumi.set(self, "cloud_type", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Input[str]:
        """
        Name of the gateway which is going to be created.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Input[str]:
        """
        Public Subnet Name.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPC-ID/VNet-Name of cloud provider.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcReg")
    def vpc_reg(self) -> pulumi.Input[str]:
        """
        Region of cloud provider.
        """
        return pulumi.get(self, "vpc_reg")

    @vpc_reg.setter
    def vpc_reg(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_reg", value)

    @property
    @pulumi.getter(name="vpcSize")
    def vpc_size(self) -> pulumi.Input[str]:
        """
        Size of the gateway instance.
        """
        return pulumi.get(self, "vpc_size")

    @vpc_size.setter
    def vpc_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_size", value)

    @property
    @pulumi.getter(name="connectedTransit")
    def connected_transit(self) -> Optional[pulumi.Input[str]]:
        """
        Specify Connected Transit status.
        """
        return pulumi.get(self, "connected_transit")

    @connected_transit.setter
    def connected_transit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connected_transit", value)

    @property
    @pulumi.getter(name="enableFirenetInterfaces")
    def enable_firenet_interfaces(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether to enable firenet interfaces or not.
        """
        return pulumi.get(self, "enable_firenet_interfaces")

    @enable_firenet_interfaces.setter
    def enable_firenet_interfaces(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_firenet_interfaces", value)

    @property
    @pulumi.getter(name="enableHybridConnection")
    def enable_hybrid_connection(self) -> Optional[pulumi.Input[bool]]:
        """
        Sign of readiness for TGW connection.
        """
        return pulumi.get(self, "enable_hybrid_connection")

    @enable_hybrid_connection.setter
    def enable_hybrid_connection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_hybrid_connection", value)

    @property
    @pulumi.getter(name="enableNat")
    def enable_nat(self) -> Optional[pulumi.Input[str]]:
        """
        Enable NAT for this container.
        """
        return pulumi.get(self, "enable_nat")

    @enable_nat.setter
    def enable_nat(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_nat", value)

    @property
    @pulumi.getter(name="haGwSize")
    def ha_gw_size(self) -> Optional[pulumi.Input[str]]:
        """
        HA Gateway Size. Mandatory if HA is enabled (ha_subnet is set).
        """
        return pulumi.get(self, "ha_gw_size")

    @ha_gw_size.setter
    def ha_gw_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_gw_size", value)

    @property
    @pulumi.getter(name="haInsaneModeAz")
    def ha_insane_mode_az(self) -> Optional[pulumi.Input[str]]:
        """
        AZ of subnet being created for Insane Mode Transit HA Gateway. Required if insane_mode is enabled and ha_subnet is set.
        """
        return pulumi.get(self, "ha_insane_mode_az")

    @ha_insane_mode_az.setter
    def ha_insane_mode_az(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_insane_mode_az", value)

    @property
    @pulumi.getter(name="haSubnet")
    def ha_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        HA Subnet.
        """
        return pulumi.get(self, "ha_subnet")

    @ha_subnet.setter
    def ha_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_subnet", value)

    @property
    @pulumi.getter(name="insaneMode")
    def insane_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Insane Mode for Transit. Valid values: true, false. If insane mode is enabled, gateway size has to at least be c5
        size.
        """
        return pulumi.get(self, "insane_mode")

    @insane_mode.setter
    def insane_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insane_mode", value)

    @property
    @pulumi.getter(name="insaneModeAz")
    def insane_mode_az(self) -> Optional[pulumi.Input[str]]:
        """
        AZ of subnet being created for Insane Mode Transit Gateway. Required if insane_mode is enabled.
        """
        return pulumi.get(self, "insane_mode_az")

    @insane_mode_az.setter
    def insane_mode_az(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insane_mode_az", value)

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Instance tag of cloud provider.
        """
        return pulumi.get(self, "tag_lists")

    @tag_lists.setter
    def tag_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tag_lists", value)


@pulumi.input_type
class _AviatrixTransitVpcState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 connected_transit: Optional[pulumi.Input[str]] = None,
                 enable_firenet_interfaces: Optional[pulumi.Input[bool]] = None,
                 enable_hybrid_connection: Optional[pulumi.Input[bool]] = None,
                 enable_nat: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 ha_gw_size: Optional[pulumi.Input[str]] = None,
                 ha_insane_mode_az: Optional[pulumi.Input[str]] = None,
                 ha_subnet: Optional[pulumi.Input[str]] = None,
                 insane_mode: Optional[pulumi.Input[bool]] = None,
                 insane_mode_az: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_reg: Optional[pulumi.Input[str]] = None,
                 vpc_size: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixTransitVpc resources.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider, requires an integer value. Use 1 for AWS.
        :param pulumi.Input[str] connected_transit: Specify Connected Transit status.
        :param pulumi.Input[bool] enable_firenet_interfaces: Specify whether to enable firenet interfaces or not.
        :param pulumi.Input[bool] enable_hybrid_connection: Sign of readiness for TGW connection.
        :param pulumi.Input[str] enable_nat: Enable NAT for this container.
        :param pulumi.Input[str] gw_name: Name of the gateway which is going to be created.
        :param pulumi.Input[str] ha_gw_size: HA Gateway Size. Mandatory if HA is enabled (ha_subnet is set).
        :param pulumi.Input[str] ha_insane_mode_az: AZ of subnet being created for Insane Mode Transit HA Gateway. Required if insane_mode is enabled and ha_subnet is set.
        :param pulumi.Input[str] ha_subnet: HA Subnet.
        :param pulumi.Input[bool] insane_mode: Enable Insane Mode for Transit. Valid values: true, false. If insane mode is enabled, gateway size has to at least be c5
               size.
        :param pulumi.Input[str] insane_mode_az: AZ of subnet being created for Insane Mode Transit Gateway. Required if insane_mode is enabled.
        :param pulumi.Input[str] subnet: Public Subnet Name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: Instance tag of cloud provider.
        :param pulumi.Input[str] vpc_id: VPC-ID/VNet-Name of cloud provider.
        :param pulumi.Input[str] vpc_reg: Region of cloud provider.
        :param pulumi.Input[str] vpc_size: Size of the gateway instance.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if cloud_type is not None:
            pulumi.set(__self__, "cloud_type", cloud_type)
        if connected_transit is not None:
            pulumi.set(__self__, "connected_transit", connected_transit)
        if enable_firenet_interfaces is not None:
            pulumi.set(__self__, "enable_firenet_interfaces", enable_firenet_interfaces)
        if enable_hybrid_connection is not None:
            pulumi.set(__self__, "enable_hybrid_connection", enable_hybrid_connection)
        if enable_nat is not None:
            pulumi.set(__self__, "enable_nat", enable_nat)
        if gw_name is not None:
            pulumi.set(__self__, "gw_name", gw_name)
        if ha_gw_size is not None:
            pulumi.set(__self__, "ha_gw_size", ha_gw_size)
        if ha_insane_mode_az is not None:
            pulumi.set(__self__, "ha_insane_mode_az", ha_insane_mode_az)
        if ha_subnet is not None:
            pulumi.set(__self__, "ha_subnet", ha_subnet)
        if insane_mode is not None:
            pulumi.set(__self__, "insane_mode", insane_mode)
        if insane_mode_az is not None:
            pulumi.set(__self__, "insane_mode_az", insane_mode_az)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if tag_lists is not None:
            pulumi.set(__self__, "tag_lists", tag_lists)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_reg is not None:
            pulumi.set(__self__, "vpc_reg", vpc_reg)
        if vpc_size is not None:
            pulumi.set(__self__, "vpc_size", vpc_size)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> Optional[pulumi.Input[int]]:
        """
        Type of cloud service provider, requires an integer value. Use 1 for AWS.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud_type", value)

    @property
    @pulumi.getter(name="connectedTransit")
    def connected_transit(self) -> Optional[pulumi.Input[str]]:
        """
        Specify Connected Transit status.
        """
        return pulumi.get(self, "connected_transit")

    @connected_transit.setter
    def connected_transit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connected_transit", value)

    @property
    @pulumi.getter(name="enableFirenetInterfaces")
    def enable_firenet_interfaces(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether to enable firenet interfaces or not.
        """
        return pulumi.get(self, "enable_firenet_interfaces")

    @enable_firenet_interfaces.setter
    def enable_firenet_interfaces(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_firenet_interfaces", value)

    @property
    @pulumi.getter(name="enableHybridConnection")
    def enable_hybrid_connection(self) -> Optional[pulumi.Input[bool]]:
        """
        Sign of readiness for TGW connection.
        """
        return pulumi.get(self, "enable_hybrid_connection")

    @enable_hybrid_connection.setter
    def enable_hybrid_connection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_hybrid_connection", value)

    @property
    @pulumi.getter(name="enableNat")
    def enable_nat(self) -> Optional[pulumi.Input[str]]:
        """
        Enable NAT for this container.
        """
        return pulumi.get(self, "enable_nat")

    @enable_nat.setter
    def enable_nat(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_nat", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the gateway which is going to be created.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="haGwSize")
    def ha_gw_size(self) -> Optional[pulumi.Input[str]]:
        """
        HA Gateway Size. Mandatory if HA is enabled (ha_subnet is set).
        """
        return pulumi.get(self, "ha_gw_size")

    @ha_gw_size.setter
    def ha_gw_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_gw_size", value)

    @property
    @pulumi.getter(name="haInsaneModeAz")
    def ha_insane_mode_az(self) -> Optional[pulumi.Input[str]]:
        """
        AZ of subnet being created for Insane Mode Transit HA Gateway. Required if insane_mode is enabled and ha_subnet is set.
        """
        return pulumi.get(self, "ha_insane_mode_az")

    @ha_insane_mode_az.setter
    def ha_insane_mode_az(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_insane_mode_az", value)

    @property
    @pulumi.getter(name="haSubnet")
    def ha_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        HA Subnet.
        """
        return pulumi.get(self, "ha_subnet")

    @ha_subnet.setter
    def ha_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_subnet", value)

    @property
    @pulumi.getter(name="insaneMode")
    def insane_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Insane Mode for Transit. Valid values: true, false. If insane mode is enabled, gateway size has to at least be c5
        size.
        """
        return pulumi.get(self, "insane_mode")

    @insane_mode.setter
    def insane_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insane_mode", value)

    @property
    @pulumi.getter(name="insaneModeAz")
    def insane_mode_az(self) -> Optional[pulumi.Input[str]]:
        """
        AZ of subnet being created for Insane Mode Transit Gateway. Required if insane_mode is enabled.
        """
        return pulumi.get(self, "insane_mode_az")

    @insane_mode_az.setter
    def insane_mode_az(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insane_mode_az", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Public Subnet Name.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Instance tag of cloud provider.
        """
        return pulumi.get(self, "tag_lists")

    @tag_lists.setter
    def tag_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tag_lists", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC-ID/VNet-Name of cloud provider.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcReg")
    def vpc_reg(self) -> Optional[pulumi.Input[str]]:
        """
        Region of cloud provider.
        """
        return pulumi.get(self, "vpc_reg")

    @vpc_reg.setter
    def vpc_reg(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_reg", value)

    @property
    @pulumi.getter(name="vpcSize")
    def vpc_size(self) -> Optional[pulumi.Input[str]]:
        """
        Size of the gateway instance.
        """
        return pulumi.get(self, "vpc_size")

    @vpc_size.setter
    def vpc_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_size", value)


class AviatrixTransitVpc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 connected_transit: Optional[pulumi.Input[str]] = None,
                 enable_firenet_interfaces: Optional[pulumi.Input[bool]] = None,
                 enable_hybrid_connection: Optional[pulumi.Input[bool]] = None,
                 enable_nat: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 ha_gw_size: Optional[pulumi.Input[str]] = None,
                 ha_insane_mode_az: Optional[pulumi.Input[str]] = None,
                 ha_subnet: Optional[pulumi.Input[str]] = None,
                 insane_mode: Optional[pulumi.Input[bool]] = None,
                 insane_mode_az: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_reg: Optional[pulumi.Input[str]] = None,
                 vpc_size: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixTransitVpc resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider, requires an integer value. Use 1 for AWS.
        :param pulumi.Input[str] connected_transit: Specify Connected Transit status.
        :param pulumi.Input[bool] enable_firenet_interfaces: Specify whether to enable firenet interfaces or not.
        :param pulumi.Input[bool] enable_hybrid_connection: Sign of readiness for TGW connection.
        :param pulumi.Input[str] enable_nat: Enable NAT for this container.
        :param pulumi.Input[str] gw_name: Name of the gateway which is going to be created.
        :param pulumi.Input[str] ha_gw_size: HA Gateway Size. Mandatory if HA is enabled (ha_subnet is set).
        :param pulumi.Input[str] ha_insane_mode_az: AZ of subnet being created for Insane Mode Transit HA Gateway. Required if insane_mode is enabled and ha_subnet is set.
        :param pulumi.Input[str] ha_subnet: HA Subnet.
        :param pulumi.Input[bool] insane_mode: Enable Insane Mode for Transit. Valid values: true, false. If insane mode is enabled, gateway size has to at least be c5
               size.
        :param pulumi.Input[str] insane_mode_az: AZ of subnet being created for Insane Mode Transit Gateway. Required if insane_mode is enabled.
        :param pulumi.Input[str] subnet: Public Subnet Name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: Instance tag of cloud provider.
        :param pulumi.Input[str] vpc_id: VPC-ID/VNet-Name of cloud provider.
        :param pulumi.Input[str] vpc_reg: Region of cloud provider.
        :param pulumi.Input[str] vpc_size: Size of the gateway instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixTransitVpcArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixTransitVpc resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixTransitVpcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixTransitVpcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 connected_transit: Optional[pulumi.Input[str]] = None,
                 enable_firenet_interfaces: Optional[pulumi.Input[bool]] = None,
                 enable_hybrid_connection: Optional[pulumi.Input[bool]] = None,
                 enable_nat: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 ha_gw_size: Optional[pulumi.Input[str]] = None,
                 ha_insane_mode_az: Optional[pulumi.Input[str]] = None,
                 ha_subnet: Optional[pulumi.Input[str]] = None,
                 insane_mode: Optional[pulumi.Input[bool]] = None,
                 insane_mode_az: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_reg: Optional[pulumi.Input[str]] = None,
                 vpc_size: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixTransitVpcArgs.__new__(AviatrixTransitVpcArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            if cloud_type is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_type'")
            __props__.__dict__["cloud_type"] = cloud_type
            __props__.__dict__["connected_transit"] = connected_transit
            __props__.__dict__["enable_firenet_interfaces"] = enable_firenet_interfaces
            __props__.__dict__["enable_hybrid_connection"] = enable_hybrid_connection
            __props__.__dict__["enable_nat"] = enable_nat
            if gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'gw_name'")
            __props__.__dict__["gw_name"] = gw_name
            __props__.__dict__["ha_gw_size"] = ha_gw_size
            __props__.__dict__["ha_insane_mode_az"] = ha_insane_mode_az
            __props__.__dict__["ha_subnet"] = ha_subnet
            __props__.__dict__["insane_mode"] = insane_mode
            __props__.__dict__["insane_mode_az"] = insane_mode_az
            if subnet is None and not opts.urn:
                raise TypeError("Missing required property 'subnet'")
            __props__.__dict__["subnet"] = subnet
            __props__.__dict__["tag_lists"] = tag_lists
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vpc_reg is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_reg'")
            __props__.__dict__["vpc_reg"] = vpc_reg
            if vpc_size is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_size'")
            __props__.__dict__["vpc_size"] = vpc_size
        super(AviatrixTransitVpc, __self__).__init__(
            'aviatrix:index/aviatrixTransitVpc:AviatrixTransitVpc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[str]] = None,
            cloud_type: Optional[pulumi.Input[int]] = None,
            connected_transit: Optional[pulumi.Input[str]] = None,
            enable_firenet_interfaces: Optional[pulumi.Input[bool]] = None,
            enable_hybrid_connection: Optional[pulumi.Input[bool]] = None,
            enable_nat: Optional[pulumi.Input[str]] = None,
            gw_name: Optional[pulumi.Input[str]] = None,
            ha_gw_size: Optional[pulumi.Input[str]] = None,
            ha_insane_mode_az: Optional[pulumi.Input[str]] = None,
            ha_subnet: Optional[pulumi.Input[str]] = None,
            insane_mode: Optional[pulumi.Input[bool]] = None,
            insane_mode_az: Optional[pulumi.Input[str]] = None,
            subnet: Optional[pulumi.Input[str]] = None,
            tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vpc_reg: Optional[pulumi.Input[str]] = None,
            vpc_size: Optional[pulumi.Input[str]] = None) -> 'AviatrixTransitVpc':
        """
        Get an existing AviatrixTransitVpc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider, requires an integer value. Use 1 for AWS.
        :param pulumi.Input[str] connected_transit: Specify Connected Transit status.
        :param pulumi.Input[bool] enable_firenet_interfaces: Specify whether to enable firenet interfaces or not.
        :param pulumi.Input[bool] enable_hybrid_connection: Sign of readiness for TGW connection.
        :param pulumi.Input[str] enable_nat: Enable NAT for this container.
        :param pulumi.Input[str] gw_name: Name of the gateway which is going to be created.
        :param pulumi.Input[str] ha_gw_size: HA Gateway Size. Mandatory if HA is enabled (ha_subnet is set).
        :param pulumi.Input[str] ha_insane_mode_az: AZ of subnet being created for Insane Mode Transit HA Gateway. Required if insane_mode is enabled and ha_subnet is set.
        :param pulumi.Input[str] ha_subnet: HA Subnet.
        :param pulumi.Input[bool] insane_mode: Enable Insane Mode for Transit. Valid values: true, false. If insane mode is enabled, gateway size has to at least be c5
               size.
        :param pulumi.Input[str] insane_mode_az: AZ of subnet being created for Insane Mode Transit Gateway. Required if insane_mode is enabled.
        :param pulumi.Input[str] subnet: Public Subnet Name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: Instance tag of cloud provider.
        :param pulumi.Input[str] vpc_id: VPC-ID/VNet-Name of cloud provider.
        :param pulumi.Input[str] vpc_reg: Region of cloud provider.
        :param pulumi.Input[str] vpc_size: Size of the gateway instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixTransitVpcState.__new__(_AviatrixTransitVpcState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["cloud_type"] = cloud_type
        __props__.__dict__["connected_transit"] = connected_transit
        __props__.__dict__["enable_firenet_interfaces"] = enable_firenet_interfaces
        __props__.__dict__["enable_hybrid_connection"] = enable_hybrid_connection
        __props__.__dict__["enable_nat"] = enable_nat
        __props__.__dict__["gw_name"] = gw_name
        __props__.__dict__["ha_gw_size"] = ha_gw_size
        __props__.__dict__["ha_insane_mode_az"] = ha_insane_mode_az
        __props__.__dict__["ha_subnet"] = ha_subnet
        __props__.__dict__["insane_mode"] = insane_mode
        __props__.__dict__["insane_mode_az"] = insane_mode_az
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["tag_lists"] = tag_lists
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_reg"] = vpc_reg
        __props__.__dict__["vpc_size"] = vpc_size
        return AviatrixTransitVpc(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Output[int]:
        """
        Type of cloud service provider, requires an integer value. Use 1 for AWS.
        """
        return pulumi.get(self, "cloud_type")

    @property
    @pulumi.getter(name="connectedTransit")
    def connected_transit(self) -> pulumi.Output[Optional[str]]:
        """
        Specify Connected Transit status.
        """
        return pulumi.get(self, "connected_transit")

    @property
    @pulumi.getter(name="enableFirenetInterfaces")
    def enable_firenet_interfaces(self) -> pulumi.Output[Optional[bool]]:
        """
        Specify whether to enable firenet interfaces or not.
        """
        return pulumi.get(self, "enable_firenet_interfaces")

    @property
    @pulumi.getter(name="enableHybridConnection")
    def enable_hybrid_connection(self) -> pulumi.Output[Optional[bool]]:
        """
        Sign of readiness for TGW connection.
        """
        return pulumi.get(self, "enable_hybrid_connection")

    @property
    @pulumi.getter(name="enableNat")
    def enable_nat(self) -> pulumi.Output[Optional[str]]:
        """
        Enable NAT for this container.
        """
        return pulumi.get(self, "enable_nat")

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Output[str]:
        """
        Name of the gateway which is going to be created.
        """
        return pulumi.get(self, "gw_name")

    @property
    @pulumi.getter(name="haGwSize")
    def ha_gw_size(self) -> pulumi.Output[Optional[str]]:
        """
        HA Gateway Size. Mandatory if HA is enabled (ha_subnet is set).
        """
        return pulumi.get(self, "ha_gw_size")

    @property
    @pulumi.getter(name="haInsaneModeAz")
    def ha_insane_mode_az(self) -> pulumi.Output[Optional[str]]:
        """
        AZ of subnet being created for Insane Mode Transit HA Gateway. Required if insane_mode is enabled and ha_subnet is set.
        """
        return pulumi.get(self, "ha_insane_mode_az")

    @property
    @pulumi.getter(name="haSubnet")
    def ha_subnet(self) -> pulumi.Output[Optional[str]]:
        """
        HA Subnet.
        """
        return pulumi.get(self, "ha_subnet")

    @property
    @pulumi.getter(name="insaneMode")
    def insane_mode(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable Insane Mode for Transit. Valid values: true, false. If insane mode is enabled, gateway size has to at least be c5
        size.
        """
        return pulumi.get(self, "insane_mode")

    @property
    @pulumi.getter(name="insaneModeAz")
    def insane_mode_az(self) -> pulumi.Output[Optional[str]]:
        """
        AZ of subnet being created for Insane Mode Transit Gateway. Required if insane_mode is enabled.
        """
        return pulumi.get(self, "insane_mode_az")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[str]:
        """
        Public Subnet Name.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Instance tag of cloud provider.
        """
        return pulumi.get(self, "tag_lists")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        VPC-ID/VNet-Name of cloud provider.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcReg")
    def vpc_reg(self) -> pulumi.Output[str]:
        """
        Region of cloud provider.
        """
        return pulumi.get(self, "vpc_reg")

    @property
    @pulumi.getter(name="vpcSize")
    def vpc_size(self) -> pulumi.Output[str]:
        """
        Size of the gateway instance.
        """
        return pulumi.get(self, "vpc_size")

