# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixTransPeerArgs', 'AviatrixTransPeer']

@pulumi.input_type
class AviatrixTransPeerArgs:
    def __init__(__self__, *,
                 nexthop: pulumi.Input[str],
                 reachable_cidr: pulumi.Input[str],
                 source: pulumi.Input[str]):
        """
        The set of arguments for constructing a AviatrixTransPeer resource.
        :param pulumi.Input[str] nexthop: Name of nexthop gateway.
        :param pulumi.Input[str] reachable_cidr: Destination CIDR.
        :param pulumi.Input[str] source: Name of Source gateway.
        """
        pulumi.set(__self__, "nexthop", nexthop)
        pulumi.set(__self__, "reachable_cidr", reachable_cidr)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def nexthop(self) -> pulumi.Input[str]:
        """
        Name of nexthop gateway.
        """
        return pulumi.get(self, "nexthop")

    @nexthop.setter
    def nexthop(self, value: pulumi.Input[str]):
        pulumi.set(self, "nexthop", value)

    @property
    @pulumi.getter(name="reachableCidr")
    def reachable_cidr(self) -> pulumi.Input[str]:
        """
        Destination CIDR.
        """
        return pulumi.get(self, "reachable_cidr")

    @reachable_cidr.setter
    def reachable_cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "reachable_cidr", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        Name of Source gateway.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class _AviatrixTransPeerState:
    def __init__(__self__, *,
                 nexthop: Optional[pulumi.Input[str]] = None,
                 reachable_cidr: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixTransPeer resources.
        :param pulumi.Input[str] nexthop: Name of nexthop gateway.
        :param pulumi.Input[str] reachable_cidr: Destination CIDR.
        :param pulumi.Input[str] source: Name of Source gateway.
        """
        if nexthop is not None:
            pulumi.set(__self__, "nexthop", nexthop)
        if reachable_cidr is not None:
            pulumi.set(__self__, "reachable_cidr", reachable_cidr)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def nexthop(self) -> Optional[pulumi.Input[str]]:
        """
        Name of nexthop gateway.
        """
        return pulumi.get(self, "nexthop")

    @nexthop.setter
    def nexthop(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nexthop", value)

    @property
    @pulumi.getter(name="reachableCidr")
    def reachable_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Destination CIDR.
        """
        return pulumi.get(self, "reachable_cidr")

    @reachable_cidr.setter
    def reachable_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reachable_cidr", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        Name of Source gateway.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)


class AviatrixTransPeer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 nexthop: Optional[pulumi.Input[str]] = None,
                 reachable_cidr: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixTransPeer resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] nexthop: Name of nexthop gateway.
        :param pulumi.Input[str] reachable_cidr: Destination CIDR.
        :param pulumi.Input[str] source: Name of Source gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixTransPeerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixTransPeer resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixTransPeerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixTransPeerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 nexthop: Optional[pulumi.Input[str]] = None,
                 reachable_cidr: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixTransPeerArgs.__new__(AviatrixTransPeerArgs)

            if nexthop is None and not opts.urn:
                raise TypeError("Missing required property 'nexthop'")
            __props__.__dict__["nexthop"] = nexthop
            if reachable_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'reachable_cidr'")
            __props__.__dict__["reachable_cidr"] = reachable_cidr
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
        super(AviatrixTransPeer, __self__).__init__(
            'aviatrix:index/aviatrixTransPeer:AviatrixTransPeer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            nexthop: Optional[pulumi.Input[str]] = None,
            reachable_cidr: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[str]] = None) -> 'AviatrixTransPeer':
        """
        Get an existing AviatrixTransPeer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] nexthop: Name of nexthop gateway.
        :param pulumi.Input[str] reachable_cidr: Destination CIDR.
        :param pulumi.Input[str] source: Name of Source gateway.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixTransPeerState.__new__(_AviatrixTransPeerState)

        __props__.__dict__["nexthop"] = nexthop
        __props__.__dict__["reachable_cidr"] = reachable_cidr
        __props__.__dict__["source"] = source
        return AviatrixTransPeer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def nexthop(self) -> pulumi.Output[str]:
        """
        Name of nexthop gateway.
        """
        return pulumi.get(self, "nexthop")

    @property
    @pulumi.getter(name="reachableCidr")
    def reachable_cidr(self) -> pulumi.Output[str]:
        """
        Destination CIDR.
        """
        return pulumi.get(self, "reachable_cidr")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        Name of Source gateway.
        """
        return pulumi.get(self, "source")

