# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixSpokeGatewayArgs', 'AviatrixSpokeGateway']

@pulumi.input_type
class AviatrixSpokeGatewayArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 cloud_type: pulumi.Input[int],
                 gw_name: pulumi.Input[str],
                 gw_size: pulumi.Input[str],
                 subnet: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 vpc_reg: pulumi.Input[str],
                 allocate_new_eip: Optional[pulumi.Input[bool]] = None,
                 approved_learned_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
                 bgp_ecmp: Optional[pulumi.Input[bool]] = None,
                 bgp_hold_time: Optional[pulumi.Input[int]] = None,
                 bgp_polling_time: Optional[pulumi.Input[int]] = None,
                 customer_managed_keys: Optional[pulumi.Input[str]] = None,
                 customized_spoke_vpc_routes: Optional[pulumi.Input[str]] = None,
                 disable_route_propagation: Optional[pulumi.Input[bool]] = None,
                 eip: Optional[pulumi.Input[str]] = None,
                 enable_active_standby: Optional[pulumi.Input[bool]] = None,
                 enable_active_standby_preemptive: Optional[pulumi.Input[bool]] = None,
                 enable_auto_advertise_s2c_cidrs: Optional[pulumi.Input[bool]] = None,
                 enable_bgp: Optional[pulumi.Input[bool]] = None,
                 enable_encrypt_volume: Optional[pulumi.Input[bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 enable_monitor_gateway_subnets: Optional[pulumi.Input[bool]] = None,
                 enable_preserve_as_path: Optional[pulumi.Input[bool]] = None,
                 enable_private_oob: Optional[pulumi.Input[bool]] = None,
                 enable_private_vpc_default_route: Optional[pulumi.Input[bool]] = None,
                 enable_skip_public_route_table_update: Optional[pulumi.Input[bool]] = None,
                 enable_spot_instance: Optional[pulumi.Input[bool]] = None,
                 enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 filtered_spoke_vpc_routes: Optional[pulumi.Input[str]] = None,
                 ha_availability_domain: Optional[pulumi.Input[str]] = None,
                 ha_azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
                 ha_eip: Optional[pulumi.Input[str]] = None,
                 ha_fault_domain: Optional[pulumi.Input[str]] = None,
                 ha_gw_size: Optional[pulumi.Input[str]] = None,
                 ha_image_version: Optional[pulumi.Input[str]] = None,
                 ha_insane_mode_az: Optional[pulumi.Input[str]] = None,
                 ha_oob_availability_zone: Optional[pulumi.Input[str]] = None,
                 ha_oob_management_subnet: Optional[pulumi.Input[str]] = None,
                 ha_private_mode_subnet_zone: Optional[pulumi.Input[str]] = None,
                 ha_software_version: Optional[pulumi.Input[str]] = None,
                 ha_subnet: Optional[pulumi.Input[str]] = None,
                 ha_zone: Optional[pulumi.Input[str]] = None,
                 image_version: Optional[pulumi.Input[str]] = None,
                 included_advertised_spoke_routes: Optional[pulumi.Input[str]] = None,
                 insane_mode: Optional[pulumi.Input[bool]] = None,
                 insane_mode_az: Optional[pulumi.Input[str]] = None,
                 learned_cidrs_approval_mode: Optional[pulumi.Input[str]] = None,
                 local_as_number: Optional[pulumi.Input[str]] = None,
                 manage_transit_gateway_attachment: Optional[pulumi.Input[bool]] = None,
                 monitor_exclude_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 oob_availability_zone: Optional[pulumi.Input[str]] = None,
                 oob_management_subnet: Optional[pulumi.Input[str]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_mode_lb_vpc_id: Optional[pulumi.Input[str]] = None,
                 private_mode_subnet_zone: Optional[pulumi.Input[str]] = None,
                 rx_queue_size: Optional[pulumi.Input[str]] = None,
                 single_az_ha: Optional[pulumi.Input[bool]] = None,
                 single_ip_snat: Optional[pulumi.Input[bool]] = None,
                 software_version: Optional[pulumi.Input[str]] = None,
                 spoke_bgp_manual_advertise_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_price: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 transit_gw: Optional[pulumi.Input[str]] = None,
                 tunnel_detection_time: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixSpokeGateway resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider.
        :param pulumi.Input[str] gw_name: Name of the gateway which is going to be created.
        :param pulumi.Input[str] gw_size: Size of the gateway instance.
        :param pulumi.Input[str] subnet: Public Subnet Info.
        :param pulumi.Input[str] vpc_id: VPC-ID/VNet-Name of cloud provider.
        :param pulumi.Input[str] vpc_reg: Region of cloud provider.
        :param pulumi.Input[bool] allocate_new_eip: If false, reuse an idle address in Elastic IP pool for this gateway. Otherwise, allocate a new Elastic IP and use it for
               this gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] approved_learned_cidrs: Approved learned CIDRs for BGP Spoke Gateway. Available as of provider version R2.21+.
        :param pulumi.Input[str] availability_domain: Availability domain for OCI.
        :param pulumi.Input[str] azure_eip_name_resource_group: The name of the public IP address and its resource group in Azure to assign to this Spoke Gateway.
        :param pulumi.Input[bool] bgp_ecmp: Enable Equal Cost Multi Path (ECMP) routing for the next hop for BGP Spoke Gateway.
        :param pulumi.Input[int] bgp_hold_time: BGP Hold Time for BGP Spoke Gateway. Unit is in seconds. Valid values are between 12 and 360.
        :param pulumi.Input[int] bgp_polling_time: BGP route polling time for BGP Spoke Gateway. Unit is in seconds. Valid values are between 10 and 50.
        :param pulumi.Input[str] customer_managed_keys: Customer managed key ID.
        :param pulumi.Input[str] customized_spoke_vpc_routes: A list of comma separated CIDRs to be customized for the spoke VPC routes. When configured, it will replace all learned
               routes in VPC routing tables, including RFC1918 and non-RFC1918 CIDRs. It applies to this spoke gateway only.
        :param pulumi.Input[bool] disable_route_propagation: Disables route propagation on BGP Spoke to attached Transit Gateway. Default: false.
        :param pulumi.Input[str] eip: Required when allocate_new_eip is false. It uses specified EIP for this gateway.
        :param pulumi.Input[bool] enable_active_standby: Enables Active-Standby Mode, available only with HA enabled for BGP Spoke Gateway.
        :param pulumi.Input[bool] enable_active_standby_preemptive: Enables Preemptive Mode for Active-Standby, available only with Active-Standby enabled.
        :param pulumi.Input[bool] enable_auto_advertise_s2c_cidrs: Automatically advertise remote CIDR to Aviatrix Transit Gateway when route based Site2Cloud Tunnel is created.
        :param pulumi.Input[bool] enable_bgp: Enable BGP. Default: false.
        :param pulumi.Input[bool] enable_encrypt_volume: Enable encrypt gateway EBS volume. Only supported for AWS provider. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_jumbo_frame: Enable jumbo frame support for spoke gateway. Valid values: true or false. Default value: true.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Switch to enable/disable learned CIDR approval for BGP Spoke Gateway. Valid values: true, false.
        :param pulumi.Input[bool] enable_monitor_gateway_subnets: Enable [monitor gateway subnets](https://docs.aviatrix.com/HowTos/gateway.html#monitor-gateway-subnet). Only valid for
               cloud_type = 1 (AWS) or 256 (AWSGov). Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_preserve_as_path: Enable preserve as_path when advertising manual summary cidrs on BGP spoke gateway.
        :param pulumi.Input[bool] enable_private_oob: Enable private OOB.
        :param pulumi.Input[bool] enable_private_vpc_default_route: Config Private VPC Default Route.
        :param pulumi.Input[bool] enable_skip_public_route_table_update: Skip Public Route Table Update.
        :param pulumi.Input[bool] enable_spot_instance: Enable spot instance. NOT supported for production deployment.
        :param pulumi.Input[bool] enable_vpc_dns_server: Enable vpc_dns_server for Gateway. Valid values: true, false.
        :param pulumi.Input[str] fault_domain: Fault domain for OCI.
        :param pulumi.Input[str] filtered_spoke_vpc_routes: A list of comma separated CIDRs to be filtered from the spoke VPC route table. When configured, filtering CIDR(s) or
               it’s subnet will be deleted from VPC routing tables as well as from spoke gateway’s routing table. It applies to
               this spoke gateway only.
        :param pulumi.Input[str] ha_availability_domain: HA availability domain for OCI.
        :param pulumi.Input[str] ha_azure_eip_name_resource_group: The name of the public IP address and its resource group in Azure to assign to the HA Spoke Gateway.
        :param pulumi.Input[str] ha_eip: Public IP address that you want assigned to the HA Spoke Gateway.
        :param pulumi.Input[str] ha_fault_domain: HA fault domain for OCI.
        :param pulumi.Input[str] ha_gw_size: HA Gateway Size.
        :param pulumi.Input[str] ha_image_version: ha_image_version can be used to set the desired image version of the HA gateway. If set, we will attempt to update the
               gateway to the specified version.
        :param pulumi.Input[str] ha_insane_mode_az: AZ of subnet being created for Insane Mode Spoke HA Gateway. Required for AWS if insane_mode is true and ha_subnet is
               set.
        :param pulumi.Input[str] ha_oob_availability_zone: OOB HA availability zone.
        :param pulumi.Input[str] ha_oob_management_subnet: OOB HA management subnet.
        :param pulumi.Input[str] ha_private_mode_subnet_zone: Private Mode HA subnet availability zone.
        :param pulumi.Input[str] ha_software_version: ha_software_version can be used to set the desired software version of the HA gateway. If set, we will attempt to update
               the gateway to the specified version. If left blank, the gateway software version will continue to be managed through
               the aviatrix_controller_config resource.
        :param pulumi.Input[str] ha_subnet: HA Subnet. Required if enabling HA for AWS/AWSGov/AWSChina/Azure/AzureChina/OCI/Alibaba Cloud. Optional if enabling HA
               for GCP.
        :param pulumi.Input[str] ha_zone: HA Zone. Required if enabling HA for GCP. Optional for Azure.
        :param pulumi.Input[str] image_version: image_version can be used to set the desired image version of the gateway. If set, we will attempt to update the gateway
               to the specified version.
        :param pulumi.Input[str] included_advertised_spoke_routes: A list of comma separated CIDRs to be advertised to on-prem as 'Included CIDR List'. When configured, it will replace
               all advertised routes from this VPC.
        :param pulumi.Input[bool] insane_mode: Enable Insane Mode for Spoke Gateway. Valid values: true, false. Supported for AWS/AWSGov, GCP, Azure and OCI. If insane
               mode is enabled, gateway size has to at least be c5 size for AWS and Standard_D3_v2 size for Azure.
        :param pulumi.Input[str] insane_mode_az: AZ of subnet being created for Insane Mode Spoke Gateway. Required if insane_mode is enabled for AWS cloud.
        :param pulumi.Input[str] learned_cidrs_approval_mode: Set the learned CIDRs approval mode for BGP Spoke Gateway. Only valid when 'enable_learned_cidrs_approval' is set to
               true. Currently, only 'gateway' is supported: learned CIDR approval applies to ALL connections. Default value:
               'gateway'.
        :param pulumi.Input[str] local_as_number: Changes the Aviatrix BGP Spoke Gateway ASN number before you setup Aviatrix BGP Spoke Gateway connection configurations.
        :param pulumi.Input[bool] manage_transit_gateway_attachment: This parameter is a switch used to determine whether or not to manage attaching this spoke gateway to transit gateways
               using the aviatrix_spoke_gateway resource. If this is set to false, attaching this spoke gateway to transit gateways
               must be done using the aviatrix_spoke_transit_attachment resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitor_exclude_lists: A set of monitored instance ids. Only valid when 'enable_monitor_gateway_subnets' = true.
        :param pulumi.Input[str] oob_availability_zone: OOB subnet availability zone.
        :param pulumi.Input[str] oob_management_subnet: OOB management subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: List of AS numbers to populate BGP AP_PATH field when it advertises to VGW or peer devices. Only valid for BGP Spoke
               Gateway
        :param pulumi.Input[str] private_mode_lb_vpc_id: Private Mode controller load balancer vpc_id. Required when private mode is enabled for the Controller.
        :param pulumi.Input[str] private_mode_subnet_zone: Subnet availability zone. Required when Private Mode is enabled on the Controller and cloud_type is AWS.
        :param pulumi.Input[str] rx_queue_size: Gateway ethernet interface RX queue size. Supported for AWS related clouds only.
        :param pulumi.Input[bool] single_az_ha: Set to 'enabled' if this feature is desired.
        :param pulumi.Input[bool] single_ip_snat: Specify whether to enable Source NAT feature in 'single_ip' mode on the gateway or not.
        :param pulumi.Input[str] software_version: software_version can be used to set the desired software version of the gateway. If set, we will attempt to update the
               gateway to the specified version. If left blank, the gateway software version will continue to be managed through the
               aviatrix_controller_config resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spoke_bgp_manual_advertise_cidrs: Intended CIDR list to be advertised to external BGP router.
        :param pulumi.Input[str] spot_price: Price for spot instance. NOT supported for production deployment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: Instance tag of cloud provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the spoke gateway.
        :param pulumi.Input[str] transit_gw: Specify the transit Gateways to attach to this spoke. Format is a comma-separated list of transit gateway names. For
               example, 'transit-gw1,transit-gw2'.
        :param pulumi.Input[int] tunnel_detection_time: The IPSec tunnel down detection time for the Spoke Gateway.
        :param pulumi.Input[str] zone: Availability Zone. Only available for cloud_type = 8 (Azure). Must be in the form 'az-n', for example, 'az-2'.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "cloud_type", cloud_type)
        pulumi.set(__self__, "gw_name", gw_name)
        pulumi.set(__self__, "gw_size", gw_size)
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_reg", vpc_reg)
        if allocate_new_eip is not None:
            pulumi.set(__self__, "allocate_new_eip", allocate_new_eip)
        if approved_learned_cidrs is not None:
            pulumi.set(__self__, "approved_learned_cidrs", approved_learned_cidrs)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if azure_eip_name_resource_group is not None:
            pulumi.set(__self__, "azure_eip_name_resource_group", azure_eip_name_resource_group)
        if bgp_ecmp is not None:
            pulumi.set(__self__, "bgp_ecmp", bgp_ecmp)
        if bgp_hold_time is not None:
            pulumi.set(__self__, "bgp_hold_time", bgp_hold_time)
        if bgp_polling_time is not None:
            pulumi.set(__self__, "bgp_polling_time", bgp_polling_time)
        if customer_managed_keys is not None:
            pulumi.set(__self__, "customer_managed_keys", customer_managed_keys)
        if customized_spoke_vpc_routes is not None:
            pulumi.set(__self__, "customized_spoke_vpc_routes", customized_spoke_vpc_routes)
        if disable_route_propagation is not None:
            pulumi.set(__self__, "disable_route_propagation", disable_route_propagation)
        if eip is not None:
            pulumi.set(__self__, "eip", eip)
        if enable_active_standby is not None:
            pulumi.set(__self__, "enable_active_standby", enable_active_standby)
        if enable_active_standby_preemptive is not None:
            pulumi.set(__self__, "enable_active_standby_preemptive", enable_active_standby_preemptive)
        if enable_auto_advertise_s2c_cidrs is not None:
            pulumi.set(__self__, "enable_auto_advertise_s2c_cidrs", enable_auto_advertise_s2c_cidrs)
        if enable_bgp is not None:
            pulumi.set(__self__, "enable_bgp", enable_bgp)
        if enable_encrypt_volume is not None:
            pulumi.set(__self__, "enable_encrypt_volume", enable_encrypt_volume)
        if enable_jumbo_frame is not None:
            pulumi.set(__self__, "enable_jumbo_frame", enable_jumbo_frame)
        if enable_learned_cidrs_approval is not None:
            pulumi.set(__self__, "enable_learned_cidrs_approval", enable_learned_cidrs_approval)
        if enable_monitor_gateway_subnets is not None:
            pulumi.set(__self__, "enable_monitor_gateway_subnets", enable_monitor_gateway_subnets)
        if enable_preserve_as_path is not None:
            pulumi.set(__self__, "enable_preserve_as_path", enable_preserve_as_path)
        if enable_private_oob is not None:
            pulumi.set(__self__, "enable_private_oob", enable_private_oob)
        if enable_private_vpc_default_route is not None:
            pulumi.set(__self__, "enable_private_vpc_default_route", enable_private_vpc_default_route)
        if enable_skip_public_route_table_update is not None:
            pulumi.set(__self__, "enable_skip_public_route_table_update", enable_skip_public_route_table_update)
        if enable_spot_instance is not None:
            pulumi.set(__self__, "enable_spot_instance", enable_spot_instance)
        if enable_vpc_dns_server is not None:
            pulumi.set(__self__, "enable_vpc_dns_server", enable_vpc_dns_server)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if filtered_spoke_vpc_routes is not None:
            pulumi.set(__self__, "filtered_spoke_vpc_routes", filtered_spoke_vpc_routes)
        if ha_availability_domain is not None:
            pulumi.set(__self__, "ha_availability_domain", ha_availability_domain)
        if ha_azure_eip_name_resource_group is not None:
            pulumi.set(__self__, "ha_azure_eip_name_resource_group", ha_azure_eip_name_resource_group)
        if ha_eip is not None:
            pulumi.set(__self__, "ha_eip", ha_eip)
        if ha_fault_domain is not None:
            pulumi.set(__self__, "ha_fault_domain", ha_fault_domain)
        if ha_gw_size is not None:
            pulumi.set(__self__, "ha_gw_size", ha_gw_size)
        if ha_image_version is not None:
            pulumi.set(__self__, "ha_image_version", ha_image_version)
        if ha_insane_mode_az is not None:
            pulumi.set(__self__, "ha_insane_mode_az", ha_insane_mode_az)
        if ha_oob_availability_zone is not None:
            pulumi.set(__self__, "ha_oob_availability_zone", ha_oob_availability_zone)
        if ha_oob_management_subnet is not None:
            pulumi.set(__self__, "ha_oob_management_subnet", ha_oob_management_subnet)
        if ha_private_mode_subnet_zone is not None:
            pulumi.set(__self__, "ha_private_mode_subnet_zone", ha_private_mode_subnet_zone)
        if ha_software_version is not None:
            pulumi.set(__self__, "ha_software_version", ha_software_version)
        if ha_subnet is not None:
            pulumi.set(__self__, "ha_subnet", ha_subnet)
        if ha_zone is not None:
            pulumi.set(__self__, "ha_zone", ha_zone)
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if included_advertised_spoke_routes is not None:
            pulumi.set(__self__, "included_advertised_spoke_routes", included_advertised_spoke_routes)
        if insane_mode is not None:
            pulumi.set(__self__, "insane_mode", insane_mode)
        if insane_mode_az is not None:
            pulumi.set(__self__, "insane_mode_az", insane_mode_az)
        if learned_cidrs_approval_mode is not None:
            pulumi.set(__self__, "learned_cidrs_approval_mode", learned_cidrs_approval_mode)
        if local_as_number is not None:
            pulumi.set(__self__, "local_as_number", local_as_number)
        if manage_transit_gateway_attachment is not None:
            pulumi.set(__self__, "manage_transit_gateway_attachment", manage_transit_gateway_attachment)
        if monitor_exclude_lists is not None:
            pulumi.set(__self__, "monitor_exclude_lists", monitor_exclude_lists)
        if oob_availability_zone is not None:
            pulumi.set(__self__, "oob_availability_zone", oob_availability_zone)
        if oob_management_subnet is not None:
            pulumi.set(__self__, "oob_management_subnet", oob_management_subnet)
        if prepend_as_paths is not None:
            pulumi.set(__self__, "prepend_as_paths", prepend_as_paths)
        if private_mode_lb_vpc_id is not None:
            pulumi.set(__self__, "private_mode_lb_vpc_id", private_mode_lb_vpc_id)
        if private_mode_subnet_zone is not None:
            pulumi.set(__self__, "private_mode_subnet_zone", private_mode_subnet_zone)
        if rx_queue_size is not None:
            pulumi.set(__self__, "rx_queue_size", rx_queue_size)
        if single_az_ha is not None:
            pulumi.set(__self__, "single_az_ha", single_az_ha)
        if single_ip_snat is not None:
            pulumi.set(__self__, "single_ip_snat", single_ip_snat)
        if software_version is not None:
            pulumi.set(__self__, "software_version", software_version)
        if spoke_bgp_manual_advertise_cidrs is not None:
            pulumi.set(__self__, "spoke_bgp_manual_advertise_cidrs", spoke_bgp_manual_advertise_cidrs)
        if spot_price is not None:
            pulumi.set(__self__, "spot_price", spot_price)
        if tag_lists is not None:
            warnings.warn("""Use tags instead.""", DeprecationWarning)
            pulumi.log.warn("""tag_lists is deprecated: Use tags instead.""")
        if tag_lists is not None:
            pulumi.set(__self__, "tag_lists", tag_lists)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_gw is not None:
            warnings.warn("""Please set `manage_transit_gateway_attachment` to false, and use the standalone aviatrix_spoke_transit_attachment resource instead.""", DeprecationWarning)
            pulumi.log.warn("""transit_gw is deprecated: Please set `manage_transit_gateway_attachment` to false, and use the standalone aviatrix_spoke_transit_attachment resource instead.""")
        if transit_gw is not None:
            pulumi.set(__self__, "transit_gw", transit_gw)
        if tunnel_detection_time is not None:
            pulumi.set(__self__, "tunnel_detection_time", tunnel_detection_time)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Input[int]:
        """
        Type of cloud service provider.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: pulumi.Input[int]):
        pulumi.set(self, "cloud_type", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Input[str]:
        """
        Name of the gateway which is going to be created.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="gwSize")
    def gw_size(self) -> pulumi.Input[str]:
        """
        Size of the gateway instance.
        """
        return pulumi.get(self, "gw_size")

    @gw_size.setter
    def gw_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_size", value)

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Input[str]:
        """
        Public Subnet Info.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPC-ID/VNet-Name of cloud provider.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcReg")
    def vpc_reg(self) -> pulumi.Input[str]:
        """
        Region of cloud provider.
        """
        return pulumi.get(self, "vpc_reg")

    @vpc_reg.setter
    def vpc_reg(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_reg", value)

    @property
    @pulumi.getter(name="allocateNewEip")
    def allocate_new_eip(self) -> Optional[pulumi.Input[bool]]:
        """
        If false, reuse an idle address in Elastic IP pool for this gateway. Otherwise, allocate a new Elastic IP and use it for
        this gateway.
        """
        return pulumi.get(self, "allocate_new_eip")

    @allocate_new_eip.setter
    def allocate_new_eip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allocate_new_eip", value)

    @property
    @pulumi.getter(name="approvedLearnedCidrs")
    def approved_learned_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Approved learned CIDRs for BGP Spoke Gateway. Available as of provider version R2.21+.
        """
        return pulumi.get(self, "approved_learned_cidrs")

    @approved_learned_cidrs.setter
    def approved_learned_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "approved_learned_cidrs", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Availability domain for OCI.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="azureEipNameResourceGroup")
    def azure_eip_name_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the public IP address and its resource group in Azure to assign to this Spoke Gateway.
        """
        return pulumi.get(self, "azure_eip_name_resource_group")

    @azure_eip_name_resource_group.setter
    def azure_eip_name_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_eip_name_resource_group", value)

    @property
    @pulumi.getter(name="bgpEcmp")
    def bgp_ecmp(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Equal Cost Multi Path (ECMP) routing for the next hop for BGP Spoke Gateway.
        """
        return pulumi.get(self, "bgp_ecmp")

    @bgp_ecmp.setter
    def bgp_ecmp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bgp_ecmp", value)

    @property
    @pulumi.getter(name="bgpHoldTime")
    def bgp_hold_time(self) -> Optional[pulumi.Input[int]]:
        """
        BGP Hold Time for BGP Spoke Gateway. Unit is in seconds. Valid values are between 12 and 360.
        """
        return pulumi.get(self, "bgp_hold_time")

    @bgp_hold_time.setter
    def bgp_hold_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bgp_hold_time", value)

    @property
    @pulumi.getter(name="bgpPollingTime")
    def bgp_polling_time(self) -> Optional[pulumi.Input[int]]:
        """
        BGP route polling time for BGP Spoke Gateway. Unit is in seconds. Valid values are between 10 and 50.
        """
        return pulumi.get(self, "bgp_polling_time")

    @bgp_polling_time.setter
    def bgp_polling_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bgp_polling_time", value)

    @property
    @pulumi.getter(name="customerManagedKeys")
    def customer_managed_keys(self) -> Optional[pulumi.Input[str]]:
        """
        Customer managed key ID.
        """
        return pulumi.get(self, "customer_managed_keys")

    @customer_managed_keys.setter
    def customer_managed_keys(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_managed_keys", value)

    @property
    @pulumi.getter(name="customizedSpokeVpcRoutes")
    def customized_spoke_vpc_routes(self) -> Optional[pulumi.Input[str]]:
        """
        A list of comma separated CIDRs to be customized for the spoke VPC routes. When configured, it will replace all learned
        routes in VPC routing tables, including RFC1918 and non-RFC1918 CIDRs. It applies to this spoke gateway only.
        """
        return pulumi.get(self, "customized_spoke_vpc_routes")

    @customized_spoke_vpc_routes.setter
    def customized_spoke_vpc_routes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customized_spoke_vpc_routes", value)

    @property
    @pulumi.getter(name="disableRoutePropagation")
    def disable_route_propagation(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables route propagation on BGP Spoke to attached Transit Gateway. Default: false.
        """
        return pulumi.get(self, "disable_route_propagation")

    @disable_route_propagation.setter
    def disable_route_propagation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_route_propagation", value)

    @property
    @pulumi.getter
    def eip(self) -> Optional[pulumi.Input[str]]:
        """
        Required when allocate_new_eip is false. It uses specified EIP for this gateway.
        """
        return pulumi.get(self, "eip")

    @eip.setter
    def eip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip", value)

    @property
    @pulumi.getter(name="enableActiveStandby")
    def enable_active_standby(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables Active-Standby Mode, available only with HA enabled for BGP Spoke Gateway.
        """
        return pulumi.get(self, "enable_active_standby")

    @enable_active_standby.setter
    def enable_active_standby(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_active_standby", value)

    @property
    @pulumi.getter(name="enableActiveStandbyPreemptive")
    def enable_active_standby_preemptive(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables Preemptive Mode for Active-Standby, available only with Active-Standby enabled.
        """
        return pulumi.get(self, "enable_active_standby_preemptive")

    @enable_active_standby_preemptive.setter
    def enable_active_standby_preemptive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_active_standby_preemptive", value)

    @property
    @pulumi.getter(name="enableAutoAdvertiseS2cCidrs")
    def enable_auto_advertise_s2c_cidrs(self) -> Optional[pulumi.Input[bool]]:
        """
        Automatically advertise remote CIDR to Aviatrix Transit Gateway when route based Site2Cloud Tunnel is created.
        """
        return pulumi.get(self, "enable_auto_advertise_s2c_cidrs")

    @enable_auto_advertise_s2c_cidrs.setter
    def enable_auto_advertise_s2c_cidrs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_auto_advertise_s2c_cidrs", value)

    @property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable BGP. Default: false.
        """
        return pulumi.get(self, "enable_bgp")

    @enable_bgp.setter
    def enable_bgp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_bgp", value)

    @property
    @pulumi.getter(name="enableEncryptVolume")
    def enable_encrypt_volume(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable encrypt gateway EBS volume. Only supported for AWS provider. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_encrypt_volume")

    @enable_encrypt_volume.setter
    def enable_encrypt_volume(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_encrypt_volume", value)

    @property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable jumbo frame support for spoke gateway. Valid values: true or false. Default value: true.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @enable_jumbo_frame.setter
    def enable_jumbo_frame(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_jumbo_frame", value)

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable/disable learned CIDR approval for BGP Spoke Gateway. Valid values: true, false.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @enable_learned_cidrs_approval.setter
    def enable_learned_cidrs_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_learned_cidrs_approval", value)

    @property
    @pulumi.getter(name="enableMonitorGatewaySubnets")
    def enable_monitor_gateway_subnets(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable [monitor gateway subnets](https://docs.aviatrix.com/HowTos/gateway.html#monitor-gateway-subnet). Only valid for
        cloud_type = 1 (AWS) or 256 (AWSGov). Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_monitor_gateway_subnets")

    @enable_monitor_gateway_subnets.setter
    def enable_monitor_gateway_subnets(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_monitor_gateway_subnets", value)

    @property
    @pulumi.getter(name="enablePreserveAsPath")
    def enable_preserve_as_path(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable preserve as_path when advertising manual summary cidrs on BGP spoke gateway.
        """
        return pulumi.get(self, "enable_preserve_as_path")

    @enable_preserve_as_path.setter
    def enable_preserve_as_path(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_preserve_as_path", value)

    @property
    @pulumi.getter(name="enablePrivateOob")
    def enable_private_oob(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable private OOB.
        """
        return pulumi.get(self, "enable_private_oob")

    @enable_private_oob.setter
    def enable_private_oob(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_oob", value)

    @property
    @pulumi.getter(name="enablePrivateVpcDefaultRoute")
    def enable_private_vpc_default_route(self) -> Optional[pulumi.Input[bool]]:
        """
        Config Private VPC Default Route.
        """
        return pulumi.get(self, "enable_private_vpc_default_route")

    @enable_private_vpc_default_route.setter
    def enable_private_vpc_default_route(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_vpc_default_route", value)

    @property
    @pulumi.getter(name="enableSkipPublicRouteTableUpdate")
    def enable_skip_public_route_table_update(self) -> Optional[pulumi.Input[bool]]:
        """
        Skip Public Route Table Update.
        """
        return pulumi.get(self, "enable_skip_public_route_table_update")

    @enable_skip_public_route_table_update.setter
    def enable_skip_public_route_table_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_skip_public_route_table_update", value)

    @property
    @pulumi.getter(name="enableSpotInstance")
    def enable_spot_instance(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable spot instance. NOT supported for production deployment.
        """
        return pulumi.get(self, "enable_spot_instance")

    @enable_spot_instance.setter
    def enable_spot_instance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_spot_instance", value)

    @property
    @pulumi.getter(name="enableVpcDnsServer")
    def enable_vpc_dns_server(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable vpc_dns_server for Gateway. Valid values: true, false.
        """
        return pulumi.get(self, "enable_vpc_dns_server")

    @enable_vpc_dns_server.setter
    def enable_vpc_dns_server(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vpc_dns_server", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Fault domain for OCI.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="filteredSpokeVpcRoutes")
    def filtered_spoke_vpc_routes(self) -> Optional[pulumi.Input[str]]:
        """
        A list of comma separated CIDRs to be filtered from the spoke VPC route table. When configured, filtering CIDR(s) or
        it’s subnet will be deleted from VPC routing tables as well as from spoke gateway’s routing table. It applies to
        this spoke gateway only.
        """
        return pulumi.get(self, "filtered_spoke_vpc_routes")

    @filtered_spoke_vpc_routes.setter
    def filtered_spoke_vpc_routes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filtered_spoke_vpc_routes", value)

    @property
    @pulumi.getter(name="haAvailabilityDomain")
    def ha_availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        HA availability domain for OCI.
        """
        return pulumi.get(self, "ha_availability_domain")

    @ha_availability_domain.setter
    def ha_availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_availability_domain", value)

    @property
    @pulumi.getter(name="haAzureEipNameResourceGroup")
    def ha_azure_eip_name_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the public IP address and its resource group in Azure to assign to the HA Spoke Gateway.
        """
        return pulumi.get(self, "ha_azure_eip_name_resource_group")

    @ha_azure_eip_name_resource_group.setter
    def ha_azure_eip_name_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_azure_eip_name_resource_group", value)

    @property
    @pulumi.getter(name="haEip")
    def ha_eip(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address that you want assigned to the HA Spoke Gateway.
        """
        return pulumi.get(self, "ha_eip")

    @ha_eip.setter
    def ha_eip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_eip", value)

    @property
    @pulumi.getter(name="haFaultDomain")
    def ha_fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        HA fault domain for OCI.
        """
        return pulumi.get(self, "ha_fault_domain")

    @ha_fault_domain.setter
    def ha_fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_fault_domain", value)

    @property
    @pulumi.getter(name="haGwSize")
    def ha_gw_size(self) -> Optional[pulumi.Input[str]]:
        """
        HA Gateway Size.
        """
        return pulumi.get(self, "ha_gw_size")

    @ha_gw_size.setter
    def ha_gw_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_gw_size", value)

    @property
    @pulumi.getter(name="haImageVersion")
    def ha_image_version(self) -> Optional[pulumi.Input[str]]:
        """
        ha_image_version can be used to set the desired image version of the HA gateway. If set, we will attempt to update the
        gateway to the specified version.
        """
        return pulumi.get(self, "ha_image_version")

    @ha_image_version.setter
    def ha_image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_image_version", value)

    @property
    @pulumi.getter(name="haInsaneModeAz")
    def ha_insane_mode_az(self) -> Optional[pulumi.Input[str]]:
        """
        AZ of subnet being created for Insane Mode Spoke HA Gateway. Required for AWS if insane_mode is true and ha_subnet is
        set.
        """
        return pulumi.get(self, "ha_insane_mode_az")

    @ha_insane_mode_az.setter
    def ha_insane_mode_az(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_insane_mode_az", value)

    @property
    @pulumi.getter(name="haOobAvailabilityZone")
    def ha_oob_availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        OOB HA availability zone.
        """
        return pulumi.get(self, "ha_oob_availability_zone")

    @ha_oob_availability_zone.setter
    def ha_oob_availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_oob_availability_zone", value)

    @property
    @pulumi.getter(name="haOobManagementSubnet")
    def ha_oob_management_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        OOB HA management subnet.
        """
        return pulumi.get(self, "ha_oob_management_subnet")

    @ha_oob_management_subnet.setter
    def ha_oob_management_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_oob_management_subnet", value)

    @property
    @pulumi.getter(name="haPrivateModeSubnetZone")
    def ha_private_mode_subnet_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Private Mode HA subnet availability zone.
        """
        return pulumi.get(self, "ha_private_mode_subnet_zone")

    @ha_private_mode_subnet_zone.setter
    def ha_private_mode_subnet_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_private_mode_subnet_zone", value)

    @property
    @pulumi.getter(name="haSoftwareVersion")
    def ha_software_version(self) -> Optional[pulumi.Input[str]]:
        """
        ha_software_version can be used to set the desired software version of the HA gateway. If set, we will attempt to update
        the gateway to the specified version. If left blank, the gateway software version will continue to be managed through
        the aviatrix_controller_config resource.
        """
        return pulumi.get(self, "ha_software_version")

    @ha_software_version.setter
    def ha_software_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_software_version", value)

    @property
    @pulumi.getter(name="haSubnet")
    def ha_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        HA Subnet. Required if enabling HA for AWS/AWSGov/AWSChina/Azure/AzureChina/OCI/Alibaba Cloud. Optional if enabling HA
        for GCP.
        """
        return pulumi.get(self, "ha_subnet")

    @ha_subnet.setter
    def ha_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_subnet", value)

    @property
    @pulumi.getter(name="haZone")
    def ha_zone(self) -> Optional[pulumi.Input[str]]:
        """
        HA Zone. Required if enabling HA for GCP. Optional for Azure.
        """
        return pulumi.get(self, "ha_zone")

    @ha_zone.setter
    def ha_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_zone", value)

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[pulumi.Input[str]]:
        """
        image_version can be used to set the desired image version of the gateway. If set, we will attempt to update the gateway
        to the specified version.
        """
        return pulumi.get(self, "image_version")

    @image_version.setter
    def image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_version", value)

    @property
    @pulumi.getter(name="includedAdvertisedSpokeRoutes")
    def included_advertised_spoke_routes(self) -> Optional[pulumi.Input[str]]:
        """
        A list of comma separated CIDRs to be advertised to on-prem as 'Included CIDR List'. When configured, it will replace
        all advertised routes from this VPC.
        """
        return pulumi.get(self, "included_advertised_spoke_routes")

    @included_advertised_spoke_routes.setter
    def included_advertised_spoke_routes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "included_advertised_spoke_routes", value)

    @property
    @pulumi.getter(name="insaneMode")
    def insane_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Insane Mode for Spoke Gateway. Valid values: true, false. Supported for AWS/AWSGov, GCP, Azure and OCI. If insane
        mode is enabled, gateway size has to at least be c5 size for AWS and Standard_D3_v2 size for Azure.
        """
        return pulumi.get(self, "insane_mode")

    @insane_mode.setter
    def insane_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insane_mode", value)

    @property
    @pulumi.getter(name="insaneModeAz")
    def insane_mode_az(self) -> Optional[pulumi.Input[str]]:
        """
        AZ of subnet being created for Insane Mode Spoke Gateway. Required if insane_mode is enabled for AWS cloud.
        """
        return pulumi.get(self, "insane_mode_az")

    @insane_mode_az.setter
    def insane_mode_az(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insane_mode_az", value)

    @property
    @pulumi.getter(name="learnedCidrsApprovalMode")
    def learned_cidrs_approval_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Set the learned CIDRs approval mode for BGP Spoke Gateway. Only valid when 'enable_learned_cidrs_approval' is set to
        true. Currently, only 'gateway' is supported: learned CIDR approval applies to ALL connections. Default value:
        'gateway'.
        """
        return pulumi.get(self, "learned_cidrs_approval_mode")

    @learned_cidrs_approval_mode.setter
    def learned_cidrs_approval_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "learned_cidrs_approval_mode", value)

    @property
    @pulumi.getter(name="localAsNumber")
    def local_as_number(self) -> Optional[pulumi.Input[str]]:
        """
        Changes the Aviatrix BGP Spoke Gateway ASN number before you setup Aviatrix BGP Spoke Gateway connection configurations.
        """
        return pulumi.get(self, "local_as_number")

    @local_as_number.setter
    def local_as_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_as_number", value)

    @property
    @pulumi.getter(name="manageTransitGatewayAttachment")
    def manage_transit_gateway_attachment(self) -> Optional[pulumi.Input[bool]]:
        """
        This parameter is a switch used to determine whether or not to manage attaching this spoke gateway to transit gateways
        using the aviatrix_spoke_gateway resource. If this is set to false, attaching this spoke gateway to transit gateways
        must be done using the aviatrix_spoke_transit_attachment resource. Valid values: true, false. Default value: true.
        """
        return pulumi.get(self, "manage_transit_gateway_attachment")

    @manage_transit_gateway_attachment.setter
    def manage_transit_gateway_attachment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_transit_gateway_attachment", value)

    @property
    @pulumi.getter(name="monitorExcludeLists")
    def monitor_exclude_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of monitored instance ids. Only valid when 'enable_monitor_gateway_subnets' = true.
        """
        return pulumi.get(self, "monitor_exclude_lists")

    @monitor_exclude_lists.setter
    def monitor_exclude_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "monitor_exclude_lists", value)

    @property
    @pulumi.getter(name="oobAvailabilityZone")
    def oob_availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        OOB subnet availability zone.
        """
        return pulumi.get(self, "oob_availability_zone")

    @oob_availability_zone.setter
    def oob_availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oob_availability_zone", value)

    @property
    @pulumi.getter(name="oobManagementSubnet")
    def oob_management_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        OOB management subnet.
        """
        return pulumi.get(self, "oob_management_subnet")

    @oob_management_subnet.setter
    def oob_management_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oob_management_subnet", value)

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of AS numbers to populate BGP AP_PATH field when it advertises to VGW or peer devices. Only valid for BGP Spoke
        Gateway
        """
        return pulumi.get(self, "prepend_as_paths")

    @prepend_as_paths.setter
    def prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prepend_as_paths", value)

    @property
    @pulumi.getter(name="privateModeLbVpcId")
    def private_mode_lb_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Private Mode controller load balancer vpc_id. Required when private mode is enabled for the Controller.
        """
        return pulumi.get(self, "private_mode_lb_vpc_id")

    @private_mode_lb_vpc_id.setter
    def private_mode_lb_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_mode_lb_vpc_id", value)

    @property
    @pulumi.getter(name="privateModeSubnetZone")
    def private_mode_subnet_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet availability zone. Required when Private Mode is enabled on the Controller and cloud_type is AWS.
        """
        return pulumi.get(self, "private_mode_subnet_zone")

    @private_mode_subnet_zone.setter
    def private_mode_subnet_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_mode_subnet_zone", value)

    @property
    @pulumi.getter(name="rxQueueSize")
    def rx_queue_size(self) -> Optional[pulumi.Input[str]]:
        """
        Gateway ethernet interface RX queue size. Supported for AWS related clouds only.
        """
        return pulumi.get(self, "rx_queue_size")

    @rx_queue_size.setter
    def rx_queue_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rx_queue_size", value)

    @property
    @pulumi.getter(name="singleAzHa")
    def single_az_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to 'enabled' if this feature is desired.
        """
        return pulumi.get(self, "single_az_ha")

    @single_az_ha.setter
    def single_az_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "single_az_ha", value)

    @property
    @pulumi.getter(name="singleIpSnat")
    def single_ip_snat(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether to enable Source NAT feature in 'single_ip' mode on the gateway or not.
        """
        return pulumi.get(self, "single_ip_snat")

    @single_ip_snat.setter
    def single_ip_snat(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "single_ip_snat", value)

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> Optional[pulumi.Input[str]]:
        """
        software_version can be used to set the desired software version of the gateway. If set, we will attempt to update the
        gateway to the specified version. If left blank, the gateway software version will continue to be managed through the
        aviatrix_controller_config resource.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "software_version", value)

    @property
    @pulumi.getter(name="spokeBgpManualAdvertiseCidrs")
    def spoke_bgp_manual_advertise_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Intended CIDR list to be advertised to external BGP router.
        """
        return pulumi.get(self, "spoke_bgp_manual_advertise_cidrs")

    @spoke_bgp_manual_advertise_cidrs.setter
    def spoke_bgp_manual_advertise_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "spoke_bgp_manual_advertise_cidrs", value)

    @property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> Optional[pulumi.Input[str]]:
        """
        Price for spot instance. NOT supported for production deployment.
        """
        return pulumi.get(self, "spot_price")

    @spot_price.setter
    def spot_price(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_price", value)

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Instance tag of cloud provider.
        """
        return pulumi.get(self, "tag_lists")

    @tag_lists.setter
    def tag_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tag_lists", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the spoke gateway.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="transitGw")
    def transit_gw(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the transit Gateways to attach to this spoke. Format is a comma-separated list of transit gateway names. For
        example, 'transit-gw1,transit-gw2'.
        """
        return pulumi.get(self, "transit_gw")

    @transit_gw.setter
    def transit_gw(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_gw", value)

    @property
    @pulumi.getter(name="tunnelDetectionTime")
    def tunnel_detection_time(self) -> Optional[pulumi.Input[int]]:
        """
        The IPSec tunnel down detection time for the Spoke Gateway.
        """
        return pulumi.get(self, "tunnel_detection_time")

    @tunnel_detection_time.setter
    def tunnel_detection_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tunnel_detection_time", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Availability Zone. Only available for cloud_type = 8 (Azure). Must be in the form 'az-n', for example, 'az-2'.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _AviatrixSpokeGatewayState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[str]] = None,
                 allocate_new_eip: Optional[pulumi.Input[bool]] = None,
                 approved_learned_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
                 bgp_ecmp: Optional[pulumi.Input[bool]] = None,
                 bgp_hold_time: Optional[pulumi.Input[int]] = None,
                 bgp_polling_time: Optional[pulumi.Input[int]] = None,
                 cloud_instance_id: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 customer_managed_keys: Optional[pulumi.Input[str]] = None,
                 customized_spoke_vpc_routes: Optional[pulumi.Input[str]] = None,
                 disable_route_propagation: Optional[pulumi.Input[bool]] = None,
                 eip: Optional[pulumi.Input[str]] = None,
                 enable_active_standby: Optional[pulumi.Input[bool]] = None,
                 enable_active_standby_preemptive: Optional[pulumi.Input[bool]] = None,
                 enable_auto_advertise_s2c_cidrs: Optional[pulumi.Input[bool]] = None,
                 enable_bgp: Optional[pulumi.Input[bool]] = None,
                 enable_encrypt_volume: Optional[pulumi.Input[bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 enable_monitor_gateway_subnets: Optional[pulumi.Input[bool]] = None,
                 enable_preserve_as_path: Optional[pulumi.Input[bool]] = None,
                 enable_private_oob: Optional[pulumi.Input[bool]] = None,
                 enable_private_vpc_default_route: Optional[pulumi.Input[bool]] = None,
                 enable_skip_public_route_table_update: Optional[pulumi.Input[bool]] = None,
                 enable_spot_instance: Optional[pulumi.Input[bool]] = None,
                 enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 filtered_spoke_vpc_routes: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 gw_size: Optional[pulumi.Input[str]] = None,
                 ha_availability_domain: Optional[pulumi.Input[str]] = None,
                 ha_azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
                 ha_cloud_instance_id: Optional[pulumi.Input[str]] = None,
                 ha_eip: Optional[pulumi.Input[str]] = None,
                 ha_fault_domain: Optional[pulumi.Input[str]] = None,
                 ha_gw_name: Optional[pulumi.Input[str]] = None,
                 ha_gw_size: Optional[pulumi.Input[str]] = None,
                 ha_image_version: Optional[pulumi.Input[str]] = None,
                 ha_insane_mode_az: Optional[pulumi.Input[str]] = None,
                 ha_oob_availability_zone: Optional[pulumi.Input[str]] = None,
                 ha_oob_management_subnet: Optional[pulumi.Input[str]] = None,
                 ha_private_ip: Optional[pulumi.Input[str]] = None,
                 ha_private_mode_subnet_zone: Optional[pulumi.Input[str]] = None,
                 ha_public_ip: Optional[pulumi.Input[str]] = None,
                 ha_security_group_id: Optional[pulumi.Input[str]] = None,
                 ha_software_version: Optional[pulumi.Input[str]] = None,
                 ha_subnet: Optional[pulumi.Input[str]] = None,
                 ha_zone: Optional[pulumi.Input[str]] = None,
                 image_version: Optional[pulumi.Input[str]] = None,
                 included_advertised_spoke_routes: Optional[pulumi.Input[str]] = None,
                 insane_mode: Optional[pulumi.Input[bool]] = None,
                 insane_mode_az: Optional[pulumi.Input[str]] = None,
                 learned_cidrs_approval_mode: Optional[pulumi.Input[str]] = None,
                 local_as_number: Optional[pulumi.Input[str]] = None,
                 manage_transit_gateway_attachment: Optional[pulumi.Input[bool]] = None,
                 monitor_exclude_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 oob_availability_zone: Optional[pulumi.Input[str]] = None,
                 oob_management_subnet: Optional[pulumi.Input[str]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 private_mode_lb_vpc_id: Optional[pulumi.Input[str]] = None,
                 private_mode_subnet_zone: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 rx_queue_size: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 single_az_ha: Optional[pulumi.Input[bool]] = None,
                 single_ip_snat: Optional[pulumi.Input[bool]] = None,
                 software_version: Optional[pulumi.Input[str]] = None,
                 spoke_bgp_manual_advertise_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_price: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 transit_gw: Optional[pulumi.Input[str]] = None,
                 tunnel_detection_time: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_reg: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixSpokeGateway resources.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[bool] allocate_new_eip: If false, reuse an idle address in Elastic IP pool for this gateway. Otherwise, allocate a new Elastic IP and use it for
               this gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] approved_learned_cidrs: Approved learned CIDRs for BGP Spoke Gateway. Available as of provider version R2.21+.
        :param pulumi.Input[str] availability_domain: Availability domain for OCI.
        :param pulumi.Input[str] azure_eip_name_resource_group: The name of the public IP address and its resource group in Azure to assign to this Spoke Gateway.
        :param pulumi.Input[bool] bgp_ecmp: Enable Equal Cost Multi Path (ECMP) routing for the next hop for BGP Spoke Gateway.
        :param pulumi.Input[int] bgp_hold_time: BGP Hold Time for BGP Spoke Gateway. Unit is in seconds. Valid values are between 12 and 360.
        :param pulumi.Input[int] bgp_polling_time: BGP route polling time for BGP Spoke Gateway. Unit is in seconds. Valid values are between 10 and 50.
        :param pulumi.Input[str] cloud_instance_id: Cloud instance ID.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider.
        :param pulumi.Input[str] customer_managed_keys: Customer managed key ID.
        :param pulumi.Input[str] customized_spoke_vpc_routes: A list of comma separated CIDRs to be customized for the spoke VPC routes. When configured, it will replace all learned
               routes in VPC routing tables, including RFC1918 and non-RFC1918 CIDRs. It applies to this spoke gateway only.
        :param pulumi.Input[bool] disable_route_propagation: Disables route propagation on BGP Spoke to attached Transit Gateway. Default: false.
        :param pulumi.Input[str] eip: Required when allocate_new_eip is false. It uses specified EIP for this gateway.
        :param pulumi.Input[bool] enable_active_standby: Enables Active-Standby Mode, available only with HA enabled for BGP Spoke Gateway.
        :param pulumi.Input[bool] enable_active_standby_preemptive: Enables Preemptive Mode for Active-Standby, available only with Active-Standby enabled.
        :param pulumi.Input[bool] enable_auto_advertise_s2c_cidrs: Automatically advertise remote CIDR to Aviatrix Transit Gateway when route based Site2Cloud Tunnel is created.
        :param pulumi.Input[bool] enable_bgp: Enable BGP. Default: false.
        :param pulumi.Input[bool] enable_encrypt_volume: Enable encrypt gateway EBS volume. Only supported for AWS provider. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_jumbo_frame: Enable jumbo frame support for spoke gateway. Valid values: true or false. Default value: true.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Switch to enable/disable learned CIDR approval for BGP Spoke Gateway. Valid values: true, false.
        :param pulumi.Input[bool] enable_monitor_gateway_subnets: Enable [monitor gateway subnets](https://docs.aviatrix.com/HowTos/gateway.html#monitor-gateway-subnet). Only valid for
               cloud_type = 1 (AWS) or 256 (AWSGov). Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_preserve_as_path: Enable preserve as_path when advertising manual summary cidrs on BGP spoke gateway.
        :param pulumi.Input[bool] enable_private_oob: Enable private OOB.
        :param pulumi.Input[bool] enable_private_vpc_default_route: Config Private VPC Default Route.
        :param pulumi.Input[bool] enable_skip_public_route_table_update: Skip Public Route Table Update.
        :param pulumi.Input[bool] enable_spot_instance: Enable spot instance. NOT supported for production deployment.
        :param pulumi.Input[bool] enable_vpc_dns_server: Enable vpc_dns_server for Gateway. Valid values: true, false.
        :param pulumi.Input[str] fault_domain: Fault domain for OCI.
        :param pulumi.Input[str] filtered_spoke_vpc_routes: A list of comma separated CIDRs to be filtered from the spoke VPC route table. When configured, filtering CIDR(s) or
               it’s subnet will be deleted from VPC routing tables as well as from spoke gateway’s routing table. It applies to
               this spoke gateway only.
        :param pulumi.Input[str] gw_name: Name of the gateway which is going to be created.
        :param pulumi.Input[str] gw_size: Size of the gateway instance.
        :param pulumi.Input[str] ha_availability_domain: HA availability domain for OCI.
        :param pulumi.Input[str] ha_azure_eip_name_resource_group: The name of the public IP address and its resource group in Azure to assign to the HA Spoke Gateway.
        :param pulumi.Input[str] ha_cloud_instance_id: Cloud instance ID of HA spoke gateway.
        :param pulumi.Input[str] ha_eip: Public IP address that you want assigned to the HA Spoke Gateway.
        :param pulumi.Input[str] ha_fault_domain: HA fault domain for OCI.
        :param pulumi.Input[str] ha_gw_name: Aviatrix spoke gateway unique name of HA spoke gateway.
        :param pulumi.Input[str] ha_gw_size: HA Gateway Size.
        :param pulumi.Input[str] ha_image_version: ha_image_version can be used to set the desired image version of the HA gateway. If set, we will attempt to update the
               gateway to the specified version.
        :param pulumi.Input[str] ha_insane_mode_az: AZ of subnet being created for Insane Mode Spoke HA Gateway. Required for AWS if insane_mode is true and ha_subnet is
               set.
        :param pulumi.Input[str] ha_oob_availability_zone: OOB HA availability zone.
        :param pulumi.Input[str] ha_oob_management_subnet: OOB HA management subnet.
        :param pulumi.Input[str] ha_private_ip: Private IP address of the spoke gateway created.
        :param pulumi.Input[str] ha_private_mode_subnet_zone: Private Mode HA subnet availability zone.
        :param pulumi.Input[str] ha_public_ip: Public IP address of the HA Spoke Gateway.
        :param pulumi.Input[str] ha_security_group_id: HA security group used for the spoke gateway.
        :param pulumi.Input[str] ha_software_version: ha_software_version can be used to set the desired software version of the HA gateway. If set, we will attempt to update
               the gateway to the specified version. If left blank, the gateway software version will continue to be managed through
               the aviatrix_controller_config resource.
        :param pulumi.Input[str] ha_subnet: HA Subnet. Required if enabling HA for AWS/AWSGov/AWSChina/Azure/AzureChina/OCI/Alibaba Cloud. Optional if enabling HA
               for GCP.
        :param pulumi.Input[str] ha_zone: HA Zone. Required if enabling HA for GCP. Optional for Azure.
        :param pulumi.Input[str] image_version: image_version can be used to set the desired image version of the gateway. If set, we will attempt to update the gateway
               to the specified version.
        :param pulumi.Input[str] included_advertised_spoke_routes: A list of comma separated CIDRs to be advertised to on-prem as 'Included CIDR List'. When configured, it will replace
               all advertised routes from this VPC.
        :param pulumi.Input[bool] insane_mode: Enable Insane Mode for Spoke Gateway. Valid values: true, false. Supported for AWS/AWSGov, GCP, Azure and OCI. If insane
               mode is enabled, gateway size has to at least be c5 size for AWS and Standard_D3_v2 size for Azure.
        :param pulumi.Input[str] insane_mode_az: AZ of subnet being created for Insane Mode Spoke Gateway. Required if insane_mode is enabled for AWS cloud.
        :param pulumi.Input[str] learned_cidrs_approval_mode: Set the learned CIDRs approval mode for BGP Spoke Gateway. Only valid when 'enable_learned_cidrs_approval' is set to
               true. Currently, only 'gateway' is supported: learned CIDR approval applies to ALL connections. Default value:
               'gateway'.
        :param pulumi.Input[str] local_as_number: Changes the Aviatrix BGP Spoke Gateway ASN number before you setup Aviatrix BGP Spoke Gateway connection configurations.
        :param pulumi.Input[bool] manage_transit_gateway_attachment: This parameter is a switch used to determine whether or not to manage attaching this spoke gateway to transit gateways
               using the aviatrix_spoke_gateway resource. If this is set to false, attaching this spoke gateway to transit gateways
               must be done using the aviatrix_spoke_transit_attachment resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitor_exclude_lists: A set of monitored instance ids. Only valid when 'enable_monitor_gateway_subnets' = true.
        :param pulumi.Input[str] oob_availability_zone: OOB subnet availability zone.
        :param pulumi.Input[str] oob_management_subnet: OOB management subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: List of AS numbers to populate BGP AP_PATH field when it advertises to VGW or peer devices. Only valid for BGP Spoke
               Gateway
        :param pulumi.Input[str] private_ip: Private IP address of the spoke gateway created.
        :param pulumi.Input[str] private_mode_lb_vpc_id: Private Mode controller load balancer vpc_id. Required when private mode is enabled for the Controller.
        :param pulumi.Input[str] private_mode_subnet_zone: Subnet availability zone. Required when Private Mode is enabled on the Controller and cloud_type is AWS.
        :param pulumi.Input[str] public_ip: Public IP address of the Spoke Gateway created.
        :param pulumi.Input[str] rx_queue_size: Gateway ethernet interface RX queue size. Supported for AWS related clouds only.
        :param pulumi.Input[str] security_group_id: Security group used for the spoke gateway.
        :param pulumi.Input[bool] single_az_ha: Set to 'enabled' if this feature is desired.
        :param pulumi.Input[bool] single_ip_snat: Specify whether to enable Source NAT feature in 'single_ip' mode on the gateway or not.
        :param pulumi.Input[str] software_version: software_version can be used to set the desired software version of the gateway. If set, we will attempt to update the
               gateway to the specified version. If left blank, the gateway software version will continue to be managed through the
               aviatrix_controller_config resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spoke_bgp_manual_advertise_cidrs: Intended CIDR list to be advertised to external BGP router.
        :param pulumi.Input[str] spot_price: Price for spot instance. NOT supported for production deployment.
        :param pulumi.Input[str] subnet: Public Subnet Info.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: Instance tag of cloud provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the spoke gateway.
        :param pulumi.Input[str] transit_gw: Specify the transit Gateways to attach to this spoke. Format is a comma-separated list of transit gateway names. For
               example, 'transit-gw1,transit-gw2'.
        :param pulumi.Input[int] tunnel_detection_time: The IPSec tunnel down detection time for the Spoke Gateway.
        :param pulumi.Input[str] vpc_id: VPC-ID/VNet-Name of cloud provider.
        :param pulumi.Input[str] vpc_reg: Region of cloud provider.
        :param pulumi.Input[str] zone: Availability Zone. Only available for cloud_type = 8 (Azure). Must be in the form 'az-n', for example, 'az-2'.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if allocate_new_eip is not None:
            pulumi.set(__self__, "allocate_new_eip", allocate_new_eip)
        if approved_learned_cidrs is not None:
            pulumi.set(__self__, "approved_learned_cidrs", approved_learned_cidrs)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if azure_eip_name_resource_group is not None:
            pulumi.set(__self__, "azure_eip_name_resource_group", azure_eip_name_resource_group)
        if bgp_ecmp is not None:
            pulumi.set(__self__, "bgp_ecmp", bgp_ecmp)
        if bgp_hold_time is not None:
            pulumi.set(__self__, "bgp_hold_time", bgp_hold_time)
        if bgp_polling_time is not None:
            pulumi.set(__self__, "bgp_polling_time", bgp_polling_time)
        if cloud_instance_id is not None:
            pulumi.set(__self__, "cloud_instance_id", cloud_instance_id)
        if cloud_type is not None:
            pulumi.set(__self__, "cloud_type", cloud_type)
        if customer_managed_keys is not None:
            pulumi.set(__self__, "customer_managed_keys", customer_managed_keys)
        if customized_spoke_vpc_routes is not None:
            pulumi.set(__self__, "customized_spoke_vpc_routes", customized_spoke_vpc_routes)
        if disable_route_propagation is not None:
            pulumi.set(__self__, "disable_route_propagation", disable_route_propagation)
        if eip is not None:
            pulumi.set(__self__, "eip", eip)
        if enable_active_standby is not None:
            pulumi.set(__self__, "enable_active_standby", enable_active_standby)
        if enable_active_standby_preemptive is not None:
            pulumi.set(__self__, "enable_active_standby_preemptive", enable_active_standby_preemptive)
        if enable_auto_advertise_s2c_cidrs is not None:
            pulumi.set(__self__, "enable_auto_advertise_s2c_cidrs", enable_auto_advertise_s2c_cidrs)
        if enable_bgp is not None:
            pulumi.set(__self__, "enable_bgp", enable_bgp)
        if enable_encrypt_volume is not None:
            pulumi.set(__self__, "enable_encrypt_volume", enable_encrypt_volume)
        if enable_jumbo_frame is not None:
            pulumi.set(__self__, "enable_jumbo_frame", enable_jumbo_frame)
        if enable_learned_cidrs_approval is not None:
            pulumi.set(__self__, "enable_learned_cidrs_approval", enable_learned_cidrs_approval)
        if enable_monitor_gateway_subnets is not None:
            pulumi.set(__self__, "enable_monitor_gateway_subnets", enable_monitor_gateway_subnets)
        if enable_preserve_as_path is not None:
            pulumi.set(__self__, "enable_preserve_as_path", enable_preserve_as_path)
        if enable_private_oob is not None:
            pulumi.set(__self__, "enable_private_oob", enable_private_oob)
        if enable_private_vpc_default_route is not None:
            pulumi.set(__self__, "enable_private_vpc_default_route", enable_private_vpc_default_route)
        if enable_skip_public_route_table_update is not None:
            pulumi.set(__self__, "enable_skip_public_route_table_update", enable_skip_public_route_table_update)
        if enable_spot_instance is not None:
            pulumi.set(__self__, "enable_spot_instance", enable_spot_instance)
        if enable_vpc_dns_server is not None:
            pulumi.set(__self__, "enable_vpc_dns_server", enable_vpc_dns_server)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if filtered_spoke_vpc_routes is not None:
            pulumi.set(__self__, "filtered_spoke_vpc_routes", filtered_spoke_vpc_routes)
        if gw_name is not None:
            pulumi.set(__self__, "gw_name", gw_name)
        if gw_size is not None:
            pulumi.set(__self__, "gw_size", gw_size)
        if ha_availability_domain is not None:
            pulumi.set(__self__, "ha_availability_domain", ha_availability_domain)
        if ha_azure_eip_name_resource_group is not None:
            pulumi.set(__self__, "ha_azure_eip_name_resource_group", ha_azure_eip_name_resource_group)
        if ha_cloud_instance_id is not None:
            pulumi.set(__self__, "ha_cloud_instance_id", ha_cloud_instance_id)
        if ha_eip is not None:
            pulumi.set(__self__, "ha_eip", ha_eip)
        if ha_fault_domain is not None:
            pulumi.set(__self__, "ha_fault_domain", ha_fault_domain)
        if ha_gw_name is not None:
            pulumi.set(__self__, "ha_gw_name", ha_gw_name)
        if ha_gw_size is not None:
            pulumi.set(__self__, "ha_gw_size", ha_gw_size)
        if ha_image_version is not None:
            pulumi.set(__self__, "ha_image_version", ha_image_version)
        if ha_insane_mode_az is not None:
            pulumi.set(__self__, "ha_insane_mode_az", ha_insane_mode_az)
        if ha_oob_availability_zone is not None:
            pulumi.set(__self__, "ha_oob_availability_zone", ha_oob_availability_zone)
        if ha_oob_management_subnet is not None:
            pulumi.set(__self__, "ha_oob_management_subnet", ha_oob_management_subnet)
        if ha_private_ip is not None:
            pulumi.set(__self__, "ha_private_ip", ha_private_ip)
        if ha_private_mode_subnet_zone is not None:
            pulumi.set(__self__, "ha_private_mode_subnet_zone", ha_private_mode_subnet_zone)
        if ha_public_ip is not None:
            pulumi.set(__self__, "ha_public_ip", ha_public_ip)
        if ha_security_group_id is not None:
            pulumi.set(__self__, "ha_security_group_id", ha_security_group_id)
        if ha_software_version is not None:
            pulumi.set(__self__, "ha_software_version", ha_software_version)
        if ha_subnet is not None:
            pulumi.set(__self__, "ha_subnet", ha_subnet)
        if ha_zone is not None:
            pulumi.set(__self__, "ha_zone", ha_zone)
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if included_advertised_spoke_routes is not None:
            pulumi.set(__self__, "included_advertised_spoke_routes", included_advertised_spoke_routes)
        if insane_mode is not None:
            pulumi.set(__self__, "insane_mode", insane_mode)
        if insane_mode_az is not None:
            pulumi.set(__self__, "insane_mode_az", insane_mode_az)
        if learned_cidrs_approval_mode is not None:
            pulumi.set(__self__, "learned_cidrs_approval_mode", learned_cidrs_approval_mode)
        if local_as_number is not None:
            pulumi.set(__self__, "local_as_number", local_as_number)
        if manage_transit_gateway_attachment is not None:
            pulumi.set(__self__, "manage_transit_gateway_attachment", manage_transit_gateway_attachment)
        if monitor_exclude_lists is not None:
            pulumi.set(__self__, "monitor_exclude_lists", monitor_exclude_lists)
        if oob_availability_zone is not None:
            pulumi.set(__self__, "oob_availability_zone", oob_availability_zone)
        if oob_management_subnet is not None:
            pulumi.set(__self__, "oob_management_subnet", oob_management_subnet)
        if prepend_as_paths is not None:
            pulumi.set(__self__, "prepend_as_paths", prepend_as_paths)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if private_mode_lb_vpc_id is not None:
            pulumi.set(__self__, "private_mode_lb_vpc_id", private_mode_lb_vpc_id)
        if private_mode_subnet_zone is not None:
            pulumi.set(__self__, "private_mode_subnet_zone", private_mode_subnet_zone)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if rx_queue_size is not None:
            pulumi.set(__self__, "rx_queue_size", rx_queue_size)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if single_az_ha is not None:
            pulumi.set(__self__, "single_az_ha", single_az_ha)
        if single_ip_snat is not None:
            pulumi.set(__self__, "single_ip_snat", single_ip_snat)
        if software_version is not None:
            pulumi.set(__self__, "software_version", software_version)
        if spoke_bgp_manual_advertise_cidrs is not None:
            pulumi.set(__self__, "spoke_bgp_manual_advertise_cidrs", spoke_bgp_manual_advertise_cidrs)
        if spot_price is not None:
            pulumi.set(__self__, "spot_price", spot_price)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if tag_lists is not None:
            warnings.warn("""Use tags instead.""", DeprecationWarning)
            pulumi.log.warn("""tag_lists is deprecated: Use tags instead.""")
        if tag_lists is not None:
            pulumi.set(__self__, "tag_lists", tag_lists)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_gw is not None:
            warnings.warn("""Please set `manage_transit_gateway_attachment` to false, and use the standalone aviatrix_spoke_transit_attachment resource instead.""", DeprecationWarning)
            pulumi.log.warn("""transit_gw is deprecated: Please set `manage_transit_gateway_attachment` to false, and use the standalone aviatrix_spoke_transit_attachment resource instead.""")
        if transit_gw is not None:
            pulumi.set(__self__, "transit_gw", transit_gw)
        if tunnel_detection_time is not None:
            pulumi.set(__self__, "tunnel_detection_time", tunnel_detection_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_reg is not None:
            pulumi.set(__self__, "vpc_reg", vpc_reg)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="allocateNewEip")
    def allocate_new_eip(self) -> Optional[pulumi.Input[bool]]:
        """
        If false, reuse an idle address in Elastic IP pool for this gateway. Otherwise, allocate a new Elastic IP and use it for
        this gateway.
        """
        return pulumi.get(self, "allocate_new_eip")

    @allocate_new_eip.setter
    def allocate_new_eip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allocate_new_eip", value)

    @property
    @pulumi.getter(name="approvedLearnedCidrs")
    def approved_learned_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Approved learned CIDRs for BGP Spoke Gateway. Available as of provider version R2.21+.
        """
        return pulumi.get(self, "approved_learned_cidrs")

    @approved_learned_cidrs.setter
    def approved_learned_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "approved_learned_cidrs", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Availability domain for OCI.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="azureEipNameResourceGroup")
    def azure_eip_name_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the public IP address and its resource group in Azure to assign to this Spoke Gateway.
        """
        return pulumi.get(self, "azure_eip_name_resource_group")

    @azure_eip_name_resource_group.setter
    def azure_eip_name_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_eip_name_resource_group", value)

    @property
    @pulumi.getter(name="bgpEcmp")
    def bgp_ecmp(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Equal Cost Multi Path (ECMP) routing for the next hop for BGP Spoke Gateway.
        """
        return pulumi.get(self, "bgp_ecmp")

    @bgp_ecmp.setter
    def bgp_ecmp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bgp_ecmp", value)

    @property
    @pulumi.getter(name="bgpHoldTime")
    def bgp_hold_time(self) -> Optional[pulumi.Input[int]]:
        """
        BGP Hold Time for BGP Spoke Gateway. Unit is in seconds. Valid values are between 12 and 360.
        """
        return pulumi.get(self, "bgp_hold_time")

    @bgp_hold_time.setter
    def bgp_hold_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bgp_hold_time", value)

    @property
    @pulumi.getter(name="bgpPollingTime")
    def bgp_polling_time(self) -> Optional[pulumi.Input[int]]:
        """
        BGP route polling time for BGP Spoke Gateway. Unit is in seconds. Valid values are between 10 and 50.
        """
        return pulumi.get(self, "bgp_polling_time")

    @bgp_polling_time.setter
    def bgp_polling_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bgp_polling_time", value)

    @property
    @pulumi.getter(name="cloudInstanceId")
    def cloud_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud instance ID.
        """
        return pulumi.get(self, "cloud_instance_id")

    @cloud_instance_id.setter
    def cloud_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_instance_id", value)

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> Optional[pulumi.Input[int]]:
        """
        Type of cloud service provider.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud_type", value)

    @property
    @pulumi.getter(name="customerManagedKeys")
    def customer_managed_keys(self) -> Optional[pulumi.Input[str]]:
        """
        Customer managed key ID.
        """
        return pulumi.get(self, "customer_managed_keys")

    @customer_managed_keys.setter
    def customer_managed_keys(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_managed_keys", value)

    @property
    @pulumi.getter(name="customizedSpokeVpcRoutes")
    def customized_spoke_vpc_routes(self) -> Optional[pulumi.Input[str]]:
        """
        A list of comma separated CIDRs to be customized for the spoke VPC routes. When configured, it will replace all learned
        routes in VPC routing tables, including RFC1918 and non-RFC1918 CIDRs. It applies to this spoke gateway only.
        """
        return pulumi.get(self, "customized_spoke_vpc_routes")

    @customized_spoke_vpc_routes.setter
    def customized_spoke_vpc_routes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customized_spoke_vpc_routes", value)

    @property
    @pulumi.getter(name="disableRoutePropagation")
    def disable_route_propagation(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables route propagation on BGP Spoke to attached Transit Gateway. Default: false.
        """
        return pulumi.get(self, "disable_route_propagation")

    @disable_route_propagation.setter
    def disable_route_propagation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_route_propagation", value)

    @property
    @pulumi.getter
    def eip(self) -> Optional[pulumi.Input[str]]:
        """
        Required when allocate_new_eip is false. It uses specified EIP for this gateway.
        """
        return pulumi.get(self, "eip")

    @eip.setter
    def eip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip", value)

    @property
    @pulumi.getter(name="enableActiveStandby")
    def enable_active_standby(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables Active-Standby Mode, available only with HA enabled for BGP Spoke Gateway.
        """
        return pulumi.get(self, "enable_active_standby")

    @enable_active_standby.setter
    def enable_active_standby(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_active_standby", value)

    @property
    @pulumi.getter(name="enableActiveStandbyPreemptive")
    def enable_active_standby_preemptive(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables Preemptive Mode for Active-Standby, available only with Active-Standby enabled.
        """
        return pulumi.get(self, "enable_active_standby_preemptive")

    @enable_active_standby_preemptive.setter
    def enable_active_standby_preemptive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_active_standby_preemptive", value)

    @property
    @pulumi.getter(name="enableAutoAdvertiseS2cCidrs")
    def enable_auto_advertise_s2c_cidrs(self) -> Optional[pulumi.Input[bool]]:
        """
        Automatically advertise remote CIDR to Aviatrix Transit Gateway when route based Site2Cloud Tunnel is created.
        """
        return pulumi.get(self, "enable_auto_advertise_s2c_cidrs")

    @enable_auto_advertise_s2c_cidrs.setter
    def enable_auto_advertise_s2c_cidrs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_auto_advertise_s2c_cidrs", value)

    @property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable BGP. Default: false.
        """
        return pulumi.get(self, "enable_bgp")

    @enable_bgp.setter
    def enable_bgp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_bgp", value)

    @property
    @pulumi.getter(name="enableEncryptVolume")
    def enable_encrypt_volume(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable encrypt gateway EBS volume. Only supported for AWS provider. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_encrypt_volume")

    @enable_encrypt_volume.setter
    def enable_encrypt_volume(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_encrypt_volume", value)

    @property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable jumbo frame support for spoke gateway. Valid values: true or false. Default value: true.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @enable_jumbo_frame.setter
    def enable_jumbo_frame(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_jumbo_frame", value)

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable/disable learned CIDR approval for BGP Spoke Gateway. Valid values: true, false.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @enable_learned_cidrs_approval.setter
    def enable_learned_cidrs_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_learned_cidrs_approval", value)

    @property
    @pulumi.getter(name="enableMonitorGatewaySubnets")
    def enable_monitor_gateway_subnets(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable [monitor gateway subnets](https://docs.aviatrix.com/HowTos/gateway.html#monitor-gateway-subnet). Only valid for
        cloud_type = 1 (AWS) or 256 (AWSGov). Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_monitor_gateway_subnets")

    @enable_monitor_gateway_subnets.setter
    def enable_monitor_gateway_subnets(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_monitor_gateway_subnets", value)

    @property
    @pulumi.getter(name="enablePreserveAsPath")
    def enable_preserve_as_path(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable preserve as_path when advertising manual summary cidrs on BGP spoke gateway.
        """
        return pulumi.get(self, "enable_preserve_as_path")

    @enable_preserve_as_path.setter
    def enable_preserve_as_path(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_preserve_as_path", value)

    @property
    @pulumi.getter(name="enablePrivateOob")
    def enable_private_oob(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable private OOB.
        """
        return pulumi.get(self, "enable_private_oob")

    @enable_private_oob.setter
    def enable_private_oob(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_oob", value)

    @property
    @pulumi.getter(name="enablePrivateVpcDefaultRoute")
    def enable_private_vpc_default_route(self) -> Optional[pulumi.Input[bool]]:
        """
        Config Private VPC Default Route.
        """
        return pulumi.get(self, "enable_private_vpc_default_route")

    @enable_private_vpc_default_route.setter
    def enable_private_vpc_default_route(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_vpc_default_route", value)

    @property
    @pulumi.getter(name="enableSkipPublicRouteTableUpdate")
    def enable_skip_public_route_table_update(self) -> Optional[pulumi.Input[bool]]:
        """
        Skip Public Route Table Update.
        """
        return pulumi.get(self, "enable_skip_public_route_table_update")

    @enable_skip_public_route_table_update.setter
    def enable_skip_public_route_table_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_skip_public_route_table_update", value)

    @property
    @pulumi.getter(name="enableSpotInstance")
    def enable_spot_instance(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable spot instance. NOT supported for production deployment.
        """
        return pulumi.get(self, "enable_spot_instance")

    @enable_spot_instance.setter
    def enable_spot_instance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_spot_instance", value)

    @property
    @pulumi.getter(name="enableVpcDnsServer")
    def enable_vpc_dns_server(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable vpc_dns_server for Gateway. Valid values: true, false.
        """
        return pulumi.get(self, "enable_vpc_dns_server")

    @enable_vpc_dns_server.setter
    def enable_vpc_dns_server(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vpc_dns_server", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Fault domain for OCI.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="filteredSpokeVpcRoutes")
    def filtered_spoke_vpc_routes(self) -> Optional[pulumi.Input[str]]:
        """
        A list of comma separated CIDRs to be filtered from the spoke VPC route table. When configured, filtering CIDR(s) or
        it’s subnet will be deleted from VPC routing tables as well as from spoke gateway’s routing table. It applies to
        this spoke gateway only.
        """
        return pulumi.get(self, "filtered_spoke_vpc_routes")

    @filtered_spoke_vpc_routes.setter
    def filtered_spoke_vpc_routes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filtered_spoke_vpc_routes", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the gateway which is going to be created.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="gwSize")
    def gw_size(self) -> Optional[pulumi.Input[str]]:
        """
        Size of the gateway instance.
        """
        return pulumi.get(self, "gw_size")

    @gw_size.setter
    def gw_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_size", value)

    @property
    @pulumi.getter(name="haAvailabilityDomain")
    def ha_availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        HA availability domain for OCI.
        """
        return pulumi.get(self, "ha_availability_domain")

    @ha_availability_domain.setter
    def ha_availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_availability_domain", value)

    @property
    @pulumi.getter(name="haAzureEipNameResourceGroup")
    def ha_azure_eip_name_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the public IP address and its resource group in Azure to assign to the HA Spoke Gateway.
        """
        return pulumi.get(self, "ha_azure_eip_name_resource_group")

    @ha_azure_eip_name_resource_group.setter
    def ha_azure_eip_name_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_azure_eip_name_resource_group", value)

    @property
    @pulumi.getter(name="haCloudInstanceId")
    def ha_cloud_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud instance ID of HA spoke gateway.
        """
        return pulumi.get(self, "ha_cloud_instance_id")

    @ha_cloud_instance_id.setter
    def ha_cloud_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_cloud_instance_id", value)

    @property
    @pulumi.getter(name="haEip")
    def ha_eip(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address that you want assigned to the HA Spoke Gateway.
        """
        return pulumi.get(self, "ha_eip")

    @ha_eip.setter
    def ha_eip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_eip", value)

    @property
    @pulumi.getter(name="haFaultDomain")
    def ha_fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        HA fault domain for OCI.
        """
        return pulumi.get(self, "ha_fault_domain")

    @ha_fault_domain.setter
    def ha_fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_fault_domain", value)

    @property
    @pulumi.getter(name="haGwName")
    def ha_gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Aviatrix spoke gateway unique name of HA spoke gateway.
        """
        return pulumi.get(self, "ha_gw_name")

    @ha_gw_name.setter
    def ha_gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_gw_name", value)

    @property
    @pulumi.getter(name="haGwSize")
    def ha_gw_size(self) -> Optional[pulumi.Input[str]]:
        """
        HA Gateway Size.
        """
        return pulumi.get(self, "ha_gw_size")

    @ha_gw_size.setter
    def ha_gw_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_gw_size", value)

    @property
    @pulumi.getter(name="haImageVersion")
    def ha_image_version(self) -> Optional[pulumi.Input[str]]:
        """
        ha_image_version can be used to set the desired image version of the HA gateway. If set, we will attempt to update the
        gateway to the specified version.
        """
        return pulumi.get(self, "ha_image_version")

    @ha_image_version.setter
    def ha_image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_image_version", value)

    @property
    @pulumi.getter(name="haInsaneModeAz")
    def ha_insane_mode_az(self) -> Optional[pulumi.Input[str]]:
        """
        AZ of subnet being created for Insane Mode Spoke HA Gateway. Required for AWS if insane_mode is true and ha_subnet is
        set.
        """
        return pulumi.get(self, "ha_insane_mode_az")

    @ha_insane_mode_az.setter
    def ha_insane_mode_az(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_insane_mode_az", value)

    @property
    @pulumi.getter(name="haOobAvailabilityZone")
    def ha_oob_availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        OOB HA availability zone.
        """
        return pulumi.get(self, "ha_oob_availability_zone")

    @ha_oob_availability_zone.setter
    def ha_oob_availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_oob_availability_zone", value)

    @property
    @pulumi.getter(name="haOobManagementSubnet")
    def ha_oob_management_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        OOB HA management subnet.
        """
        return pulumi.get(self, "ha_oob_management_subnet")

    @ha_oob_management_subnet.setter
    def ha_oob_management_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_oob_management_subnet", value)

    @property
    @pulumi.getter(name="haPrivateIp")
    def ha_private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Private IP address of the spoke gateway created.
        """
        return pulumi.get(self, "ha_private_ip")

    @ha_private_ip.setter
    def ha_private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_private_ip", value)

    @property
    @pulumi.getter(name="haPrivateModeSubnetZone")
    def ha_private_mode_subnet_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Private Mode HA subnet availability zone.
        """
        return pulumi.get(self, "ha_private_mode_subnet_zone")

    @ha_private_mode_subnet_zone.setter
    def ha_private_mode_subnet_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_private_mode_subnet_zone", value)

    @property
    @pulumi.getter(name="haPublicIp")
    def ha_public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address of the HA Spoke Gateway.
        """
        return pulumi.get(self, "ha_public_ip")

    @ha_public_ip.setter
    def ha_public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_public_ip", value)

    @property
    @pulumi.getter(name="haSecurityGroupId")
    def ha_security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        HA security group used for the spoke gateway.
        """
        return pulumi.get(self, "ha_security_group_id")

    @ha_security_group_id.setter
    def ha_security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_security_group_id", value)

    @property
    @pulumi.getter(name="haSoftwareVersion")
    def ha_software_version(self) -> Optional[pulumi.Input[str]]:
        """
        ha_software_version can be used to set the desired software version of the HA gateway. If set, we will attempt to update
        the gateway to the specified version. If left blank, the gateway software version will continue to be managed through
        the aviatrix_controller_config resource.
        """
        return pulumi.get(self, "ha_software_version")

    @ha_software_version.setter
    def ha_software_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_software_version", value)

    @property
    @pulumi.getter(name="haSubnet")
    def ha_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        HA Subnet. Required if enabling HA for AWS/AWSGov/AWSChina/Azure/AzureChina/OCI/Alibaba Cloud. Optional if enabling HA
        for GCP.
        """
        return pulumi.get(self, "ha_subnet")

    @ha_subnet.setter
    def ha_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_subnet", value)

    @property
    @pulumi.getter(name="haZone")
    def ha_zone(self) -> Optional[pulumi.Input[str]]:
        """
        HA Zone. Required if enabling HA for GCP. Optional for Azure.
        """
        return pulumi.get(self, "ha_zone")

    @ha_zone.setter
    def ha_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_zone", value)

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[pulumi.Input[str]]:
        """
        image_version can be used to set the desired image version of the gateway. If set, we will attempt to update the gateway
        to the specified version.
        """
        return pulumi.get(self, "image_version")

    @image_version.setter
    def image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_version", value)

    @property
    @pulumi.getter(name="includedAdvertisedSpokeRoutes")
    def included_advertised_spoke_routes(self) -> Optional[pulumi.Input[str]]:
        """
        A list of comma separated CIDRs to be advertised to on-prem as 'Included CIDR List'. When configured, it will replace
        all advertised routes from this VPC.
        """
        return pulumi.get(self, "included_advertised_spoke_routes")

    @included_advertised_spoke_routes.setter
    def included_advertised_spoke_routes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "included_advertised_spoke_routes", value)

    @property
    @pulumi.getter(name="insaneMode")
    def insane_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Insane Mode for Spoke Gateway. Valid values: true, false. Supported for AWS/AWSGov, GCP, Azure and OCI. If insane
        mode is enabled, gateway size has to at least be c5 size for AWS and Standard_D3_v2 size for Azure.
        """
        return pulumi.get(self, "insane_mode")

    @insane_mode.setter
    def insane_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insane_mode", value)

    @property
    @pulumi.getter(name="insaneModeAz")
    def insane_mode_az(self) -> Optional[pulumi.Input[str]]:
        """
        AZ of subnet being created for Insane Mode Spoke Gateway. Required if insane_mode is enabled for AWS cloud.
        """
        return pulumi.get(self, "insane_mode_az")

    @insane_mode_az.setter
    def insane_mode_az(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insane_mode_az", value)

    @property
    @pulumi.getter(name="learnedCidrsApprovalMode")
    def learned_cidrs_approval_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Set the learned CIDRs approval mode for BGP Spoke Gateway. Only valid when 'enable_learned_cidrs_approval' is set to
        true. Currently, only 'gateway' is supported: learned CIDR approval applies to ALL connections. Default value:
        'gateway'.
        """
        return pulumi.get(self, "learned_cidrs_approval_mode")

    @learned_cidrs_approval_mode.setter
    def learned_cidrs_approval_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "learned_cidrs_approval_mode", value)

    @property
    @pulumi.getter(name="localAsNumber")
    def local_as_number(self) -> Optional[pulumi.Input[str]]:
        """
        Changes the Aviatrix BGP Spoke Gateway ASN number before you setup Aviatrix BGP Spoke Gateway connection configurations.
        """
        return pulumi.get(self, "local_as_number")

    @local_as_number.setter
    def local_as_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_as_number", value)

    @property
    @pulumi.getter(name="manageTransitGatewayAttachment")
    def manage_transit_gateway_attachment(self) -> Optional[pulumi.Input[bool]]:
        """
        This parameter is a switch used to determine whether or not to manage attaching this spoke gateway to transit gateways
        using the aviatrix_spoke_gateway resource. If this is set to false, attaching this spoke gateway to transit gateways
        must be done using the aviatrix_spoke_transit_attachment resource. Valid values: true, false. Default value: true.
        """
        return pulumi.get(self, "manage_transit_gateway_attachment")

    @manage_transit_gateway_attachment.setter
    def manage_transit_gateway_attachment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_transit_gateway_attachment", value)

    @property
    @pulumi.getter(name="monitorExcludeLists")
    def monitor_exclude_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of monitored instance ids. Only valid when 'enable_monitor_gateway_subnets' = true.
        """
        return pulumi.get(self, "monitor_exclude_lists")

    @monitor_exclude_lists.setter
    def monitor_exclude_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "monitor_exclude_lists", value)

    @property
    @pulumi.getter(name="oobAvailabilityZone")
    def oob_availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        OOB subnet availability zone.
        """
        return pulumi.get(self, "oob_availability_zone")

    @oob_availability_zone.setter
    def oob_availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oob_availability_zone", value)

    @property
    @pulumi.getter(name="oobManagementSubnet")
    def oob_management_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        OOB management subnet.
        """
        return pulumi.get(self, "oob_management_subnet")

    @oob_management_subnet.setter
    def oob_management_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oob_management_subnet", value)

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of AS numbers to populate BGP AP_PATH field when it advertises to VGW or peer devices. Only valid for BGP Spoke
        Gateway
        """
        return pulumi.get(self, "prepend_as_paths")

    @prepend_as_paths.setter
    def prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prepend_as_paths", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Private IP address of the spoke gateway created.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="privateModeLbVpcId")
    def private_mode_lb_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Private Mode controller load balancer vpc_id. Required when private mode is enabled for the Controller.
        """
        return pulumi.get(self, "private_mode_lb_vpc_id")

    @private_mode_lb_vpc_id.setter
    def private_mode_lb_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_mode_lb_vpc_id", value)

    @property
    @pulumi.getter(name="privateModeSubnetZone")
    def private_mode_subnet_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet availability zone. Required when Private Mode is enabled on the Controller and cloud_type is AWS.
        """
        return pulumi.get(self, "private_mode_subnet_zone")

    @private_mode_subnet_zone.setter
    def private_mode_subnet_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_mode_subnet_zone", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address of the Spoke Gateway created.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter(name="rxQueueSize")
    def rx_queue_size(self) -> Optional[pulumi.Input[str]]:
        """
        Gateway ethernet interface RX queue size. Supported for AWS related clouds only.
        """
        return pulumi.get(self, "rx_queue_size")

    @rx_queue_size.setter
    def rx_queue_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rx_queue_size", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Security group used for the spoke gateway.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="singleAzHa")
    def single_az_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to 'enabled' if this feature is desired.
        """
        return pulumi.get(self, "single_az_ha")

    @single_az_ha.setter
    def single_az_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "single_az_ha", value)

    @property
    @pulumi.getter(name="singleIpSnat")
    def single_ip_snat(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether to enable Source NAT feature in 'single_ip' mode on the gateway or not.
        """
        return pulumi.get(self, "single_ip_snat")

    @single_ip_snat.setter
    def single_ip_snat(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "single_ip_snat", value)

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> Optional[pulumi.Input[str]]:
        """
        software_version can be used to set the desired software version of the gateway. If set, we will attempt to update the
        gateway to the specified version. If left blank, the gateway software version will continue to be managed through the
        aviatrix_controller_config resource.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "software_version", value)

    @property
    @pulumi.getter(name="spokeBgpManualAdvertiseCidrs")
    def spoke_bgp_manual_advertise_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Intended CIDR list to be advertised to external BGP router.
        """
        return pulumi.get(self, "spoke_bgp_manual_advertise_cidrs")

    @spoke_bgp_manual_advertise_cidrs.setter
    def spoke_bgp_manual_advertise_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "spoke_bgp_manual_advertise_cidrs", value)

    @property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> Optional[pulumi.Input[str]]:
        """
        Price for spot instance. NOT supported for production deployment.
        """
        return pulumi.get(self, "spot_price")

    @spot_price.setter
    def spot_price(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_price", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Public Subnet Info.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Instance tag of cloud provider.
        """
        return pulumi.get(self, "tag_lists")

    @tag_lists.setter
    def tag_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tag_lists", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the spoke gateway.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="transitGw")
    def transit_gw(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the transit Gateways to attach to this spoke. Format is a comma-separated list of transit gateway names. For
        example, 'transit-gw1,transit-gw2'.
        """
        return pulumi.get(self, "transit_gw")

    @transit_gw.setter
    def transit_gw(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_gw", value)

    @property
    @pulumi.getter(name="tunnelDetectionTime")
    def tunnel_detection_time(self) -> Optional[pulumi.Input[int]]:
        """
        The IPSec tunnel down detection time for the Spoke Gateway.
        """
        return pulumi.get(self, "tunnel_detection_time")

    @tunnel_detection_time.setter
    def tunnel_detection_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tunnel_detection_time", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC-ID/VNet-Name of cloud provider.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcReg")
    def vpc_reg(self) -> Optional[pulumi.Input[str]]:
        """
        Region of cloud provider.
        """
        return pulumi.get(self, "vpc_reg")

    @vpc_reg.setter
    def vpc_reg(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_reg", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Availability Zone. Only available for cloud_type = 8 (Azure). Must be in the form 'az-n', for example, 'az-2'.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class AviatrixSpokeGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 allocate_new_eip: Optional[pulumi.Input[bool]] = None,
                 approved_learned_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
                 bgp_ecmp: Optional[pulumi.Input[bool]] = None,
                 bgp_hold_time: Optional[pulumi.Input[int]] = None,
                 bgp_polling_time: Optional[pulumi.Input[int]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 customer_managed_keys: Optional[pulumi.Input[str]] = None,
                 customized_spoke_vpc_routes: Optional[pulumi.Input[str]] = None,
                 disable_route_propagation: Optional[pulumi.Input[bool]] = None,
                 eip: Optional[pulumi.Input[str]] = None,
                 enable_active_standby: Optional[pulumi.Input[bool]] = None,
                 enable_active_standby_preemptive: Optional[pulumi.Input[bool]] = None,
                 enable_auto_advertise_s2c_cidrs: Optional[pulumi.Input[bool]] = None,
                 enable_bgp: Optional[pulumi.Input[bool]] = None,
                 enable_encrypt_volume: Optional[pulumi.Input[bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 enable_monitor_gateway_subnets: Optional[pulumi.Input[bool]] = None,
                 enable_preserve_as_path: Optional[pulumi.Input[bool]] = None,
                 enable_private_oob: Optional[pulumi.Input[bool]] = None,
                 enable_private_vpc_default_route: Optional[pulumi.Input[bool]] = None,
                 enable_skip_public_route_table_update: Optional[pulumi.Input[bool]] = None,
                 enable_spot_instance: Optional[pulumi.Input[bool]] = None,
                 enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 filtered_spoke_vpc_routes: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 gw_size: Optional[pulumi.Input[str]] = None,
                 ha_availability_domain: Optional[pulumi.Input[str]] = None,
                 ha_azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
                 ha_eip: Optional[pulumi.Input[str]] = None,
                 ha_fault_domain: Optional[pulumi.Input[str]] = None,
                 ha_gw_size: Optional[pulumi.Input[str]] = None,
                 ha_image_version: Optional[pulumi.Input[str]] = None,
                 ha_insane_mode_az: Optional[pulumi.Input[str]] = None,
                 ha_oob_availability_zone: Optional[pulumi.Input[str]] = None,
                 ha_oob_management_subnet: Optional[pulumi.Input[str]] = None,
                 ha_private_mode_subnet_zone: Optional[pulumi.Input[str]] = None,
                 ha_software_version: Optional[pulumi.Input[str]] = None,
                 ha_subnet: Optional[pulumi.Input[str]] = None,
                 ha_zone: Optional[pulumi.Input[str]] = None,
                 image_version: Optional[pulumi.Input[str]] = None,
                 included_advertised_spoke_routes: Optional[pulumi.Input[str]] = None,
                 insane_mode: Optional[pulumi.Input[bool]] = None,
                 insane_mode_az: Optional[pulumi.Input[str]] = None,
                 learned_cidrs_approval_mode: Optional[pulumi.Input[str]] = None,
                 local_as_number: Optional[pulumi.Input[str]] = None,
                 manage_transit_gateway_attachment: Optional[pulumi.Input[bool]] = None,
                 monitor_exclude_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 oob_availability_zone: Optional[pulumi.Input[str]] = None,
                 oob_management_subnet: Optional[pulumi.Input[str]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_mode_lb_vpc_id: Optional[pulumi.Input[str]] = None,
                 private_mode_subnet_zone: Optional[pulumi.Input[str]] = None,
                 rx_queue_size: Optional[pulumi.Input[str]] = None,
                 single_az_ha: Optional[pulumi.Input[bool]] = None,
                 single_ip_snat: Optional[pulumi.Input[bool]] = None,
                 software_version: Optional[pulumi.Input[str]] = None,
                 spoke_bgp_manual_advertise_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_price: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 transit_gw: Optional[pulumi.Input[str]] = None,
                 tunnel_detection_time: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_reg: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixSpokeGateway resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[bool] allocate_new_eip: If false, reuse an idle address in Elastic IP pool for this gateway. Otherwise, allocate a new Elastic IP and use it for
               this gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] approved_learned_cidrs: Approved learned CIDRs for BGP Spoke Gateway. Available as of provider version R2.21+.
        :param pulumi.Input[str] availability_domain: Availability domain for OCI.
        :param pulumi.Input[str] azure_eip_name_resource_group: The name of the public IP address and its resource group in Azure to assign to this Spoke Gateway.
        :param pulumi.Input[bool] bgp_ecmp: Enable Equal Cost Multi Path (ECMP) routing for the next hop for BGP Spoke Gateway.
        :param pulumi.Input[int] bgp_hold_time: BGP Hold Time for BGP Spoke Gateway. Unit is in seconds. Valid values are between 12 and 360.
        :param pulumi.Input[int] bgp_polling_time: BGP route polling time for BGP Spoke Gateway. Unit is in seconds. Valid values are between 10 and 50.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider.
        :param pulumi.Input[str] customer_managed_keys: Customer managed key ID.
        :param pulumi.Input[str] customized_spoke_vpc_routes: A list of comma separated CIDRs to be customized for the spoke VPC routes. When configured, it will replace all learned
               routes in VPC routing tables, including RFC1918 and non-RFC1918 CIDRs. It applies to this spoke gateway only.
        :param pulumi.Input[bool] disable_route_propagation: Disables route propagation on BGP Spoke to attached Transit Gateway. Default: false.
        :param pulumi.Input[str] eip: Required when allocate_new_eip is false. It uses specified EIP for this gateway.
        :param pulumi.Input[bool] enable_active_standby: Enables Active-Standby Mode, available only with HA enabled for BGP Spoke Gateway.
        :param pulumi.Input[bool] enable_active_standby_preemptive: Enables Preemptive Mode for Active-Standby, available only with Active-Standby enabled.
        :param pulumi.Input[bool] enable_auto_advertise_s2c_cidrs: Automatically advertise remote CIDR to Aviatrix Transit Gateway when route based Site2Cloud Tunnel is created.
        :param pulumi.Input[bool] enable_bgp: Enable BGP. Default: false.
        :param pulumi.Input[bool] enable_encrypt_volume: Enable encrypt gateway EBS volume. Only supported for AWS provider. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_jumbo_frame: Enable jumbo frame support for spoke gateway. Valid values: true or false. Default value: true.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Switch to enable/disable learned CIDR approval for BGP Spoke Gateway. Valid values: true, false.
        :param pulumi.Input[bool] enable_monitor_gateway_subnets: Enable [monitor gateway subnets](https://docs.aviatrix.com/HowTos/gateway.html#monitor-gateway-subnet). Only valid for
               cloud_type = 1 (AWS) or 256 (AWSGov). Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_preserve_as_path: Enable preserve as_path when advertising manual summary cidrs on BGP spoke gateway.
        :param pulumi.Input[bool] enable_private_oob: Enable private OOB.
        :param pulumi.Input[bool] enable_private_vpc_default_route: Config Private VPC Default Route.
        :param pulumi.Input[bool] enable_skip_public_route_table_update: Skip Public Route Table Update.
        :param pulumi.Input[bool] enable_spot_instance: Enable spot instance. NOT supported for production deployment.
        :param pulumi.Input[bool] enable_vpc_dns_server: Enable vpc_dns_server for Gateway. Valid values: true, false.
        :param pulumi.Input[str] fault_domain: Fault domain for OCI.
        :param pulumi.Input[str] filtered_spoke_vpc_routes: A list of comma separated CIDRs to be filtered from the spoke VPC route table. When configured, filtering CIDR(s) or
               it’s subnet will be deleted from VPC routing tables as well as from spoke gateway’s routing table. It applies to
               this spoke gateway only.
        :param pulumi.Input[str] gw_name: Name of the gateway which is going to be created.
        :param pulumi.Input[str] gw_size: Size of the gateway instance.
        :param pulumi.Input[str] ha_availability_domain: HA availability domain for OCI.
        :param pulumi.Input[str] ha_azure_eip_name_resource_group: The name of the public IP address and its resource group in Azure to assign to the HA Spoke Gateway.
        :param pulumi.Input[str] ha_eip: Public IP address that you want assigned to the HA Spoke Gateway.
        :param pulumi.Input[str] ha_fault_domain: HA fault domain for OCI.
        :param pulumi.Input[str] ha_gw_size: HA Gateway Size.
        :param pulumi.Input[str] ha_image_version: ha_image_version can be used to set the desired image version of the HA gateway. If set, we will attempt to update the
               gateway to the specified version.
        :param pulumi.Input[str] ha_insane_mode_az: AZ of subnet being created for Insane Mode Spoke HA Gateway. Required for AWS if insane_mode is true and ha_subnet is
               set.
        :param pulumi.Input[str] ha_oob_availability_zone: OOB HA availability zone.
        :param pulumi.Input[str] ha_oob_management_subnet: OOB HA management subnet.
        :param pulumi.Input[str] ha_private_mode_subnet_zone: Private Mode HA subnet availability zone.
        :param pulumi.Input[str] ha_software_version: ha_software_version can be used to set the desired software version of the HA gateway. If set, we will attempt to update
               the gateway to the specified version. If left blank, the gateway software version will continue to be managed through
               the aviatrix_controller_config resource.
        :param pulumi.Input[str] ha_subnet: HA Subnet. Required if enabling HA for AWS/AWSGov/AWSChina/Azure/AzureChina/OCI/Alibaba Cloud. Optional if enabling HA
               for GCP.
        :param pulumi.Input[str] ha_zone: HA Zone. Required if enabling HA for GCP. Optional for Azure.
        :param pulumi.Input[str] image_version: image_version can be used to set the desired image version of the gateway. If set, we will attempt to update the gateway
               to the specified version.
        :param pulumi.Input[str] included_advertised_spoke_routes: A list of comma separated CIDRs to be advertised to on-prem as 'Included CIDR List'. When configured, it will replace
               all advertised routes from this VPC.
        :param pulumi.Input[bool] insane_mode: Enable Insane Mode for Spoke Gateway. Valid values: true, false. Supported for AWS/AWSGov, GCP, Azure and OCI. If insane
               mode is enabled, gateway size has to at least be c5 size for AWS and Standard_D3_v2 size for Azure.
        :param pulumi.Input[str] insane_mode_az: AZ of subnet being created for Insane Mode Spoke Gateway. Required if insane_mode is enabled for AWS cloud.
        :param pulumi.Input[str] learned_cidrs_approval_mode: Set the learned CIDRs approval mode for BGP Spoke Gateway. Only valid when 'enable_learned_cidrs_approval' is set to
               true. Currently, only 'gateway' is supported: learned CIDR approval applies to ALL connections. Default value:
               'gateway'.
        :param pulumi.Input[str] local_as_number: Changes the Aviatrix BGP Spoke Gateway ASN number before you setup Aviatrix BGP Spoke Gateway connection configurations.
        :param pulumi.Input[bool] manage_transit_gateway_attachment: This parameter is a switch used to determine whether or not to manage attaching this spoke gateway to transit gateways
               using the aviatrix_spoke_gateway resource. If this is set to false, attaching this spoke gateway to transit gateways
               must be done using the aviatrix_spoke_transit_attachment resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitor_exclude_lists: A set of monitored instance ids. Only valid when 'enable_monitor_gateway_subnets' = true.
        :param pulumi.Input[str] oob_availability_zone: OOB subnet availability zone.
        :param pulumi.Input[str] oob_management_subnet: OOB management subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: List of AS numbers to populate BGP AP_PATH field when it advertises to VGW or peer devices. Only valid for BGP Spoke
               Gateway
        :param pulumi.Input[str] private_mode_lb_vpc_id: Private Mode controller load balancer vpc_id. Required when private mode is enabled for the Controller.
        :param pulumi.Input[str] private_mode_subnet_zone: Subnet availability zone. Required when Private Mode is enabled on the Controller and cloud_type is AWS.
        :param pulumi.Input[str] rx_queue_size: Gateway ethernet interface RX queue size. Supported for AWS related clouds only.
        :param pulumi.Input[bool] single_az_ha: Set to 'enabled' if this feature is desired.
        :param pulumi.Input[bool] single_ip_snat: Specify whether to enable Source NAT feature in 'single_ip' mode on the gateway or not.
        :param pulumi.Input[str] software_version: software_version can be used to set the desired software version of the gateway. If set, we will attempt to update the
               gateway to the specified version. If left blank, the gateway software version will continue to be managed through the
               aviatrix_controller_config resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spoke_bgp_manual_advertise_cidrs: Intended CIDR list to be advertised to external BGP router.
        :param pulumi.Input[str] spot_price: Price for spot instance. NOT supported for production deployment.
        :param pulumi.Input[str] subnet: Public Subnet Info.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: Instance tag of cloud provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the spoke gateway.
        :param pulumi.Input[str] transit_gw: Specify the transit Gateways to attach to this spoke. Format is a comma-separated list of transit gateway names. For
               example, 'transit-gw1,transit-gw2'.
        :param pulumi.Input[int] tunnel_detection_time: The IPSec tunnel down detection time for the Spoke Gateway.
        :param pulumi.Input[str] vpc_id: VPC-ID/VNet-Name of cloud provider.
        :param pulumi.Input[str] vpc_reg: Region of cloud provider.
        :param pulumi.Input[str] zone: Availability Zone. Only available for cloud_type = 8 (Azure). Must be in the form 'az-n', for example, 'az-2'.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixSpokeGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixSpokeGateway resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixSpokeGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixSpokeGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 allocate_new_eip: Optional[pulumi.Input[bool]] = None,
                 approved_learned_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
                 bgp_ecmp: Optional[pulumi.Input[bool]] = None,
                 bgp_hold_time: Optional[pulumi.Input[int]] = None,
                 bgp_polling_time: Optional[pulumi.Input[int]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 customer_managed_keys: Optional[pulumi.Input[str]] = None,
                 customized_spoke_vpc_routes: Optional[pulumi.Input[str]] = None,
                 disable_route_propagation: Optional[pulumi.Input[bool]] = None,
                 eip: Optional[pulumi.Input[str]] = None,
                 enable_active_standby: Optional[pulumi.Input[bool]] = None,
                 enable_active_standby_preemptive: Optional[pulumi.Input[bool]] = None,
                 enable_auto_advertise_s2c_cidrs: Optional[pulumi.Input[bool]] = None,
                 enable_bgp: Optional[pulumi.Input[bool]] = None,
                 enable_encrypt_volume: Optional[pulumi.Input[bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 enable_monitor_gateway_subnets: Optional[pulumi.Input[bool]] = None,
                 enable_preserve_as_path: Optional[pulumi.Input[bool]] = None,
                 enable_private_oob: Optional[pulumi.Input[bool]] = None,
                 enable_private_vpc_default_route: Optional[pulumi.Input[bool]] = None,
                 enable_skip_public_route_table_update: Optional[pulumi.Input[bool]] = None,
                 enable_spot_instance: Optional[pulumi.Input[bool]] = None,
                 enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 filtered_spoke_vpc_routes: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 gw_size: Optional[pulumi.Input[str]] = None,
                 ha_availability_domain: Optional[pulumi.Input[str]] = None,
                 ha_azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
                 ha_eip: Optional[pulumi.Input[str]] = None,
                 ha_fault_domain: Optional[pulumi.Input[str]] = None,
                 ha_gw_size: Optional[pulumi.Input[str]] = None,
                 ha_image_version: Optional[pulumi.Input[str]] = None,
                 ha_insane_mode_az: Optional[pulumi.Input[str]] = None,
                 ha_oob_availability_zone: Optional[pulumi.Input[str]] = None,
                 ha_oob_management_subnet: Optional[pulumi.Input[str]] = None,
                 ha_private_mode_subnet_zone: Optional[pulumi.Input[str]] = None,
                 ha_software_version: Optional[pulumi.Input[str]] = None,
                 ha_subnet: Optional[pulumi.Input[str]] = None,
                 ha_zone: Optional[pulumi.Input[str]] = None,
                 image_version: Optional[pulumi.Input[str]] = None,
                 included_advertised_spoke_routes: Optional[pulumi.Input[str]] = None,
                 insane_mode: Optional[pulumi.Input[bool]] = None,
                 insane_mode_az: Optional[pulumi.Input[str]] = None,
                 learned_cidrs_approval_mode: Optional[pulumi.Input[str]] = None,
                 local_as_number: Optional[pulumi.Input[str]] = None,
                 manage_transit_gateway_attachment: Optional[pulumi.Input[bool]] = None,
                 monitor_exclude_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 oob_availability_zone: Optional[pulumi.Input[str]] = None,
                 oob_management_subnet: Optional[pulumi.Input[str]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_mode_lb_vpc_id: Optional[pulumi.Input[str]] = None,
                 private_mode_subnet_zone: Optional[pulumi.Input[str]] = None,
                 rx_queue_size: Optional[pulumi.Input[str]] = None,
                 single_az_ha: Optional[pulumi.Input[bool]] = None,
                 single_ip_snat: Optional[pulumi.Input[bool]] = None,
                 software_version: Optional[pulumi.Input[str]] = None,
                 spoke_bgp_manual_advertise_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_price: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 transit_gw: Optional[pulumi.Input[str]] = None,
                 tunnel_detection_time: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_reg: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixSpokeGatewayArgs.__new__(AviatrixSpokeGatewayArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["allocate_new_eip"] = allocate_new_eip
            __props__.__dict__["approved_learned_cidrs"] = approved_learned_cidrs
            __props__.__dict__["availability_domain"] = availability_domain
            __props__.__dict__["azure_eip_name_resource_group"] = azure_eip_name_resource_group
            __props__.__dict__["bgp_ecmp"] = bgp_ecmp
            __props__.__dict__["bgp_hold_time"] = bgp_hold_time
            __props__.__dict__["bgp_polling_time"] = bgp_polling_time
            if cloud_type is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_type'")
            __props__.__dict__["cloud_type"] = cloud_type
            __props__.__dict__["customer_managed_keys"] = customer_managed_keys
            __props__.__dict__["customized_spoke_vpc_routes"] = customized_spoke_vpc_routes
            __props__.__dict__["disable_route_propagation"] = disable_route_propagation
            __props__.__dict__["eip"] = eip
            __props__.__dict__["enable_active_standby"] = enable_active_standby
            __props__.__dict__["enable_active_standby_preemptive"] = enable_active_standby_preemptive
            __props__.__dict__["enable_auto_advertise_s2c_cidrs"] = enable_auto_advertise_s2c_cidrs
            __props__.__dict__["enable_bgp"] = enable_bgp
            __props__.__dict__["enable_encrypt_volume"] = enable_encrypt_volume
            __props__.__dict__["enable_jumbo_frame"] = enable_jumbo_frame
            __props__.__dict__["enable_learned_cidrs_approval"] = enable_learned_cidrs_approval
            __props__.__dict__["enable_monitor_gateway_subnets"] = enable_monitor_gateway_subnets
            __props__.__dict__["enable_preserve_as_path"] = enable_preserve_as_path
            __props__.__dict__["enable_private_oob"] = enable_private_oob
            __props__.__dict__["enable_private_vpc_default_route"] = enable_private_vpc_default_route
            __props__.__dict__["enable_skip_public_route_table_update"] = enable_skip_public_route_table_update
            __props__.__dict__["enable_spot_instance"] = enable_spot_instance
            __props__.__dict__["enable_vpc_dns_server"] = enable_vpc_dns_server
            __props__.__dict__["fault_domain"] = fault_domain
            __props__.__dict__["filtered_spoke_vpc_routes"] = filtered_spoke_vpc_routes
            if gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'gw_name'")
            __props__.__dict__["gw_name"] = gw_name
            if gw_size is None and not opts.urn:
                raise TypeError("Missing required property 'gw_size'")
            __props__.__dict__["gw_size"] = gw_size
            __props__.__dict__["ha_availability_domain"] = ha_availability_domain
            __props__.__dict__["ha_azure_eip_name_resource_group"] = ha_azure_eip_name_resource_group
            __props__.__dict__["ha_eip"] = ha_eip
            __props__.__dict__["ha_fault_domain"] = ha_fault_domain
            __props__.__dict__["ha_gw_size"] = ha_gw_size
            __props__.__dict__["ha_image_version"] = ha_image_version
            __props__.__dict__["ha_insane_mode_az"] = ha_insane_mode_az
            __props__.__dict__["ha_oob_availability_zone"] = ha_oob_availability_zone
            __props__.__dict__["ha_oob_management_subnet"] = ha_oob_management_subnet
            __props__.__dict__["ha_private_mode_subnet_zone"] = ha_private_mode_subnet_zone
            __props__.__dict__["ha_software_version"] = ha_software_version
            __props__.__dict__["ha_subnet"] = ha_subnet
            __props__.__dict__["ha_zone"] = ha_zone
            __props__.__dict__["image_version"] = image_version
            __props__.__dict__["included_advertised_spoke_routes"] = included_advertised_spoke_routes
            __props__.__dict__["insane_mode"] = insane_mode
            __props__.__dict__["insane_mode_az"] = insane_mode_az
            __props__.__dict__["learned_cidrs_approval_mode"] = learned_cidrs_approval_mode
            __props__.__dict__["local_as_number"] = local_as_number
            __props__.__dict__["manage_transit_gateway_attachment"] = manage_transit_gateway_attachment
            __props__.__dict__["monitor_exclude_lists"] = monitor_exclude_lists
            __props__.__dict__["oob_availability_zone"] = oob_availability_zone
            __props__.__dict__["oob_management_subnet"] = oob_management_subnet
            __props__.__dict__["prepend_as_paths"] = prepend_as_paths
            __props__.__dict__["private_mode_lb_vpc_id"] = private_mode_lb_vpc_id
            __props__.__dict__["private_mode_subnet_zone"] = private_mode_subnet_zone
            __props__.__dict__["rx_queue_size"] = rx_queue_size
            __props__.__dict__["single_az_ha"] = single_az_ha
            __props__.__dict__["single_ip_snat"] = single_ip_snat
            __props__.__dict__["software_version"] = software_version
            __props__.__dict__["spoke_bgp_manual_advertise_cidrs"] = spoke_bgp_manual_advertise_cidrs
            __props__.__dict__["spot_price"] = spot_price
            if subnet is None and not opts.urn:
                raise TypeError("Missing required property 'subnet'")
            __props__.__dict__["subnet"] = subnet
            if tag_lists is not None and not opts.urn:
                warnings.warn("""Use tags instead.""", DeprecationWarning)
                pulumi.log.warn("""tag_lists is deprecated: Use tags instead.""")
            __props__.__dict__["tag_lists"] = tag_lists
            __props__.__dict__["tags"] = tags
            if transit_gw is not None and not opts.urn:
                warnings.warn("""Please set `manage_transit_gateway_attachment` to false, and use the standalone aviatrix_spoke_transit_attachment resource instead.""", DeprecationWarning)
                pulumi.log.warn("""transit_gw is deprecated: Please set `manage_transit_gateway_attachment` to false, and use the standalone aviatrix_spoke_transit_attachment resource instead.""")
            __props__.__dict__["transit_gw"] = transit_gw
            __props__.__dict__["tunnel_detection_time"] = tunnel_detection_time
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vpc_reg is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_reg'")
            __props__.__dict__["vpc_reg"] = vpc_reg
            __props__.__dict__["zone"] = zone
            __props__.__dict__["cloud_instance_id"] = None
            __props__.__dict__["ha_cloud_instance_id"] = None
            __props__.__dict__["ha_gw_name"] = None
            __props__.__dict__["ha_private_ip"] = None
            __props__.__dict__["ha_public_ip"] = None
            __props__.__dict__["ha_security_group_id"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["security_group_id"] = None
        super(AviatrixSpokeGateway, __self__).__init__(
            'aviatrix:index/aviatrixSpokeGateway:AviatrixSpokeGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[str]] = None,
            allocate_new_eip: Optional[pulumi.Input[bool]] = None,
            approved_learned_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
            bgp_ecmp: Optional[pulumi.Input[bool]] = None,
            bgp_hold_time: Optional[pulumi.Input[int]] = None,
            bgp_polling_time: Optional[pulumi.Input[int]] = None,
            cloud_instance_id: Optional[pulumi.Input[str]] = None,
            cloud_type: Optional[pulumi.Input[int]] = None,
            customer_managed_keys: Optional[pulumi.Input[str]] = None,
            customized_spoke_vpc_routes: Optional[pulumi.Input[str]] = None,
            disable_route_propagation: Optional[pulumi.Input[bool]] = None,
            eip: Optional[pulumi.Input[str]] = None,
            enable_active_standby: Optional[pulumi.Input[bool]] = None,
            enable_active_standby_preemptive: Optional[pulumi.Input[bool]] = None,
            enable_auto_advertise_s2c_cidrs: Optional[pulumi.Input[bool]] = None,
            enable_bgp: Optional[pulumi.Input[bool]] = None,
            enable_encrypt_volume: Optional[pulumi.Input[bool]] = None,
            enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
            enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
            enable_monitor_gateway_subnets: Optional[pulumi.Input[bool]] = None,
            enable_preserve_as_path: Optional[pulumi.Input[bool]] = None,
            enable_private_oob: Optional[pulumi.Input[bool]] = None,
            enable_private_vpc_default_route: Optional[pulumi.Input[bool]] = None,
            enable_skip_public_route_table_update: Optional[pulumi.Input[bool]] = None,
            enable_spot_instance: Optional[pulumi.Input[bool]] = None,
            enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
            fault_domain: Optional[pulumi.Input[str]] = None,
            filtered_spoke_vpc_routes: Optional[pulumi.Input[str]] = None,
            gw_name: Optional[pulumi.Input[str]] = None,
            gw_size: Optional[pulumi.Input[str]] = None,
            ha_availability_domain: Optional[pulumi.Input[str]] = None,
            ha_azure_eip_name_resource_group: Optional[pulumi.Input[str]] = None,
            ha_cloud_instance_id: Optional[pulumi.Input[str]] = None,
            ha_eip: Optional[pulumi.Input[str]] = None,
            ha_fault_domain: Optional[pulumi.Input[str]] = None,
            ha_gw_name: Optional[pulumi.Input[str]] = None,
            ha_gw_size: Optional[pulumi.Input[str]] = None,
            ha_image_version: Optional[pulumi.Input[str]] = None,
            ha_insane_mode_az: Optional[pulumi.Input[str]] = None,
            ha_oob_availability_zone: Optional[pulumi.Input[str]] = None,
            ha_oob_management_subnet: Optional[pulumi.Input[str]] = None,
            ha_private_ip: Optional[pulumi.Input[str]] = None,
            ha_private_mode_subnet_zone: Optional[pulumi.Input[str]] = None,
            ha_public_ip: Optional[pulumi.Input[str]] = None,
            ha_security_group_id: Optional[pulumi.Input[str]] = None,
            ha_software_version: Optional[pulumi.Input[str]] = None,
            ha_subnet: Optional[pulumi.Input[str]] = None,
            ha_zone: Optional[pulumi.Input[str]] = None,
            image_version: Optional[pulumi.Input[str]] = None,
            included_advertised_spoke_routes: Optional[pulumi.Input[str]] = None,
            insane_mode: Optional[pulumi.Input[bool]] = None,
            insane_mode_az: Optional[pulumi.Input[str]] = None,
            learned_cidrs_approval_mode: Optional[pulumi.Input[str]] = None,
            local_as_number: Optional[pulumi.Input[str]] = None,
            manage_transit_gateway_attachment: Optional[pulumi.Input[bool]] = None,
            monitor_exclude_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            oob_availability_zone: Optional[pulumi.Input[str]] = None,
            oob_management_subnet: Optional[pulumi.Input[str]] = None,
            prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            private_ip: Optional[pulumi.Input[str]] = None,
            private_mode_lb_vpc_id: Optional[pulumi.Input[str]] = None,
            private_mode_subnet_zone: Optional[pulumi.Input[str]] = None,
            public_ip: Optional[pulumi.Input[str]] = None,
            rx_queue_size: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            single_az_ha: Optional[pulumi.Input[bool]] = None,
            single_ip_snat: Optional[pulumi.Input[bool]] = None,
            software_version: Optional[pulumi.Input[str]] = None,
            spoke_bgp_manual_advertise_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            spot_price: Optional[pulumi.Input[str]] = None,
            subnet: Optional[pulumi.Input[str]] = None,
            tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            transit_gw: Optional[pulumi.Input[str]] = None,
            tunnel_detection_time: Optional[pulumi.Input[int]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vpc_reg: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'AviatrixSpokeGateway':
        """
        Get an existing AviatrixSpokeGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[bool] allocate_new_eip: If false, reuse an idle address in Elastic IP pool for this gateway. Otherwise, allocate a new Elastic IP and use it for
               this gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] approved_learned_cidrs: Approved learned CIDRs for BGP Spoke Gateway. Available as of provider version R2.21+.
        :param pulumi.Input[str] availability_domain: Availability domain for OCI.
        :param pulumi.Input[str] azure_eip_name_resource_group: The name of the public IP address and its resource group in Azure to assign to this Spoke Gateway.
        :param pulumi.Input[bool] bgp_ecmp: Enable Equal Cost Multi Path (ECMP) routing for the next hop for BGP Spoke Gateway.
        :param pulumi.Input[int] bgp_hold_time: BGP Hold Time for BGP Spoke Gateway. Unit is in seconds. Valid values are between 12 and 360.
        :param pulumi.Input[int] bgp_polling_time: BGP route polling time for BGP Spoke Gateway. Unit is in seconds. Valid values are between 10 and 50.
        :param pulumi.Input[str] cloud_instance_id: Cloud instance ID.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider.
        :param pulumi.Input[str] customer_managed_keys: Customer managed key ID.
        :param pulumi.Input[str] customized_spoke_vpc_routes: A list of comma separated CIDRs to be customized for the spoke VPC routes. When configured, it will replace all learned
               routes in VPC routing tables, including RFC1918 and non-RFC1918 CIDRs. It applies to this spoke gateway only.
        :param pulumi.Input[bool] disable_route_propagation: Disables route propagation on BGP Spoke to attached Transit Gateway. Default: false.
        :param pulumi.Input[str] eip: Required when allocate_new_eip is false. It uses specified EIP for this gateway.
        :param pulumi.Input[bool] enable_active_standby: Enables Active-Standby Mode, available only with HA enabled for BGP Spoke Gateway.
        :param pulumi.Input[bool] enable_active_standby_preemptive: Enables Preemptive Mode for Active-Standby, available only with Active-Standby enabled.
        :param pulumi.Input[bool] enable_auto_advertise_s2c_cidrs: Automatically advertise remote CIDR to Aviatrix Transit Gateway when route based Site2Cloud Tunnel is created.
        :param pulumi.Input[bool] enable_bgp: Enable BGP. Default: false.
        :param pulumi.Input[bool] enable_encrypt_volume: Enable encrypt gateway EBS volume. Only supported for AWS provider. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_jumbo_frame: Enable jumbo frame support for spoke gateway. Valid values: true or false. Default value: true.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Switch to enable/disable learned CIDR approval for BGP Spoke Gateway. Valid values: true, false.
        :param pulumi.Input[bool] enable_monitor_gateway_subnets: Enable [monitor gateway subnets](https://docs.aviatrix.com/HowTos/gateway.html#monitor-gateway-subnet). Only valid for
               cloud_type = 1 (AWS) or 256 (AWSGov). Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_preserve_as_path: Enable preserve as_path when advertising manual summary cidrs on BGP spoke gateway.
        :param pulumi.Input[bool] enable_private_oob: Enable private OOB.
        :param pulumi.Input[bool] enable_private_vpc_default_route: Config Private VPC Default Route.
        :param pulumi.Input[bool] enable_skip_public_route_table_update: Skip Public Route Table Update.
        :param pulumi.Input[bool] enable_spot_instance: Enable spot instance. NOT supported for production deployment.
        :param pulumi.Input[bool] enable_vpc_dns_server: Enable vpc_dns_server for Gateway. Valid values: true, false.
        :param pulumi.Input[str] fault_domain: Fault domain for OCI.
        :param pulumi.Input[str] filtered_spoke_vpc_routes: A list of comma separated CIDRs to be filtered from the spoke VPC route table. When configured, filtering CIDR(s) or
               it’s subnet will be deleted from VPC routing tables as well as from spoke gateway’s routing table. It applies to
               this spoke gateway only.
        :param pulumi.Input[str] gw_name: Name of the gateway which is going to be created.
        :param pulumi.Input[str] gw_size: Size of the gateway instance.
        :param pulumi.Input[str] ha_availability_domain: HA availability domain for OCI.
        :param pulumi.Input[str] ha_azure_eip_name_resource_group: The name of the public IP address and its resource group in Azure to assign to the HA Spoke Gateway.
        :param pulumi.Input[str] ha_cloud_instance_id: Cloud instance ID of HA spoke gateway.
        :param pulumi.Input[str] ha_eip: Public IP address that you want assigned to the HA Spoke Gateway.
        :param pulumi.Input[str] ha_fault_domain: HA fault domain for OCI.
        :param pulumi.Input[str] ha_gw_name: Aviatrix spoke gateway unique name of HA spoke gateway.
        :param pulumi.Input[str] ha_gw_size: HA Gateway Size.
        :param pulumi.Input[str] ha_image_version: ha_image_version can be used to set the desired image version of the HA gateway. If set, we will attempt to update the
               gateway to the specified version.
        :param pulumi.Input[str] ha_insane_mode_az: AZ of subnet being created for Insane Mode Spoke HA Gateway. Required for AWS if insane_mode is true and ha_subnet is
               set.
        :param pulumi.Input[str] ha_oob_availability_zone: OOB HA availability zone.
        :param pulumi.Input[str] ha_oob_management_subnet: OOB HA management subnet.
        :param pulumi.Input[str] ha_private_ip: Private IP address of the spoke gateway created.
        :param pulumi.Input[str] ha_private_mode_subnet_zone: Private Mode HA subnet availability zone.
        :param pulumi.Input[str] ha_public_ip: Public IP address of the HA Spoke Gateway.
        :param pulumi.Input[str] ha_security_group_id: HA security group used for the spoke gateway.
        :param pulumi.Input[str] ha_software_version: ha_software_version can be used to set the desired software version of the HA gateway. If set, we will attempt to update
               the gateway to the specified version. If left blank, the gateway software version will continue to be managed through
               the aviatrix_controller_config resource.
        :param pulumi.Input[str] ha_subnet: HA Subnet. Required if enabling HA for AWS/AWSGov/AWSChina/Azure/AzureChina/OCI/Alibaba Cloud. Optional if enabling HA
               for GCP.
        :param pulumi.Input[str] ha_zone: HA Zone. Required if enabling HA for GCP. Optional for Azure.
        :param pulumi.Input[str] image_version: image_version can be used to set the desired image version of the gateway. If set, we will attempt to update the gateway
               to the specified version.
        :param pulumi.Input[str] included_advertised_spoke_routes: A list of comma separated CIDRs to be advertised to on-prem as 'Included CIDR List'. When configured, it will replace
               all advertised routes from this VPC.
        :param pulumi.Input[bool] insane_mode: Enable Insane Mode for Spoke Gateway. Valid values: true, false. Supported for AWS/AWSGov, GCP, Azure and OCI. If insane
               mode is enabled, gateway size has to at least be c5 size for AWS and Standard_D3_v2 size for Azure.
        :param pulumi.Input[str] insane_mode_az: AZ of subnet being created for Insane Mode Spoke Gateway. Required if insane_mode is enabled for AWS cloud.
        :param pulumi.Input[str] learned_cidrs_approval_mode: Set the learned CIDRs approval mode for BGP Spoke Gateway. Only valid when 'enable_learned_cidrs_approval' is set to
               true. Currently, only 'gateway' is supported: learned CIDR approval applies to ALL connections. Default value:
               'gateway'.
        :param pulumi.Input[str] local_as_number: Changes the Aviatrix BGP Spoke Gateway ASN number before you setup Aviatrix BGP Spoke Gateway connection configurations.
        :param pulumi.Input[bool] manage_transit_gateway_attachment: This parameter is a switch used to determine whether or not to manage attaching this spoke gateway to transit gateways
               using the aviatrix_spoke_gateway resource. If this is set to false, attaching this spoke gateway to transit gateways
               must be done using the aviatrix_spoke_transit_attachment resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitor_exclude_lists: A set of monitored instance ids. Only valid when 'enable_monitor_gateway_subnets' = true.
        :param pulumi.Input[str] oob_availability_zone: OOB subnet availability zone.
        :param pulumi.Input[str] oob_management_subnet: OOB management subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: List of AS numbers to populate BGP AP_PATH field when it advertises to VGW or peer devices. Only valid for BGP Spoke
               Gateway
        :param pulumi.Input[str] private_ip: Private IP address of the spoke gateway created.
        :param pulumi.Input[str] private_mode_lb_vpc_id: Private Mode controller load balancer vpc_id. Required when private mode is enabled for the Controller.
        :param pulumi.Input[str] private_mode_subnet_zone: Subnet availability zone. Required when Private Mode is enabled on the Controller and cloud_type is AWS.
        :param pulumi.Input[str] public_ip: Public IP address of the Spoke Gateway created.
        :param pulumi.Input[str] rx_queue_size: Gateway ethernet interface RX queue size. Supported for AWS related clouds only.
        :param pulumi.Input[str] security_group_id: Security group used for the spoke gateway.
        :param pulumi.Input[bool] single_az_ha: Set to 'enabled' if this feature is desired.
        :param pulumi.Input[bool] single_ip_snat: Specify whether to enable Source NAT feature in 'single_ip' mode on the gateway or not.
        :param pulumi.Input[str] software_version: software_version can be used to set the desired software version of the gateway. If set, we will attempt to update the
               gateway to the specified version. If left blank, the gateway software version will continue to be managed through the
               aviatrix_controller_config resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spoke_bgp_manual_advertise_cidrs: Intended CIDR list to be advertised to external BGP router.
        :param pulumi.Input[str] spot_price: Price for spot instance. NOT supported for production deployment.
        :param pulumi.Input[str] subnet: Public Subnet Info.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: Instance tag of cloud provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the spoke gateway.
        :param pulumi.Input[str] transit_gw: Specify the transit Gateways to attach to this spoke. Format is a comma-separated list of transit gateway names. For
               example, 'transit-gw1,transit-gw2'.
        :param pulumi.Input[int] tunnel_detection_time: The IPSec tunnel down detection time for the Spoke Gateway.
        :param pulumi.Input[str] vpc_id: VPC-ID/VNet-Name of cloud provider.
        :param pulumi.Input[str] vpc_reg: Region of cloud provider.
        :param pulumi.Input[str] zone: Availability Zone. Only available for cloud_type = 8 (Azure). Must be in the form 'az-n', for example, 'az-2'.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixSpokeGatewayState.__new__(_AviatrixSpokeGatewayState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["allocate_new_eip"] = allocate_new_eip
        __props__.__dict__["approved_learned_cidrs"] = approved_learned_cidrs
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["azure_eip_name_resource_group"] = azure_eip_name_resource_group
        __props__.__dict__["bgp_ecmp"] = bgp_ecmp
        __props__.__dict__["bgp_hold_time"] = bgp_hold_time
        __props__.__dict__["bgp_polling_time"] = bgp_polling_time
        __props__.__dict__["cloud_instance_id"] = cloud_instance_id
        __props__.__dict__["cloud_type"] = cloud_type
        __props__.__dict__["customer_managed_keys"] = customer_managed_keys
        __props__.__dict__["customized_spoke_vpc_routes"] = customized_spoke_vpc_routes
        __props__.__dict__["disable_route_propagation"] = disable_route_propagation
        __props__.__dict__["eip"] = eip
        __props__.__dict__["enable_active_standby"] = enable_active_standby
        __props__.__dict__["enable_active_standby_preemptive"] = enable_active_standby_preemptive
        __props__.__dict__["enable_auto_advertise_s2c_cidrs"] = enable_auto_advertise_s2c_cidrs
        __props__.__dict__["enable_bgp"] = enable_bgp
        __props__.__dict__["enable_encrypt_volume"] = enable_encrypt_volume
        __props__.__dict__["enable_jumbo_frame"] = enable_jumbo_frame
        __props__.__dict__["enable_learned_cidrs_approval"] = enable_learned_cidrs_approval
        __props__.__dict__["enable_monitor_gateway_subnets"] = enable_monitor_gateway_subnets
        __props__.__dict__["enable_preserve_as_path"] = enable_preserve_as_path
        __props__.__dict__["enable_private_oob"] = enable_private_oob
        __props__.__dict__["enable_private_vpc_default_route"] = enable_private_vpc_default_route
        __props__.__dict__["enable_skip_public_route_table_update"] = enable_skip_public_route_table_update
        __props__.__dict__["enable_spot_instance"] = enable_spot_instance
        __props__.__dict__["enable_vpc_dns_server"] = enable_vpc_dns_server
        __props__.__dict__["fault_domain"] = fault_domain
        __props__.__dict__["filtered_spoke_vpc_routes"] = filtered_spoke_vpc_routes
        __props__.__dict__["gw_name"] = gw_name
        __props__.__dict__["gw_size"] = gw_size
        __props__.__dict__["ha_availability_domain"] = ha_availability_domain
        __props__.__dict__["ha_azure_eip_name_resource_group"] = ha_azure_eip_name_resource_group
        __props__.__dict__["ha_cloud_instance_id"] = ha_cloud_instance_id
        __props__.__dict__["ha_eip"] = ha_eip
        __props__.__dict__["ha_fault_domain"] = ha_fault_domain
        __props__.__dict__["ha_gw_name"] = ha_gw_name
        __props__.__dict__["ha_gw_size"] = ha_gw_size
        __props__.__dict__["ha_image_version"] = ha_image_version
        __props__.__dict__["ha_insane_mode_az"] = ha_insane_mode_az
        __props__.__dict__["ha_oob_availability_zone"] = ha_oob_availability_zone
        __props__.__dict__["ha_oob_management_subnet"] = ha_oob_management_subnet
        __props__.__dict__["ha_private_ip"] = ha_private_ip
        __props__.__dict__["ha_private_mode_subnet_zone"] = ha_private_mode_subnet_zone
        __props__.__dict__["ha_public_ip"] = ha_public_ip
        __props__.__dict__["ha_security_group_id"] = ha_security_group_id
        __props__.__dict__["ha_software_version"] = ha_software_version
        __props__.__dict__["ha_subnet"] = ha_subnet
        __props__.__dict__["ha_zone"] = ha_zone
        __props__.__dict__["image_version"] = image_version
        __props__.__dict__["included_advertised_spoke_routes"] = included_advertised_spoke_routes
        __props__.__dict__["insane_mode"] = insane_mode
        __props__.__dict__["insane_mode_az"] = insane_mode_az
        __props__.__dict__["learned_cidrs_approval_mode"] = learned_cidrs_approval_mode
        __props__.__dict__["local_as_number"] = local_as_number
        __props__.__dict__["manage_transit_gateway_attachment"] = manage_transit_gateway_attachment
        __props__.__dict__["monitor_exclude_lists"] = monitor_exclude_lists
        __props__.__dict__["oob_availability_zone"] = oob_availability_zone
        __props__.__dict__["oob_management_subnet"] = oob_management_subnet
        __props__.__dict__["prepend_as_paths"] = prepend_as_paths
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["private_mode_lb_vpc_id"] = private_mode_lb_vpc_id
        __props__.__dict__["private_mode_subnet_zone"] = private_mode_subnet_zone
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["rx_queue_size"] = rx_queue_size
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["single_az_ha"] = single_az_ha
        __props__.__dict__["single_ip_snat"] = single_ip_snat
        __props__.__dict__["software_version"] = software_version
        __props__.__dict__["spoke_bgp_manual_advertise_cidrs"] = spoke_bgp_manual_advertise_cidrs
        __props__.__dict__["spot_price"] = spot_price
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["tag_lists"] = tag_lists
        __props__.__dict__["tags"] = tags
        __props__.__dict__["transit_gw"] = transit_gw
        __props__.__dict__["tunnel_detection_time"] = tunnel_detection_time
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_reg"] = vpc_reg
        __props__.__dict__["zone"] = zone
        return AviatrixSpokeGateway(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="allocateNewEip")
    def allocate_new_eip(self) -> pulumi.Output[Optional[bool]]:
        """
        If false, reuse an idle address in Elastic IP pool for this gateway. Otherwise, allocate a new Elastic IP and use it for
        this gateway.
        """
        return pulumi.get(self, "allocate_new_eip")

    @property
    @pulumi.getter(name="approvedLearnedCidrs")
    def approved_learned_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Approved learned CIDRs for BGP Spoke Gateway. Available as of provider version R2.21+.
        """
        return pulumi.get(self, "approved_learned_cidrs")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        Availability domain for OCI.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="azureEipNameResourceGroup")
    def azure_eip_name_resource_group(self) -> pulumi.Output[str]:
        """
        The name of the public IP address and its resource group in Azure to assign to this Spoke Gateway.
        """
        return pulumi.get(self, "azure_eip_name_resource_group")

    @property
    @pulumi.getter(name="bgpEcmp")
    def bgp_ecmp(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable Equal Cost Multi Path (ECMP) routing for the next hop for BGP Spoke Gateway.
        """
        return pulumi.get(self, "bgp_ecmp")

    @property
    @pulumi.getter(name="bgpHoldTime")
    def bgp_hold_time(self) -> pulumi.Output[Optional[int]]:
        """
        BGP Hold Time for BGP Spoke Gateway. Unit is in seconds. Valid values are between 12 and 360.
        """
        return pulumi.get(self, "bgp_hold_time")

    @property
    @pulumi.getter(name="bgpPollingTime")
    def bgp_polling_time(self) -> pulumi.Output[Optional[int]]:
        """
        BGP route polling time for BGP Spoke Gateway. Unit is in seconds. Valid values are between 10 and 50.
        """
        return pulumi.get(self, "bgp_polling_time")

    @property
    @pulumi.getter(name="cloudInstanceId")
    def cloud_instance_id(self) -> pulumi.Output[str]:
        """
        Cloud instance ID.
        """
        return pulumi.get(self, "cloud_instance_id")

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Output[int]:
        """
        Type of cloud service provider.
        """
        return pulumi.get(self, "cloud_type")

    @property
    @pulumi.getter(name="customerManagedKeys")
    def customer_managed_keys(self) -> pulumi.Output[Optional[str]]:
        """
        Customer managed key ID.
        """
        return pulumi.get(self, "customer_managed_keys")

    @property
    @pulumi.getter(name="customizedSpokeVpcRoutes")
    def customized_spoke_vpc_routes(self) -> pulumi.Output[Optional[str]]:
        """
        A list of comma separated CIDRs to be customized for the spoke VPC routes. When configured, it will replace all learned
        routes in VPC routing tables, including RFC1918 and non-RFC1918 CIDRs. It applies to this spoke gateway only.
        """
        return pulumi.get(self, "customized_spoke_vpc_routes")

    @property
    @pulumi.getter(name="disableRoutePropagation")
    def disable_route_propagation(self) -> pulumi.Output[Optional[bool]]:
        """
        Disables route propagation on BGP Spoke to attached Transit Gateway. Default: false.
        """
        return pulumi.get(self, "disable_route_propagation")

    @property
    @pulumi.getter
    def eip(self) -> pulumi.Output[str]:
        """
        Required when allocate_new_eip is false. It uses specified EIP for this gateway.
        """
        return pulumi.get(self, "eip")

    @property
    @pulumi.getter(name="enableActiveStandby")
    def enable_active_standby(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables Active-Standby Mode, available only with HA enabled for BGP Spoke Gateway.
        """
        return pulumi.get(self, "enable_active_standby")

    @property
    @pulumi.getter(name="enableActiveStandbyPreemptive")
    def enable_active_standby_preemptive(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables Preemptive Mode for Active-Standby, available only with Active-Standby enabled.
        """
        return pulumi.get(self, "enable_active_standby_preemptive")

    @property
    @pulumi.getter(name="enableAutoAdvertiseS2cCidrs")
    def enable_auto_advertise_s2c_cidrs(self) -> pulumi.Output[Optional[bool]]:
        """
        Automatically advertise remote CIDR to Aviatrix Transit Gateway when route based Site2Cloud Tunnel is created.
        """
        return pulumi.get(self, "enable_auto_advertise_s2c_cidrs")

    @property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable BGP. Default: false.
        """
        return pulumi.get(self, "enable_bgp")

    @property
    @pulumi.getter(name="enableEncryptVolume")
    def enable_encrypt_volume(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable encrypt gateway EBS volume. Only supported for AWS provider. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_encrypt_volume")

    @property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable jumbo frame support for spoke gateway. Valid values: true or false. Default value: true.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable/disable learned CIDR approval for BGP Spoke Gateway. Valid values: true, false.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @property
    @pulumi.getter(name="enableMonitorGatewaySubnets")
    def enable_monitor_gateway_subnets(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable [monitor gateway subnets](https://docs.aviatrix.com/HowTos/gateway.html#monitor-gateway-subnet). Only valid for
        cloud_type = 1 (AWS) or 256 (AWSGov). Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_monitor_gateway_subnets")

    @property
    @pulumi.getter(name="enablePreserveAsPath")
    def enable_preserve_as_path(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable preserve as_path when advertising manual summary cidrs on BGP spoke gateway.
        """
        return pulumi.get(self, "enable_preserve_as_path")

    @property
    @pulumi.getter(name="enablePrivateOob")
    def enable_private_oob(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable private OOB.
        """
        return pulumi.get(self, "enable_private_oob")

    @property
    @pulumi.getter(name="enablePrivateVpcDefaultRoute")
    def enable_private_vpc_default_route(self) -> pulumi.Output[Optional[bool]]:
        """
        Config Private VPC Default Route.
        """
        return pulumi.get(self, "enable_private_vpc_default_route")

    @property
    @pulumi.getter(name="enableSkipPublicRouteTableUpdate")
    def enable_skip_public_route_table_update(self) -> pulumi.Output[Optional[bool]]:
        """
        Skip Public Route Table Update.
        """
        return pulumi.get(self, "enable_skip_public_route_table_update")

    @property
    @pulumi.getter(name="enableSpotInstance")
    def enable_spot_instance(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable spot instance. NOT supported for production deployment.
        """
        return pulumi.get(self, "enable_spot_instance")

    @property
    @pulumi.getter(name="enableVpcDnsServer")
    def enable_vpc_dns_server(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable vpc_dns_server for Gateway. Valid values: true, false.
        """
        return pulumi.get(self, "enable_vpc_dns_server")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> pulumi.Output[str]:
        """
        Fault domain for OCI.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="filteredSpokeVpcRoutes")
    def filtered_spoke_vpc_routes(self) -> pulumi.Output[Optional[str]]:
        """
        A list of comma separated CIDRs to be filtered from the spoke VPC route table. When configured, filtering CIDR(s) or
        it’s subnet will be deleted from VPC routing tables as well as from spoke gateway’s routing table. It applies to
        this spoke gateway only.
        """
        return pulumi.get(self, "filtered_spoke_vpc_routes")

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Output[str]:
        """
        Name of the gateway which is going to be created.
        """
        return pulumi.get(self, "gw_name")

    @property
    @pulumi.getter(name="gwSize")
    def gw_size(self) -> pulumi.Output[str]:
        """
        Size of the gateway instance.
        """
        return pulumi.get(self, "gw_size")

    @property
    @pulumi.getter(name="haAvailabilityDomain")
    def ha_availability_domain(self) -> pulumi.Output[str]:
        """
        HA availability domain for OCI.
        """
        return pulumi.get(self, "ha_availability_domain")

    @property
    @pulumi.getter(name="haAzureEipNameResourceGroup")
    def ha_azure_eip_name_resource_group(self) -> pulumi.Output[str]:
        """
        The name of the public IP address and its resource group in Azure to assign to the HA Spoke Gateway.
        """
        return pulumi.get(self, "ha_azure_eip_name_resource_group")

    @property
    @pulumi.getter(name="haCloudInstanceId")
    def ha_cloud_instance_id(self) -> pulumi.Output[str]:
        """
        Cloud instance ID of HA spoke gateway.
        """
        return pulumi.get(self, "ha_cloud_instance_id")

    @property
    @pulumi.getter(name="haEip")
    def ha_eip(self) -> pulumi.Output[str]:
        """
        Public IP address that you want assigned to the HA Spoke Gateway.
        """
        return pulumi.get(self, "ha_eip")

    @property
    @pulumi.getter(name="haFaultDomain")
    def ha_fault_domain(self) -> pulumi.Output[str]:
        """
        HA fault domain for OCI.
        """
        return pulumi.get(self, "ha_fault_domain")

    @property
    @pulumi.getter(name="haGwName")
    def ha_gw_name(self) -> pulumi.Output[str]:
        """
        Aviatrix spoke gateway unique name of HA spoke gateway.
        """
        return pulumi.get(self, "ha_gw_name")

    @property
    @pulumi.getter(name="haGwSize")
    def ha_gw_size(self) -> pulumi.Output[Optional[str]]:
        """
        HA Gateway Size.
        """
        return pulumi.get(self, "ha_gw_size")

    @property
    @pulumi.getter(name="haImageVersion")
    def ha_image_version(self) -> pulumi.Output[str]:
        """
        ha_image_version can be used to set the desired image version of the HA gateway. If set, we will attempt to update the
        gateway to the specified version.
        """
        return pulumi.get(self, "ha_image_version")

    @property
    @pulumi.getter(name="haInsaneModeAz")
    def ha_insane_mode_az(self) -> pulumi.Output[Optional[str]]:
        """
        AZ of subnet being created for Insane Mode Spoke HA Gateway. Required for AWS if insane_mode is true and ha_subnet is
        set.
        """
        return pulumi.get(self, "ha_insane_mode_az")

    @property
    @pulumi.getter(name="haOobAvailabilityZone")
    def ha_oob_availability_zone(self) -> pulumi.Output[Optional[str]]:
        """
        OOB HA availability zone.
        """
        return pulumi.get(self, "ha_oob_availability_zone")

    @property
    @pulumi.getter(name="haOobManagementSubnet")
    def ha_oob_management_subnet(self) -> pulumi.Output[Optional[str]]:
        """
        OOB HA management subnet.
        """
        return pulumi.get(self, "ha_oob_management_subnet")

    @property
    @pulumi.getter(name="haPrivateIp")
    def ha_private_ip(self) -> pulumi.Output[str]:
        """
        Private IP address of the spoke gateway created.
        """
        return pulumi.get(self, "ha_private_ip")

    @property
    @pulumi.getter(name="haPrivateModeSubnetZone")
    def ha_private_mode_subnet_zone(self) -> pulumi.Output[Optional[str]]:
        """
        Private Mode HA subnet availability zone.
        """
        return pulumi.get(self, "ha_private_mode_subnet_zone")

    @property
    @pulumi.getter(name="haPublicIp")
    def ha_public_ip(self) -> pulumi.Output[str]:
        """
        Public IP address of the HA Spoke Gateway.
        """
        return pulumi.get(self, "ha_public_ip")

    @property
    @pulumi.getter(name="haSecurityGroupId")
    def ha_security_group_id(self) -> pulumi.Output[str]:
        """
        HA security group used for the spoke gateway.
        """
        return pulumi.get(self, "ha_security_group_id")

    @property
    @pulumi.getter(name="haSoftwareVersion")
    def ha_software_version(self) -> pulumi.Output[str]:
        """
        ha_software_version can be used to set the desired software version of the HA gateway. If set, we will attempt to update
        the gateway to the specified version. If left blank, the gateway software version will continue to be managed through
        the aviatrix_controller_config resource.
        """
        return pulumi.get(self, "ha_software_version")

    @property
    @pulumi.getter(name="haSubnet")
    def ha_subnet(self) -> pulumi.Output[Optional[str]]:
        """
        HA Subnet. Required if enabling HA for AWS/AWSGov/AWSChina/Azure/AzureChina/OCI/Alibaba Cloud. Optional if enabling HA
        for GCP.
        """
        return pulumi.get(self, "ha_subnet")

    @property
    @pulumi.getter(name="haZone")
    def ha_zone(self) -> pulumi.Output[Optional[str]]:
        """
        HA Zone. Required if enabling HA for GCP. Optional for Azure.
        """
        return pulumi.get(self, "ha_zone")

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> pulumi.Output[str]:
        """
        image_version can be used to set the desired image version of the gateway. If set, we will attempt to update the gateway
        to the specified version.
        """
        return pulumi.get(self, "image_version")

    @property
    @pulumi.getter(name="includedAdvertisedSpokeRoutes")
    def included_advertised_spoke_routes(self) -> pulumi.Output[Optional[str]]:
        """
        A list of comma separated CIDRs to be advertised to on-prem as 'Included CIDR List'. When configured, it will replace
        all advertised routes from this VPC.
        """
        return pulumi.get(self, "included_advertised_spoke_routes")

    @property
    @pulumi.getter(name="insaneMode")
    def insane_mode(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable Insane Mode for Spoke Gateway. Valid values: true, false. Supported for AWS/AWSGov, GCP, Azure and OCI. If insane
        mode is enabled, gateway size has to at least be c5 size for AWS and Standard_D3_v2 size for Azure.
        """
        return pulumi.get(self, "insane_mode")

    @property
    @pulumi.getter(name="insaneModeAz")
    def insane_mode_az(self) -> pulumi.Output[Optional[str]]:
        """
        AZ of subnet being created for Insane Mode Spoke Gateway. Required if insane_mode is enabled for AWS cloud.
        """
        return pulumi.get(self, "insane_mode_az")

    @property
    @pulumi.getter(name="learnedCidrsApprovalMode")
    def learned_cidrs_approval_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Set the learned CIDRs approval mode for BGP Spoke Gateway. Only valid when 'enable_learned_cidrs_approval' is set to
        true. Currently, only 'gateway' is supported: learned CIDR approval applies to ALL connections. Default value:
        'gateway'.
        """
        return pulumi.get(self, "learned_cidrs_approval_mode")

    @property
    @pulumi.getter(name="localAsNumber")
    def local_as_number(self) -> pulumi.Output[str]:
        """
        Changes the Aviatrix BGP Spoke Gateway ASN number before you setup Aviatrix BGP Spoke Gateway connection configurations.
        """
        return pulumi.get(self, "local_as_number")

    @property
    @pulumi.getter(name="manageTransitGatewayAttachment")
    def manage_transit_gateway_attachment(self) -> pulumi.Output[Optional[bool]]:
        """
        This parameter is a switch used to determine whether or not to manage attaching this spoke gateway to transit gateways
        using the aviatrix_spoke_gateway resource. If this is set to false, attaching this spoke gateway to transit gateways
        must be done using the aviatrix_spoke_transit_attachment resource. Valid values: true, false. Default value: true.
        """
        return pulumi.get(self, "manage_transit_gateway_attachment")

    @property
    @pulumi.getter(name="monitorExcludeLists")
    def monitor_exclude_lists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A set of monitored instance ids. Only valid when 'enable_monitor_gateway_subnets' = true.
        """
        return pulumi.get(self, "monitor_exclude_lists")

    @property
    @pulumi.getter(name="oobAvailabilityZone")
    def oob_availability_zone(self) -> pulumi.Output[Optional[str]]:
        """
        OOB subnet availability zone.
        """
        return pulumi.get(self, "oob_availability_zone")

    @property
    @pulumi.getter(name="oobManagementSubnet")
    def oob_management_subnet(self) -> pulumi.Output[Optional[str]]:
        """
        OOB management subnet.
        """
        return pulumi.get(self, "oob_management_subnet")

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of AS numbers to populate BGP AP_PATH field when it advertises to VGW or peer devices. Only valid for BGP Spoke
        Gateway
        """
        return pulumi.get(self, "prepend_as_paths")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[str]:
        """
        Private IP address of the spoke gateway created.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="privateModeLbVpcId")
    def private_mode_lb_vpc_id(self) -> pulumi.Output[Optional[str]]:
        """
        Private Mode controller load balancer vpc_id. Required when private mode is enabled for the Controller.
        """
        return pulumi.get(self, "private_mode_lb_vpc_id")

    @property
    @pulumi.getter(name="privateModeSubnetZone")
    def private_mode_subnet_zone(self) -> pulumi.Output[Optional[str]]:
        """
        Subnet availability zone. Required when Private Mode is enabled on the Controller and cloud_type is AWS.
        """
        return pulumi.get(self, "private_mode_subnet_zone")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        Public IP address of the Spoke Gateway created.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="rxQueueSize")
    def rx_queue_size(self) -> pulumi.Output[Optional[str]]:
        """
        Gateway ethernet interface RX queue size. Supported for AWS related clouds only.
        """
        return pulumi.get(self, "rx_queue_size")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        Security group used for the spoke gateway.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="singleAzHa")
    def single_az_ha(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to 'enabled' if this feature is desired.
        """
        return pulumi.get(self, "single_az_ha")

    @property
    @pulumi.getter(name="singleIpSnat")
    def single_ip_snat(self) -> pulumi.Output[Optional[bool]]:
        """
        Specify whether to enable Source NAT feature in 'single_ip' mode on the gateway or not.
        """
        return pulumi.get(self, "single_ip_snat")

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> pulumi.Output[str]:
        """
        software_version can be used to set the desired software version of the gateway. If set, we will attempt to update the
        gateway to the specified version. If left blank, the gateway software version will continue to be managed through the
        aviatrix_controller_config resource.
        """
        return pulumi.get(self, "software_version")

    @property
    @pulumi.getter(name="spokeBgpManualAdvertiseCidrs")
    def spoke_bgp_manual_advertise_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Intended CIDR list to be advertised to external BGP router.
        """
        return pulumi.get(self, "spoke_bgp_manual_advertise_cidrs")

    @property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> pulumi.Output[Optional[str]]:
        """
        Price for spot instance. NOT supported for production deployment.
        """
        return pulumi.get(self, "spot_price")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[str]:
        """
        Public Subnet Info.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Instance tag of cloud provider.
        """
        return pulumi.get(self, "tag_lists")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the spoke gateway.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="transitGw")
    def transit_gw(self) -> pulumi.Output[Optional[str]]:
        """
        Specify the transit Gateways to attach to this spoke. Format is a comma-separated list of transit gateway names. For
        example, 'transit-gw1,transit-gw2'.
        """
        return pulumi.get(self, "transit_gw")

    @property
    @pulumi.getter(name="tunnelDetectionTime")
    def tunnel_detection_time(self) -> pulumi.Output[int]:
        """
        The IPSec tunnel down detection time for the Spoke Gateway.
        """
        return pulumi.get(self, "tunnel_detection_time")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        VPC-ID/VNet-Name of cloud provider.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcReg")
    def vpc_reg(self) -> pulumi.Output[str]:
        """
        Region of cloud provider.
        """
        return pulumi.get(self, "vpc_reg")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[str]]:
        """
        Availability Zone. Only available for cloud_type = 8 (Azure). Must be in the form 'az-n', for example, 'az-2'.
        """
        return pulumi.get(self, "zone")

